<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-64</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>


      <let name="expected2" value="'No schema release folder was found with the required version information V&lt;MajorVersionNumber&gt;_&lt;MinorVersionNumber&gt;{_&lt;OptionalPatchNumber&gt;} for Document XSD named badA_V2_0.xsd.'"/>
      <let name="expected5" value="'No schema release folder was found with the required version information V&lt;MajorVersionNumber&gt;_&lt;MinorVersionNumber&gt;{_&lt;OptionalPatchNumber&gt;} for Document XSD named bad_V2_0.xsd.'"/>
      <let name="expected6" value="'The flattened schema file name badD.xsd does not contain version information in the required format &lt;ComponentName&gt;{_V&lt;MajorVersionNumber&gt;_&lt;MinorVersionNumber&gt;_&lt;OptionalPatchVersionNumber&gt;}.&lt;FileExtension&gt;'"/>
      <let name="expected8" value="'The Document schema file name badC.xsd does not contain version information in the required format &lt;ComponentName&gt;{_V&lt;MajorVersionNumber&gt;_&lt;MinorVersionNumber&gt;_&lt;OptionalPatchVersionNumber&gt;}.&lt;FileExtension&gt;'"/>
      <let name="expected9" value="'The Document schema file name badC_V1_0.xsd has a major version number (1) that does not match the release major version number (2).'"/>
      <let name="expected10" value="'The Document schema file name badC_V2.0.xsd does not contain version information in the required format &lt;ComponentName&gt;{_V&lt;MajorVersionNumber&gt;_&lt;MinorVersionNumber&gt;_&lt;OptionalPatchVersionNumber&gt;}.&lt;FileExtension&gt;'"/>
      <let name="expected11" value="'The Document schema file name badC_v2_0.xsd does not contain version information in the required format &lt;ComponentName&gt;{_V&lt;MajorVersionNumber&gt;_&lt;MinorVersionNumber&gt;_&lt;OptionalPatchVersionNumber&gt;}.&lt;FileExtension&gt;'"/>
      <let name="expected12" value="'The Document schema file name badC_V2_0_0.xsd does not contain version information in the required format &lt;ComponentName&gt;{_V&lt;MajorVersionNumber&gt;_&lt;MinorVersionNumber&gt;_&lt;OptionalPatchVersionNumber&gt;}.&lt;FileExtension&gt;'"/>
      <let name="expected13" value="'The Document schema file name badC_V2_1.xsd has a minor version number (1) that does not match the release minor version number (0).'"/>

      <let name="failmsg2" value="fnx:expect-infile(
                                  $expected2,
                                  'badA_V2_0.svrl', $inFileName, /)"/>
      <let name="failmsg5" value="fnx:expect-infile(
                                  $expected5,
                                  'bad_V2_0.svrl', $inFileName, /)"/>
      <let name="failmsg6" value="fnx:expect-infile(
                                  $expected6,
                                  'badD.svrl', $inFileName, /)"/>
      <let name="failmsg8" value="fnx:expect-infile(
                                  $expected8,
                                  'badC.svrl', $inFileName, /)"/>
      <let name="failmsg9" value="fnx:expect-infile(
                                   $expected9,
                                   'badC_V1_0.svrl', $inFileName, /)"/>
      <let name="failmsg10" value="fnx:expect-infile(
                                   $expected10,
                                   'badC_V2.0.svrl', $inFileName, /)"/>
      <let name="failmsg11" value="fnx:expect-infile(
                                   $expected11,
                                   'badC_v2_0.svrl', $inFileName, /)"/>
      <let name="failmsg12" value="fnx:expect-infile(
                                   $expected12,
                                   'badC_V2_0_0.svrl', $inFileName, /)"/>
      <let name="failmsg13" value="fnx:expect-infile(
                                   $expected13,
                                   'badC_V2_1.svrl', $inFileName, /)"/>

      <assert test="fnx:failed-assert-count-is-infile(0, 'goodB.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>

      <assert test="fnx:failed-assert-count-is-infile(1, 'badA_V2_0.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'goodA.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'good.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'bad_V2_0.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'badD.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'goodD_V2_0.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'badC.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:failed-assert-count-is-infile(1, 'badC_V1_0.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'badC_V2.0.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'badC_v2_0.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:failed-assert-count-is-infile(1, 'badC_V2_0_0.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'badC_V2_1.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:failed-assert-count-is-infile(0, 'goodC_V2_0.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg2, 'badA_V2_0.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg2"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg5, 'bad_V2_0.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg5"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg6, 'badD.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg6"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg8, 'badC.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg8"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg9, 'badC_V1_0.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg9"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg10, 'badC_V2.0.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg10"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg11, 'badC_v2_0.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg11"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg12, 'badC_V2_0_0.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg12"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg13, 'badC_V2_1.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-64" role="ERROR">
        <value-of select="$failmsg13"/>
      </assert>

    </rule>
	</pattern>
<diagnostics><diagnostic id="SD-64"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>
