<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-61</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1" value="fnx:expect-infile(
                                  'The xsd:schema does not contain an xsd:annotation/xsd:documentation element.',
                                  'bad.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile(
                                  'The xsd:annotation/xsd:appinfo element does not contain the required &quot;com:SchemaCreatedDate&quot; element.',
                                  'bad2.svrl', $inFileName, /)"/>
      <let name="failmsg2b" value="fnx:expect-infile(
                                  'The xsd:annotation/xsd:appinfo element does not contain the required &quot;com:SchemaContactPoint&quot; element.',
                                  'bad2.svrl', $inFileName, /)"/>
      <let name="failmsg3" value="fnx:expect-infile(
                                  'The xsd:annotation/xsd:appinfo element does not contain the optional &quot;com:SchemaReleaseNoteURL&quot; element.',
                                  'bad3.svrl', $inFileName, /)"/>

      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, 'gooda.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
     <assert test="fnx:failed-assert-count-is-infile(0, 'good.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
       <assert test="fnx:failed-assert-count-is-infile(0, 'good2.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'bad.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(2, 'bad2.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(2, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'bad3.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg1, 'bad.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <value-of select="$failmsg1"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg2, 'bad2.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <value-of select="$failmsg2"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg2b, 'bad2.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <value-of select="$failmsg2b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg3, 'bad3.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-61" role="ERROR">
        <value-of select="$failmsg3"/>
      </assert>

    </rule>
	</pattern>
<diagnostics><diagnostic id="SD-61"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>
