<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>
  <let name="st96Version" value="'V4_0'"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-28</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg3" value="fnx:expect-infile(
        concat('&quot;V4_01&quot; does not match st96Version &quot;',$st96Version,'&quot;'),
        'OrphanWorkAlternativeTitleBag.svrl', $inFileName,/
        )"/>
      <let name="failmsg4" value="fnx:expect-infile(
        concat('&quot;V4_01&quot; does not match st96Version &quot;',$st96Version,'&quot;'),
        'OrphanWorkTitleBagType.svrl', $inFileName,/
        )"/>
      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(1, 'OrphanWorkAlternativeTitleBag.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-28" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'OrphanWorkTitleBagType.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-28" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg3, 'OrphanWorkAlternativeTitleBag.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-28" role="ERROR">
        <value-of select="$failmsg3"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg4, 'OrphanWorkTitleBagType.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-28" role="ERROR">
        <value-of select="$failmsg4"/>
      </assert>
    </rule>
	</pattern>
<diagnostics><diagnostic id="SD-28"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>