<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-14</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg3" value="fnx:expect-infile(
                                  'Namespace http://www.wipo.int/standards/XMLSchema/ST96/BAD does not follow the proper form.',
                                  '3.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile(
                                  'Namespace http://www.wipo.int/standards/XMLSchema/ST96/BAD/Common does not follow the proper form.',
                                  '4.svrl', $inFileName, /)"/>
      <let name="failmsg7" value="fnx:expect-infile(
                                  'Namespace http://www.wipo.int/standards/XMLSchema/ST96/BAD does not follow the proper form.',
                                  '7.svrl', $inFileName, /)"/>
      <let name="failmsg11" value="fnx:expect-infile(
                                  'Namespace urn:us:gov:doc:uspto:bad does not follow the proper form. Expected namespace urn:us:gov:doc:uspto:corporate based on subdirectory name USCorporate.',
                                  '11.svrl', $inFileName, /)"/>

       <let name="failmsg19" value="fnx:expect-infile(
                                  'Namespace http://www.wipo.int/standards/XMLSchema/ST96/BAD does not follow the proper form.',
                                  '19.svrl', $inFileName, /)"/>
     <let name="failmsg21" value="fnx:expect-infile(
                                  'Namespace urn:us:gov:doc:uspto:bad does not follow the proper form. Expected namespace urn:us:gov:doc:uspto:corporate based on subdirectory name USCorporate.',
                                  '21.svrl', $inFileName, /)"/>

      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '2.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '3.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '4.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '5.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '6.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '7.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '8.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '9.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '10.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '11.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '12.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
       <assert test="fnx:failed-assert-count-is-infile(0, '13.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
       <assert test="fnx:failed-assert-count-is-infile(0, '14.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
       <assert test="fnx:failed-assert-count-is-infile(0, '15.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
       <assert test="fnx:failed-assert-count-is-infile(0, '16.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
       <assert test="fnx:failed-assert-count-is-infile(0, '17.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '18.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '19.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '20.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '21.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
 
      <assert test="fnx:no-fail-infile($failmsg3, '3.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <value-of select="$failmsg3"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg4, '4.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <value-of select="$failmsg4"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg7, '7.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <value-of select="$failmsg7"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg11, '11.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-14" role="WARNING">
        <value-of select="$failmsg11"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg19, '19.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-14" role="ERROR">
        <value-of select="$failmsg19"/>
      </assert>
     <assert test="fnx:no-fail-infile($failmsg21, '21.svrl', $inFileName)" flag="AUTO" diagnostics="uri SD-14" role="WARNING">
        <value-of select="$failmsg21"/>
      </assert>

    </rule>
	</pattern>
<diagnostics><diagnostic id="SD-14"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>