<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
  <!-- "the term component refers to type, element or attribute" -->

	<pattern>
		<title>GD-07</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg0" value="fnx:expect('The length of the element named ThisElementNameHas36CharactersAAAAAA is 36.', /)"/>
      <let name="failmsg1" value="fnx:expect('The length of the attribute named ThisAttributeNameHas36CharactersAAAA is 36.', /)"/>
      <let name="failmsg2" value="fnx:expect('The length of the simpleType named ThisSimpleTypeNameHas36CharactersAAA is 36.', /)"/>
      <let name="failmsg3" value="fnx:expect('The length of the complexType named ThisComplexTypeNameHas36CharactersAA is 36.', /)"/>

      <!-- Assertions -->

      <assert test="fnx:failed-assert-count-is(4, .)" flag="AUTO" diagnostics="uri GD-07" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(4, .)"/>
      </assert>

      <assert test="$failmsg0 = ''" flag="AUTO" diagnostics="uri GD-07" role="WARNING">
        <value-of select="$failmsg0"/>
      </assert>
      <assert test="$failmsg1 = ''" flag="AUTO" diagnostics="uri GD-07" role="WARNING">
        <value-of select="$failmsg1"/>
      </assert>
      <assert test="$failmsg2 = ''" flag="AUTO" diagnostics="uri GD-07" role="WARNING">
        <value-of select="$failmsg2"/>
      </assert>
      <assert test="$failmsg3 = ''" flag="AUTO" diagnostics="uri GD-07" role="WARNING">
        <value-of select="$failmsg3"/>
      </assert>

    </rule>
	</pattern>
<diagnostics><diagnostic id="GD-07"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>