<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
	<ns prefix="xsl" uri="http://www.w3.org/1999/XSL/Transform"/>
	<ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>GD-06</title>

    <rule context="svrl:schematron-output" role="ERROR">

      <let name="failmsg0" value="fnx:expect('The name of element BAD_element contains invalid characters.', /)"/>
      <let name="failmsg1" value="fnx:expect('The name of element BAD.element contains invalid characters.', /)"/>
      <let name="failmsg2" value="fnx:expect('The name of element BAD-element contains invalid characters.', /)"/>
      <let name="failmsg3" value="fnx:expect('The name of element BADΔelement contains invalid characters.', /)"/>
      <let name="failmsg4" value="fnx:expect('The name of attribute BAD_attribute contains invalid characters.', /)"/>
      <let name="failmsg5" value="fnx:expect('The name of attribute BAD.attribute contains invalid characters.', /)"/>
      <let name="failmsg6" value="fnx:expect('The name of attribute BAD-attribute contains invalid characters.', /)"/>
      <let name="failmsg7" value="fnx:expect('The name of attribute BADΔattribute contains invalid characters.', /)"/>
      <let name="failmsg8" value="fnx:expect('The name of simpleType BAD_simpleType contains invalid characters.', /)"/>
      <let name="failmsg9" value="fnx:expect('The name of simpleType BAD.simpleType contains invalid characters.', /)"/>
      <let name="failmsg10" value="fnx:expect('The name of simpleType BAD-simpleType contains invalid characters.', /)"/>
      <let name="failmsg11" value="fnx:expect('The name of simpleType BADΔsimpleType contains invalid characters.', /)"/>
      <let name="failmsg12" value="fnx:expect('The name of complexType BAD_complexType contains invalid characters.', /)"/>
      <let name="failmsg13" value="fnx:expect('The name of complexType BAD.complexType contains invalid characters.', /)"/>
      <let name="failmsg14" value="fnx:expect('The name of complexType BAD-complexType contains invalid characters.', /)"/>
      <let name="failmsg15" value="fnx:expect('The name of complexType BADΔcomplexType contains invalid characters.', /)"/>
      <!-- Assertions -->

      <assert test="fnx:failed-assert-count-is(16, .)" flag="AUTO" diagnostics="uri GD-06" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(16, .)"/>
      </assert>

      <assert test="$failmsg0 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg0"/></assert>
      <assert test="$failmsg1 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg1"/></assert>
      <assert test="$failmsg2 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg2"/></assert>
      <assert test="$failmsg3 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg3"/></assert>
      <assert test="$failmsg4 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg4"/></assert>
      <assert test="$failmsg5 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg5"/></assert>
      <assert test="$failmsg6 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg6"/></assert>
      <assert test="$failmsg7 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg7"/></assert>
      <assert test="$failmsg8 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg8"/></assert>
      <assert test="$failmsg9 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg9"/></assert>
      <assert test="$failmsg10 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg10"/></assert>
      <assert test="$failmsg11 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg11"/></assert>
      <assert test="$failmsg12 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg12"/></assert>
      <assert test="$failmsg13 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg13"/></assert>
      <assert test="$failmsg14 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg14"/></assert>
      <assert test="$failmsg15 = ''" flag="AUTO" diagnostics="uri GD-06" role="ERROR"><value-of select="$failmsg15"/></assert>

    </rule>

	</pattern>
<diagnostics><diagnostic id="GD-06"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>