<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fnx="http://www.example.com/fnx" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
   <xsl:import href="common_style.xsl"/>
   <xsl:import href="component_status.xsl"/>
   
   <xsl:variable name="components" select="if (doc-available('../components.xml')) then doc('../components.xml') else ()"/>
   <xsl:variable name="previousSchemaComponentsFound" select="exists($components/components/component)"/>
   <xsl:key name="component-by-status-and-namespace" match="component" use="concat(@status,@namespace)"/>
   <xsl:key name="component-by-name-and-namespace" match="component" use="concat(@name,@namespace)"/>
   
   <xsl:template match="/">
      <html xmlns="http://www.w3.org/1999/xhtml">
         <head>
            <title>Component Name Report</title>
            <xsl:sequence select="fnx:include-css()"/>
            <style>.top{background-color:white;}p.modified:after{content:"\00A0Mod";font-size:xx-small;vertical-align:top;}p.new:after{content:"\00A0New";font-size:xx-small;vertical-align:top;}</style>
            <script type="text/javascript">
                     <xsl:text disable-output-escaping="yes">
document.addEventListener('DOMContentLoaded', function () {
     document.getElementById("modified-checkbox").addEventListener("change", function (changeType) {toggle("modified");});
    document.getElementById("new-checkbox").addEventListener("change", function (changeType) {toggle("new");});
    /*document.getElementById("deleted-checkbox").addEventListener("change", function (changeType) {toggle("deleted");});*/
    document.getElementById("unchanged-checkbox").addEventListener("change", function (changeType) {toggle("unchanged");});
});

function toggle(changeType){
    var components = document.querySelectorAll(".name-p."+changeType);
        if (document.getElementById(changeType+"-checkbox").checked) {
            // Checkbox is checked..
            components.forEach(function (i) {
                i.style.display = "block";
            });
        } else {
            // Checkbox is not checked..
            components.forEach(function (i) {
                i.style.display = "none";
            });
        }
}
</xsl:text>
                </script>
         </head>
         <a style="position: fixed; bottom:5px;right:5px;" href="#" title="Click to go to top">Go to top</a>
         <body>
            <h1 align="center">Component Name Report</h1>
            <xsl:sequence select="fnx:time-run()"/>
            <hr/>
            <div><p>See also:  [<a href="summary.html" target="_blank">ST.96 Conformance Checking Report</a>] and [<a href="integritycheck.html" target="_blank">Schema Integrity Check Report</a>]</p></div>
            <xsl:if test="$previousSchemaComponentsFound">
               <h3>Show: <span> <input type="checkbox" id="modified-checkbox" checked="checked" /><label for="modified-checkbox">Modified</label> </span><span> <input type="checkbox" id="new-checkbox" checked="checked" /><label for="new-checkbox">New</label></span><!--<span> <input type="checkbox" id="deleted-checkbox" checked="checked" /><label for="deleted-checkbox">Deleted</label></span>--><span> <input type="checkbox" id="unchanged-checkbox" checked="checked" /><label for="unchanged-checkbox">Unchanged</label></span></h3>
            </xsl:if>
            <xsl:sequence select="fnx:input()"/>
            <xsl:if test="$previousSchemaInputDir">
               <p class="header">
            <b>Reference XSDs (for comparison): </b>  <xsl:value-of select="$previousSchemaInputDir"/>  </p>
            </xsl:if>
           
            <p class="name-p">
               <xsl:for-each-group select="$input-collection" group-by="@namespace">
                  <xsl:text> [</xsl:text>
                  <a href="#N{position()}">
                     <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                  </a>
                  <xsl:text>] &#160; </xsl:text>
               </xsl:for-each-group>
            </p>
            <xsl:for-each-group select="$input-collection" group-by="@namespace">
               <h2 id="N{position()}">
                  <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                  <xsl:text> Components [</xsl:text><xsl:value-of select="count(current-group())"/><xsl:text>]</xsl:text>
               </h2>
               <xsl:if test="$previousSchemaComponentsFound">
                  <xsl:variable name="modifiedInNamespace" select="key('component-by-status-and-namespace',concat('modified',tokenize(current-grouping-key(),'[/:]')[last()]),$components)"/>
                  <xsl:variable name="newInNamespace" select="key('component-by-status-and-namespace',concat('new',tokenize(current-grouping-key(),'[/:]')[last()]),$components)"/>
                  
                  <h4>
                     <xsl:if test="$modifiedInNamespace">
                        <xsl:value-of select="concat(' Modified: ',count($modifiedInNamespace))"/><br></br>
                     </xsl:if>
                     <xsl:if test="$newInNamespace">
                        <xsl:value-of select="concat(' New: ',count($newInNamespace))"/><br></br>
                     </xsl:if>
                     <xsl:value-of select="concat(' Unchanged: ',count(current-group()) - count($modifiedInNamespace) - count($newInNamespace))"/>
                     <!-- Modified: Count
                          New: Count
                          Deleted: Count
                     -->
                  </h4>
               </xsl:if>
               <table>
                  <tr>
                     <xsl:sequence select="fnx:display-section('Elements',current-group()/element)"/>
                     <xsl:sequence select="fnx:display-section('Complex Types',current-group()/complexType)"/>
                     <xsl:sequence select="fnx:display-section('Simple Types',current-group()/simpleType)"/>
                     <xsl:sequence select="fnx:display-section('Attributes',current-group()/attribute)"/>
                  </tr>
               </table>
            </xsl:for-each-group>
         </body>
      </html>
   </xsl:template>
   
   <xsl:function name="fnx:display-section"><!-- override imported -->
      <xsl:param name="title"/>
      <xsl:param name="definitions"/>
      <td class="{$definitions[1]/local-name()}">
         <p class="name-header">
            <i>
               <xsl:value-of select="$title"/>
            </i>
            [<xsl:value-of select="count($definitions)"/>]
         </p>
         <xsl:for-each select="$definitions">
            <xsl:sort select="@name"/>
            
            <p class="name-p">
               <xsl:variable name="status" select="if ($previousSchemaComponentsFound) then key('component-by-name-and-namespace',concat(@name, tokenize(current()/parent::node()/@namespace, '[/:]')[last()]),$components)/@status else ()"/>
               <!--<xsl:message>look up status of <xsl:value-of select="@name"/> in <xsl:value-of select="tokenize(current()/parent::node()/@namespace, '[/:]')[last()]"/>: <xsl:value-of select="$status"/></xsl:message>-->
               <xsl:if test="$status">
                  <xsl:attribute name="class">name-p <xsl:value-of select="$status"/></xsl:attribute>
                  <xsl:if test="$status != 'unchanged'">
                     <xsl:attribute name="title"><xsl:value-of select="$status"/></xsl:attribute>
                  </xsl:if>
               </xsl:if>
               <a href="{../@file}">
                  <xsl:value-of select="@name"/>
               </a>
            </p>
         </xsl:for-each>
      </td>
   </xsl:function>
</xsl:stylesheet>
