<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fnx="http://www.example.com/fnx" exclude-result-prefixes="fnx">
   <xsl:import href="common_style.xsl"/>
   <xsl:strip-space elements="*"/>
   
   <xsl:output method="html" indent="no"></xsl:output>
   
   <xsl:template match="/">
      <html>
         <head>
            <title>Schema Integrity Check</title>
            <xsl:sequence select="fnx:include-css()"/>
            <style>body table tr:nth-child(even){background: #e8f4f8;}span.misspelled{color:red;background-image: linear-gradient(to right, red 50%, transparent 50%);background-position: 0 1.04em;background-repeat: repeat-x;background-size: 6px 3px; /*text-decoration-line: underline;text-decoration-color:red;text-decoration-style: dashed;*/}th{text-align:left;}table.sortable th{cursor:pointer;}tr td:nth-child(3){width:10em;min-width:11ch;}table *{font-size:small;}.sortable th.dir-d::after {color: inherit;content: " \025B4";}
.sortable th.dir-u::after {color: inherit;content: " \025BE";}</style>
<!--            <script type="text/javascript" src="../sortable.min.js"/>-->
            <script type="text/javascript">
               <xsl:text>/*!
 * sortable 
 * https://github.com/tofsjonas/sortable/blob/master/LICENSE 
*/ </xsl:text>
               <xsl:text disable-output-escaping="yes">document.addEventListener("click",function(d){function f(a,b){a.className=a.className.replace(h,"")+b}var h=/ dir-(u|d) /,a=/\bsortable\b/,b=d.target;if("TH"==b.nodeName&amp;&amp;(d=b.offsetParent,a.test(d.className))){var e,c=b.parentNode.cells;for(a=0;a&lt;c.length;a++)c[a]===b?e=a:f(c[a],"");a=" dir-d ";-1!==b.className.indexOf(" dir-d ")&amp;&amp;(a=" dir-u ");f(b,a);b=d.tBodies[0];c=[].slice.call(b.cloneNode(!0).rows,0);var k=" dir-u "==a;c.sort(function(a,b){a=a.cells[e].innerText;b=b.cells[e].innerText;if(k){var c=
a;a=b;b=c}return isNaN(a-b)?a.localeCompare(b):a-b});var g=b.cloneNode();for(a=0;a&lt;c.length;a++)g.appendChild(c[a]);d.replaceChild(g,b)}});
</xsl:text>
            </script>
         </head>
         <body>
            <h1 align="center">Schema Integrity Check</h1>
            <xsl:sequence select="fnx:time-run()"/>
            <hr/>
            <h2>
               <xsl:text>Integrity Checking of </xsl:text>
               <xsl:value-of select="count($input-collection)"/>
               <xsl:text> XSDs: </xsl:text>
               <span class="code">
                  <xsl:value-of select="$reportInDir"/>
               </span>
            </h2>
            <div><p>See also:  [<a href="summary.html" target="_blank">ST.96 Conformance Checking Report</a>] and [<a href="namelist.html" target="_blank">Component Name Report</a>]</p></div>
            <xsl:variable name="results" as="node()*">
               <table id="integrity-issues" class="sortable">
                 <thead> <tr>
                     <th class=" dir-d ">Namespace</th>
                     <th>File</th>
                     <th>Error Type</th>
                     <th>Details</th>
                  </tr></thead>
                  <tbody><xsl:for-each-group select="$input-collection" group-by="@namespace">
                     <!--<h2 id="N{position()}">
                     <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                     <xsl:text> Components</xsl:text>
                  </h2>-->
                     <xsl:choose>
                        <xsl:when test="current-group()/*">
                           <!-- <table>-->
                           <xsl:apply-templates select="current-group()"/>
                           <!---->
                        </xsl:when>
                        <xsl:otherwise>
                           <p>
                              <i>No integrity issues were found for this namespace.</i>
                           </p>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:for-each-group></tbody>
               </table>
            </xsl:variable>
            <div class="summaryDiv">
               <xsl:for-each-group select="$results/tbody/tr/td[3]" group-by=".">
                  <div>
                     <xsl:value-of select="concat(current-grouping-key(), ': ', count(current-group()))"/>
                  </div>
               </xsl:for-each-group>
               <div><xsl:value-of select="concat('Total: ',count($results/tbody/tr))"/></div>
            </div>
            
            <!--<p class="name-p">
               <xsl:for-each-group select="$input-collection" group-by="@namespace">
                  <xsl:text> [</xsl:text>
                  <a href="#N{position()}">
                     <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                  </a>
                  <xsl:text>] &#160; </xsl:text>
               </xsl:for-each-group>
            </p>-->
            <xsl:copy-of select="$results"/>
            
         </body>
      </html>
   </xsl:template>
   <xsl:template match="include-path-not-local">
      <xsl:element name="tr">
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td><a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a></td>
         <td>Unexpected include path</td>
         <td>Include has relative or full path (<xsl:value-of select="@include-file"/>) instead of just schema file name</td>
      </xsl:element>
   </xsl:template>
   <xsl:template match="import-unused">
      <xsl:element name="tr">
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/><!--<xsl:value-of select="replace(@namespace,'.*/([^/]+)','$1')"/>--></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Unused import/include</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@element"/>
            <xsl:text> of </xsl:text>
            <xsl:value-of select="@imported-file"/>
            <xsl:text> is unnecessary and can be deleted.</xsl:text>
         </td>
      </xsl:element>
   </xsl:template>
   <xsl:template match="import-unused-directly">
      <xsl:element name="tr">
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Unused import/include</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@element"/>
            <xsl:text> of </xsl:text>
            <xsl:value-of select="@imported-file"/>
            <xsl:text> is not used directly; it is possibly used indirectly.</xsl:text>
         </td>
      </xsl:element>
   </xsl:template>
   <xsl:template match="import-file-not-found">
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Import/include file not found</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@element"/>
            <xsl:text> of </xsl:text>
            <xsl:value-of select="@imported-file"/>
            <xsl:text> cannot be resolved; the file was not found.</xsl:text>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="missing-import">
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Missing import/include</td>
         <td>
            <xsl:text>The following name(s) are used but not directly imported into the XSD:  </xsl:text>
            <xsl:value-of select="@names"/>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="unused-prefixes[parent::node()/@namespace[contains(.,'Common')]]" priority="2">
      <!-- should be reported as SD-02 rule violation instead -->
   </xsl:template>
   
   <xsl:template match="unused-prefixes">
      <tr>
         <td><xsl:value-of select="replace(parent::node()/@namespace,'.*/([^/]+)','$1')"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Unused prefixes</td>
         <td>
            <xsl:text>The following prefix(es) are unnecessarily declared:  </xsl:text>
            <xsl:value-of select="@prefixes"/>
         </td>
      </tr>
   </xsl:template>
  <xsl:template match="orphan">
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Orphan</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> is declared but never referenced.</xsl:text>
         </td>
      </tr>
   </xsl:template>
  <xsl:template match="dup-common">
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Duplicate of Common</td>
         <td>
            <xsl:text>The name </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> duplicates a name that is in the </xsl:text>
            <xsl:value-of select="@namespace"/>
            <xsl:text> namespace.</xsl:text>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="dup-enumeration"><!-- 2020-06-15 -->
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Duplicate Enumerations</td>
         <td>
            <xsl:text>The simpleType </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> contains duplicate enumerations: </xsl:text>
            <xsl:value-of select="@duplicates"/>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="improper-filename">
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Improper File name</td>
         <td>
            <xsl:text>The file name of </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> does not match the component name.</xsl:text>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="missing-explicit-datatype">
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Missing explicit data type</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> does not have an explicit data type associated with it.</xsl:text>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="misspelled-name">
        <tr>
           <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
            <!--<xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Misspelling in component name (GD-04)</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> has misspelled words: </xsl:text>
            <xsl:variable name="suggestion" select="@suggestions"/>
            <xsl:for-each select="tokenize(@misspelled,', ')">
               <xsl:variable name="position" select="position()"/>
               <span class="misspelled">
                  <xsl:value-of select="."/>
               </span>
               <span><i> (suggested: <xsl:value-of select="tokenize($suggestion,'; ')[$position]"/>)</i></span>
               <xsl:if test="position() ne last()">
                  <xsl:text>, </xsl:text>
               </xsl:if>
            </xsl:for-each>
           
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="misspelled-enumeration">
        <tr>
           <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
         <td>
<!--            <xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Misspelling in enumeration value</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:variable name="misspelled" select="@misspelled"/>
            <xsl:variable name="suggestion" select="tokenize(@suggestions, '; ')"/>
            <xsl:value-of select="concat(' has misspelled words (',$misspelled,') in the enumeration value: ')"/>
            <xsl:text>&quot;</xsl:text>
            <xsl:analyze-string select="@enumeration" regex="({replace($misspelled,', ','|')})(\W|$)">
               <xsl:matching-substring>
                  <span class="misspelled"><xsl:value-of select="regex-group(1)"/></span>
                  <xsl:value-of select="regex-group(2)"/>
               </xsl:matching-substring>
               <xsl:non-matching-substring>
                  <xsl:value-of select="current()"/>
               </xsl:non-matching-substring>
            </xsl:analyze-string>
            <xsl:text>&quot;</xsl:text>
            <p>
               <br></br>
               <xsl:for-each select="tokenize($misspelled, ', ')">
                  <xsl:variable name="position" select="position()"/>
                  <xsl:value-of select="current()"/>
                  <xsl:choose>
                     <xsl:when test="matches(current(),'^[A-Z][A-Z0-9]+$')">
                        <span> is not found in the approved acronyms and abbreviations list. </span>
                     </xsl:when>
                     <xsl:otherwise>
                        <span>
                           <i> (Suggested: <xsl:value-of select="$suggestion[$position]"/>)</i>
                        </span>
                     </xsl:otherwise>
                  </xsl:choose>
                 
                  <xsl:if test="position() ne last()">
                     <br/>
                  </xsl:if>
               </xsl:for-each>
            </p>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="misspelled-description">
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
           <td>
<!--            <xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a></td>
         <td>Misspelling in description of component <xsl:if test="@enumeration-value"> enumeration value &quot;<xsl:value-of select="@enumeration-value"/>&quot;</xsl:if></td>
         <td>
            <xsl:copy-of select="node()"/>
            <xsl:for-each-group select="span/@data-suggestion" group-by="parent::node()">
               <p><br></br>
                  <xsl:value-of select="current-grouping-key()"/>
                  <span>
                     <i> (Suggested: <xsl:value-of select="current()"/>)</i>
                  </span>
               </p>
            </xsl:for-each-group>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="max-occurs-less-than-child">
          <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
              <td>
<!--            <xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Attribute maxOccurs fewer than number of child components</td>
             <td>
                <xsl:value-of select="@compositor"/> maxOccurs <xsl:value-of select="@maxOccurs"/> is fewer than the number of child components <xsl:value-of select="@count-child"/>. Consider incorporating a nested choice. 
             </td>
          </tr>
      </xsl:template>
   
      <xsl:template match="max-occurs-out-of-bound"><!-- consider rolling into SD-53: Schemas MAY use occurrence indicators in xsd:sequence and xsd:choice compositors.
 -->
          <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
              <td>
<!--            <xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Attribute maxOccurs out of bound</td><!-- out of bound, because we don't repeat the components? -->
             <td>
                <xsl:value-of select="@compositor"/> maxOccurs <xsl:value-of select="@maxOccurs"/> is greater than the number of child components <xsl:value-of select="@count-child"/>
             </td>
          </tr>
      </xsl:template>
   
   <xsl:template match="min-occurs-out-of-bound"><!-- consider rolling into SD-53: Schemas MAY use occurrence indicators in xsd:sequence and xsd:choice compositors.
 -->
          <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
              <td>
<!--            <xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Attribute minOccurs out of bound</td><!-- out of bound, because we don't repeat the components? -->
             <td>
                <xsl:value-of select="@compositor"/> minOccurs <xsl:value-of select="@minOccurs"/> is greater than the number of child components <xsl:value-of select="@count-child"/>
             </td>
          </tr>
      </xsl:template>
   
   <xsl:template match="duplicate-component-in-extension">
      <tr>
         <td><xsl:value-of select="fnx:ns-display-name(@namespace)"/></td>
              <td>
<!--            <xsl:sequence select="fnx:file-link(../@file)"/>-->
            <a href="{../@file}" target="_blank"><xsl:value-of select="replace(../@file,'.*/([^/]+)','$1')"/></a>
         </td>
         <td>Duplicate component in extension</td>
             <td>
                <xsl:value-of select="@duplicate"/> is duplicated in the complexType which extends from <xsl:value-of select="@base"/>
             </td>
          </tr>
   </xsl:template>
   
</xsl:stylesheet>
