<?xml version="1.0" encoding="UTF-8"?>
<!--
    Check schema integrity
     - unused imports/includes
     - unresolveable imports/includes
     - unused namespaces
     - orphan components
     - duplication of common components
     - spellcheck results (with suggestions) (currently excludes spell check of enumeration documentation) 
     
     Run on each schemaFile
     
     
     *** NEED TO DO: reorg so that instead of custom elements describing problem (becuase any updates here require updates to the integritycheck_style.xsl), have single element type which describes the following:
      <th class=" dir-d ">Namespace</th>
                     <th>File</th>
                     <th>Error Type</th>
                     <th>Details</th>
-->
<xsl:stylesheet version="2.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dty="http://www.datypic.com" xmlns:fnx="http://www.example.com/fnx" exclude-result-prefixes="xsd xsl dty fnx">
   <xsl:import href="wipo_xsd.xsl"/><!-- need in order to reuse splitCamelCase function -->
   
   <xsl:output encoding="UTF-8" method="xml" indent="yes"/>
   <xsl:strip-space elements="*"/>

<xsl:param name="reportInDir"/>
  
   <xsl:param name="spellcheckResultsFile"/>
   <xsl:param name="spellcheckAnnotationResultsFile"/>
   <xsl:variable name="misspelled-words" select="if (doc-available($spellcheckResultsFile)) then doc($spellcheckResultsFile) else ()"/>
   <xsl:variable name="misspelled-descriptions" select="if (doc-available($spellcheckAnnotationResultsFile)) then doc($spellcheckAnnotationResultsFile) else ()"/>
   
   <xsl:variable name="misspelled-words-in-descriptions" select="$misspelled-descriptions/*/entry/@word"/>
   
   
   <xsl:key name="misspelled-by-word" match="entry" use="@word"/>
   
   
   <xsl:param name="approvedAcronyms" select="
         (if (doc-available('../AcronymsAndAbbreviations.xml')) then
            (doc('../AcronymsAndAbbreviations.xml'))
         else
            (),
         if (doc-available('../AcronymsAndAbbreviationsLocal.xml')) then
            (doc('../AcronymsAndAbbreviationsLocal.xml'))
         else
            ())"/>
   
   <xsl:template match="/"><!-- need this to ensure this stylesheet first -->
      <xsl:if test="doc-available($misspelled-words) eq false() and doc-available($misspelled-descriptions) eq false()">
         <xsl:message>No spell check results found.</xsl:message>
      </xsl:if>
      <xsl:apply-templates/>
   </xsl:template>

   <xsl:template match="xsd:schema">
      <xsl:variable name="integrity-info" select="doc('../integritycheck/refs.configxml')/names"/>
      <!-- <names>
   <ref name="string" ns="http://www.w3.org/2001/XMLSchema"/>
   <ref name="NameType"
        ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ref name="AdditionalRemarkType"
        ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ref name="P" ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ref name="languageCode"
        ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ref name="AddressLineCategoryType"
        ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
      -->
      <xsl:variable name="nsUsedPrefixesElements" select="//*/substring-before(name(),':')" as="xsd:string*"/>
      <xsl:variable name="nsUsedPrefixesAttrs" select="//(@type|@ref|@itemType|@refer|@base)/substring-before(., ':')" as="xsd:string*"/>
      <xsl:variable name="nsUsedPrefixesMemberTypes" select="
            for $val in //@memberTypes/tokenize(.,'\s+')
            return
               substring-before($val, ':')" as="xsd:string*"/>
      <xsl:variable name="nsUsedPrefixes" select="distinct-values(($nsUsedPrefixesElements, $nsUsedPrefixesAttrs, $nsUsedPrefixesMemberTypes))"/>
      <xsl:variable name="tns" select="/xsd:schema/@targetNamespace"/>
      <xsl:variable name="nsUnusedPrefixes" as="xsd:string*">
         <xsl:for-each select="/xsd:schema/namespace::*">
            <xsl:variable name="nsPrefix" select="name()"/>
            <xsl:variable name="nsURI" select="."/>
            <xsl:if test="$nsPrefix != 'xml' and $nsURI != $tns and empty(index-of($nsUsedPrefixes, $nsPrefix))">
               <xsl:value-of select="$nsPrefix"/>
            </xsl:if>
         </xsl:for-each>
      </xsl:variable>
      <xsl:variable name="UsedNamesAttrs" select="//(@type|@ref|@itemType|@refer|@base)/dty:resolve-name-in-attr(.)" as="xsd:QName*"/>
      <xsl:variable name="UsedNamesMemberTypes" as="xsd:QName*">
         <xsl:for-each select="//@memberTypes">
            <xsl:variable name="el" select=".."/>
            <xsl:for-each select="tokenize(.,'\s+')">
               <xsl:sequence select="resolve-QName(.,$el)"/>
            </xsl:for-each>
         </xsl:for-each>
      </xsl:variable>
      <xsl:variable name="UsedNames" select="distinct-values(($UsedNamesAttrs, $UsedNamesMemberTypes))" as="xsd:QName*"/>
      <xsl:variable name="names-one-level-down" select="dty:names-one-level-down(.)" as="xsd:QName*"/>
      <xsl:variable name="NamesNotCoveredDirectly" select="$UsedNames[not(namespace-uri-from-QName(.) = 'http://www.w3.org/2001/XMLSchema')][not(. = $names-one-level-down)]" as="xsd:QName*"/>
      <integrity-info file="{base-uri()}" namespace="{@targetNamespace}">
         <xsl:if test="count($nsUnusedPrefixes) > 0">
            <unused-prefixes prefixes="{$nsUnusedPrefixes}"/>
         </xsl:if>
         <!-- get the names used one level deep.  if they are all accounted for, any imported file that doesn't have any names 
           is unnecessary.  This eliminates the performance issue associated with unnecessary imports of huge 
           schemas like PhraseType -->
         <xsl:if test="exists($NamesNotCoveredDirectly)">
            <missing-import names="{string-join(for $n in $NamesNotCoveredDirectly return string($n),', ')}"/>
         </xsl:if>
         <xsl:apply-templates select="xsd:import|xsd:include">
            <xsl:with-param name="UsedNames" select="$UsedNames"/>
            <xsl:with-param name="NamesNotCoveredDirectly" select="$NamesNotCoveredDirectly"/>
         </xsl:apply-templates>
         <xsl:apply-templates select="xsd:include" mode="check-schemaLocation">
            <xsl:with-param name="tns" select="@targetNamespace"/>
         </xsl:apply-templates>
         <xsl:if test="not(contains(base-uri(),'/Document/'))"><!-- if not Document schema -->
            <xsl:apply-templates select="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="orphan">
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="xsd:simpleType[xsd:restriction[xsd:enumeration]]" mode="dup-enumeration">
              
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="*[ends-with(local-name(), 'Type') or local-name() eq 'element' or local-name() eq 'attribute'][local-name() ne 'complexType'][not(@*:type or (local-name() eq 'simpleType' and (*:restriction/@*:base or *:union/@*:memberTypes)))]" mode="missing-datatype">
               
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
            
         </xsl:if>
         <xsl:apply-templates select="xsd:element | xsd:attribute | xsd:complexType | xsd:simpleType" mode="misspelled-names">
            <xsl:with-param name="tns" select="@targetNamespace"/>
            <xsl:with-param name="integrity-info" select="$integrity-info"/>
         </xsl:apply-templates>
         <xsl:apply-templates select="xsd:simpleType[xsd:restriction[xsd:enumeration]][not(matches(base-uri(), '(/ISO|/.*ST3CodeType.xsd)'))]" mode="misspelled-enumeration">
            <!-- spelling was not checked for ISO or ST3 codes -->
            
            <xsl:with-param name="tns" select="@targetNamespace"/>
            <xsl:with-param name="integrity-info" select="$integrity-info"/>
         </xsl:apply-templates>
         
         <xsl:apply-templates select="*[@name][xsd:annotation[1]/xsd:documentation[1]]" mode="misspelled-description"><!-- not including documentation for enumeration values *[descendant::xsd:annotation[1]/xsd:documentation[1]]-->
            <xsl:with-param name="tns" select="@targetNamespace" tunnel="yes"/>
            <xsl:with-param name="integrity-info" select="$integrity-info" tunnel="yes"/>
         </xsl:apply-templates>


         <xsl:if test="not(@targetNamespace = ('http://www.wipo.int/standards/XMLSchema/ST96/Common','urn:us:gov:doc:uspto:common'))">
            <xsl:apply-templates select="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="dup-common">
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
         </xsl:if>
         
         <xsl:apply-templates select="xsd:complexType[xsd:complexContent/xsd:extension[@base]]" mode="duplicate-in-extension">
            <xsl:with-param name="tns" select="@targetNamespace" />
         </xsl:apply-templates>

      </integrity-info>
   </xsl:template>
   <xsl:template match="xsd:import|xsd:include">
      <xsl:param name="UsedNames"/>
      <xsl:param name="NamesNotCoveredDirectly"/>
      <xsl:variable name="ImportedFile" select="resolve-uri(@schemaLocation,document-uri(/))"/>
      <!--<xsl:message select="$ImportedFile"/>-->
      <xsl:choose>
         <xsl:when test="doc-available($ImportedFile)">
            <xsl:variable name="imported" select="doc($ImportedFile)"/>
            <xsl:variable name="DefinedNames" select="dty:names-in-schema($imported)"/>
            <xsl:if test="not($DefinedNames = $UsedNames)">
               <xsl:choose>
                  <xsl:when test="empty($NamesNotCoveredDirectly)">
                     <!-- no need to go recursively checking in this import because all names are accounted for
                          in other imports - saves a lot of time -->
                     <import-unused element="{local-name(.)}" imported-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:variable name="used-recursive" select="dty:name-used-recursive($imported,$ImportedFile,$UsedNames)"/>
                     <xsl:choose>
                        <xsl:when test="exists($used-recursive)">
                           <import-unused-directly element="{local-name(.)}" imported-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}"/>
                        </xsl:when>
                        <xsl:otherwise>
                           <import-unused element="{local-name(.)}" imported-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:if>
         </xsl:when>
         <xsl:otherwise>
            <import-file-not-found element="{local-name(.)}" imported-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="text()"/>
   <xsl:template match="xsd:include" mode="check-schemaLocation">
      <xsl:param name="tns"/>
      <xsl:if test="matches(@schemaLocation,'[/\\][^\.]+[/\\]')">
         <include-path-not-local element="{local-name(.)}" include-file="{@schemaLocation}" namespace="{$tns}"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="orphan">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:if test="not($integrity-info/ref[@name = current()/@name and @ns=$tns])">
         <orphan type="{local-name(.)}" name="{@name}" namespace="{$tns}"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="dup-common">
      <xsl:param name="integrity-info"/>
      <xsl:if test="$integrity-info/common-name[@name = current()/@name]">
         <dup-common type="{local-name(.)}" name="{@name}" namespace="{$integrity-info/common-name[@name = current()/@name]/@ns}"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="xsd:simpleType[xsd:restriction[count(distinct-values(xsd:enumeration/@value)) ne count(xsd:enumeration/@value)]]" mode="dup-enumeration" priority="2">
      <!-- 2020-06-15 -->
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <dup-enumeration type="{local-name(.)}" name="{@name}" namespace="{$tns}" duplicates="{string-join(xsd:restriction/xsd:enumeration[exists(index-of(following-sibling::*/@*:value,@*:value))]/@value,', ')}"> </dup-enumeration>
   </xsl:template>
   <xsl:template match="xsd:simpleType" priority="1" mode="dup-enumeration"/>
   
   
   <xsl:template match="*[ends-with(local-name(), 'Type') or local-name() eq 'element' or local-name() eq 'attribute'][local-name() ne 'complexType'][not(@*:type or (local-name() eq 'simpleType' and (*:restriction/@*:base or *:union/@*:memberTypes)))]" mode="missing-datatype">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <!--<item namespace="{$tns}" category="Missing explicit data type" name="{@name}" type="{local-name(.)}">
         <xsl:value-of select="concat('The ',@type)"/>
      </item>-->
      <missing-explicit-datatype type="{local-name(.)}" name="{@name}" namespace="{$tns}"/>
   </xsl:template>
   
   
   <xsl:template match="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="misspelled-description">
      <xsl:apply-templates mode="#current"/>
   </xsl:template>
   
   <xsl:template match="xsd:annotation" mode="misspelled-description"></xsl:template>
   
   <xsl:template match="xsd:annotation[xsd:documentation[1][matches(.,concat('(^|[^a-zA-Z\-])',replace(string-join($misspelled-words-in-descriptions,'|'),'([\.\(\)\[\]\*\+\?\$\^])','\\$1'),'($|[^a-zA-Z\-])'))]]" mode="misspelled-description" priority="2"><!-- in cse checking documentation of enumeration -->
      <xsl:param name="tns" tunnel="yes"/>
      <xsl:param name="integrity-info" />
      <xsl:variable name="component" select="ancestor::*[@name][1]"/>
      <!--<xsl:message>
         misspelling in description of <xsl:value-of select="$component/@name"/> (<xsl:value-of select="string-join($misspelled-words-in-descriptions,'|')"/>)
      </xsl:message>-->
      <xsl:variable name="misspelled">
         <misspelled-description type="{$component/local-name()}" name="{$component/@name}" namespace="{$tns}" enumeration-value="{parent::node()/self::xsd:enumeration/@value}">
            <xsl:analyze-string select="xsd:documentation[1]" regex="(^|[^a-zA-Z\-])({replace(string-join($misspelled-words-in-descriptions,'|'),'([\.\(\)\[\]\*\+\?\$\^])','\\$1')})($|[^a-zA-Z\-])">
               <xsl:matching-substring>
                  <xsl:value-of select="regex-group(1)"/>
                  <span class="misspelled">
                     <xsl:attribute name="data-suggestion"><xsl:value-of select="$misspelled-descriptions/key('misspelled-by-word',regex-group(2))/@suggestions"/></xsl:attribute>
                     <xsl:value-of select="regex-group(2)"/>
                  </span>
                  <xsl:value-of select="regex-group(3)"/>
               </xsl:matching-substring>
               <xsl:non-matching-substring>
                  <xsl:value-of select="current()"/>
               </xsl:non-matching-substring>
            </xsl:analyze-string>
         </misspelled-description>
      </xsl:variable>
      <xsl:if test="$misspelled/*/span">
         <xsl:copy-of select="$misspelled"/>
      </xsl:if>
   </xsl:template>
   
   <xsl:template match="*[matches(xsd:annotation[1]/xsd:documentation[1],concat('(^|[^a-zA-Z\-])',replace(string-join($misspelled-words-in-descriptions,'|'),'([\.\(\)\[\]\*\+\?\$\^])','\\$1'),'($|[^a-zA-Z\-])'))]" mode="misspelled-description" priority="10">
      <xsl:param name="tns" tunnel="yes"/>
      <xsl:param name="integrity-info" />
      <!--<xsl:message>
         misspelling in description of <xsl:value-of select="@name"/> (<xsl:value-of select="string-join($misspelled-words-in-descriptions,'|')"/>)
      </xsl:message>-->
      <xsl:variable name="misspelled">
         <misspelled-description type="{local-name(.)}" name="{@name}" namespace="{$tns}">
            <xsl:analyze-string select="xsd:annotation/xsd:documentation" regex="(^|[^a-zA-Z\-])({replace(string-join($misspelled-words-in-descriptions,'|'),'([\.\(\)\[\]\*\+\?\$\^])','\\$1')})($|[^a-zA-Z\-])">
               <xsl:matching-substring>
                  <xsl:value-of select="regex-group(1)"/>
                  <span class="misspelled">
                     <xsl:attribute name="data-suggestion"><xsl:value-of select="$misspelled-descriptions/key('misspelled-by-word',regex-group(2))/@suggestions"/></xsl:attribute>
                     <xsl:value-of select="regex-group(2)"/>
                  </span>
                  <xsl:value-of select="regex-group(3)"/>
               </xsl:matching-substring>
               <xsl:non-matching-substring>
                  <xsl:value-of select="current()"/>
               </xsl:non-matching-substring>
            </xsl:analyze-string>
         </misspelled-description>
      </xsl:variable>
      <xsl:if test="$misspelled/*/span">
         <xsl:copy-of select="$misspelled"/>
      </xsl:if>
   </xsl:template>

   <xsl:template match="xsd:element | xsd:complexType | xsd:simpleType" mode="misspelled-names">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="words" select="fnx:splitCamelCase(@name)" />
<!--      <xsl:message>name: <xsl:value-of select="string-join($words, ' ')"/></xsl:message>-->
      <xsl:variable name="misspelled-components-found" select="for $x in $words[not(matches(.,'^[A-Z][A-Z0-9]+$'))][empty(index-of($approvedAcronyms/AAs/AA/short, .))] return $misspelled-words/key('misspelled-by-word',$x)" /><!-- exclude those caught by GD-14 -->
      
      <xsl:if test="exists($misspelled-components-found)">
      <!--   <xsl:message>misspelled names: <xsl:value-of select="string-join($misspelled-components-found,', ')"/> </xsl:message>
         <xsl:message>retrieve suggestion from <xsl:value-of select="string-join($misspelled-component-names/@suggestion,',')"/>: <xsl:value-of select="string-join($misspelled-component-names[exists(index-of($misspelled-components-found,.))]/@suggestion,'; ')"/></xsl:message>-->
         <misspelled-name type="{local-name(.)}" name="{@name}" namespace="{$tns}" misspelled="{string-join($misspelled-components-found/@word,', ')}" suggestions="{string-join($misspelled-components-found/@suggestions,'; ')}"/>
      </xsl:if>
   </xsl:template>
   
   <xsl:template match="xsd:attribute" mode="misspelled-names">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="words" select="fnx:splitCamelCase(@name)" as="item()+"/>
      <xsl:variable name="approvedacronym-first" select="$words[1][exists(index-of($approvedAcronyms/AAs/AA/short/lower-case(.),.))]"/>
      <xsl:variable name="misspelled-components-found" select="for $x in $words[. ne $approvedacronym-first and not(matches(.,'^[A-Z][A-Z0-9]+$'))] return $misspelled-words/key('misspelled-by-word',$x)" as="item()*"/><!-- exclude those caught by GD-13 -->
     
      <xsl:if test="exists($misspelled-components-found)">
        <!-- <xsl:message>misspelled: <xsl:value-of select="string-join($misspelled-component-names, '| ')"/></xsl:message>
         <xsl:message>retrieve suggestion: <xsl:value-of select="string-join($misspelled-component-names[exists(index-of($misspelled-components-found,.))]/@suggestion,'; ')"/></xsl:message>-->
         <misspelled-name type="{local-name(.)}" name="{@name}" namespace="{$tns}" misspelled="{string-join($misspelled-components-found/@word,', ')}" suggestions="{string-join($misspelled-components-found/@suggestions,'; ')}"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="xsd:simpleType" mode="misspelled-enumeration"/>
   <xsl:template match="xsd:simpleType[xsd:restriction[xsd:enumeration[matches(@value, '[a-zA-Z][a-z]+')]]]" mode="misspelled-enumeration" priority="10">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="type" select="local-name(.)"/>
      <xsl:variable name="name" select="@name"/>

      <xsl:for-each select="
            *:restriction/*:enumeration/@value[every $x in tokenize(., '\s+')
               satisfies empty(index-of($approvedAcronyms/AAs/AA/short, $x))]">
         <xsl:variable name="words" select="fnx:splitEnumeration(.)"/>
         <!-- to improve: if camelcased value with other part of string, need to check against camelcased acronyms/abbreviations first... -->
         <xsl:message>Enumerations with conversion of underscore (to space) and camelcasing (to space): <xsl:value-of select="string-join($words, ', ')"/></xsl:message>
         <xsl:variable name="misspelled-enumerations-found" select="for $x in $words return $misspelled-words/key('misspelled-by-word',$x)"/>
         
         <xsl:if test="exists($misspelled-enumerations-found)">
           <!-- <xsl:message>misspelled: <xsl:value-of select="string-join($misspelled-enumerations-found, '| ')"/></xsl:message>
            <xsl:message>retrieve suggestion: <xsl:value-of select="string-join($misspelled-enumeration-values[exists(index-of($misspelled-enumerations-found,.))]/@suggestion,'; ')"/></xsl:message>-->
            <misspelled-enumeration type="{$type}" name="{$name}" namespace="{$tns}" misspelled="{string-join($misspelled-enumerations-found/@word,', ')}" suggestions="{string-join($misspelled-enumerations-found/@suggestions,'; ')}" enumeration="{current()}"/>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
    <xsl:template match="xsd:complexType[xsd:complexContent/xsd:extension[@base]]" mode="duplicate-in-extension">
       <xsl:param name="tns"/>
       
       <xsl:variable name="imported-included" select="for $x in /xsd:schema/*[@schemaLocation]/@schemaLocation return doc(resolve-uri($x,base-uri(.)))"/>
       <xsl:variable name="name" select="@name"/>
       <xsl:for-each select="xsd:complexContent/xsd:extension/*[local-name() = 'sequence' or local-name() = 'choice']/xsd:element[@ref]">
          <!-- check @ref after reconciling namespace prefixes -->
          <xsl:variable name="referenced-component-name" select="@ref"/>
          <xsl:variable name="base-component-name" select="substring-after(ancestor::xsd:extension/@base,':')"/>
          <xsl:variable name="base-components" select="$imported-included/xsd:schema/*[@name = $base-component-name]/descendant::xsd:element[@ref]/@ref"/>
          
          <xsl:message>checking <xsl:value-of select="$referenced-component-name"/> against <xsl:value-of select="string-join($base-components,', ')"/></xsl:message>
          <xsl:if test="$referenced-component-name = ($base-components)">
             <duplicate-component-in-extension  name="{$name}" namespace="{$tns}" duplicate="{$referenced-component-name}" base="{ancestor::xsd:extension[1]/@base}" />
          </xsl:if>
       </xsl:for-each>
      <!--<xsd:schema xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:tmk="http://www.wipo.int/standards/XMLSchema/ST96/Trademark" xmlns:xsd="http://www.w3.org/2001/XMLSchema" targetNamespace="http://www.wipo.int/standards/XMLSchema/ST96/Trademark" elementFormDefault="qualified" attributeFormDefault="qualified" version="V4_0">
         <xsd:include schemaLocation="DocumentCreatedDate.xsd"/>
         <xsd:import namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" schemaLocation="../Common/DocumentReceivedDate.xsd"/>
         <xsd:import namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" schemaLocation="../Common/DocumentLoadedDateTime.xsd"/>
         <xsd:include schemaLocation="TrademarkDocumentCode.xsd"/>
         <xsd:include schemaLocation="TrademarkDocumentDescriptionText.xsd"/>
         <xsd:include schemaLocation="TrademarkDocumentCategory.xsd"/>
         <xsd:include schemaLocation="TrademarkDocumentCategoryDescriptionText.xsd"/>
         <xsd:import namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" schemaLocation="../Common/PageTotalQuantity.xsd"/>
         <xsd:import namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" schemaLocation="../Common/DocumentIdentifier.xsd"/>
         <xsd:import namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" schemaLocation="../Common/DocumentType.xsd"/>
         <xsd:complexType name="TrademarkDocumentType">
            <xsd:complexContent>
               <xsd:extension base="com:DocumentType">
                  <xsd:sequence>
                     <xsd:element ref="tmk:DocumentCreatedDate" minOccurs="0"/>
                     <xsd:element ref="com:DocumentReceivedDate" minOccurs="0"/>
                     <xsd:element ref="com:DocumentLoadedDateTime" minOccurs="0"/>
                     <xsd:element ref="tmk:TrademarkDocumentCode" minOccurs="0"/>
                     <xsd:element ref="tmk:TrademarkDocumentDescriptionText" minOccurs="0"/>
                     <xsd:element ref="tmk:TrademarkDocumentCategory" minOccurs="0"/>
                     <xsd:element ref="tmk:TrademarkDocumentCategoryDescriptionText" minOccurs="0"/>
                     <xsd:element ref="com:PageTotalQuantity" minOccurs="0"/>
                     <xsd:element ref="com:DocumentIdentifier" minOccurs="0"/>
                  </xsd:sequence>
               </xsd:extension>
            </xsd:complexContent>
         </xsd:complexType>
      </xsd:schema>-->

       
       
    </xsl:template>
   
   <xsl:function name="dty:resolve-name-in-attr" as="xsd:QName">
      <xsl:param name="prefixed-name" as="attribute()"/>
      <!-- for @ref, @type, @base, etc. -->
      <xsl:sequence select="resolve-QName($prefixed-name,$prefixed-name/parent::*)"/>
   </xsl:function>
   <xsl:function name="dty:schema-name" as="xsd:QName">
      <xsl:param name="unprefixed-name" as="attribute()"/>
      <!-- for @name -->
      <xsl:sequence select="QName($unprefixed-name/ancestor::xsd:schema/@targetNamespace,$unprefixed-name)"/>
   </xsl:function>
   <xsl:function name="dty:names-in-schema" as="xsd:QName*">
      <xsl:param name="doc"/>
      <xsl:sequence select="$doc//@name/dty:schema-name(.)"/>
   </xsl:function>
   <xsl:function name="dty:name-used-recursive" as="xsd:boolean*">
      <xsl:param name="doc"/>
      <xsl:param name="used-uris"/>
      <xsl:param name="used-names"/>
      <xsl:choose>
         <xsl:when test="not($doc/xsd:schema/(xsd:import|xsd:include))">
            <xsl:sequence select="()"/>
         </xsl:when>
         <xsl:when test="$used-names = dty:names-one-level-down($doc)">
            <xsl:sequence select="true()"/>
         </xsl:when>
         <xsl:otherwise>
            <!-- go down one more level -->
            <xsl:for-each select="$doc/xsd:schema/(xsd:import|xsd:include)">
               <xsl:variable name="ImportedFile" select="resolve-uri(@schemaLocation,document-uri($doc))"/>
               <xsl:if test="not($ImportedFile = $used-uris) and doc-available($ImportedFile)">
                  <xsl:variable name="imported" select="doc($ImportedFile)"/>
                  <xsl:sequence select="dty:name-used-recursive($imported, ($used-uris,$ImportedFile),$used-names)"/>
               </xsl:if>
            </xsl:for-each>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
   <xsl:function name="dty:names-one-level-down" as="xsd:QName*">
      <xsl:param name="doc"/>
      <xsl:for-each select="$doc//(xsd:import|xsd:include)">
         <xsl:variable name="ImportedFile" select="resolve-uri(@schemaLocation,document-uri(root($doc)))"/>
         <xsl:if test="doc-available($ImportedFile)">
            <xsl:variable name="imported" select="doc($ImportedFile)"/>
            <xsl:sequence select="dty:names-in-schema($imported)"/>
         </xsl:if>
      </xsl:for-each>
   </xsl:function>
</xsl:stylesheet>
