<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="2.0">
    
    <!-- produce components list with status: 'new', 'modified', 'unchanged', or 'unknown' 
    
         Should work even if folder depth levels are uneven between two versions of schemas
    -->
    <xsl:param name="previousSchemaInputDir"/>
    
    <xsl:param name="newSchemaComponents"/>
    <xsl:param name="preexistingSchemaComponents"/>
    <xsl:param name="previousSchemaVersion"/>
    
    <xsl:variable name="previousSchemaCollection" select="collection(concat('file:///',$previousSchemaInputDir,'?select=*.xsd&amp;recurse=yes'))"/>
    
    <xsl:key name="schema-by-name-and-namespace" match="*:schema/*[@name]" use="concat(@name,tokenize(parent::*:schema/@targetNamespace,'[/:]')[last()])"/><!-- e.g. 'TrademarkDocumentType,Trademark' -->
    
    <xsl:template match="/" mode="component-status">
        <components>
            <xsl:for-each select="tokenize($newSchemaComponents, ';')">
                <xsl:variable name="newSchemaFile" select="concat('file:/',current())"/>
                <xsl:variable name="newSchema" select="doc($newSchemaFile)"/>
                <xsl:for-each select="$newSchema/*:schema/*[@name]"><!-- loop through in case flattened schema -->
                    <xsl:variable name="componentName" select="$newSchema/*:schema/*[@name]/@name"/>
                    <xsl:variable name="namespaceName" select="$newSchema/*:schema/@targetNamespace/tokenize(., '[/:]')[last()]"/>
                    <component uri="{$newSchemaFile}" status="new" namespace="{$namespaceName}" name="{$componentName}"/>
                </xsl:for-each>
                <!-- resultPattern uri has file protocol -->
            </xsl:for-each>
            <xsl:for-each select="tokenize($preexistingSchemaComponents, ';')">
                <xsl:variable name="currentSchemaFile" select="concat('file:/', current())"/>
                <xsl:variable name="currentSchema" select="doc($currentSchemaFile)"/>
                <xsl:for-each select="$currentSchema/*:schema/*[@name]">
                    <!-- loop through in case flattened schema -->
                    <xsl:variable name="componentName" select="$currentSchema/*:schema/*[@name]/@name"/>
                    <xsl:variable name="namespaceName" select="$currentSchema/*:schema/@targetNamespace/tokenize(., '[/:]')[last()]"/>
                    <xsl:variable name="previousComponent" select="$previousSchemaCollection/key('schema-by-name-and-namespace', concat($componentName, $namespaceName))"/>

                    <xsl:choose>
                       <!-- <xsl:when test="deep-equal($previousComponent/@*, current()/@*) = false()">
                            <component uri="{$currentSchemaFile}" status="modified" namespace="{$namespaceName}" name="{$componentName}"/>
                        </xsl:when>-->
                        <!-- <xsl:when test="deep-equal($previousComponent/descendant::*, current()/descendant::*) = false()">
                            <component uri="{$currentSchemaFile}" status="modified" namespace="{$namespaceName}" name="{$componentName}"/>
                        </xsl:when>-->
                        <xsl:when test="deep-equal($previousComponent,current()) = false()"><!-- compare only at the component leve; this works in conjunction with saxon setting to strip whitespace only nodes (see ant build) -->
                            <component uri="{$currentSchemaFile}" status="modified" namespace="{$namespaceName}" name="{$componentName}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <component uri="{$currentSchemaFile}" status="unchanged" namespace="{$namespaceName}" name="{$componentName}"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:for-each>
        </components>
    </xsl:template>
    
</xsl:stylesheet>