<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:fnx="http://www.example.com/fnx">
  
  <xsl:param name="kXsdValidatorVersion" select="'?.?'"/>
  
  <xsl:function name="fnx:make_tr_class">
   <xsl:param name="status"/>
   <xsl:param name="method"/>
   <xsl:choose>
     <xsl:when test="$method eq 'Auto' and $status eq 'success'">passTr</xsl:when>
     <xsl:when test="$method eq 'Partial' and $status eq 'success'">manualTr</xsl:when>
     <xsl:when test="$method = ('Auto','Partial') and $status eq 'warning'">warnTr</xsl:when>
     <xsl:when test="$method = ('Auto','Partial') and $status eq 'failure'">failTr</xsl:when>
     <xsl:otherwise><xsl:value-of select="concat(lower-case($method), 'Tr')"/></xsl:otherwise>
   </xsl:choose>
  </xsl:function>

  <xsl:variable name="patterns"
                select="document(concat('file:///',$schFile))/sch:schema">
  </xsl:variable>

  <xsl:variable name="st96rules"
                select="document(concat('file:///',$st96rulesFile))/st96rules"/>

  <xsl:function name="fnx:calc_pattern_method">
    <xsl:param name="st96ruleId"/>
     <xsl:sequence select="fnx:automation-type($patterns/sch:pattern[sch:title eq $st96ruleId])"/>
  </xsl:function>

  <xsl:variable name="collectedSVRLFiles" as="xsd:string*">
    <xsl:choose>
      <xsl:when test="$svrlSingleFile">
        <xsl:sequence select="$svrlSingleFileFullPath"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="collection(concat('file:///', $svrlDirFullPath, '?select=*.svrl&amp;recurse=yes'))">
          <xsl:value-of select="document-uri(.)"/>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="numXSDs"
                select="count($collectedSVRLFiles)"/>

  <xsl:variable name="resultsPass">
    <patterns>
      <xsl:merge>
        <xsl:merge-source name="patterns" select="$st96rules/st96rule">
          <xsl:merge-key select="@id"/>
        </xsl:merge-source>
        <xsl:merge-source name="results" for-each-source="$collectedSVRLFiles" streamable="false" select="/svrl:schematron-output/*[local-name() = 'failed-assert' or local-name() = 'successful-report' ]">
          <xsl:merge-key select="svrl:diagnostic-reference/@diagnostic[matches(.,'[SG]D-\d\d')]"/>
        </xsl:merge-source>
        <xsl:merge-action>
          <pattern st96ruleId="{current-merge-key()}">
            <xsl:attribute name="status"><!-- change to deleted, success, warning, failure  -->
              <xsl:choose>
                <xsl:when test="current-merge-group('patterns')/@deleted='true'">
                  <xsl:text>deleted</xsl:text>
                </xsl:when>
                <xsl:when test="empty(current-merge-group('results')[local-name() = 'failed-assert' or local-name() = 'successful-report'])">
                  <xsl:text>success</xsl:text>
                </xsl:when>
                <xsl:when test="exists(current-merge-group()[@role = 'WARNING'])"><!-- **** -->
                  <xsl:text>warning</xsl:text>
                </xsl:when>
                <xsl:when test="exists(current-merge-group()[@role = 'ERROR'])">
                  <xsl:text>failure</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>unknown</xsl:text>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="method"><!-- 'Auto', 'Partial', or sequence of both; refer to fnx:automation-type; purely based on schematron, not the results themselves -->
              <xsl:value-of select="fnx:automation-type($patterns/sch:pattern[sch:title eq current-merge-key()])"/>
            </xsl:attribute>
            <!-- add design rule description here? -->
            <description>
              <xsl:value-of select="current-merge-group('patterns')"/>
            </description>
            <xsl:for-each select="current-merge-group('results')[svrl:diagnostic-reference]">
              <xsl:variable name="namespace" select="svrl:diagnostic-reference[@diagnostic = 'namespaceName']"/>
              <xsl:variable name="component" select="svrl:diagnostic-reference[@diagnostic = 'componentName']"/>
              <xsl:variable name="schemaFile" select="replace(svrl:diagnostic-reference[@diagnostic = 'uri']/tokenize(.,'/')[last()],'_V\d+_\d+','')"/><!-- ignore version part of file -->
              <result uri="{string(svrl:diagnostic-reference[@diagnostic = 'uri'][1])}">
                <xsl:attribute name="type">
                  <xsl:choose>
                    <xsl:when test="self::svrl:failed-assert">failed-assert</xsl:when>
                    <xsl:otherwise>successful-report</xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:attribute name="is-exception" select="$approvedExceptions and boolean($approvedExceptions/ApprovedExceptions/ApprovedException[@ruleID=current-merge-key()]/xsd[@subdir = $namespace][replace(tokenize(@file,'/')[last()],'_V\d+_\d+','') = $schemaFile])"/>
                  
                
                
                <xsl:if test="$component">
                  <xsl:attribute name="component">
                      <xsl:value-of select="$component"/>
                    </xsl:attribute>
                </xsl:if>
                <xsl:if test="$namespace">
                  <xsl:attribute name="namespace">
                      <xsl:value-of select="$namespace"/>
                    </xsl:attribute>
                </xsl:if>
                <xsl:value-of select="svrl:text"/>
              </result>
            </xsl:for-each>
          </pattern>
          
        </xsl:merge-action>
      </xsl:merge>
    </patterns>
  </xsl:variable>

   <xsl:template name="DebugInfo">
    <xsl:param name="xmlInfo"/>
    <div style="border: 1px solid #880000; padding: 24px; background: #ffeeee">
      <h2 style="color: #880000">Debug Info</h2>
      <textarea rows="50" style="width: 100%; border: 1px solid #880000" spellcheck="false">
        <xsl:sequence select="$xmlInfo"/>
      </textarea>
    </div>
  </xsl:template>
  
  <xsl:variable name="gdST96ruleCount"
                select="count($st96rules/st96rule[substring(@id, 1, 2) eq 'GD'])"/>
  <xsl:variable name="sdST96ruleCount"
                select="count($st96rules/st96rule[substring(@id, 1, 2) eq 'SD'])"/>
  <xsl:variable name="totalST96ruleCount"
                select="$gdST96ruleCount + $sdST96ruleCount"/>

  <xsl:variable name="autoRules" select="$patterns/sch:pattern[fnx:automation-type(.) = 'Auto']/sch:title"/>
  <xsl:variable name="autoCount" select="count($autoRules)"/><!-- count rules checked automatically -->
  <xsl:variable name="partialRules" select="$patterns/sch:pattern[fnx:automation-type(.) = 'Partial']/sch:title"/>
  <xsl:variable name="partialCount" select="count($partialRules)"/>
  <xsl:variable name="manualRules" select="$patterns/sch:pattern[fnx:automation-type(.) = 'Manual']/sch:title"/>
  <xsl:variable name="manualCount" select="count($manualRules)"/>
  <xsl:variable name="deletedCount" select="count($patterns/sch:pattern[fnx:automation-type(.) = 'Deleted'])"/>
  <xsl:variable name="unaddressedCount" select="$totalST96ruleCount - $autoCount - $partialCount - $manualCount - $deletedCount"/>
  <xsl:variable name="patternCount" select="count($patterns/sch:pattern)"/>

  <!--<xsl:variable name="auto-results" select="$resultsPass1/patterns/pattern[fnx:calc_pattern_method(@st96ruleId)='Auto']"/>-->
  <xsl:variable name="auto-results" select="$resultsPass/patterns/pattern[@st96ruleId = ($autoRules)]"/>
  <xsl:variable name="auto-failCount" select="count(distinct-values($auto-results[@status eq 'failure']))"/><!-- return how many automatic rules failed -->

  <xsl:variable name="auto-warnCount" select="count(distinct-values($auto-results[@status eq 'warning']))"/><!-- return how many automatic rules warned -->

  <xsl:variable name="auto-passCount"
                      select="$autoCount - $auto-failCount - $auto-warnCount"/><!-- return how many automatic rules passed -->
  <xsl:variable name="partial-results" select="$resultsPass/patterns/pattern[@st96ruleId = ($partialRules)]"/>
<!--  <xsl:variable name="partial-results" select="$resultsPass1/patterns/pattern[fnx:calc_pattern_method(@st96ruleId)='Partial']"/>-->
  <xsl:variable name="partial-failCount"
                      select="count(distinct-values($partial-results[@status eq 'failure']))"/><!-- return how many semi-manual failed -->

  <xsl:variable name="partial-warnCount"
                      select="count(distinct-values($partial-results[@status eq 'warning']/@st96ruleId))"/><!-- return how many semi-manual rules warned -->

  <xsl:variable name="partial-passCount"
                      select="$partialCount - $partial-failCount - $partial-warnCount"/><!-- return how many semi-manual rules passed -->
  <!--<xsl:variable name="failureIds"
                      select="distinct-values($resultsPass1/patterns/pattern[@status eq 'failure']/@st96ruleId)"/>-->

  <!--<xsl:variable name="testedRuleCount"
                select="count(distinct-values($resultsPass1/patterns/pattern/@st96ruleId))"/><!-\- 2021-01-05: updated to include only fired... -\->-->
  <xsl:variable name="testedRuleCount"
                select="$totalST96ruleCount - $manualCount"/><!-- ** NEED TO UPDATE; what about manual inspection rules?? -->

  <xsl:variable name="untestedCount"
                select="$totalST96ruleCount - $testedRuleCount"/><!-- untested in this sense just means there is no pattern in the Schematron for the corresponding rule -->

  <!--<xsl:variable name="assertionPassCount"
                select="count($patterns/sch:pattern/sch:rule/sch:assert[not(@flag eq 'MANUAL')])"/>--><!-- possible assertion count?? -->
  <xsl:variable name="approvedExceptions"
                select="if (doc-available('../ApprovedExceptions.xml')) then doc('../ApprovedExceptions.xml') else false()"/>

  <xsl:template name="genDrcVersionInfo">
    <div class="drcVersionDiv">
      <span class="drcVersion"><b>DRC Information:</b> </span>
      <span class="drcDocFileName"> <xsl:value-of select="$st96rules/@drcDocFileName"/></span>
      <xsl:text> </xsl:text>
      <span class="drcVersion">Version: v<xsl:value-of select="$st96rules/@drcVersionNum"/></span>
      <span class="drcDocFileLastModifiedDate">Modified: <xsl:value-of select="$st96rules/@drcDocLastModifiedDate"/></span>
    </div>
  </xsl:template>
  <xsl:template name="genXSDValidatorVersionInfo">
    ST96XSDValidator (V<xsl:value-of select="$kXsdValidatorVersion"/>)
  </xsl:template>

  <xsl:function name="fnx:automation-type">
     <xsl:param name="pattern" as="element(sch:pattern)"/>
     <xsl:variable name="asserts" select="$pattern/sch:rule/(sch:assert|sch:report)"/>
     <xsl:choose>
        <xsl:when test="not($asserts)">Unaddressed</xsl:when>
        <xsl:when test="not($asserts[@flag = ('MANUAL','DELETED')])">Auto</xsl:when>
        <xsl:when test="$asserts[@flag eq 'MANUAL'] and $asserts[not(@flag = 'MANUAL')]">Partial</xsl:when>
        <xsl:when test="$asserts[@flag eq 'MANUAL']">Manual</xsl:when>
        <xsl:when test="$asserts[@flag eq 'DELETED']">Deleted</xsl:when>
        <xsl:otherwise>Unknown</xsl:otherwise>
     </xsl:choose>
    
  </xsl:function>

</xsl:stylesheet>
