<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"  
    exclude-result-prefixes="xs xsd"
    version="2.0">
    
    <xsl:param name="collectionFiles"/>
    <!--<xsl:output method="text" encoding="UTF-8"/>-->
    
    <xsl:template match="/">
        <annotations>
            <xsl:for-each select="tokenize($collectionFiles, ';')">
                <xsl:apply-templates select="doc(current())//*[@name][*:annotation[1]/*:documentation[1]]"/>
            </xsl:for-each>
        </annotations>
    </xsl:template>
    
    <xsl:template match="*">
        <component name="{@name}" namespace="{ancestor::xsd:schema[1]/@targetNamespace}" type="{local-name()}"><xsl:value-of select="*:annotation[1]/*:documentation[1]"/></component>
    </xsl:template>
    
</xsl:stylesheet>