<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:x="http://www.jenitennison.com/xslt/xspec"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all"
                version="3.0">

   <!--
      mode="x:declare-variable"
      Generates XSLT or XQuery variable declaration(s) from the current element. Actual
      implementation depends on language (XSLT or XQuery).
      
      This mode itself does not handle whitespace-only text nodes specially. To handle
      whitespace-only text node in a special manner, the text node should be handled specially
      before applying this mode and/or mode="x:node-constructor" should be overridden.
      
      Handling of @static depends on language (XSLT or XQuery).
   -->
   <xsl:mode name="x:declare-variable" on-multiple-match="fail" on-no-match="fail" />

   <xsl:template match="element()" as="node()+" mode="x:declare-variable">
      <xsl:param name="comment" as="xs:string?" />

      <xsl:variable name="current-element-is-global" as="xs:boolean"
         select="exists(parent::x:description)" />

      <!-- Dispatch to a language-specific (XSLT or XQuery) worker template -->
      <xsl:call-template name="x:declare-variable">
         <xsl:with-param name="comment" select="$comment" />

         <!-- URIQualifiedName of the variable being declared -->
         <xsl:with-param name="uqname" select="x:variable-UQName(.)" />

         <!-- Child nodes to be excluded -->
         <xsl:with-param name="exclude" select="self::x:context/x:param | self::x:expect/x:label" />

         <!-- True if the variable should be declared as global -->
         <xsl:with-param name="as-global" select="$current-element-is-global" />

         <!-- XSLT: True if the variable should be declared using xsl:param (not xsl:variable).
            XQuery: True if the variable should be declared as external. -->
         <xsl:with-param name="as-param" select="self::x:param and $current-element-is-global" />

         <!-- URIQualifiedName of the temporary runtime variable which holds a document specified by
            child::node() or @href -->
         <xsl:with-param name="temp-doc-uqname" as="xs:string?">
            <xsl:if test="node() or @href">
               <xsl:sequence
                  select="x:known-UQName('impl:' || local-name() || '-' || generate-id() || '-doc')" />
            </xsl:if>
         </xsl:with-param>
      </xsl:call-template>
   </xsl:template>

   <!--
      Utils for variable declarations
   -->

   <!--
      Returns URIQualifiedName of the variable generated by mode="x:declare-variable"
   -->
   <xsl:function as="xs:string" name="x:variable-UQName">
      <xsl:param as="element()" name="source-element" />

      <!-- xsl:for-each is not for iteration but for simplifying XPath -->
      <xsl:for-each select="$source-element">
         <xsl:choose>
            <xsl:when test="@name">
               <xsl:sequence select="x:UQName-from-EQName-ignoring-default-ns(@name, .)" />
            </xsl:when>

            <xsl:otherwise>
               <xsl:sequence
                  select="x:known-UQName('impl:' || local-name() || '-' || generate-id())" />
            </xsl:otherwise>
         </xsl:choose>
      </xsl:for-each>
   </xsl:function>

</xsl:stylesheet>