<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                xmlns:fnx="http://www.example.com/fnx">

  <!-- The main xmlIPV development directory param, devDir, must be set. -->
  <xsl:param name="devDir"/> <!-- full path to xmlIPV dev dir; required -->

  <!-- Either svrlSingleFile or svrlDir must be set -->
  <xsl:param name="svrlSingleFile"/>
  <xsl:param name="svrlDir"/>

  <xsl:variable name="devDirForwardSlashes" select="replace($devDir, '\\', '/')"/>
  <xsl:variable name="st96rulesFile" select="concat($devDir, '/st96rules.xml')"/>
  <xsl:variable name="schFile" select="concat($devDir, '/schemas/wipo_xsd.sch')"/>
  <xsl:variable name="cssFile" select="concat($devDir, '/css/report.css')"/>
  <xsl:variable name="svrlSingleFileFullPath" select="concat($devDirForwardSlashes, '/', $svrlSingleFile)"/>
  <xsl:variable name="svrlDirFullPath" select="concat($devDirForwardSlashes, '/', $svrlDir)"/>

  <xsl:output encoding="UTF-8" method="html" indent="yes"/>

  <xsl:include href="../../xsl/common.xsl"/>

  <xsl:variable name="schematronUnitTests">
    <unitTests xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               xmlns="http://purl.oclc.org/dsdl/schematron">
      <xsl:for-each select="collection('../schemas/split_guidelines_tests/?select=*.sch')">
        <xsl:copy-of select="."/>
      </xsl:for-each>
    </unitTests>
  </xsl:variable>

  <xsl:template match="/">
    <html>
      <head>
        <title>ST96XSDValidator - Project Status - ST.96 Conformance Checking via Schematron</title>
        <style type="text/css">
          <xsl:value-of select="unparsed-text(concat('file:///', $cssFile))" disable-output-escaping="yes" />.methodSummaryTd{min-width:8ch;}.ruleIdTd{min-width:10ch;/*70px*/}.ruleIdTd,.methodSummaryTd{vertical-align:top;}table.sortable th{cursor:pointer;}.sortable th{content:"  ";}.sortable th.dir-d::after {color: inherit;content: " \025B4";}
.sortable th.dir-u::after {color: inherit;content: " \025BE";}
        </style>
        <script type="text/javascript">
               <xsl:text>/*!
 * sortable 
 * https://github.com/tofsjonas/sortable/blob/master/LICENSE 
*/ </xsl:text>
               <xsl:text disable-output-escaping="yes">document.addEventListener("click",function(d){function f(a,b){a.className=a.className.replace(h,"")+b}var h=/ dir-(u|d) /,a=/\bsortable\b/,b=d.target;if("TH"==b.nodeName&amp;&amp;(d=b.offsetParent,a.test(d.className))){var e,c=b.parentNode.cells;for(a=0;a&lt;c.length;a++)c[a]===b?e=a:f(c[a],"");a=" dir-d ";-1!==b.className.indexOf(" dir-d ")&amp;&amp;(a=" dir-u ");f(b,a);b=d.tBodies[0];c=[].slice.call(b.cloneNode(!0).rows,0);var k=" dir-u "==a;c.sort(function(a,b){a=a.cells[e].innerText;b=b.cells[e].innerText;if(k){var c=
a;a=b;b=c}return isNaN(a-b)?a.localeCompare(b):a-b});var g=b.cloneNode();for(a=0;a&lt;c.length;a++)g.appendChild(c[a]);d.replaceChild(g,b)}});
</xsl:text>
            </script>
      </head>
      <body>
		<h1 align="center" class="noWrap"><xsl:call-template name="genXSDValidatorVersionInfo"/> Test Results </h1>
		<h2 align="center" class="noWrap">Project Status - ST.96 Conformance Checking via Schematron</h2>  
		
        <div class="timeStampDiv">
          <span style="font-family: sans-serif"> Run at </span>
          <xsl:value-of select="format-dateTime(current-dateTime(), '[Y0001]-[M01]-[D01] [H01]:[m01] [Z]')"/>
        </div>

        <div>
          <hr/>
		  <xsl:call-template name="genDrcVersionInfo"/>
          <xsl:text>There are </xsl:text>
          <xsl:value-of select="$totalST96ruleCount"/>
          <xsl:text> </xsl:text>
          <a href="../../../doc/03-96-i.pdf" target="_blank">ST.96 Annex I XML Design Rules And Conventions</a>
          <xsl:text> rules: </xsl:text>
          <xsl:value-of select="$gdST96ruleCount"/>
          <xsl:text> General Design (GD) rules and </xsl:text>
          <xsl:value-of select="$sdST96ruleCount"/>
          <xsl:text> Schema Design (SD) rules; </xsl:text>
          <xsl:value-of select="$deletedCount"/>
          <xsl:text> rule</xsl:text>
          <xsl:value-of select="if ($deletedCount = 1) then ' has' else 's have'"/>
          <xsl:text> been deleted.  Unit testing is currently performed via </xsl:text>
          <xsl:value-of select="count($schematronUnitTests/sch:unitTests/sch:schema/sch:pattern/sch:rule/sch:assert)"/>
          <xsl:text> assertions against </xsl:text>
          <xsl:value-of select="$autoCount"/>
          <xsl:text> automatically checked rules.  Manually checked (</xsl:text>
          <xsl:value-of select="$manualCount"/>
          <xsl:text>) and unaddressed rules (</xsl:text>
          <xsl:value-of select="$unaddressedCount"/>
          <xsl:text>) cannot be automatically unit tested.</xsl:text>
          
          <div><b>Note: </b>Unit test messages are hard-coded, and must be updated if the schematron assertion messages are updated.</div>
          <hr/>
        </div>

<!--
        <xsl:call-template name="DebugInfo">
          <xsl:with-param name="xmlInfo" select="$resultsPass1"/>
        </xsl:call-template>
-->
        <h2>Rule Coverage Summary</h2>
       
        <xsl:if test="$patternCount != $totalST96ruleCount">
          <p style="color: red">WARNING: Schematron pattern count (<xsl:value-of select="$patternCount"/>) does not equal the ST.96 rule count (<xsl:value-of select="$totalST96ruleCount"/>) plus the deleted rule count (<xsl:value-of select="$deletedCount"/>).</p>
        </xsl:if>
        
        <div class="conformanceCoverageDiv">
          <div class="colLeft">
            <table>
              <caption>Conformance</caption>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($autoCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>automated</td>
              </tr>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($partialCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>partially automated</td>
              </tr>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($manualCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>manual</td>
              </tr>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($unaddressedCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>unaddressed</td>
              </tr>
            </table>
          </div>

          <div class="colRight"><!-- *** NEED TO UPDATE the way these are counted... -->
            <table>
              <caption>Unit Testing</caption>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($auto-passCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>automatically pass</td>
              </tr>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($auto-failCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>automatically fail</td>
              </tr>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($partial-passCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>partially pass</td>
              </tr>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($partial-failCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>partially fail</td>
              </tr>
              <tr>
                <td class="percent">
                  <xsl:value-of select="format-number($untestedCount div $totalST96ruleCount, '0%')"/>
                </td>
                <td>untested</td>
              </tr>
            </table>
          </div>
          
        </div>
        <div style="margin-top: 16px; font-size: 18pt; font-weight: bold">Rule Coverage Details</div>

        <table style="margin-top: 16px;" class="sortable table table-bordered table-condensed table-striped table-primary results">
          <colgroup>
            <col width="64px"/>
          </colgroup>
          <tr>
            <th>Rule Id</th>
            <th colspan="2">Description / Results</th>
            <th>Conformance Method</th>
            <th>Unit Tests</th>
          </tr>
          <xsl:for-each select="$st96rules/st96rule">
            <xsl:variable name="st96ruleId" select="@id"/>
            <xsl:variable name="resultPattern" select="$resultsPass2/patterns/pattern[@st96ruleId eq $st96ruleId]"/>
            <xsl:variable name="method" select="fnx:calc_pattern_method($st96ruleId)"/>

            <!--<xsl:message>$resultPattern=<xsl:sequence select="$resultPattern"/></xsl:message>-->

            <xsl:variable name="isDeleted" select="$st96rules/st96rule[@id=$st96ruleId and @deleted='true']"/>
            <xsl:variable name="trClass" select="if ($isDeleted) then 'deletedTr' else fnx:make_tr_class($resultPattern/@status, $method)"/>
            <tr class="{$trClass}">
              <xsl:variable name="deletedClass" select="if ($st96rules/st96rule[@id=$st96ruleId and @deleted='true']) then 'deletedRule' else ''"/>
              <td class="ruleIdTd {$deletedClass}"><xsl:value-of select="$st96ruleId"/></td>
              <td class="descriptionTd" colspan="2">
                <xsl:choose>
                  <xsl:when test="$isDeleted">
                    <i>Deleted</i>
                  </xsl:when>
                  <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
                </xsl:choose>
              </td>
              <td class="methodStatusTd">
                <xsl:if test="not($isDeleted)">
                  <xsl:value-of select="$method"/>
                </xsl:if>
              </td>
              <td class="unitResultTd">
                <xsl:if test="not($isDeleted)">
                  <xsl:choose>
                    <xsl:when test="$method eq 'Manual'">None</xsl:when>
                    <xsl:when test="$method eq 'Unaddressed'">None</xsl:when>
                    <!--<xsl:when test="$resultPattern/@status eq 'success'">Pass</xsl:when>
                    <xsl:when test="$resultPattern/@status eq 'warning'">Warn</xsl:when>-->
                    <xsl:when test="$resultPattern/@status eq 'success' or (every $x in $resultPattern/result satisfies starts-with($x,'Successfully identified error:'))">Pass</xsl:when>
                    <xsl:when test="$resultPattern/@status eq 'warning'">Warn</xsl:when>
                    <xsl:otherwise>Fail</xsl:otherwise>
                  </xsl:choose>
                </xsl:if>
              </td>
            </tr>
            <xsl:for-each select="$resultsPass2/patterns/pattern[@st96ruleId eq $st96ruleId]">
              <xsl:choose>
                <xsl:when test="@status eq 'failure' or @status eq 'warning'">
                  <xsl:variable name="trClass" select="fnx:make_tr_class($resultPattern/@status, $method)"/>
                  <xsl:variable name="numFailures" select="count(result[not(starts-with(.,'Successfully identified error:'))])"/>
                  <xsl:variable name="numSucceeded" select="count(result[starts-with(.,'Successfully identified error:')])"/>
                  
                  <xsl:for-each select="result[not(starts-with(.,'Successfully identified error:'))]">
                    <xsl:if test="position() eq 1">
                      <tr class="{$trClass}">
                        <td/>
                        <td class="violationHeaderTd">These <xsl:value-of select="
                            if ($numFailures &gt; 3) then
                              $numFailures
                            else
                              ''"/> unit tests failed for <xsl:value-of select="$st96ruleId"/>:</td>
                        <td class="violationHeaderTd">Failure details:</td>
                        <td/>
                        <td/>
                      </tr>
                    </xsl:if>
                    <tr class="{$trClass}">
                      <xsl:variable name="uri" select="@uri"/>
                      <td/>
                      <td class="fileNameTd"><a href="../input/{fnx:ShortenName($uri)}" target="_blank"><xsl:value-of select="fnx:ShortenName($uri)"/></a></td>
                      <td class="reportTextTd"><xsl:value-of select="text()"/></td>
                      <td/>
                      <td/>
                    </tr>
                  </xsl:for-each>
                  <xsl:for-each select="result[starts-with(.,'Successfully identified error:')]"><!-- 2020-1-18: show errors successfully found -->
                    <xsl:if test="position() eq 1">
                      <tr class="passTr">
                        <td/>
                        <td class="violationHeaderTd">These <xsl:value-of select="
                            if ($numSucceeded &gt; 3) then
                              $numSucceeded
                            else
                              ''"/> unit tests passed for <xsl:value-of select="$st96ruleId"/>:</td>
                        <td class="violationHeaderTd">Details:</td>
                        <td/>
                        <td/>
                      </tr>
                    </xsl:if>
                    <tr class="passTr">
                      <xsl:variable name="uri" select="@uri"/>
                      <td/>
                      <td class="fileNameTd"><a href="../input/{fnx:ShortenName($uri)}" target="_blank"><xsl:value-of select="fnx:ShortenName($uri)"/></a></td>
                      <td class="reportTextTd"><xsl:value-of select="text()"/></td>
                      <td/>
                      <td/>
                    </tr>
                  </xsl:for-each>
                    
                  
                </xsl:when>
              </xsl:choose>
            </xsl:for-each>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:function name="fnx:ShortenName">
   <xsl:param name="uri"/>
    <xsl:value-of select="replace(substring-after($uri, 'dev/test/svrl_conformance_svrl/'), '.svrl', '.xsd')"/>
  </xsl:function>

</xsl:stylesheet>
