<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-49</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg0" value="fnx:expect('@minOccurs is set to the default value (1) for xs:element (e3).', /)"/>
      <let name="failmsg1" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:element (e4).', /)"/>
      <let name="failmsg2" value="fnx:expect('@minOccurs is set to the default value (1) for xs:sequence.', /)"/>
      <let name="failmsg3" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:sequence.', /)"/>
      <let name="failmsg4" value="fnx:expect('@minOccurs is set to the default value (1) for xs:any.', /)"/>
      <let name="failmsg5" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:any.', /)"/>
      <let name="failmsg6" value="fnx:expect('@minOccurs is set to the default value (1) for xs:all.', /)"/>
      <let name="failmsg7" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:all.', /)"/>
      <let name="failmsg8" value="fnx:expect('@minOccurs is set to the default value (1) for xs:choice.', /)"/>
      <let name="failmsg9" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:choice.', /)"/>
      <let name="failmsg10" value="fnx:expect('@minOccurs is set to the default value (1) for xs:group.', /)"/>
      <let name="failmsg11" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:group.', /)"/>

      <!-- Assertions -->

      <assert test="fnx:failed-assert-count-is(12, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(12, .)"/>
      </assert>

      <assert test="$failmsg0 = ''" flag="AUTO"><value-of select="$failmsg0"/></assert>
      <assert test="$failmsg1 = ''" flag="AUTO"><value-of select="$failmsg1"/></assert>
      <assert test="$failmsg2 = ''" flag="AUTO"><value-of select="$failmsg2"/></assert>
      <assert test="$failmsg3 = ''" flag="AUTO"><value-of select="$failmsg3"/></assert>
      <assert test="$failmsg4 = ''" flag="AUTO"><value-of select="$failmsg4"/></assert>
      <assert test="$failmsg5 = ''" flag="AUTO"><value-of select="$failmsg5"/></assert>
      <assert test="$failmsg6 = ''" flag="AUTO"><value-of select="$failmsg6"/></assert>
      <assert test="$failmsg7 = ''" flag="AUTO"><value-of select="$failmsg7"/></assert>
      <assert test="$failmsg8 = ''" flag="AUTO"><value-of select="$failmsg8"/></assert>
      <assert test="$failmsg9 = ''" flag="AUTO"><value-of select="$failmsg9"/></assert>
      <assert test="$failmsg10 = ''" flag="AUTO"><value-of select="$failmsg10"/></assert>
      <assert test="$failmsg11 = ''" flag="AUTO"><value-of select="$failmsg11"/></assert>

    </rule>
	</pattern>
</schema>