<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns="http://purl.oclc.org/dsdl/schematron">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
	<ns prefix="fnx" uri="http://www.example.com/fnx"/>
	<ns prefix="xsl" uri="http://www.w3.org/1999/XSL/Transform"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-34</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">

      <let name="failmsg3" value="fnx:expect-infile(
                                  'Element MathStuff: mathml:math should be used for math data.',
                                  '3.svrl', $inFileName, /)"/>
      
      <let name="failmsg5" value="fnx:expect-infile(
                                  'Element MathJunk: mathml:math should be used for math data.',
                                  '5.svrl', $inFileName, /)"/>

      <let name="failmsg6" value="fnx:expect-infile(
                                  'Element AlgebraThing: mathml:math should be used for math data.',
                                  '6.svrl', $inFileName, /)"/>
      
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '3.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '4.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '5.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '6.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '7.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg3, '3.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg5, '5.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg5"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg6, '6.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg6"/>
      </assert>

    </rule>
	</pattern>
</schema>