<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

	<pattern>
		<title>SD-19</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg2" value="fnx:expect-infile(
                                  'For XSD found in the Patent subdirectory, @targetNamespace (http://www.wipo.int/standards/XMLSchema/ST96/BAD) must equal http://www.wipo.int/standards/XMLSchema/ST96/Patent',
                                  '2.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile(
                                  'For XSD found in the Patent subdirectory, @targetNamespace (http://www.wipo.int/standards/XMLSchema/ST96/BAD) must equal http://www.wipo.int/standards/XMLSchema/ST96/Patent',
                                  '4.svrl', $inFileName, /)"/>
      <let name="failmsg6" value="fnx:expect-infile(
                                  'For XSD found in the USPatent subdirectory, @targetNamespace (urn:us:gov:doc:uspto:bad) must equal urn:us:gov:doc:uspto:patent',
                                  '6.svrl', $inFileName, /)"/>
      <let name="failmsg8" value="fnx:expect-infile(
                                  'For XSD found in the USPatent subdirectory, @targetNamespace (urn:us:gov:doc:uspto:bad) must equal urn:us:gov:doc:uspto:patent',
                                  '8.svrl', $inFileName, /)"/>
      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '3.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '4.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '5.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '6.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '7.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '8.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg4, '4.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg4"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg6, '6.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg6"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg8, '8.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg8"/>
      </assert>
    </rule>
	</pattern>
</schema>