<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-03</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Patent namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '1b.svrl', $inFileName, /)"/>
      <let name="failmsg1c" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Patent namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.',
                                   '1c.svrl', $inFileName, /)"/>
      <let name="failmsg2b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Trademark namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '2b.svrl', $inFileName, /)"/>
      <let name="failmsg2c" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Trademark namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.',
                                   '2c.svrl', $inFileName, /)"/>
      <let name="failmsg3b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Design namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Patent.',
                                   '3b.svrl', $inFileName, /)"/>
      <let name="failmsg3c" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Design namespace may not refer to XSDs in the following namespace(s):
        urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.',
                                   '3c.svrl', $inFileName, /)"/>
      <let name="failmsg4b" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:patent namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '4b.svrl', $inFileName, /)"/>
      <let name="failmsg4c" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:patent namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.',
                                   '4c.svrl', $inFileName, /)"/>
      <let name="failmsg5b" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:trademark namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '5b.svrl', $inFileName, /)"/>
      <let name="failmsg5c" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:trademark namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.',
                                   '5c.svrl', $inFileName, /)"/>
      <let name="failmsg6b" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:design namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Patent.',
                                   '6b.svrl', $inFileName, /)"/>
      <let name="failmsg6c" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:design namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.',
                                   '6c.svrl', $inFileName, /)"/>
     <let name="failmsg7b" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:corporate namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '7b.svrl', $inFileName, /)"/>
      <let name="failmsg7c" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:corporate namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.',
                                   '7c.svrl', $inFileName, /)"/>
     <let name="failmsg8b" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:dissemination namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '8b.svrl', $inFileName, /)"/>
      <let name="failmsg8c" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:dissemination namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:legal.',
                                   '8c.svrl', $inFileName, /)"/>
     <let name="failmsg9b" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:legal namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '9b.svrl', $inFileName, /)"/>
      <let name="failmsg9c" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:legal namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination.',
                                   '9c.svrl', $inFileName, /)"/>

      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '3.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '4.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '5.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '6.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '7.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '8.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '9.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '1b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '2b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '3b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk'))
                    or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn'))
                    or fnx:failed-assert-count-is-infile(1, '4b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn'))
                    or fnx:failed-assert-count-is-infile(1, '5b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk'))
                    or not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or fnx:failed-assert-count-is-infile(1, '6b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '7b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
     <assert test="fnx:failed-assert-count-is-infile(1, '8b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
     <assert test="fnx:failed-assert-count-is-infile(1, '9b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk'))
                    or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn'))
                    or fnx:failed-assert-count-is-infile(1, '1c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn'))
                    or fnx:failed-assert-count-is-infile(1, '2c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk'))
                    or not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or fnx:failed-assert-count-is-infile(1, '3c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk'))
                    or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn'))
                    or fnx:failed-assert-count-is-infile(1, '4c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn'))
                    or fnx:failed-assert-count-is-infile(1, '5c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk'))
                    or not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or fnx:failed-assert-count-is-infile(1, '6c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '7c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
     <assert test="fnx:failed-assert-count-is-infile(1, '8c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
     <assert test="fnx:failed-assert-count-is-infile(1, '9c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg1b, '1b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg1b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg1c, '1c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg1c"/>
      </assert>

       <assert test="fnx:no-fail-infile($failmsg2b, '2b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg2c, '2c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2c"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg3b, '3b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg3c, '3c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3c"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg4b, '4b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg4b"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg4c, '4c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg4c"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg5b, '5b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg5b"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg5c, '5c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg5c"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg6b, '6b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg6b"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg6c, '6c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg6c"/>
      </assert>
       
     <assert test="fnx:no-fail-infile($failmsg7b, '7b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg7b"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg7c, '7c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg7c"/>
      </assert>
       
     <assert test="fnx:no-fail-infile($failmsg8b, '8b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg8b"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg8c, '8c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg8c"/>
      </assert>
     <assert test="fnx:no-fail-infile($failmsg9b, '9b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg9b"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg9c, '9c.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg9c"/>
      </assert>
 
    </rule>

	</pattern>
</schema>