<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>GD-31</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1" value="fnx:expect-infile(
                                  'The file name Bad_V1.0.xsd does not follow the required format &#x003C;ComponentName&#x003E;[_V&#x003C;MajorVersionNum&#x003E;_&#x003C;MinorVersionNum&#x003E;].&#x003C;FileExtension&#x003E;',
                                  'Bad_V1.0.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile(
                                  'The file name Bad_1_0.xsd does not follow the required format &#x003C;ComponentName&#x003E;[_V&#x003C;MajorVersionNum&#x003E;_&#x003C;MinorVersionNum&#x003E;].&#x003C;FileExtension&#x003E;',
                                  'Bad_1_0.svrl', $inFileName, /)"/>
      <let name="failmsg3" value="fnx:expect-infile(
        'The file name DesignClaimBagTextType.xsd does not follow the required format &#x003C;DesignClaimTextBagType&#x003E;[_V&#x003C;MajorVersionNum&#x003E;_&#x003C;MinorVersionNum&#x003E;].&#x003C;FileExtension&#x003E;', 
          'DesignClaimBagTextType.svrl', $inFileName, /)"/>
        
      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, 'Good.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'Good_V1_0.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'GoodDraft.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'Good_D1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'Bad_1_0.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'Bad_V1.0.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, 'DesignClaimBagTextType.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg1, 'Bad_V1.0.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg1"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg2, 'Bad_1_0.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg3, 'DesignClaimBagTextType.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3"/>
      </assert>

    </rule>
	</pattern>
</schema>