<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
  <!-- "the term component refers to type, element or attribute" -->

	<pattern>
		<title>GD-23</title>

    <rule context="svrl:schematron-output" role="ERROR">

      <let name="failmsg0" value="fnx:expect('E0Text must have Amount as a representation term, not Text.', /)"/>
      <let name="failmsg1" value="fnx:expect('E1Rate must have Category, Code, Identifier, Number, Text or Name as a representation term, not Rate.', /)"/>
      <let name="failmsg2" value="fnx:expect('E2Percent must have Category, Code, Identifier, Number, Text or Name as a representation term, not Percent.', /)"/>
      <let name="failmsg3" value="fnx:expect('E3Time must have Date as a representation term, not Time.', /)"/>
      <let name="failmsg4" value="fnx:expect('E4Time must have Date as a representation term, not Time.', /)"/>
      <let name="failmsg5" value="fnx:expect('E5Text must have Category, Code, Identifier or Number as a representation term, not Text.', /)"/>
      <let name="failmsg6" value="fnx:expect('E6Identifier must have Indicator as a representation term, not Identifier.', /)"/>
      <let name="failmsg7" value="fnx:expect('E7Rate must have Measure as a representation term, not Rate.', /)"/>
      <let name="failmsg8" value="fnx:expect('E8Quantity must have Text, Name, Number, Identifier or Category as a representation term, not Quantity.', /)"/>
      <let name="failmsg9" value="fnx:expect('E9URI must have Number as a representation term, not URI.', /)"/>
      <let name="failmsg10" value="fnx:expect('E10Percent must have Text, Name, Number, Identifier or Category as a representation term, not Percent.', /)"/>
      <let name="failmsg11" value="fnx:expect('E11Text must have Category, Code, Identifier or Number as a representation term, not Text.', /)"/>
      <let name="failmsg12" value="fnx:expect('E12Category must have Percent, Rate or Quantity as a representation term, not Category.', /)"/>
      <let name="failmsg13" value="fnx:expect('E13 must have Quantity as a representation term, but it has none.', /)"/>
      <let name="failmsg14" value="fnx:expect('E14 must have Quantity as a representation term, but it has none.', /)"/>
      <let name="failmsg15" value="fnx:expect('E15 must have Percent, Rate or Quantity as a representation term, but it has none.', /)"/>
      <let name="failmsg16" value="fnx:expect('E16 must have Text, Name, Number, Identifier or Category as a representation term, but it has none.', /)"/>
      <let name="failmsg17" value="fnx:expect('E17 must have Text, Name or Number as a representation term, but it has none.', /)"/>
      <let name="failmsg18" value="fnx:expect('E18 must have Time as a representation term, but it has none.', /)"/>
      <let name="failmsg19" value="fnx:expect('E19 must have DateTime as a representation term, but it has none.', /)"/>
      <let name="failmsg20" value="fnx:expect('E20 must have URI as a representation term, but it has none.', /)"/>
      <let name="failmsg21" value="fnx:expect('CategoryKind must have Category, Code, Identifier or Number as a representation term, but it has none.', /)"/>
      <!-- Assertions -->

      <assert test="fnx:failed-assert-count-is(22, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(22, .)"/>
      </assert>

      <assert test="$failmsg0 = ''" flag="AUTO"><value-of select="$failmsg0"/></assert>
      <assert test="$failmsg1 = ''" flag="AUTO"><value-of select="$failmsg1"/></assert>
      <assert test="$failmsg2 = ''" flag="AUTO"><value-of select="$failmsg2"/></assert>
      <assert test="$failmsg3 = ''" flag="AUTO"><value-of select="$failmsg3"/></assert>
      <assert test="$failmsg4 = ''" flag="AUTO"><value-of select="$failmsg4"/></assert>
      <assert test="$failmsg5 = ''" flag="AUTO"><value-of select="$failmsg5"/></assert>
      <assert test="$failmsg6 = ''" flag="AUTO"><value-of select="$failmsg6"/></assert>
      <assert test="$failmsg7 = ''" flag="AUTO"><value-of select="$failmsg7"/></assert>
      <assert test="$failmsg8 = ''" flag="AUTO"><value-of select="$failmsg8"/></assert>
      <assert test="$failmsg9 = ''" flag="AUTO"><value-of select="$failmsg9"/></assert>
      <assert test="$failmsg10 = ''" flag="AUTO"><value-of select="$failmsg10"/></assert>
      <assert test="$failmsg11 = ''" flag="AUTO"><value-of select="$failmsg11"/></assert>
      <assert test="$failmsg12 = ''" flag="AUTO"><value-of select="$failmsg12"/></assert>
      <assert test="$failmsg13 = ''" flag="AUTO"><value-of select="$failmsg13"/></assert>
      <assert test="$failmsg14 = ''" flag="AUTO"><value-of select="$failmsg14"/></assert>
      <assert test="$failmsg15 = ''" flag="AUTO"><value-of select="$failmsg15"/></assert>
      <assert test="$failmsg16 = ''" flag="AUTO"><value-of select="$failmsg16"/></assert>
      <assert test="$failmsg17 = ''" flag="AUTO"><value-of select="$failmsg17"/></assert>
      <assert test="$failmsg18 = ''" flag="AUTO"><value-of select="$failmsg18"/></assert>
      <assert test="$failmsg19 = ''" flag="AUTO"><value-of select="$failmsg19"/></assert>
      <assert test="$failmsg20 = ''" flag="AUTO"><value-of select="$failmsg20"/></assert>
      <assert test="$failmsg21 = ''" flag="AUTO"><value-of select="$failmsg21"/></assert>
    </rule>

	</pattern>
</schema>
