<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>GD-13</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg1" value="fnx:expect-infile('Attribute ISOThis contains these improperly capitalized abbreviations: ISO.', '1.svrl', $inFileName, /)"/>
      <!--<let name="failmsg2" value="fnx:expect-infile('Attribute isOthis contains these improperly capitalized abbreviations: ISO.', '1.svrl', $inFileName, /)"/>-->
      <!--<let name="failmsg3" value="fnx:expect-infile('Attribute iSOthis contains these improperly capitalized abbreviations: ISO.', '1.svrl', $inFileName, /)"/>-->
      <!--<let name="failmsg4" value="fnx:expect-infile('Attribute hasLoweriso contains these improperly capitalized abbreviations: ISO.', '1.svrl', $inFileName, /)"/>-->
      <let name="failmsg5" value="fnx:expect-infile('Attribute hasCapitalizedIso contains these improperly capitalized abbreviations: Iso.', '1.svrl', $inFileName, /)"/>
      <!--<let name="failmsg6" value="fnx:expect-infile('Attribute cpcAbccpc contains these improperly capitalized abbreviations: cpc.', '1.svrl', $inFileName, /)"/>-->
      <let name="failmsg7" value="fnx:expect-infile('Attribute CPCAbcDeCPCFGhicpcJ contains these improperly capitalized abbreviations: CPC, CPCF.', '1.svrl', $inFileName, /)"/>

      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(3, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(7, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'journalArticleCategoryCode.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'transmitSuccess.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'isCompressed.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg1, '1.svrl', $inFileName)" flag="AUTO"><value-of select="$failmsg1"/></assert>
      <!--<assert test="fnx:no-fail-infile($failmsg2, '1.svrl', $inFileName)" flag="AUTO"><value-of select="$failmsg2"/></assert>-->
<!--      <assert test="fnx:no-fail-infile($failmsg3, '1.svrl', $inFileName)" flag="AUTO"><value-of select="$failmsg3"/></assert>-->
<!--      <assert test="fnx:no-fail-infile($failmsg4, '1.svrl', $inFileName)" flag="AUTO"><value-of select="$failmsg4"/></assert>-->
      <assert test="fnx:no-fail-infile($failmsg5, '1.svrl', $inFileName)" flag="AUTO"><value-of select="$failmsg5"/></assert>
<!--      <assert test="fnx:no-fail-infile($failmsg6, '1.svrl', $inFileName)" flag="AUTO"><value-of select="$failmsg6"/></assert>-->
      <assert test="fnx:no-fail-infile($failmsg7, '1.svrl', $inFileName)" flag="AUTO"><value-of select="$failmsg7"/></assert>

    </rule>
	</pattern>
</schema>
