<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fnx="http://www.example.com/fnx" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
   <xsl:import href="common_style.xsl"/>
   <xsl:template match="/">
      <html xmlns="http://www.w3.org/1999/xhtml">
         <head>
            <title>Component Name Report</title>
            <xsl:sequence select="fnx:include-css()"/>
         </head>
         <a style="position: fixed; bottom:5px;right:5px;" href="#" title="Click to go to top">Go to top</a>
         <body>
            <h1>Component Name Report</h1>
            <xsl:sequence select="fnx:input()"/>
            <p class="name-p">
               <xsl:for-each-group select="$input-collection" group-by="@namespace">
                  <xsl:text> [</xsl:text>
                  <a href="#N{position()}">
                     <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                  </a>
                  <xsl:text>] &#160; </xsl:text>
               </xsl:for-each-group>
            </p>
            <xsl:for-each-group select="$input-collection" group-by="@namespace">
               <h2 id="N{position()}">
                  <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                  <xsl:text> Components [</xsl:text><xsl:value-of select="count(current-group())"/><xsl:text>]</xsl:text>
               </h2>
               <table>
                  <tr>
                     <xsl:sequence select="fnx:display-section('Elements',current-group()/element)"/>
                     <xsl:sequence select="fnx:display-section('Complex Types',current-group()/complexType)"/>
                     <xsl:sequence select="fnx:display-section('Simple Types',current-group()/simpleType)"/>
                     <xsl:sequence select="fnx:display-section('Attributes',current-group()/attribute)"/>
                  </tr>
               </table>
            </xsl:for-each-group>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>
