<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fnx="http://www.example.com/fnx">
   <xsl:import href="common_style.xsl"/>
   <xsl:template match="/">
      <html xmlns="http://www.w3.org/1999/xhtml">
         <head>
            <title>Schema Integrity Check</title>
            <xsl:sequence select="fnx:include-css()"/>
         </head>
         <body>
            <h1 align="center">Schema Integrity Check</h1>
            <xsl:sequence select="fnx:time-run()"/>
            <hr/>
            <h2>
               <xsl:text>Integrity Checking of </xsl:text>
               <xsl:value-of select="count($input-collection)"/>
               <xsl:text> XSDs: </xsl:text>
               <span class="code">
                  <xsl:value-of select="$reportInDir"/>
               </span>
            </h2>
            <p class="name-p">
               <xsl:for-each-group select="$input-collection" group-by="@namespace">
                  <xsl:text> [</xsl:text>
                  <a href="#N{position()}">
                     <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                  </a>
                  <xsl:text>] &#160; </xsl:text>
               </xsl:for-each-group>
            </p>
            <xsl:for-each-group select="$input-collection" group-by="@namespace">
               <h2 id="N{position()}">
                  <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                  <xsl:text> Components</xsl:text>
               </h2>
               <xsl:choose>
                  <xsl:when test="current-group()/*">
                     <table>
                  <tr>
                     <th>File</th>
                     <th>Error Type</th>
                     <th>Details</th>
                  </tr>
                  <xsl:apply-templates select="current-group()"/>
               </table>
                  </xsl:when>
                  <xsl:otherwise>
                     <p><i>No integrity issues were found for this namespace.</i></p>
                  </xsl:otherwise>
               </xsl:choose>
               
            </xsl:for-each-group>
         </body>
      </html>
   </xsl:template>
   <xsl:template match="import-unused">
      <tr>
         <td>
            <xsl:sequence select="fnx:file-link(../@file)"/>
         </td>
         <td>Unused import/include</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@element"/>
            <xsl:text> of </xsl:text>
            <xsl:value-of select="@imported-file"/>
            <xsl:text> is unnecessary and can be deleted.</xsl:text>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="import-unused-directly">
      <tr>
         <td>
            <xsl:sequence select="fnx:file-link(../@file)"/>
         </td>
         <td>Unused import/include</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@element"/>
            <xsl:text> of </xsl:text>
            <xsl:value-of select="@imported-file"/>
            <xsl:text> is not used directly; it is possibly used indirectly.</xsl:text>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="import-file-not-found">
      <tr>
         <td>
            <xsl:sequence select="fnx:file-link(../@file)"/>
         </td>
         <td>Import/include file not found</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@element"/>
            <xsl:text> of </xsl:text>
            <xsl:value-of select="@imported-file"/>
            <xsl:text> cannot be resolved; the file was not found.</xsl:text>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="missing-import">
      <tr>
         <td>
            <xsl:sequence select="fnx:file-link(../@file)"/>
         </td>
         <td>Missing import/include</td>
         <td>
            <xsl:text>The following name(s) are used but not directly imported into the XSD:  </xsl:text>
            <xsl:value-of select="@names"/>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="unused-prefixes">
      <tr>
         <td>
            <xsl:sequence select="fnx:file-link(../@file)"/>
         </td>
         <td>Unused prefixes</td>
         <td>
            <xsl:text>The following prefix(es) are unnecessarily declared:  </xsl:text>
            <xsl:value-of select="@prefixes"/>
         </td>
      </tr>
   </xsl:template>
  <xsl:template match="orphan">
      <tr>
         <td>
            <xsl:sequence select="fnx:file-link(../@file)"/>
         </td>
         <td>Orphan</td>
         <td>
            <xsl:text>The </xsl:text>
            <xsl:value-of select="@type"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> is declared but never referenced.</xsl:text>
         </td>
      </tr>
   </xsl:template>
  <xsl:template match="dup-common">
      <tr>
         <td>
            <xsl:sequence select="fnx:file-link(../@file)"/>
         </td>
         <td>Duplicate of Common</td>
         <td>
            <xsl:text>The name </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text> duplicates a name that is in the </xsl:text>
            <xsl:value-of select="@namespace"/>
            <xsl:text> namespace.</xsl:text>
         </td>
      </tr>
   </xsl:template>
</xsl:stylesheet>
