<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:fnx="http://www.example.com/fnx">

  <xsl:param name="kXsdValidatorVersion" select="'?.?'"/>

  <xsl:function name="fnx:make_tr_class">
   <xsl:param name="status"/>
   <xsl:param name="method"/>
   <xsl:choose>
     <xsl:when test="$method eq 'Auto' and $status eq 'success'">passTr</xsl:when>
     <xsl:when test="$method eq 'Partial' and $status eq 'success'">manualTr</xsl:when>
     <xsl:when test="$method = ('Auto','Partial') and $status eq 'warning'">warnTr</xsl:when>
     <xsl:when test="$method = ('Auto','Partial') and $status eq 'failure'">failTr</xsl:when>
     <xsl:otherwise><xsl:value-of select="concat(lower-case($method), 'Tr')"/></xsl:otherwise>
   </xsl:choose>
  </xsl:function>

  <xsl:variable name="patterns"
                select="document($schFile)/sch:schema"/>

  <xsl:variable name="st96rules"
                select="document($st96rulesFile)/st96rules"/>

  <xsl:function name="fnx:calc_pattern_method">
    <xsl:param name="st96ruleId"/>
     <xsl:sequence select="fnx:automation-type($patterns/sch:pattern[sch:title eq $st96ruleId])"/>
  </xsl:function>

  <xsl:variable name="resultsPass2">
    <patterns>
      <xsl:for-each select="$st96rules/st96rule">
        <xsl:variable name="st96ruleId" select="@id"/>

        <pattern st96ruleId="{$st96ruleId}">
          <xsl:attribute name="status">
            <xsl:choose>
              <xsl:when test="$resultsPass1/patterns/pattern[@st96ruleId eq $st96ruleId and @status eq 'failure']">failure</xsl:when>
              <xsl:when test="$resultsPass1/patterns/pattern[@st96ruleId eq $st96ruleId and @status eq 'warning']">warning</xsl:when>
              <xsl:otherwise>success</xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          
          <xsl:for-each select="$resultsPass1/patterns/pattern[@st96ruleId eq $st96ruleId]">
            <xsl:variable name="uri" select="@uri"/>
            <xsl:for-each select="result[@type eq 'failed-assert']">
              <result uri="{$uri}"><xsl:value-of select="text()"/></result>
            </xsl:for-each>
          </xsl:for-each>
        </pattern>
      </xsl:for-each>
    </patterns>
  </xsl:variable>

  <xsl:variable name="collectedSVRLFiles" as="xsd:string*">
    <xsl:choose>
      <xsl:when test="$svrlSingleFile">
        <xsl:sequence select="$svrlSingleFileFullPath"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="collection(concat('file:///', $svrlDirFullPath, '?select=*.svrl&amp;recurse=yes'))">
          <xsl:value-of select="document-uri(.)"/>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="numXSDs"
                select="count($collectedSVRLFiles)"/>

  <xsl:variable name="resultsPass1">
    <patterns>
      <xsl:for-each select="$collectedSVRLFiles">
        <xsl:variable name="docURI" select="."/>
        <!--<xsl:message>docURI=<xsl:value-of select="$docURI"/></xsl:message>-->
        <xsl:variable name="doc" select="document(.)"/>
        <xsl:for-each-group select="$doc/svrl:schematron-output/*[not(self::svrl:ns-prefix-in-attribute-values)]" group-starting-with="svrl:active-pattern">
          <xsl:variable name="st96ruleId" select="@name"/>
          <pattern st96ruleId="{$st96ruleId}"
                   uri="{$docURI}">
            <xsl:variable name="curgroup" select="current-group()"/>
            <xsl:attribute name="status">
              <xsl:choose>
                <xsl:when test="some $e in $curgroup satisfies (local-name($e) eq 'failed-assert' and $e/@role eq 'WARNING')">warning</xsl:when>
                <xsl:when test="some $e in $curgroup satisfies (local-name($e) eq 'failed-assert')">failure</xsl:when>
                <xsl:otherwise>success</xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <xsl:for-each select="$curgroup[self::svrl:failed-assert | self::svrl:successful-report]">
              <result>
                <xsl:attribute name="type">
                  <xsl:choose>
                    <xsl:when test="self::svrl:failed-assert">failed-assert</xsl:when>
                    <xsl:otherwise>successful-report</xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:value-of select="svrl:text"/>
              </result>
            </xsl:for-each>
          </pattern>
        </xsl:for-each-group>
      </xsl:for-each>
    </patterns>
  </xsl:variable>

  <xsl:template name="DebugInfo">
    <xsl:param name="xmlInfo"/>
    <div style="border: 1px solid #880000; padding: 24px; background: #ffeeee">
      <h2 style="color: #880000">Debug Info</h2>
      <textarea rows="50" style="width: 100%; border: 1px solid #880000">
        <xsl:sequence select="$xmlInfo"/>
      </textarea>
    </div>
  </xsl:template>
  
  <xsl:variable name="gdST96ruleCount"
                select="count($st96rules/st96rule[substring(@id, 1, 2) eq 'GD'])"/>
  <xsl:variable name="sdST96ruleCount"
                select="count($st96rules/st96rule[substring(@id, 1, 2) eq 'SD'])"/>
  <xsl:variable name="totalST96ruleCount"
                select="$gdST96ruleCount + $sdST96ruleCount"/>

  <xsl:variable name="autoCount" select="count($patterns/sch:pattern[fnx:automation-type(.) = 'Auto'])"/>
  <xsl:variable name="partialCount" select="count($patterns/sch:pattern[fnx:automation-type(.) = 'Partial'])"/>
  <xsl:variable name="manualCount" select="count($patterns/sch:pattern[fnx:automation-type(.) = 'Manual'])"/>
  <xsl:variable name="deletedCount" select="count($patterns/sch:pattern[fnx:automation-type(.) = 'Deleted'])"/>
  <xsl:variable name="unaddressedCount" select="count($patterns/sch:pattern[fnx:automation-type(.) = 'Unaddressed'])"/>
  <xsl:variable name="patternCount" select="count($patterns/sch:pattern)"/>

  <xsl:variable name="auto-results" select="$resultsPass1/patterns/pattern[fnx:calc_pattern_method(@st96ruleId)='Auto']"/>
  <xsl:variable name="auto-failCount"
                      select="count(distinct-values($auto-results[@status eq 'failure']/@st96ruleId))"/>

  <xsl:variable name="auto-warnCount"
                      select="count(distinct-values($auto-results[@status eq 'warning']/@st96ruleId))"/>

  <xsl:variable name="auto-passCount"
                      select="$autoCount - $auto-failCount - $auto-warnCount"/>

  <xsl:variable name="partial-results" select="$resultsPass1/patterns/pattern[fnx:calc_pattern_method(@st96ruleId)='Partial']"/>
  <xsl:variable name="partial-failCount"
                      select="count(distinct-values($partial-results[@status eq 'failure']/@st96ruleId))"/>

  <xsl:variable name="partial-warnCount"
                      select="count(distinct-values($partial-results[@status eq 'warning']/@st96ruleId))"/>

  <xsl:variable name="partial-passCount"
                      select="$partialCount - $partial-failCount - $partial-warnCount"/>
  <xsl:variable name="failureIds"
                      select="distinct-values($resultsPass1/patterns/pattern[@status eq 'failure']/@st96ruleId)"/>

  <xsl:variable name="testedRuleCount"
                select="count(distinct-values($resultsPass1/patterns/pattern/@st96ruleId))"/>

  <xsl:variable name="untestedCount"
                select="$totalST96ruleCount - $testedRuleCount"/>

  <xsl:variable name="assertionPassCount"
                select="count($patterns/sch:pattern/sch:rule/sch:assert[not(@flag eq 'MANUAL')])"/>

  <xsl:template name="genDrcVersionInfo">
    <div class="drcVersionDiv">
      <span class="drcVersion"><b>DRC Information:</b> </span>
      <span class="drcDocFileName"> <xsl:value-of select="$st96rules/@drcDocFileName"/></span>
      <xsl:text> </xsl:text>
      <span class="drcVersion">Version: v<xsl:value-of select="$st96rules/@drcVersionNum"/></span>
      <span class="drcDocFileLastModifiedDate">Modified: <xsl:value-of select="$st96rules/@drcDocLastModifiedDate"/></span>
    </div>
  </xsl:template>
  <xsl:template name="genXSDValidatorVersionInfo">
    ST96XSDValidator (V<xsl:value-of select="$kXsdValidatorVersion"/>)
  </xsl:template>

  <xsl:function name="fnx:automation-type">
     <xsl:param name="pattern" as="element(sch:pattern)"/>
     <xsl:variable name="asserts" select="$pattern/sch:rule/(sch:assert|sch:report)"/>
     <xsl:choose>
        <xsl:when test="not($asserts)">Unaddressed</xsl:when>
        <xsl:when test="not($asserts[@flag = ('MANUAL','DELETED')])">Auto</xsl:when>
        <xsl:when test="$asserts[@flag eq 'MANUAL'] and $asserts[not(@flag = 'MANUAL')]">Partial</xsl:when>
        <xsl:when test="$asserts[@flag eq 'MANUAL']">Manual</xsl:when>
        <xsl:when test="$asserts[@flag eq 'DELETED']">Deleted</xsl:when>
        <xsl:otherwise>Unknown</xsl:otherwise>
     </xsl:choose>
  </xsl:function>

</xsl:stylesheet>
