<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:fnx="http://www.example.com/fnx"
                version="2.0">


  <xsl:variable name="ipoConfig" select="doc('../BaselineNamespaces.xml')"/>

  <xsl:function name="fnx:expect" as="xsd:string">
      <xsl:param name="expected" as="xsd:string"/>
      <xsl:param name="svrlRoot" as="node()"/>
    
      <xsl:choose>
         <xsl:when test="not($svrlRoot/svrl:schematron-output/svrl:failed-assert[normalize-space() eq normalize-space($expected)])">
            <xsl:value-of select="concat('Failed to find expected error message: ', $expected)"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="''"/>
         </xsl:otherwise>
      </xsl:choose>
  </xsl:function>

  <xsl:function name="fnx:expect-infile" as="xsd:string">
      <xsl:param name="expected" as="xsd:string"/>
      <xsl:param name="ifFileName" as="xsd:string"/>
      <xsl:param name="inFileName" as="xsd:string"/>
      <xsl:param name="svrlRoot" as="node()"/>
    
      <xsl:choose>
         <xsl:when test="$inFileName eq $ifFileName                       and not($svrlRoot/svrl:schematron-output/svrl:failed-assert[normalize-space() eq normalize-space($expected)])">
            <xsl:value-of select="concat('Failed to find expected error message: ', $expected)"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="''"/>
         </xsl:otherwise>
      </xsl:choose>
  </xsl:function>

  <xsl:function name="fnx:wrong-error-count-message" as="xsd:string">
      <xsl:param name="expected" as="xsd:integer"/>
      <xsl:param name="n" as="node()"/>

      <xsl:value-of select="concat('Expected ', $expected, ' failures but got ',  count($n/svrl:failed-assert), ' failures.')"/>
  </xsl:function>

  <xsl:function name="fnx:failed-assert-count-is" as="xsd:boolean">
      <xsl:param name="expected" as="xsd:integer"/>
      <xsl:param name="n" as="node()"/>

      <xsl:value-of select="count($n/svrl:failed-assert) = $expected"/>
  </xsl:function>

  <xsl:function name="fnx:failed-assert-count-is-infile" as="xsd:boolean">
      <xsl:param name="expected" as="xsd:integer"/>
      <xsl:param name="ifFileName" as="xsd:string"/>
      <xsl:param name="inFileName" as="xsd:string"/>
      <xsl:param name="n" as="node()"/>

      <xsl:value-of select="not($inFileName eq $ifFileName) or count($n/svrl:failed-assert) = $expected"/>
  </xsl:function>

  <xsl:function name="fnx:no-fail-infile" as="xsd:boolean">
      <xsl:param name="failmsg" as="xsd:string"/>
      <xsl:param name="ifFileName" as="xsd:string"/>
      <xsl:param name="inFileName" as="xsd:string"/>

      <xsl:value-of select="not($inFileName eq $ifFileName) or $failmsg = ''"/>
  </xsl:function>

  <xsl:function name="fnx:ipo-has" as="xsd:boolean">
      <xsl:param name="area" as="xsd:string"/>
      <xsl:param name="part" as="xsd:string"/>
      <xsl:param name="val" as="xsd:string"/>
    
      <!--<xsl:value-of select="$ipoConfig/ipo/*[name() = $area]/@*[name() = $part] = $val"/>-->
      <xsl:value-of select="$ipoConfig/Namespaces/Namespace[@std='USPTO'][@component = $area]/@*[name() = $part] = $val"/>
  </xsl:function>

</xsl:stylesheet>
