<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

	<pattern>
		<title>SD-63</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="expected1" value="'Root element does not declare an optional ipoVersion attribute with a fixed value of the form {ST3CODE}_V{n}_{m}.'"/>
      <let name="expected2" value="'@ipoVersion=XX_V1_0 is fixed but does not start with a valid ST.3 code.'"/>

      <let name="failmsg3" value="fnx:expect-infile(
                                  $expected1,
                                  '3.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile(
                                  $expected1,
                                  '4.svrl', $inFileName, /)"/>
      <let name="failmsg6" value="fnx:expect-infile(
                                  $expected1,
                                  '6.svrl', $inFileName, /)"/>
      <let name="failmsg7" value="fnx:expect-infile(
                                  $expected2,
                                  '7.svrl', $inFileName, /)"/>
      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '3.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '4.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '5.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '6.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '7.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg3, '3.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg4, '4.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg4"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg6, '6.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg6"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg7, '7.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg7"/>
      </assert>
     </rule>
	</pattern>
</schema>
