<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

	<pattern>
		<title>SD-43</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
      <let name="failmsg1" value="fnx:expect-infile(
                                  'Element DateOfBirth_BAD must use xsd:date for date data.',
                                  '1.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile(
                                  'Element TimeOfBirth_BAD must use xsd:time for time data.',
                                  '1.svrl', $inFileName, /)"/>
      <let name="failmsg3" value="fnx:expect-infile(
                                  'Element DateOfBirthA_BAD must use xsd:date for date data.',
                                  '1.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile(
                                  'Element x_BAD must use xsd:date for date data.',
                                  '1.svrl', $inFileName, /)"/>
      <let name="failmsg5" value="fnx:expect-infile(
                                  'Element DateOfBirthD_BAD must use xsd:date for date data.',
                                  '1.svrl', $inFileName, /)"/>
      <let name="failmsg6" value="fnx:expect-infile(
                                  'Element DateOfBirthE_BAD must use xsd:date for date data.',
                                  '1.svrl', $inFileName, /)"/>
      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(6, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(6, .)"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg1, '1.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg1"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg2, '1.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg3, '1.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg4, '1.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg4"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg5, '1.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg5"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg6, '1.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg6"/>
      </assert>

    </rule>
	</pattern>
</schema>