<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

	<pattern>
		<title>SD-02</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg2b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent.',
                                   '2b.svrl', $inFileName, /)"/>
      <let name="failmsg3b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark.',
                                   '3b.svrl', $inFileName, /)"/>
      <let name="failmsg4b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '4b.svrl', $inFileName, /)"/>
      <let name="failmsg5b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent.',
                                   '5b.svrl', $inFileName, /)"/>
      <let name="failmsg6b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark.',
                                   '6b.svrl', $inFileName, /)"/>
      <let name="failmsg7b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:design.',
                                   '7b.svrl', $inFileName, /)"/>
      <let name="failmsg9b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:corporate.',
                                   '9b.svrl', $inFileName, /)"/>
      <let name="failmsg10b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:dissemination.',
                                   '10b.svrl', $inFileName, /)"/>
      <let name="failmsg11b" value="fnx:expect-infile(
                                   'XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:legal.',
                                   '11b.svrl', $inFileName, /)"/>
      <let name="failmsg2a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent.',
                                   '2a.svrl', $inFileName, /)"/>
      <let name="failmsg3a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark.',
                                   '3a.svrl', $inFileName, /)"/>
      <let name="failmsg4a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Design.',
                                   '4a.svrl', $inFileName, /)"/>
      <let name="failmsg5a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent.',
                                   '5a.svrl', $inFileName, /)"/>
      <let name="failmsg6a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark.',
                                   '6a.svrl', $inFileName, /)"/>
      <let name="failmsg7a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:design.',
                                   '7a.svrl', $inFileName, /)"/>
      <let name="failmsg9a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:corporate.',
                                   '9a.svrl', $inFileName, /)"/>
      <let name="failmsg10a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:dissemination.',
                                   '10a.svrl', $inFileName, /)"/>
      <let name="failmsg11a" value="fnx:expect-infile(
                                   'XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:legal.',
                                   '11a.svrl', $inFileName, /)"/>
      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, '1a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>


      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(0, '1a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '1b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '2a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '2b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '3a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '3b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '4a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '4b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '5a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '5b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '6a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '6b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '7a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '7b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(0, '8a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '8b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '9a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '9b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '10a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '10b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '11a.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:failed-assert-count-is-infile(1, '11b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg2b, '2b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg3b, '3b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg4b, '4b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg4b"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg5b, '5b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg5b"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg6b, '6b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg6b"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg7b, '7b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg7b"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg9b, '9b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg9b"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg10b, '10b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg10b"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg11b, '11b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg11b"/>
      </assert>

      <!-- US -->

      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg2a, '2a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2a"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg3a, '3a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3a"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg4a, '4a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg4a"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg5a, '5a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg5a"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg6a, '6a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg6a"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg7a, '7a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg7a"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg9a, '9a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg9a"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg10a, '10a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg10a"/>
      </assert>
      <assert test="not(fnx:ipo-has('common', 'ns-prefix', 'uscom'))
                    or fnx:no-fail-infile($failmsg11a, '11a.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg11a"/>
      </assert>

    </rule>

	</pattern>
</schema>