@echo off

REM -------------------------------------------------------
REM Update user installed JDK Home location in settings.xml
REM -------------------------------------------------------

set CONFIGFILE="%~dp0settings.xml"
for /F "tokens=2 delims=^>,^<" %%i IN ('findstr /L "JDKHome" %CONFIGFILE%') do call set JAVA_HOME=%%~fsi

set ANT_HOME=%CD%\tools\apache-ant-1.9.4
set PATH="C:\Windows\System32";%ANT_HOME%\bin";"%JAVA_HOME%\bin";%PATH%

REM Note: hitting 'clean' everytime below is done for clarity of operation.
REM       'clean' can be removed for more efficient operation.

IF exist %JAVA_HOME%\bin\java.exe (
	IF exist %JAVA_HOME%\lib\tools.jar (
		IF NOT [%1]==[] (
			IF /I NOT [%1]==[clean] (
				IF NOT [%2]==[] (
					GOTO PASSTHROUGH
				) ELSE (
					GOTO RUNPARAMTARGET
				)
			) ELSE (
				GOTO RUNCLEAN
			)
		) ELSE (
			GOTO RUNBUILDTARGET
		)
	) ELSE (
		GOTO INVALIDJREHOME
	)
) ELSE (
	GOTO INVALIDJAVAHOME
)

:RUNCLEAN
CALL "%ANT_HOME%\bin\ant" clean
GOTO END

:RUNPARAMTARGET
CALL "%ANT_HOME%\bin\ant" clean
CALL "%ANT_HOME%\bin\ant" -DinputDir=%1 summary
GOTO END

:RUNBUILDTARGET
CALL "%ANT_HOME%\bin\ant" clean
CALL "%ANT_HOME%\bin\ant" summary
GOTO END

:PASSTHROUGH
CALL "%ANT_HOME%\bin\ant" %1 %2
GOTO END

:INVALIDJREHOME
echo Invalid Java Home (%JAVA_HOME%)!!
echo Schematron validator requires JDK, please refer installation section in ST.96_XSD_Validation_via_Schematron.docx for details.
echo Please update settings.xml with JDK installation path.
GOTO END

:INVALIDJAVAHOME
echo Invalid Java Home!!
echo 	Please update settings.xml with JDK installation path.

:END
echo on

