<?xml version="1.0" encoding="UTF-8"?>
<!--
    ST.96 conformance checking using Schematron
    Developed by: USPTO, Enterprise Data Architecture Division (EDAD)
	Point of Contact: Narith Tith, narith.tith@uspto.gov, 571-272-5458
-->
<xsl:stylesheet version="2.0" xmlns:fnx="http://www.example.com/fnx" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:param name="devDir"/> <!-- full path to ST96XSDValidator dev dir -->
   <xsl:param name="reportInDir"/>
   <xsl:param name="reportDir"/>
   <xsl:output encoding="UTF-8" method="xhtml" indent="yes"/>
   <xsl:strip-space elements="*"/>
   <xsl:variable name="devDirForwardSlashes" select="replace($devDir, '\\', '/')"/>
   <xsl:variable name="reportDirFullPath" select="concat($devDirForwardSlashes, '/', $reportDir)"/>
   <xsl:function name="fnx:display-xsd-file-name">
      <xsl:param name="file-name"/>
      <xsl:variable name="tokenized" select="tokenize($file-name, '/')"/>
      <xsl:choose>
         <xsl:when test="contains($file-name,'/Document/')">
            <xsl:value-of select="string-join(($tokenized[last()-2],$tokenized[last()-1],$tokenized[last()]),'/')"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="string-join(($tokenized[last()-1],$tokenized[last()]),'/')"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
   <xsl:function name="fnx:include-css">
      <xsl:variable name="cssFile" select="concat($devDirForwardSlashes, '/css/report.css')"/>
      <style type="text/css">
          <xsl:value-of select="unparsed-text(concat('file:///', $cssFile))" disable-output-escaping="yes"/>
      </style>
   </xsl:function>
   <xsl:function name="fnx:time-run">
       <div class="timeStampDiv">
         <xsl:text> Run at </xsl:text>
         <xsl:value-of select="format-dateTime(current-dateTime(), '[Y0001]-[M01]-[D01] [H01]:[m01] [Z]')"/>
       </div>
   </xsl:function>
   <xsl:function name="fnx:input">
      <p class="header">
         <b>Input: </b>
         <xsl:value-of select="$reportInDir"/>
      </p>
   </xsl:function>
   <xsl:function name="fnx:file-link">
      <xsl:param name="file-name"/>
      <a href="{$file-name}" target="_blank">
         <xsl:value-of select="fnx:display-xsd-file-name($file-name)"/>
      </a>
   </xsl:function>
   <xsl:variable name="input-collection" as="element()*">
      <xsl:sequence select="collection(concat('file:///', $reportDirFullPath, '?select=*.xml&amp;recurse=yes'))/*"/>
   </xsl:variable>
   <xsl:function name="fnx:ns-display-name">
      <xsl:param name="ns"/>
      <xsl:choose>
         <xsl:when test="starts-with($ns,'urn:us:gov:doc:uspto:')">
            <xsl:variable name="lastpart" select="replace($ns,'.*:','')"/>
            <xsl:value-of select="concat('US',upper-case(substring($lastpart,1,1)),substring($lastpart,2))"/>
         </xsl:when>
         <xsl:when test="starts-with($ns,'http://www.wipo.int/standards/XMLSchema/ST96/')">
            <xsl:value-of select="replace($ns,'.*/','')"/>
         </xsl:when>
         <xsl:when test="$ns = 'http://www.w3.org/1998/Math/MathML'">
            <xsl:value-of select="'MathML'"/>
         </xsl:when>
         <xsl:when test="$ns = 'http://www.oasis-open.org/tables/exchange/1.0'">
            <xsl:value-of select="'OASIS Table'"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$ns"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
   <xsl:function name="fnx:display-section">
      <xsl:param name="title"/>
      <xsl:param name="definitions"/>
      <td class="{$definitions[1]/local-name()}">
         <p class="name-header">
            <i>
               <xsl:value-of select="$title"/>
            </i>
            [<xsl:value-of select="count($definitions)"/>]
         </p>
         <xsl:for-each select="$definitions">
            <xsl:sort select="@name"/>
            <p class="name-p">
               <a href="{../@file}">
                  <xsl:value-of select="@name"/>
               </a>
            </p>
         </xsl:for-each>
      </td>
   </xsl:function>
</xsl:stylesheet>
