<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

	<pattern>
		<title>SD-58</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsge2" value="fnx:expect('The e2 element is missing xsd:documentation.', /)"/>
      <let name="failmsga2" value="fnx:expect('The a2 attribute is missing xsd:documentation.', /)"/>

      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is(2, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(2, .)"/>
      </assert>

      <assert test="$failmsge2 = ''" flag="AUTO"><value-of select="$failmsge2"/></assert>
      <assert test="$failmsga2 = ''" flag="AUTO"><value-of select="$failmsga2"/></assert>
    </rule>
	</pattern>
</schema>