<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

	<pattern>
		<title>SD-30</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1" value="fnx:expect-infile(
                                  'The version attribute is not specified.',
                                  'bad.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile(
                                  '&quot;1.0&quot; does not follow the form &quot;V&lt;number&gt;_&lt;number&gt;&quot;',
                                  'bad2.svrl', $inFileName, /)"/>
      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, 'good.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'good2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg1, 'bad.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg1"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg2, 'bad2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>

    </rule>
	</pattern>
</schema>