<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

	<pattern>
		<title>SD-01</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1b" value="fnx:expect-infile(
                                  'XSDs in the patent namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules.',
                                  '1b.svrl', $inFileName, /)"/>
      <let name="failmsg2b" value="fnx:expect-infile(
                                  'XSDs in the trademark namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules.',
                                  '2b.svrl', $inFileName, /)"/>
      <let name="failmsg3b" value="fnx:expect-infile(
                                  'XSDs in the design namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules.',
                                  '3b.svrl', $inFileName, /)"/>

      <let name="failmsg4b" value="fnx:expect-infile(
                                  'XSDs in the patent namespace must use xsd:import to reference common component schema modules.',
                                  '4b.svrl', $inFileName, /)"/>
      <let name="failmsg5b" value="fnx:expect-infile(
                                  'XSDs in the trademark namespace must use xsd:import to reference common component schema modules.',
                                  '5b.svrl', $inFileName, /)"/>
      <let name="failmsg6b" value="fnx:expect-infile(
                                  'XSDs in the design namespace must use xsd:import to reference common component schema modules.',
                                  '6b.svrl', $inFileName, /)"/>

      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '3.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '4.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '5.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '6.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>

      <assert test="fnx:failed-assert-count-is-infile(1, '1b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '2b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '3b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or fnx:failed-assert-count-is-infile(1, '4b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or fnx:failed-assert-count-is-infile(1, '5b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat'))
                    or fnx:failed-assert-count-is-infile(1, '6b.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <assert test="fnx:failed-assert-count-is-infile(0, '1c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '2c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '3c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '4c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '5c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '6c.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>

      <assert test="fnx:no-fail-infile($failmsg1b, '1b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg1b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg2b, '2b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg3b, '3b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg1b, '4b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg1b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg2b, '5b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2b"/>
      </assert>
      <assert test="fnx:no-fail-infile($failmsg3b, '6b.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg3b"/>
      </assert>

    </rule>

	</pattern>
</schema>