<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

  <!-- "the term component refers to type, element or attribute" -->

	<pattern>
		<title>GD-26</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg1" value='fnx:expect("The &apos;BList&apos; element is a collection, but its name lacks a &apos;Bag&apos; suffix.", /)'/>
      <let name="failmsg2" value='fnx:expect("The &apos;CBag&apos; element is not a collection, but its name has a &apos;Bag&apos; suffix.", /)'/>
      <let name="failmsg3" value='fnx:expect("The &apos;DBagType&apos; simpleType is not a collection, but its name has a &apos;BagType&apos; suffix.", /)'/>
      <let name="failmsg4" value='fnx:expect("The &apos;FType&apos; complexType is a collection, but its name lacks a &apos;BagType&apos; suffix.", /)'/>
      <let name="failmsg5" value='fnx:expect("The &apos;GBagType&apos; complexType is not a collection, but its name has a &apos;BagType&apos; suffix.", /)'/>
      <let name="failmsg8" value='fnx:expect("The &apos;NBag&apos; element is not a collection, but its name has a &apos;Bag&apos; suffix.", /)'/>
      <let name="failmsg9" value='fnx:expect("The &apos;OBagType&apos; complexType is not a collection, but its name has a &apos;BagType&apos; suffix.", /)'/>
      <let name="failmsg10" value='fnx:expect("The &apos;BoundaryData2BagType&apos; complexType is not a collection, but its name has a &apos;BagType&apos; suffix.", /)'/>


      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is(9, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(9, .)"/>
      </assert>

      <assert test="$failmsg1 = ''" flag="AUTO"><value-of select="$failmsg1"/></assert>
      <assert test="$failmsg2 = ''" flag="AUTO"><value-of select="$failmsg2"/></assert>
      <assert test="$failmsg3 = ''" flag="AUTO"><value-of select="$failmsg3"/></assert>
      <assert test="$failmsg4 = ''" flag="AUTO"><value-of select="$failmsg4"/></assert>
      <assert test="$failmsg5 = ''" flag="AUTO"><value-of select="$failmsg5"/></assert>
      <assert test="$failmsg8 = ''" flag="AUTO"><value-of select="$failmsg8"/></assert>
      <assert test="$failmsg9 = ''" flag="AUTO"><value-of select="$failmsg9"/></assert>
      <assert test="$failmsg10 = ''" flag="AUTO"><value-of select="$failmsg10"/></assert>

    </rule>
	</pattern>
</schema>
