<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

  <!-- "the term component refers to type, element or attribute" -->

	<pattern>
		<title>GD-22</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg1" value="fnx:expect('ThisQuantityQuantity contains a repeated representation term (Quantity).', /)"/>
      <let name="failmsg2" value="fnx:expect('ThatRateRate contains a repeated representation term (Rate).', /)"/>
      <let name="failmsg3" value="fnx:expect('SimpleAmountAmountType contains a repeated representation term (Amount).', /)"/>
      <let name="failmsg4" value="fnx:expect('ComplexCategoryCategoryType contains a repeated representation term (Category).', /)"/>

      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is(4, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(4, .)"/>
      </assert>

      <assert test="$failmsg1 = ''" flag="AUTO"><value-of select="$failmsg1"/></assert>
      <assert test="$failmsg2 = ''" flag="AUTO"><value-of select="$failmsg2"/></assert>
      <assert test="$failmsg3 = ''" flag="AUTO"><value-of select="$failmsg3"/></assert>
      <assert test="$failmsg4 = ''" flag="AUTO"><value-of select="$failmsg4"/></assert>
    </rule>
	</pattern>
</schema>