<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

	<pattern>
		<title>GD-09</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg0" value="fnx:expect('The element name badElementName does not start with an upper-case letter.', /)"/>
      <let name="failmsg1" value="fnx:expect('The element name badelementname does not start with an upper-case letter.', /)"/>
      <let name="failmsg2" value="fnx:expect('The element name BADELEMENTNAME contains all upper-case letters instead of using camel case.', /)"/>

      <!-- Assertions -->

      <assert test="fnx:failed-assert-count-is(3, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(3, .)"/>
      </assert>

      <assert test="$failmsg0 = ''" flag="AUTO">
        <value-of select="$failmsg0"/>
      </assert>
      <assert test="$failmsg1 = ''" flag="AUTO">
        <value-of select="$failmsg1"/>
      </assert>
      <assert test="$failmsg2 = ''" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>

    </rule>
	</pattern>
</schema>