<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:xdt="http://www.w3.org/2005/02/xpath-datatypes">
<xsl:template match="/">
	<html>
	    <head>
        <meta http-equiv="Content-Language" content="en-us"/>
        <meta http-equiv="Content-Type" content="text/html; charset=windows-1252"/>
        <link name="styles" rel="STYLESHEET" href="ipcr_elayer_illustrations.css" type="text/css"/>
    </head>
		<body>
		<center>
			<h2>IPC ILLUSTRATIONS
			<br><br>VERSION 
				<xsl:value-of select="IPCIllustrations/@*[name()='edition']" /> </br></br>
			</h2>
			<table width="30%" border="1" align="center">

				<xsl:for-each select="IPCIllustrations/IPCIllustrationsSection/IPCIllustrationsClass/IPCIllustrationsSubclass/IPCIllustrationsMaingroup/IPCIllustrationsGroup/illustrations/illustration">
				<xsl:variable name="symbol">
				<xsl:value-of select="substring(@*[name()='label'],1,14)"/>
				</xsl:variable>
				<xsl:variable name="label">
				<xsl:value-of select="@*[name()='label']"/>
				</xsl:variable>
				<xsl:variable name="maingrouphundred">
				<xsl:value-of select="substring($symbol,6,1)"/>
				</xsl:variable>
				<xsl:variable name="maingroup">
				<xsl:value-of select="substring($symbol,7,2)"/>
				</xsl:variable>
				<xsl:variable name="subgroup">
				<xsl:value-of select="substring($symbol,9,4)"/>
				</xsl:variable>
				
				
				<tr  border="1">
					<td width="25%" align="center"> 
					
						<h3><xsl:text disable-output-escaping="yes">Symbol:&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
				<xsl:variable name="format">
				<xsl:value-of select="@*[name()='format']"/>
				</xsl:variable>						
							<xsl:value-of select="formattedsymbol"/>
						   <xsl:value-of select="substring($symbol,0,5)"/>
						<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
						<xsl:call-template name="compilationPurgeEndSymbol"/></h3>
					
					<xsl:for-each select="illustrationversion">
						<xsl:if test="@format='skc'">
							<a href="{concat($label,'.skc')}">structure (.skc)</a> -
						</xsl:if>
						
						<xsl:if test="@format='skc'">
							<a href="{concat($label,'.cdx')}">structure (.cdx)</a>
						</xsl:if>

					</xsl:for-each>
					
					<br/><br/>
					<img src="{concat($label,'.gif')}"/>
					</td>

				</tr>
				 </xsl:for-each>

			 </table>
		</center>
		 </body>
	 </html>
  </xsl:template>
  
  

    <xsl:template name="compilationPurgeEndSymbol">
        <xsl:variable name="symbol" select="substring(@*[name()='label'],1,14)"/>
        <xsl:variable name="st">
            <xsl:choose>
                <xsl:when test="*/@entryType='i'">:</xsl:when>
                <xsl:otherwise>/</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="string-length($symbol)=14">
                <xsl:value-of select="number(substring($symbol, 5, 4))"/>/<xsl:value-of select="substring($symbol, 9, 2)"/>
                <xsl:choose>
                    <xsl:when test="substring($symbol, 11)='0000'"/>
                    <xsl:when test="substring($symbol, 12)='000'">
                        <xsl:value-of select="substring($symbol, 11, 1)"/>
                    </xsl:when>
                    <xsl:when test="substring($symbol, 13)='00'">
                        <xsl:value-of select="substring($symbol, 11, 2)"/>
                    </xsl:when>
                    <xsl:when test="substring($symbol, 14)='0'">
                        <xsl:value-of select="substring($symbol, 11, 3)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="substring($symbol, 11)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="substring($symbol,5,2)='00'">
                <xsl:value-of select="concat(substring($symbol,7,1),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:when test="substring($symbol,5,1)='0'">
                <xsl:value-of select="concat(substring($symbol,6,2),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($symbol,5,3),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

  
  
</xsl:stylesheet>
