from lxml import etree as ElementTree
from datetime import datetime
import sys, os, logging, glob, re, fileinput

def counting(inputDir, outputDir, internet_publication, edition, lang):
  
# htm files from inputDir are copied in outputDir
    for f in glob.glob(os.path.join(inputDir , '*.htm')):
        if "htm" in f:                
            if "_g" in f: 
                continue
            else:
                path= f.replace(inputDir,'')
                pathtobackup = outputDir + path
                input = open(pathtobackup, 'w')
                input.write(open(f).read())     
        else:
            continue
        input.close()

# js Files, A.htm and Z.htm are loaded in the output folder 
    totalFile = outputDir + lang + '_' + edition + '_definitions_viewer.htm'
    configurationfile = outputDir +'configuration.js'
    openglosswin = outputDir + "openglosswin.js"
    opendefwin = outputDir + "opendefwin.js"
    jquery = outputDir + "jquery-1.3.2.min.js"
    getparams = outputDir + "getparams.js"
    definition = outputDir + "definition.js"
    decodesymbol = outputDir + "decodesymbol.js"
    configuration = outputDir + "configuration.js"
    css = outputDir + "definition.css"
    A = outputDir + "A.htm"
    Z = outputDir + "B.htm"
    open(openglosswin,'w').write(open('../src/openglosswin.js').read())
    open(opendefwin,'w').write(open("../src/opendefwin.js").read())
    open(jquery,'w').write(open("../src/jquery-1.3.2.min.js").read())
    open(getparams,'w').write(open("../src/getparams.js").read())
    open(definition,'w').write(open("../src/definition.js").read())
    open(decodesymbol,'w').write(open('../src/decodesymbol.js').read())
    open(configuration,'w').write(open("../src/configuration.js").read())
    open(css,'w').write(open("../src/definition.css").read())
    open(A,'w').write(open("../src/A.htm").read())
    open(Z,'w').write(open("../src/Z.htm").read())
 # configuration file contains the internet publication     
    cfh = open(configurationfile, 'w')
    cfh.write("var internet = '" + internet_publication +"'")
    open (totalFile, "w").close()
    tfh = open(totalFile , 'w') 
    gpsLine=""
    subclass =""
    for f in glob.glob(os.path.join(outputDir , '*.htm')):
 #avoids glossary files
        if "_g" in f: 
            continue
        if totalFile in f: 
            r=""
        else:
            for line in fileinput.FileInput(f, inplace=1):
                
                expression = re.compile(r"openDefWin\('(\S+)',")
                result = expression.findall(line)
                if len(result)==1:
                    subclass=result[0]          
                line=line.replace("openGlossWin(","openGlossWin('"+subclass+"',")
                line=line.replace('<a ', '<a target="_blank"')
                line=line.replace("index.html",internet_publication)
                line=line.replace("../shared/img/",internet_publication+ "shared/img/")
                line=line.replace('href="glossary?', 'href="' + internet_publication + 'glossary/#edition=' + edition +"&lang=" + lang + "&symbol=A01N&")
                print line         
            tfh.write(open(f).read())
    tfh.close() 
    
#deletes the htm files that are not necessary
    for f in glob.glob(os.path.join(outputDir , '*.htm')):
        if totalFile in f:                
            continue
        else:
            os.remove(f)
    
    

    
if __name__ == "__main__":
    import ConfigParser
    
    if len(sys.argv) > 1:
        cfg = sys.argv[1]
    else:
        cfg = '..\ipc_definitions_viewer.cfg'
        
    config = ConfigParser.SafeConfigParser()
    config.optionxform = str # this is to prevent conversion of options name to lowercase
    config.readfp(open(cfg))
    
    counting(**dict(config.items('ipc_definitions_viewer')))
