<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml"
		xmlns:v="urn:schemas-microsoft-com:vml"
		xmlns:w10="urn:schemas-microsoft-com:office:word"
		xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core"
		xmlns:aml="http://schemas.microsoft.com/aml/2001/core"
		xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint"
		xmlns:o="urn:schemas-microsoft-com:office:office"
		xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882"
		xmlns:msxsl="urn:schemas-microsoft-com:xslt"
		xmlns:script="script"
>

	<msxsl:script language="JScript" implements-prefix="script">
<![CDATA[

  var sPrevSym = 'XXXX';

  function getPrevSym(sSym) {
  	var sTemp = sPrevSym;
	sPrevSym = sSym;
	return sTemp;
  }

]]>
	</msxsl:script>

	<xsl:template name="DocumentProperties">
		<xsl:param name="lang"/>
		<xsl:param name="smallEdition"/>
		<xsl:param name="edition"/>
		<xsl:param name="volume"/>
		<xsl:param name="section"/>
		<xsl:param name="level"/>
		<xsl:param name="year"/>
		<xsl:param name="class"/>
		<xsl:param name="classTitle"/>
		<o:DocumentProperties>
			<o:Title><xsl:value-of select="$class"/><xsl:text> </xsl:text><xsl:value-of select="$classTitle"/></o:Title>
			<!--
			<o:Subject>
				<xsl:choose>
					<xsl:when test="$level='c'">Int.Cl.</xsl:when>
					<xsl:otherwise>Int.Cl.</xsl:otherwise>
				</xsl:choose>
			</o:Subject>
			-->
			<o:Subject><xsl:call-template name="translate"><xsl:with-param name="id" select="'int_cl'"/></xsl:call-template></o:Subject>
<!--			<o:Subject><xsl:value-of select="concat(substring($edition,1,4),'.',substring($edition,5,2))"/></o:Subject>-->
<!--			<o:Subject><xsl:value-of select="$edition"/></o:Subject>-->
			<o:Author>WIPO</o:Author>
			<o:Keywords>
				<xsl:choose>
					<xsl:when test="$level='c'"><xsl:value-of select="concat(substring($edition,1,4),'.',substring($edition,5,2))"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="concat(substring($edition,1,4),'.',substring($edition,5,2))"/></xsl:otherwise>
				</xsl:choose>
<!--				<xsl:call-template name="translate"><xsl:with-param name="id" select="'version'"/></xsl:call-template>, <xsl:value-of select="$year"/>-->
				<!-- TA 20060404 replaced by translate
				<xsl:choose>
				<xsl:when test="$lang='EN'">th version, <xsl:value-of select="$year"/></xsl:when>
				<xsl:when test="$lang='FR'">th version, <xsl:value-of select="$year"/></xsl:when>
				<xsl:when test="$lang='ES'">a edicio'n, <xsl:value-of select="$year"/></xsl:when>
				</xsl:choose>
				-->
			</o:Keywords>
			<o:Description>
				<xsl:choose>
					<xsl:when test="$level='c'">
						<xsl:variable name="replace0">
							<xsl:call-template name="translate"><xsl:with-param name="id" select="'vol'"/></xsl:call-template>
						</xsl:variable>
						<xsl:variable name="replace1">
							<xsl:choose>
								<xsl:when test="contains($replace0, '%v')">
									<xsl:value-of select="concat(substring-before($replace0, '%v'), $volume, substring-after($replace0, '%v'))"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$replace0"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="replace2">
							<xsl:choose>
								<xsl:when test="contains($replace1, '%s')">
									<xsl:value-of select="concat(substring-before($replace1, '%s'), $section, substring-after($replace1, '%s'))"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$replace1"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:value-of select="$replace2"/>
					</xsl:when>
					<xsl:otherwise>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'section'"/></xsl:call-template><xsl:text> </xsl:text><xsl:value-of select="$section"/></xsl:otherwise>
				</xsl:choose>
			</o:Description>
			
			<!-- TA 20060404 added translate -->
<!--			<o:Description>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'Section'"/></xsl:call-template> <xsl:value-of select="$section"/></o:Description>-->
<!--			<o:Description>Vol. <xsl:value-of select="$volume"/>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'Section'"/></xsl:call-template> <xsl:value-of select="$section"/></o:Description>-->
			<o:LastAuthor>WIPO</o:LastAuthor>
			<o:Revision>0</o:Revision>
			<o:TotalTime>0</o:TotalTime>
			<!--
			<o:LastPrinted>1999-05-21T22:12:00Z</o:LastPrinted>
			<o:Created>2005-03-09T11:31:00Z</o:Created>
			<o:LastSaved>2005-03-09T11:31:00Z</o:LastSaved>
			<o:Pages>1</o:Pages>
			<o:Words>50334</o:Words>
			<o:Characters>286910</o:Characters>
			-->
			<o:Company>Arcanum Development</o:Company>
			<!--
			<o:Bytes>36352</o:Bytes>
			<o:Lines>2390</o:Lines>
			<o:Paragraphs>673</o:Paragraphs>
			<o:CharactersWithSpaces>336571</o:CharactersWithSpaces>
			<o:Version>11.6359</o:Version>
			-->
		</o:DocumentProperties>
	</xsl:template>
	<xsl:template name="CustomDocumentProperties">
		<o:CustomDocumentProperties>
			<o:columngap dt:dt="float">28.34645652771</o:columngap>
			<o:columnwidth dt:dt="float">245.95176696777</o:columnwidth>
			<o:columned dt:dt="boolean">1</o:columned>
			<o:indhead1 dt:dt="string"/>
			<o:indhead2 dt:dt="string"/>
			<o:indhead3 dt:dt="string"/>
		</o:CustomDocumentProperties>
	</xsl:template>

	<xsl:template name="fonts">
		<w:fonts>
			<w:defaultFonts w:ascii="Times New Roman" w:fareast="Times New Roman" w:h-ansi="Times New Roman" w:cs="Times New Roman"/>
			<w:font w:name="Times New Roman">
				<w:panose-1 w:val="02020603050405020304"/>
				<w:charset w:val="00"/>
				<w:family w:val="Roman"/>
				<w:pitch w:val="variable"/>
				<w:sig w:usb-0="20007A87" w:usb-1="80000000" w:usb-2="00000008" w:usb-3="00000000" w:csb-0="000001FF" w:csb-1="00000000"/>
			</w:font>
		</w:fonts>
	</xsl:template>
	<xsl:template name="styles">
		<w:styles>
			<w:versionOfBuiltInStylenames w:val="4"/>
			<w:latentStyles w:defLockedState="off" w:latentStyleCount="156"/>
			<w:style w:type="paragraph" w:default="on" w:styleId="Normal">
				<w:name w:val="Normal"/>
				<w:pPr>
					<w:keepLines/>
					<w:suppressAutoHyphens/>
				</w:pPr>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<wx:font wx:val="Times New Roman"/>
					<w:kern w:val="10"/>
					<w:sz w:val="18"/>
					<w:lang w:val="EN-US" w:fareast="EN-US" w:bidi="AR-SA"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:default="on" w:styleId="DefaultParagraphFont">
				<w:name w:val="Default Paragraph Font"/>
				<w:semiHidden/>
			</w:style>
			<w:style w:type="table" w:default="on" w:styleId="TableNormal">
				<w:name w:val="Normal Table"/>
				<wx:uiName wx:val="Table Normal"/>
				<w:semiHidden/>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
				<w:tblPr>
					<w:tblInd w:w="0" w:type="dxa"/>
					<w:tblCellMar>
						<w:top w:w="0" w:type="dxa"/>
						<w:left w:w="108" w:type="dxa"/>
						<w:bottom w:w="0" w:type="dxa"/>
						<w:right w:w="108" w:type="dxa"/>
					</w:tblCellMar>
				</w:tblPr>
			</w:style>
			<w:style w:type="list" w:default="on" w:styleId="NoList">
				<w:name w:val="No List"/>
				<w:semiHidden/>
			</w:style>
			<w:style w:type="paragraph" w:styleId="Footer">
				<w:name w:val="footer"/>
				<wx:uiName wx:val="Footer"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="Footer"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="10405"/>
					</w:tabs>
				</w:pPr>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="Header">
				<w:name w:val="header"/>
				<wx:uiName wx:val="Header"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="Header"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="10405"/>
					</w:tabs>
				</w:pPr>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="editionnumber">
				<w:name w:val="edition number"/>
				<w:basedOn w:val="DefaultParagraphFont"/>
				<w:rPr>
					<w:b/>
					<w:i w:val="off"/>
					<w:bdr w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/>
					<w:shd w:val="clear" w:color="auto" w:fill="auto"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="toctitle">
				<w:name w:val="toctitle"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="toctitle"/>
					<w:keepNext/>
					<w:spacing w:after="363"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="tocsubtitle">
				<w:name w:val="tocsubtitle"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="tocsubtitle"/>
					<w:keepNext/>
					<w:tabs>
						<w:tab w:val="left" w:pos="1134"/>
					</w:tabs>
					<w:spacing w:before="567"/>
					<w:ind w:left="1134" w:hanging="1134"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="tocclass">
				<w:name w:val="tocclass"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="tocclass"/>
					<w:keepNext/>
					<w:tabs>
						<w:tab w:val="left" w:pos="669"/>
						<w:tab w:val="right" w:leader="dot" w:pos="4919"/>
					</w:tabs>
					<w:spacing w:before="624" w:after="249"/>
					<w:ind w:left="669" w:right="567" w:hanging="669"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="tocsubclass">
				<w:name w:val="tocsubclass"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="tocsubclass"/>
					<w:tabs>
						<w:tab w:val="left" w:pos="669"/>
						<w:tab w:val="right" w:leader="dot" w:pos="4919"/>
					</w:tabs>
					<w:spacing w:after="57"/>
					<w:ind w:left="669" w:right="567" w:hanging="669"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="section">
				<w:name w:val="section"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="section"/>
					<w:keepNext/>
					<w:pageBreakBefore/>
					<w:spacing w:after="822"/>
					<w:jc w:val="both"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
					<w:sz w:val="26"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="subsection">
				<w:name w:val="subsection"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="subsection"/>
					<w:keepNext/>
					<w:pageBreakBefore/>
					<w:spacing w:after="522"/>
					<w:ind w:left="824" w:hanging="824"/>
					<w:jc w:val="both"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
					<w:sz w:val="26"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="class">
				<w:name w:val="class"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="subclass"/>
				<w:pPr>
					<w:pStyle w:val="class"/>
					<w:keepNext/>
					<w:pageBreakBefore/>
					<w:spacing w:before="522" w:after="397"/>
					<w:ind w:left="824" w:hanging="824"/>
					<w:jc w:val="both"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
					<w:sz w:val="22"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="subclass">
				<w:name w:val="subclass"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="notetitle1"/>
				<w:pPr>
					<w:pStyle w:val="subclass"/>
					<w:keepNext/>
					<w:spacing w:after="397"/>
					<w:ind w:left="824" w:hanging="824"/>
					<w:jc w:val="both"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="guide">
				<w:name w:val="guide"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="maingroup"/>
				<w:pPr>
					<w:pStyle w:val="guide"/>
					<w:keepNext/>
					<w:spacing w:before="414"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
					<w:u w:val="single"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="indextitle">
				<w:name w:val="index title"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="index0"/>
				<w:pPr>
					<w:pStyle w:val="indextitle"/>
					<w:keepNext/>
					<w:spacing w:after="113"/>
					<w:ind w:right="1701"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
					<w:u w:val="single"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="notetitle0">
				<w:name w:val="note title 0"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="simplenote1"/>
				<w:pPr>
					<w:pStyle w:val="notetitle0"/>
					<w:keepNext/>
					<w:spacing w:before="283" w:after="170"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
					<w:u w:val="single"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="notetitle1">
				<w:name w:val="note title 1"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="simplenote1"/>
				<w:pPr>
					<w:pStyle w:val="notetitle1"/>
					<w:keepNext/>
					<w:spacing w:before="283" w:after="170"/>
					<w:ind w:left="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
					<w:u w:val="single"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="maingroup">
				<w:name w:val="maingroup"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="maingroup"/>
<!--					<w:keepNext/>-->
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
					</w:tabs>
					<w:spacing w:before="187"/>
					<w:ind w:left="824" w:hanging="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots1">
				<w:name w:val="dots1"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots1"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="1034" w:hanging="1034"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots2">
				<w:name w:val="dots2"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots2"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="1244" w:hanging="1244"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots3">
				<w:name w:val="dots3"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots3"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="1454" w:hanging="1454"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots4">
				<w:name w:val="dots4"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots4"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="1663" w:hanging="1663"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots5">
				<w:name w:val="dots5"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots5"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="1873" w:hanging="1873"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots6">
				<w:name w:val="dots6"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots6"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="2083" w:hanging="2083"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots7">
				<w:name w:val="dots7"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots7"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="2293" w:hanging="2293"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots8">
				<w:name w:val="dots8"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots8"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
						<w:tab w:val="left" w:pos="2712"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="2502" w:hanging="2502"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots9">
				<w:name w:val="dots9"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots9"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
						<w:tab w:val="left" w:pos="2712"/>
						<w:tab w:val="left" w:pos="2922"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="2712" w:hanging="2712"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots10">
				<w:name w:val="dots10"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots10"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
						<w:tab w:val="left" w:pos="2712"/>
						<w:tab w:val="left" w:pos="2922"/>
						<w:tab w:val="left" w:pos="3132"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="2922" w:hanging="2922"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots11">
				<w:name w:val="dots11"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots11"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
						<w:tab w:val="left" w:pos="2712"/>
						<w:tab w:val="left" w:pos="2922"/>
						<w:tab w:val="left" w:pos="3132"/>
						<w:tab w:val="left" w:pos="3341"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="3132" w:hanging="3132"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots12">
				<w:name w:val="dots12"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots12"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
						<w:tab w:val="left" w:pos="2712"/>
						<w:tab w:val="left" w:pos="2922"/>
						<w:tab w:val="left" w:pos="3132"/>
						<w:tab w:val="left" w:pos="3341"/>
						<w:tab w:val="left" w:pos="3551"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="3341" w:hanging="3341"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots13">
				<w:name w:val="dots13"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots13"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
						<w:tab w:val="left" w:pos="2712"/>
						<w:tab w:val="left" w:pos="2922"/>
						<w:tab w:val="left" w:pos="3132"/>
						<w:tab w:val="left" w:pos="3341"/>
						<w:tab w:val="left" w:pos="3551"/>
						<w:tab w:val="left" w:pos="3761"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="3551" w:hanging="3551"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots14">
				<w:name w:val="dots14"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots14"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
						<w:tab w:val="left" w:pos="2712"/>
						<w:tab w:val="left" w:pos="2922"/>
						<w:tab w:val="left" w:pos="3132"/>
						<w:tab w:val="left" w:pos="3341"/>
						<w:tab w:val="left" w:pos="3551"/>
						<w:tab w:val="left" w:pos="3761"/>
						<w:tab w:val="left" w:pos="3971"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="3761" w:hanging="3761"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots15">
				<w:name w:val="dots15"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="dots15"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
						<w:tab w:val="left" w:pos="1244"/>
						<w:tab w:val="left" w:pos="1454"/>
						<w:tab w:val="left" w:pos="1663"/>
						<w:tab w:val="left" w:pos="1873"/>
						<w:tab w:val="left" w:pos="2083"/>
						<w:tab w:val="left" w:pos="2293"/>
						<w:tab w:val="left" w:pos="2502"/>
						<w:tab w:val="left" w:pos="2712"/>
						<w:tab w:val="left" w:pos="2922"/>
						<w:tab w:val="left" w:pos="3132"/>
						<w:tab w:val="left" w:pos="3341"/>
						<w:tab w:val="left" w:pos="3551"/>
						<w:tab w:val="left" w:pos="3761"/>
						<w:tab w:val="left" w:pos="3971"/>
						<w:tab w:val="left" w:pos="4181"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="3971" w:hanging="3971"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote0">
				<w:name w:val="hanging note 0"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote0"/>
					<w:keepNext/>
					<w:ind w:left="824" w:hanging="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote0">
				<w:name w:val="simple note 0"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="simplenote0"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index0">
				<w:name w:val="index0"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="index0"/>
					<w:tabs>
						<w:tab w:val="right" w:leader="dot" w:pos="4919"/>
						<w:tab w:val="center" w:leader="dot" w:pos="4947"/>
					</w:tabs>
					<w:spacing w:before="45"/>
					<w:ind w:right="1474"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="indexcontinued">
				<w:name w:val="index continued"/>
				<w:basedOn w:val="index0"/>
				<w:next w:val="index0"/>
				<w:pPr>
					<w:pStyle w:val="indexcontinued"/>
					<w:keepNext w:val="off"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="4919"/>
					</w:tabs>
					<w:spacing w:before="0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote1">
				<w:name w:val="hanging note 1"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote1"/>
					<w:keepNext/>
					<w:ind w:left="1102" w:hanging="278"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote1">
				<w:name w:val="simple note 1"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="hangingnote1"/>
				<w:pPr>
					<w:pStyle w:val="simplenote1"/>
					<w:keepNext/>
					<w:ind w:left="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index1">
				<w:name w:val="index1"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="index1"/>
					<w:tabs>
						<w:tab w:val="right" w:leader="dot" w:pos="4919"/>
						<w:tab w:val="center" w:leader="dot" w:pos="4947"/>
					</w:tabs>
					<w:spacing w:before="45"/>
					<w:ind w:left="824" w:right="1474"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote2">
				<w:name w:val="hanging note 2"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote2"/>
					<w:keepNext/>
					<w:ind w:left="1380" w:hanging="278"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote2">
				<w:name w:val="simple note 2"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="simplenote2"/>
					<w:keepNext/>
					<w:ind w:left="1102"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index2">
				<w:name w:val="index2"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="index2"/>
					<w:tabs>
						<w:tab w:val="right" w:leader="dot" w:pos="4919"/>
						<w:tab w:val="center" w:leader="dot" w:pos="4947"/>
					</w:tabs>
					<w:spacing w:before="45"/>
					<w:ind w:left="1170" w:right="1474"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote3">
				<w:name w:val="hanging note 3"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote3"/>
					<w:keepNext/>
					<w:ind w:left="1658" w:hanging="278"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote3">
				<w:name w:val="simple note 3"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="simplenote3"/>
					<w:keepNext/>
					<w:ind w:left="1380"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index3">
				<w:name w:val="index3"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="index3"/>
					<w:tabs>
						<w:tab w:val="right" w:leader="dot" w:pos="4919"/>
						<w:tab w:val="center" w:leader="dot" w:pos="4947"/>
					</w:tabs>
					<w:spacing w:before="45"/>
					<w:ind w:left="1516" w:right="1474"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote4">
				<w:name w:val="hanging note 4"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote4"/>
					<w:keepNext/>
					<w:ind w:left="1935" w:hanging="278"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote4">
				<w:name w:val="simple note 4"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="simplenote4"/>
					<w:keepNext/>
					<w:ind w:left="1658"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index4">
				<w:name w:val="index4"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="index4"/>
					<w:tabs>
						<w:tab w:val="right" w:leader="dot" w:pos="4919"/>
						<w:tab w:val="center" w:leader="dot" w:pos="4947"/>
					</w:tabs>
					<w:spacing w:before="45"/>
					<w:ind w:left="1862" w:right="1474"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote5">
				<w:name w:val="hanging note 5"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote5"/>
					<w:keepNext/>
					<w:ind w:left="2213" w:hanging="278"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote5">
				<w:name w:val="simple note 5"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="simplenote5"/>
					<w:keepNext/>
					<w:ind w:left="1935"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index5">
				<w:name w:val="index5"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="index5"/>
					<w:tabs>
						<w:tab w:val="right" w:leader="dot" w:pos="4919"/>
						<w:tab w:val="center" w:leader="dot" w:pos="4947"/>
					</w:tabs>
					<w:spacing w:before="45"/>
					<w:ind w:left="2208" w:right="1474"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="columnednote">
				<w:name w:val="columned note"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="columnednote"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="1731"/>
						<w:tab w:val="center" w:pos="1759"/>
						<w:tab w:val="left" w:pos="1805"/>
						<w:tab w:val="left" w:pos="2156"/>
					</w:tabs>
					<w:ind w:left="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="columnednote0">
				<w:name w:val="columned note 0"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="columnednote0"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="1731"/>
						<w:tab w:val="center" w:pos="1759"/>
						<w:tab w:val="left" w:pos="1805"/>
						<w:tab w:val="left" w:pos="2156"/>
					</w:tabs>
					<w:ind w:left="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="columnednote1">
				<w:name w:val="columned note 1"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="columnednote1"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="1941"/>
						<w:tab w:val="center" w:pos="1969"/>
						<w:tab w:val="left" w:pos="2015"/>
						<w:tab w:val="left" w:pos="2366"/>
					</w:tabs>
					<w:ind w:left="1034"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="columnednote2">
				<w:name w:val="columned note 2"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="columnednote2"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="2151"/>
						<w:tab w:val="center" w:pos="2179"/>
						<w:tab w:val="left" w:pos="2225"/>
						<w:tab w:val="left" w:pos="2576"/>
					</w:tabs>
					<w:ind w:left="1244"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="manual">
				<w:name w:val="manual"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="manual"/>
				</w:pPr>
				<w:rPr>
					<w:rFonts w:ascii="Courier New" w:h-ansi="Courier New"/>
					<wx:font wx:val="Courier New"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="deletedmaingroup">
				<w:name w:val="deleted maingroup"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="deleted"/>
				<w:pPr>
					<w:pStyle w:val="deletedmaingroup"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
					</w:tabs>
					<w:spacing w:before="187"/>
					<w:ind w:left="824" w:hanging="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:b/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="deleted">
				<w:name w:val="deleted"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="deleted"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
					</w:tabs>
					<w:spacing w:before="28"/>
					<w:ind w:left="824" w:hanging="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="deleteduntil">
				<w:name w:val="deleted until"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="deleteduntil"/>
					<w:tabs>
						<w:tab w:val="right" w:pos="283"/>
						<w:tab w:val="center" w:pos="326"/>
						<w:tab w:val="left" w:pos="369"/>
						<w:tab w:val="left" w:pos="824"/>
						<w:tab w:val="left" w:pos="1034"/>
					</w:tabs>
					<w:ind w:left="824" w:hanging="824"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="sectionnew">
				<w:name w:val="section new"/>
				<w:basedOn w:val="section"/>
				<w:pPr>
					<w:pStyle w:val="sectionnew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="subsectionnew">
				<w:name w:val="subsection new"/>
				<w:basedOn w:val="subsection"/>
				<w:pPr>
					<w:pStyle w:val="subsectionnew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="classnew">
				<w:name w:val="class new"/>
				<w:basedOn w:val="class"/>
				<w:pPr>
					<w:pStyle w:val="classnew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="subclassnew">
				<w:name w:val="subclass new"/>
				<w:basedOn w:val="subclass"/>
				<w:pPr>
					<w:pStyle w:val="subclassnew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="guidenew">
				<w:name w:val="guide new"/>
				<w:basedOn w:val="guide"/>
				<w:pPr>
					<w:pStyle w:val="guidenew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="indextitlenew">
				<w:name w:val="index title new"/>
				<w:basedOn w:val="indextitle"/>
				<w:pPr>
					<w:pStyle w:val="indextitlenew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="notetitle0new">
				<w:name w:val="note title 0 new"/>
				<w:basedOn w:val="notetitle0"/>
				<w:pPr>
					<w:pStyle w:val="notetitle0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="notetitle1new">
				<w:name w:val="note title 1 new"/>
				<w:basedOn w:val="notetitle1"/>
				<w:pPr>
					<w:pStyle w:val="notetitle1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="maingroupnew">
				<w:name w:val="maingroup new"/>
				<w:basedOn w:val="maingroup"/>
				<w:next w:val="dots1new"/>
				<w:pPr>
					<w:pStyle w:val="maingroupnew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots1new">
				<w:name w:val="dots1 new"/>
				<w:basedOn w:val="dots1"/>
				<w:pPr>
					<w:pStyle w:val="dots1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots2new">
				<w:name w:val="dots2 new"/>
				<w:basedOn w:val="dots2"/>
				<w:pPr>
					<w:pStyle w:val="dots2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots3new">
				<w:name w:val="dots3 new"/>
				<w:basedOn w:val="dots3"/>
				<w:pPr>
					<w:pStyle w:val="dots3new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots4new">
				<w:name w:val="dots4 new"/>
				<w:basedOn w:val="dots4"/>
				<w:pPr>
					<w:pStyle w:val="dots4new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots5new">
				<w:name w:val="dots5 new"/>
				<w:basedOn w:val="dots5"/>
				<w:pPr>
					<w:pStyle w:val="dots5new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots6new">
				<w:name w:val="dots6 new"/>
				<w:basedOn w:val="dots6"/>
				<w:pPr>
					<w:pStyle w:val="dots6new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots7new">
				<w:name w:val="dots7 new"/>
				<w:basedOn w:val="dots7"/>
				<w:pPr>
					<w:pStyle w:val="dots7new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots8new">
				<w:name w:val="dots8 new"/>
				<w:basedOn w:val="dots8"/>
				<w:pPr>
					<w:pStyle w:val="dots8new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots9new">
				<w:name w:val="dots9 new"/>
				<w:basedOn w:val="dots9"/>
				<w:pPr>
					<w:pStyle w:val="dots9new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots10new">
				<w:name w:val="dots10 new"/>
				<w:basedOn w:val="dots10"/>
				<w:pPr>
					<w:pStyle w:val="dots10new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots11new">
				<w:name w:val="dots11 new"/>
				<w:basedOn w:val="dots11"/>
				<w:pPr>
					<w:pStyle w:val="dots11new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots12new">
				<w:name w:val="dots12 new"/>
				<w:basedOn w:val="dots12"/>
				<w:pPr>
					<w:pStyle w:val="dots12new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots13new">
				<w:name w:val="dots13 new"/>
				<w:basedOn w:val="dots13"/>
				<w:pPr>
					<w:pStyle w:val="dots13new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots14new">
				<w:name w:val="dots14 new"/>
				<w:basedOn w:val="dots14"/>
				<w:pPr>
					<w:pStyle w:val="dots14new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots15new">
				<w:name w:val="dots15 new"/>
				<w:basedOn w:val="dots15"/>
				<w:pPr>
					<w:pStyle w:val="dots15new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote0new">
				<w:name w:val="hanging note 0 new"/>
				<w:basedOn w:val="hangingnote0"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote0new">
				<w:name w:val="simple note 0 new"/>
				<w:basedOn w:val="simplenote0"/>
				<w:pPr>
					<w:pStyle w:val="simplenote0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index0new">
				<w:name w:val="index0 new"/>
				<w:basedOn w:val="index0"/>
				<w:pPr>
					<w:pStyle w:val="index0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="indexcontinuednew">
				<w:name w:val="index continued new"/>
				<w:basedOn w:val="indexcontinued"/>
				<w:pPr>
					<w:pStyle w:val="indexcontinuednew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote1new">
				<w:name w:val="hanging note 1 new"/>
				<w:basedOn w:val="hangingnote1"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote1new">
				<w:name w:val="simple note 1 new"/>
				<w:basedOn w:val="simplenote1"/>
				<w:pPr>
					<w:pStyle w:val="simplenote1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index1new">
				<w:name w:val="index1 new"/>
				<w:basedOn w:val="index1"/>
				<w:pPr>
					<w:pStyle w:val="index1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote2new">
				<w:name w:val="hanging note 2 new"/>
				<w:basedOn w:val="hangingnote2"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote2new">
				<w:name w:val="simple note 2 new"/>
				<w:basedOn w:val="simplenote2"/>
				<w:pPr>
					<w:pStyle w:val="simplenote2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index2new">
				<w:name w:val="index2 new"/>
				<w:basedOn w:val="index2"/>
				<w:pPr>
					<w:pStyle w:val="index2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote3new">
				<w:name w:val="hanging note 3 new"/>
				<w:basedOn w:val="hangingnote3"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote3new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote3new">
				<w:name w:val="simple note 3 new"/>
				<w:basedOn w:val="simplenote3"/>
				<w:pPr>
					<w:pStyle w:val="simplenote3new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index3new">
				<w:name w:val="index3 new"/>
				<w:basedOn w:val="index3"/>
				<w:pPr>
					<w:pStyle w:val="index3new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote4new">
				<w:name w:val="hanging note 4 new"/>
				<w:basedOn w:val="hangingnote4"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote4new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote4new">
				<w:name w:val="simple note 4 new"/>
				<w:basedOn w:val="simplenote4"/>
				<w:pPr>
					<w:pStyle w:val="simplenote4new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index4new">
				<w:name w:val="index4 new"/>
				<w:basedOn w:val="index4"/>
				<w:pPr>
					<w:pStyle w:val="index4new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hangingnote5new">
				<w:name w:val="hanging note 5 new"/>
				<w:basedOn w:val="hangingnote5"/>
				<w:pPr>
					<w:pStyle w:val="hangingnote5new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="simplenote5new">
				<w:name w:val="simple note 5 new"/>
				<w:basedOn w:val="simplenote5"/>
				<w:pPr>
					<w:pStyle w:val="simplenote5new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="index5new">
				<w:name w:val="index5 new"/>
				<w:basedOn w:val="index5"/>
				<w:pPr>
					<w:pStyle w:val="index5new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="columnednotenew">
				<w:name w:val="columned note new"/>
				<w:basedOn w:val="columnednote"/>
				<w:pPr>
					<w:pStyle w:val="columnednotenew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="columnednote0new">
				<w:name w:val="columned note 0 new"/>
				<w:basedOn w:val="columnednote0"/>
				<w:pPr>
					<w:pStyle w:val="columnednote0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="columnednote1new">
				<w:name w:val="columned note 1 new"/>
				<w:basedOn w:val="columnednote1"/>
				<w:pPr>
					<w:pStyle w:val="columnednote1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="columnednote2new">
				<w:name w:val="columned note 2 new"/>
				<w:basedOn w:val="columnednote2"/>
				<w:pPr>
					<w:pStyle w:val="columnednote2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="manualnew">
				<w:name w:val="manual new"/>
				<w:basedOn w:val="manual"/>
				<w:pPr>
					<w:pStyle w:val="manualnew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Courier New"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="line">
				<w:name w:val="line"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="line"/>
					<w:pBdr>
						<w:bottom w:val="single" w:sz="4" wx:bdrwidth="10" w:space="1" w:color="auto"/>
					</w:pBdr>
					<w:spacing w:after="369"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:sz w:val="30"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="guideline">
				<w:name w:val="guideline"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="maingroup"/>
				<w:pPr>
					<w:pStyle w:val="guideline"/>
					<w:pBdr>
						<w:bottom w:val="single" w:sz="4" wx:bdrwidth="10" w:space="1" w:color="auto"/>
					</w:pBdr>
					<w:spacing w:before="122" w:after="255"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="subclassline">
				<w:name w:val="subclass line"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="subclassline"/>
					<w:pBdr>
						<w:bottom w:val="single" w:sz="4" wx:bdrwidth="10" w:space="1" w:color="auto"/>
					</w:pBdr>
					<w:spacing w:before="262" w:after="300"/>
					<w:ind w:left="3118" w:right="3118"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="maingroupbar">
				<w:name w:val="maingroup bar"/>
				<w:basedOn w:val="maingroup"/>
				<w:next w:val="dots1bar"/>
				<w:pPr>
					<w:pStyle w:val="maingroupbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="maingroupnewbar">
				<w:name w:val="maingroup new bar"/>
				<w:basedOn w:val="maingroupnew"/>
				<w:pPr>
					<w:pStyle w:val="maingroupnewbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots1bar">
				<w:name w:val="dots1 bar"/>
				<w:basedOn w:val="dots1"/>
				<w:pPr>
					<w:pStyle w:val="dots1bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots1newbar">
				<w:name w:val="dots1 new bar"/>
				<w:basedOn w:val="dots1new"/>
				<w:pPr>
					<w:pStyle w:val="dots1newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots2bar">
				<w:name w:val="dots2 bar"/>
				<w:basedOn w:val="dots2"/>
				<w:pPr>
					<w:pStyle w:val="dots2bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots2newbar">
				<w:name w:val="dots2 new bar"/>
				<w:basedOn w:val="dots2new"/>
				<w:pPr>
					<w:pStyle w:val="dots2newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots3bar">
				<w:name w:val="dots3 bar"/>
				<w:basedOn w:val="dots3"/>
				<w:pPr>
					<w:pStyle w:val="dots3bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots3newbar">
				<w:name w:val="dots3 new bar"/>
				<w:basedOn w:val="dots3new"/>
				<w:pPr>
					<w:pStyle w:val="dots3newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots4bar">
				<w:name w:val="dots4 bar"/>
				<w:basedOn w:val="dots4"/>
				<w:pPr>
					<w:pStyle w:val="dots4bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots4newbar">
				<w:name w:val="dots4 new bar"/>
				<w:basedOn w:val="dots4new"/>
				<w:pPr>
					<w:pStyle w:val="dots4newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots5bar">
				<w:name w:val="dots5 bar"/>
				<w:basedOn w:val="dots5"/>
				<w:pPr>
					<w:pStyle w:val="dots5bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots5newbar">
				<w:name w:val="dots5 new bar"/>
				<w:basedOn w:val="dots5new"/>
				<w:pPr>
					<w:pStyle w:val="dots5newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots6bar">
				<w:name w:val="dots6 bar"/>
				<w:basedOn w:val="dots6"/>
				<w:pPr>
					<w:pStyle w:val="dots6bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots6newbar">
				<w:name w:val="dots6 new bar"/>
				<w:basedOn w:val="dots6new"/>
				<w:pPr>
					<w:pStyle w:val="dots6newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots7bar">
				<w:name w:val="dots7 bar"/>
				<w:basedOn w:val="dots7"/>
				<w:pPr>
					<w:pStyle w:val="dots7bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots7newbar">
				<w:name w:val="dots7 new bar"/>
				<w:basedOn w:val="dots7new"/>
				<w:pPr>
					<w:pStyle w:val="dots7newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots8bar">
				<w:name w:val="dots8 bar"/>
				<w:basedOn w:val="dots8"/>
				<w:pPr>
					<w:pStyle w:val="dots8bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots8newbar">
				<w:name w:val="dots8 new bar"/>
				<w:basedOn w:val="dots8new"/>
				<w:pPr>
					<w:pStyle w:val="dots8newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots9bar">
				<w:name w:val="dots9 bar"/>
				<w:basedOn w:val="dots9"/>
				<w:pPr>
					<w:pStyle w:val="dots9bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots9newbar">
				<w:name w:val="dots9 new bar"/>
				<w:basedOn w:val="dots9new"/>
				<w:pPr>
					<w:pStyle w:val="dots9newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots10bar">
				<w:name w:val="dots10 bar"/>
				<w:basedOn w:val="dots10"/>
				<w:pPr>
					<w:pStyle w:val="dots10bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots10newbar">
				<w:name w:val="dots10 new bar"/>
				<w:basedOn w:val="dots10new"/>
				<w:pPr>
					<w:pStyle w:val="dots10newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots11bar">
				<w:name w:val="dots11 bar"/>
				<w:basedOn w:val="dots11"/>
				<w:pPr>
					<w:pStyle w:val="dots11bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots11newbar">
				<w:name w:val="dots11 new bar"/>
				<w:basedOn w:val="dots11new"/>
				<w:pPr>
					<w:pStyle w:val="dots11newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots12bar">
				<w:name w:val="dots12 bar"/>
				<w:basedOn w:val="dots12"/>
				<w:pPr>
					<w:pStyle w:val="dots12bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots12newbar">
				<w:name w:val="dots12 new bar"/>
				<w:basedOn w:val="dots12new"/>
				<w:pPr>
					<w:pStyle w:val="dots12newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots13bar">
				<w:name w:val="dots13 bar"/>
				<w:basedOn w:val="dots13"/>
				<w:pPr>
					<w:pStyle w:val="dots13bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots13newbar">
				<w:name w:val="dots13 new bar"/>
				<w:basedOn w:val="dots13new"/>
				<w:pPr>
					<w:pStyle w:val="dots13newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots14bar">
				<w:name w:val="dots14 bar"/>
				<w:basedOn w:val="dots14"/>
				<w:pPr>
					<w:pStyle w:val="dots14bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots14newbar">
				<w:name w:val="dots14 new bar"/>
				<w:basedOn w:val="dots14new"/>
				<w:pPr>
					<w:pStyle w:val="dots14newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots15bar">
				<w:name w:val="dots15 bar"/>
				<w:basedOn w:val="dots15"/>
				<w:pPr>
					<w:pStyle w:val="dots15bar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="dots15newbar">
				<w:name w:val="dots15 new bar"/>
				<w:basedOn w:val="dots15new"/>
				<w:pPr>
					<w:pStyle w:val="dots15newbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="Grayed">
				<w:name w:val="Grayed"/>
				<w:basedOn w:val="DefaultParagraphFont"/>
				<w:rsid w:val="008436C9"/>
				<w:rPr>
					<w:bdr w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/>
					<w:shd w:val="clear" w:color="auto" w:fill="D9D9D9"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="aspage">
				<w:name w:val="aspage"/>
				<w:basedOn w:val="DefaultParagraphFont"/>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="pspage">
				<w:name w:val="pspage"/>
				<w:basedOn w:val="aspage"/>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="ppspage">
				<w:name w:val="ppspage"/>
				<w:basedOn w:val="aspage"/>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="aschar">
				<w:name w:val="aschar"/>
				<w:basedOn w:val="aspage"/>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="pschar">
				<w:name w:val="pschar"/>
				<w:basedOn w:val="aspage"/>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="ppschar">
				<w:name w:val="ppschar"/>
				<w:basedOn w:val="aspage"/>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="cchar">
				<w:name w:val="cchar"/>
				<w:basedOn w:val="aspage"/>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="headerreference">
				<w:name w:val="header reference"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="subclass"/>
				<w:pPr>
					<w:pStyle w:val="headerreference"/>
					<w:keepNext/>
					<w:spacing w:after="0"/>
				</w:pPr>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<wx:font wx:val="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="cindclass">
				<w:name w:val="cindclass"/>
				<w:basedOn w:val="DefaultParagraphFont"/>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindextitle">
				<w:name w:val="page index title"/>
				<w:basedOn w:val="autoindextitle"/>
				<w:pPr>
					<w:pStyle w:val="pageindextitle"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pagenotetitle0">
				<w:name w:val="page note title 0"/>
				<w:basedOn w:val="autonotetitle0"/>
				<w:pPr>
					<w:pStyle w:val="pagenotetitle0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pagenotetitle1">
				<w:name w:val="page note title 1"/>
				<w:basedOn w:val="autonotetitle1"/>
				<w:pPr>
					<w:pStyle w:val="pagenotetitle1"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindextitlenew">
				<w:name w:val="page index title new"/>
				<w:basedOn w:val="pageindextitle"/>
				<w:pPr>
					<w:pStyle w:val="pageindextitlenew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pagenotetitle0new">
				<w:name w:val="page note title 0 new"/>
				<w:basedOn w:val="pagenotetitle0"/>
				<w:pPr>
					<w:pStyle w:val="pagenotetitle0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pagenotetitle1new">
				<w:name w:val="page note title 1 new"/>
				<w:basedOn w:val="pagenotetitle1"/>
				<w:pPr>
					<w:pStyle w:val="pagenotetitle1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hiddenline">
				<w:name w:val="hidden line"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hiddenline"/>
					<w:pageBreakBefore/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:vanish/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hiddenguideline">
				<w:name w:val="hidden guideline"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hiddenguideline"/>
					<w:pageBreakBefore/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:vanish/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="hiddensubclassline">
				<w:name w:val="hidden subclass line"/>
				<w:basedOn w:val="Normal"/>
				<w:next w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="hiddensubclassline"/>
					<w:pageBreakBefore/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:vanish/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="character" w:styleId="hiddenpageno">
				<w:name w:val="hidden pageno"/>
				<w:basedOn w:val="aspage"/>
				<w:rPr>
					<w:rFonts w:ascii="Times New Roman" w:h-ansi="Times New Roman"/>
					<w:color w:val="FFFFFF"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autoindextitle">
				<w:name w:val="auto index title"/>
				<w:basedOn w:val="indextitle"/>
				<w:pPr>
					<w:pStyle w:val="autoindextitle"/>
					<w:pageBreakBefore/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autonotetitle0">
				<w:name w:val="auto note title 0"/>
				<w:basedOn w:val="notetitle0"/>
				<w:pPr>
					<w:pStyle w:val="autonotetitle0"/>
					<w:pageBreakBefore/>
					<w:spacing w:before="0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autonotetitle1">
				<w:name w:val="auto note title 1"/>
				<w:basedOn w:val="notetitle1"/>
				<w:pPr>
					<w:pStyle w:val="autonotetitle1"/>
					<w:pageBreakBefore/>
					<w:spacing w:before="0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepmaingroup">
				<w:name w:val="keep maingroup"/>
				<w:basedOn w:val="maingroup"/>
				<w:pPr>
					<w:pStyle w:val="keepmaingroup"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots1">
				<w:name w:val="keep dots1"/>
				<w:basedOn w:val="dots1"/>
				<w:pPr>
					<w:pStyle w:val="keepdots1"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots2">
				<w:name w:val="keep dots2"/>
				<w:basedOn w:val="dots2"/>
				<w:pPr>
					<w:pStyle w:val="keepdots2"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots3">
				<w:name w:val="keep dots3"/>
				<w:basedOn w:val="dots3"/>
				<w:pPr>
					<w:pStyle w:val="keepdots3"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots4">
				<w:name w:val="keep dots4"/>
				<w:basedOn w:val="dots4"/>
				<w:pPr>
					<w:pStyle w:val="keepdots4"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots5">
				<w:name w:val="keep dots5"/>
				<w:basedOn w:val="dots5"/>
				<w:pPr>
					<w:pStyle w:val="keepdots5"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots6">
				<w:name w:val="keep dots6"/>
				<w:basedOn w:val="dots6"/>
				<w:pPr>
					<w:pStyle w:val="keepdots6"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots7">
				<w:name w:val="keep dots7"/>
				<w:basedOn w:val="dots7"/>
				<w:pPr>
					<w:pStyle w:val="keepdots7"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots8">
				<w:name w:val="keep dots8"/>
				<w:basedOn w:val="dots8"/>
				<w:pPr>
					<w:pStyle w:val="keepdots8"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots9">
				<w:name w:val="keep dots9"/>
				<w:basedOn w:val="dots9"/>
				<w:pPr>
					<w:pStyle w:val="keepdots9"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots10">
				<w:name w:val="keep dots10"/>
				<w:basedOn w:val="dots10"/>
				<w:pPr>
					<w:pStyle w:val="keepdots10"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots11">
				<w:name w:val="keep dots11"/>
				<w:basedOn w:val="dots11"/>
				<w:pPr>
					<w:pStyle w:val="keepdots11"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots12">
				<w:name w:val="keep dots12"/>
				<w:basedOn w:val="dots12"/>
				<w:pPr>
					<w:pStyle w:val="keepdots12"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots13">
				<w:name w:val="keep dots13"/>
				<w:basedOn w:val="dots13"/>
				<w:pPr>
					<w:pStyle w:val="keepdots13"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots14">
				<w:name w:val="keep dots14"/>
				<w:basedOn w:val="dots14"/>
				<w:pPr>
					<w:pStyle w:val="keepdots14"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots15">
				<w:name w:val="keep dots15"/>
				<w:basedOn w:val="dots15"/>
				<w:pPr>
					<w:pStyle w:val="keepdots15"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote0">
				<w:name w:val="keep hanging note 0"/>
				<w:basedOn w:val="hangingnote0"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote0">
				<w:name w:val="keep simple note 0"/>
				<w:basedOn w:val="simplenote0"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex0">
				<w:name w:val="page index0"/>
				<w:basedOn w:val="index0"/>
				<w:pPr>
					<w:pStyle w:val="pageindex0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindexcontinued">
				<w:name w:val="page index continued"/>
				<w:basedOn w:val="indexcontinued"/>
				<w:pPr>
					<w:pStyle w:val="pageindexcontinued"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote1">
				<w:name w:val="keep hanging note 1"/>
				<w:basedOn w:val="hangingnote1"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote1"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote1">
				<w:name w:val="keep simple note 1"/>
				<w:basedOn w:val="simplenote1"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote1"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex1">
				<w:name w:val="page index1"/>
				<w:basedOn w:val="index1"/>
				<w:pPr>
					<w:pStyle w:val="pageindex1"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote2">
				<w:name w:val="keep hanging note 2"/>
				<w:basedOn w:val="hangingnote2"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote2"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote2">
				<w:name w:val="keep simple note 2"/>
				<w:basedOn w:val="simplenote2"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote2"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex2">
				<w:name w:val="page index2"/>
				<w:basedOn w:val="index2"/>
				<w:pPr>
					<w:pStyle w:val="pageindex2"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote3">
				<w:name w:val="keep hanging note 3"/>
				<w:basedOn w:val="hangingnote3"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote3"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote3">
				<w:name w:val="keep simple note 3"/>
				<w:basedOn w:val="simplenote3"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote3"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex3">
				<w:name w:val="page index3"/>
				<w:basedOn w:val="index3"/>
				<w:pPr>
					<w:pStyle w:val="pageindex3"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote4">
				<w:name w:val="keep hanging note 4"/>
				<w:basedOn w:val="hangingnote4"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote4"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote4">
				<w:name w:val="keep simple note 4"/>
				<w:basedOn w:val="simplenote4"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote4"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex4">
				<w:name w:val="page index4"/>
				<w:basedOn w:val="index4"/>
				<w:pPr>
					<w:pStyle w:val="pageindex4"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote5">
				<w:name w:val="keep hanging note 5"/>
				<w:basedOn w:val="hangingnote5"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote5"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote5">
				<w:name w:val="keep simple note 5"/>
				<w:basedOn w:val="simplenote5"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote5"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex5">
				<w:name w:val="page index5"/>
				<w:basedOn w:val="index5"/>
				<w:pPr>
					<w:pStyle w:val="pageindex5"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdeletedmaingroup">
				<w:name w:val="keep deleted maingroup"/>
				<w:basedOn w:val="deletedmaingroup"/>
				<w:pPr>
					<w:pStyle w:val="keepdeletedmaingroup"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdeleted">
				<w:name w:val="keep deleted"/>
				<w:basedOn w:val="deleted"/>
				<w:pPr>
					<w:pStyle w:val="keepdeleted"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdeleteduntil">
				<w:name w:val="keep deleted until"/>
				<w:basedOn w:val="deleteduntil"/>
				<w:pPr>
					<w:pStyle w:val="keepdeleteduntil"/>
					<w:keepNext/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autoindextitlenew">
				<w:name w:val="auto index title new"/>
				<w:basedOn w:val="autoindextitle"/>
				<w:pPr>
					<w:pStyle w:val="autoindextitlenew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autonotetitle0new">
				<w:name w:val="auto note title 0 new"/>
				<w:basedOn w:val="autonotetitle0"/>
				<w:pPr>
					<w:pStyle w:val="autonotetitle0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autonotetitle1new">
				<w:name w:val="auto note title 1 new"/>
				<w:basedOn w:val="autonotetitle1"/>
				<w:pPr>
					<w:pStyle w:val="autonotetitle1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepmaingroupnew">
				<w:name w:val="keep maingroup new"/>
				<w:basedOn w:val="keepmaingroup"/>
				<w:pPr>
					<w:pStyle w:val="keepmaingroupnew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots1new">
				<w:name w:val="keep dots1 new"/>
				<w:basedOn w:val="keepdots1"/>
				<w:pPr>
					<w:pStyle w:val="keepdots1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots2new">
				<w:name w:val="keep dots2 new"/>
				<w:basedOn w:val="keepdots2"/>
				<w:pPr>
					<w:pStyle w:val="keepdots2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots3new">
				<w:name w:val="keep dots3 new"/>
				<w:basedOn w:val="keepdots3"/>
				<w:pPr>
					<w:pStyle w:val="keepdots3new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots4new">
				<w:name w:val="keep dots4 new"/>
				<w:basedOn w:val="keepdots4"/>
				<w:pPr>
					<w:pStyle w:val="keepdots4new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots5new">
				<w:name w:val="keep dots5 new"/>
				<w:basedOn w:val="keepdots5"/>
				<w:pPr>
					<w:pStyle w:val="keepdots5new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots6new">
				<w:name w:val="keep dots6 new"/>
				<w:basedOn w:val="keepdots6"/>
				<w:pPr>
					<w:pStyle w:val="keepdots6new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots7new">
				<w:name w:val="keep dots7 new"/>
				<w:basedOn w:val="keepdots7"/>
				<w:pPr>
					<w:pStyle w:val="keepdots7new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots8new">
				<w:name w:val="keep dots8 new"/>
				<w:basedOn w:val="keepdots8"/>
				<w:pPr>
					<w:pStyle w:val="keepdots8new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots9new">
				<w:name w:val="keep dots9 new"/>
				<w:basedOn w:val="keepdots9"/>
				<w:pPr>
					<w:pStyle w:val="keepdots9new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots10new">
				<w:name w:val="keep dots10 new"/>
				<w:basedOn w:val="keepdots10"/>
				<w:pPr>
					<w:pStyle w:val="keepdots10new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots11new">
				<w:name w:val="keep dots11 new"/>
				<w:basedOn w:val="keepdots11"/>
				<w:pPr>
					<w:pStyle w:val="keepdots11new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots12new">
				<w:name w:val="keep dots12 new"/>
				<w:basedOn w:val="keepdots12"/>
				<w:pPr>
					<w:pStyle w:val="keepdots12new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots13new">
				<w:name w:val="keep dots13 new"/>
				<w:basedOn w:val="keepdots13"/>
				<w:pPr>
					<w:pStyle w:val="keepdots13new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots14new">
				<w:name w:val="keep dots14 new"/>
				<w:basedOn w:val="keepdots14"/>
				<w:pPr>
					<w:pStyle w:val="keepdots14new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots15new">
				<w:name w:val="keep dots15 new"/>
				<w:basedOn w:val="keepdots15"/>
				<w:pPr>
					<w:pStyle w:val="keepdots15new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote0new">
				<w:name w:val="keep hanging note 0 new"/>
				<w:basedOn w:val="keephangingnote0"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote0new">
				<w:name w:val="keep simple note 0 new"/>
				<w:basedOn w:val="keepsimplenote0"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex0new">
				<w:name w:val="page index0 new"/>
				<w:basedOn w:val="pageindex0"/>
				<w:pPr>
					<w:pStyle w:val="pageindex0new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindexcontinuednew">
				<w:name w:val="page index continued new"/>
				<w:basedOn w:val="pageindexcontinued"/>
				<w:pPr>
					<w:pStyle w:val="pageindexcontinuednew"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote1new">
				<w:name w:val="keep hanging note 1 new"/>
				<w:basedOn w:val="keephangingnote1"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote1new">
				<w:name w:val="keep simple note 1 new"/>
				<w:basedOn w:val="keepsimplenote1"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex1new">
				<w:name w:val="page index1 new"/>
				<w:basedOn w:val="pageindex1"/>
				<w:pPr>
					<w:pStyle w:val="pageindex1new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote2new">
				<w:name w:val="keep hanging note 2 new"/>
				<w:basedOn w:val="keephangingnote2"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote2new">
				<w:name w:val="keep simple note 2 new"/>
				<w:basedOn w:val="keepsimplenote2"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex2new">
				<w:name w:val="page index2 new"/>
				<w:basedOn w:val="pageindex2"/>
				<w:pPr>
					<w:pStyle w:val="pageindex2new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote3new">
				<w:name w:val="keep hanging note 3 new"/>
				<w:basedOn w:val="keephangingnote3"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote3new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote3new">
				<w:name w:val="keep simple note 3 new"/>
				<w:basedOn w:val="keepsimplenote3"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote3new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex3new">
				<w:name w:val="page index3 new"/>
				<w:basedOn w:val="pageindex3"/>
				<w:pPr>
					<w:pStyle w:val="pageindex3new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote4new">
				<w:name w:val="keep hanging note 4 new"/>
				<w:basedOn w:val="keephangingnote4"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote4new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote4new">
				<w:name w:val="keep simple note 4 new"/>
				<w:basedOn w:val="keepsimplenote4"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote4new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex4new">
				<w:name w:val="page index4 new"/>
				<w:basedOn w:val="pageindex4"/>
				<w:pPr>
					<w:pStyle w:val="pageindex4new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keephangingnote5new">
				<w:name w:val="keep hanging note 5 new"/>
				<w:basedOn w:val="keephangingnote5"/>
				<w:pPr>
					<w:pStyle w:val="keephangingnote5new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepsimplenote5new">
				<w:name w:val="keep simple note 5 new"/>
				<w:basedOn w:val="keepsimplenote5"/>
				<w:pPr>
					<w:pStyle w:val="keepsimplenote5new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageindex5new">
				<w:name w:val="page index5 new"/>
				<w:basedOn w:val="pageindex5"/>
				<w:pPr>
					<w:pStyle w:val="pageindex5new"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:i/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autoline">
				<w:name w:val="auto line"/>
				<w:basedOn w:val="line"/>
				<w:next w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="autoline"/>
					<w:pageBreakBefore/>
					<w:pBdr>
						<w:bottom w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/>
					</w:pBdr>
					<w:spacing w:after="0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageline">
				<w:name w:val="page line"/>
				<w:basedOn w:val="autoline"/>
				<w:pPr>
					<w:pStyle w:val="pageline"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autoguideline">
				<w:name w:val="auto guideline"/>
				<w:basedOn w:val="guideline"/>
				<w:next w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="autoguideline"/>
					<w:pageBreakBefore/>
					<w:pBdr>
						<w:bottom w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/>
					</w:pBdr>
					<w:spacing w:before="0" w:after="0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pageguideline">
				<w:name w:val="page guideline"/>
				<w:basedOn w:val="autoguideline"/>
				<w:pPr>
					<w:pStyle w:val="pageguideline"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="autosubclassline">
				<w:name w:val="auto subclass line"/>
				<w:basedOn w:val="subclassline"/>
				<w:next w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="autosubclassline"/>
					<w:pageBreakBefore/>
					<w:pBdr>
						<w:bottom w:val="none" w:sz="0" wx:bdrwidth="0" w:space="0" w:color="auto"/>
					</w:pBdr>
					<w:spacing w:before="0" w:after="0"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="pagesubclassline">
				<w:name w:val="page subclass line"/>
				<w:basedOn w:val="autosubclassline"/>
				<w:pPr>
					<w:pStyle w:val="pagesubclassline"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepmaingroupbar">
				<w:name w:val="keep maingroup bar"/>
				<w:basedOn w:val="maingroup"/>
				<w:pPr>
					<w:pStyle w:val="keepmaingroupbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepmaingroupnewbar">
				<w:name w:val="keep maingroup new bar"/>
				<w:basedOn w:val="maingroupnew"/>
				<w:pPr>
					<w:pStyle w:val="keepmaingroupnewbar"/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots1bar">
				<w:name w:val="keep dots1 bar"/>
				<w:basedOn w:val="dots1"/>
				<w:pPr>
					<w:pStyle w:val="keepdots1bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots1newbar">
				<w:name w:val="keep dots1 new bar"/>
				<w:basedOn w:val="dots1new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots1newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots2bar">
				<w:name w:val="keep dots2 bar"/>
				<w:basedOn w:val="dots2"/>
				<w:pPr>
					<w:pStyle w:val="keepdots2bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots2newbar">
				<w:name w:val="keep dots2 new bar"/>
				<w:basedOn w:val="dots2new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots2newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots3bar">
				<w:name w:val="keep dots3 bar"/>
				<w:basedOn w:val="dots3"/>
				<w:pPr>
					<w:pStyle w:val="keepdots3bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots3newbar">
				<w:name w:val="keep dots3 new bar"/>
				<w:basedOn w:val="dots3new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots3newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots4bar">
				<w:name w:val="keep dots4 bar"/>
				<w:basedOn w:val="dots4"/>
				<w:pPr>
					<w:pStyle w:val="keepdots4bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots4newbar">
				<w:name w:val="keep dots4 new bar"/>
				<w:basedOn w:val="dots4new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots4newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots5bar">
				<w:name w:val="keep dots5 bar"/>
				<w:basedOn w:val="dots5"/>
				<w:pPr>
					<w:pStyle w:val="keepdots5bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots5newbar">
				<w:name w:val="keep dots5 new bar"/>
				<w:basedOn w:val="dots5new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots5newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots6bar">
				<w:name w:val="keep dots6 bar"/>
				<w:basedOn w:val="dots6"/>
				<w:pPr>
					<w:pStyle w:val="keepdots6bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots6newbar">
				<w:name w:val="keep dots6 new bar"/>
				<w:basedOn w:val="dots6new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots6newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots7bar">
				<w:name w:val="keep dots7 bar"/>
				<w:basedOn w:val="dots7"/>
				<w:pPr>
					<w:pStyle w:val="keepdots7bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots7newbar">
				<w:name w:val="keep dots7 new bar"/>
				<w:basedOn w:val="dots7new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots7newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots8bar">
				<w:name w:val="keep dots8 bar"/>
				<w:basedOn w:val="dots8"/>
				<w:pPr>
					<w:pStyle w:val="keepdots8bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots8newbar">
				<w:name w:val="keep dots8 new bar"/>
				<w:basedOn w:val="dots8new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots8newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots9bar">
				<w:name w:val="keep dots9 bar"/>
				<w:basedOn w:val="dots9"/>
				<w:pPr>
					<w:pStyle w:val="keepdots9bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots9newbar">
				<w:name w:val="keep dots9 new bar"/>
				<w:basedOn w:val="dots9new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots9newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots10bar">
				<w:name w:val="keep dots10 bar"/>
				<w:basedOn w:val="dots10"/>
				<w:pPr>
					<w:pStyle w:val="keepdots10bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots10newbar">
				<w:name w:val="keep dots10 new bar"/>
				<w:basedOn w:val="dots10new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots10newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots11bar">
				<w:name w:val="keep dots11 bar"/>
				<w:basedOn w:val="dots11"/>
				<w:pPr>
					<w:pStyle w:val="keepdots11bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots11newbar">
				<w:name w:val="keep dots11 new bar"/>
				<w:basedOn w:val="dots11new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots11newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots12bar">
				<w:name w:val="keep dots12 bar"/>
				<w:basedOn w:val="dots12"/>
				<w:pPr>
					<w:pStyle w:val="keepdots12bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots12newbar">
				<w:name w:val="keep dots12 new bar"/>
				<w:basedOn w:val="dots12new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots12newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots13bar">
				<w:name w:val="keep dots13 bar"/>
				<w:basedOn w:val="dots13"/>
				<w:pPr>
					<w:pStyle w:val="keepdots13bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots13newbar">
				<w:name w:val="keep dots13 new bar"/>
				<w:basedOn w:val="dots13new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots13newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots14bar">
				<w:name w:val="keep dots14 bar"/>
				<w:basedOn w:val="dots14"/>
				<w:pPr>
					<w:pStyle w:val="keepdots14bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots14newbar">
				<w:name w:val="keep dots14 new bar"/>
				<w:basedOn w:val="dots14new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots14newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots15bar">
				<w:name w:val="keep dots15 bar"/>
				<w:basedOn w:val="dots15"/>
				<w:pPr>
					<w:pStyle w:val="keepdots15bar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="keepdots15newbar">
				<w:name w:val="keep dots15 new bar"/>
				<w:basedOn w:val="dots15new"/>
				<w:pPr>
					<w:pStyle w:val="keepdots15newbar"/>
					<w:keepNext/>
					<w:pBdr>
						<w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
					</w:pBdr>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
				</w:rPr>
			</w:style>
			<w:style w:type="paragraph" w:styleId="GAP">
				<w:name w:val="GAP"/>
				<w:basedOn w:val="Normal"/>
				<w:pPr>
					<w:pStyle w:val="GAP"/>
				</w:pPr>
				<w:rPr>
					<wx:font wx:val="Times New Roman"/>
					<w:sz w:val="2"/>
				</w:rPr>
			</w:style>
			<!-- 20050419 TA Added { lSubclassBookmark was missing! -->
<!--			<w:style w:type="character" w:styleId="lSubclassBookmark">
				<w:name w:val="lSubclassBookmark"/><w:basedOn w:val="DefaultParagraphFont"/>
				<w:rsid w:val="00A85C47"/><w:rPr><w:color w:val="FFFFFF"/><w:sz w:val="2"/><w:sz-cs w:val="28"/></w:rPr>
			</w:style>-->
			<w:style w:type="paragraph" w:styleId="lSubclassBookmark">
				<w:name w:val="lSubclassBookmark"/><w:basedOn w:val="DefaultParagraphFont"/>
				<w:rsid w:val="00A85C47"/><w:rPr><w:color w:val="FFFFFF"/><w:sz w:val="2"/><w:sz-cs w:val="28"/></w:rPr>
	            <w:rPr>
					<w:keepNext/>
	            </w:rPr>
			</w:style>
			<!-- 20050419 TA added } -->
<!--	        <w:style w:type="character" w:styleId="tSubclassBookmark">
	            <w:name w:val="tSubclassBookmark"/>
	            <w:basedOn w:val="lSubclassBookmark"/>
	            <w:rsid w:val="00A85C47"/>
	            <w:rPr>
	                <w:color w:val="FFFFFF"/>
	                <w:sz w:val="2"/>
	                <w:sz-cs w:val="2"/>
	            </w:rPr>
	        </w:style>-->
	        <w:style w:type="paragraph" w:styleId="tSubclassBookmark">
	            <w:name w:val="tSubclassBookmark"/>
	            <w:basedOn w:val="lSubclassBookmark"/>
	            <w:rsid w:val="00A85C47"/>
	            <w:rPr>
					<w:keepNext/>
	                <w:color w:val="FFFFFF"/>
	                <w:sz w:val="2"/>
	                <w:sz-cs w:val="2"/>
	            </w:rPr>
	        </w:style>
	        <w:style w:type="character" w:styleId="nSubclassBookmark">
	            <w:name w:val="nSubclassBookmark"/>
	            <w:basedOn w:val="lSubclassBookmark"/>
	            <w:rsid w:val="00A85C47"/>
	            <w:rPr>
	                <w:color w:val="FF0000"/>
	                <w:sz w:val="28"/>
	                <w:sz-cs w:val="28"/>
	            </w:rPr>
	        </w:style>
<!--	        <w:style w:type="character" w:styleId="tSubclass">
	            <w:name w:val="tSubclass"/>
	            <w:basedOn w:val="tSubclassBookmark"/>
	            <w:rsid w:val="00A85C47"/>
	            <w:rPr>
	                <w:color w:val="FFFFFF"/>
	                <w:sz w:val="2"/>
	                <w:sz-cs w:val="28"/>
	            </w:rPr>
	        </w:style>
	        <w:style w:type="character" w:styleId="lSubclass">
	            <w:name w:val="lSubclass"/>
	            <w:basedOn w:val="tSubclass"/>
	            <w:rsid w:val="00A85C47"/>
	            <w:rPr>
	                <w:color w:val="FFFFFF"/>
	                <w:sz w:val="2"/>
	                <w:sz-cs w:val="28"/>
	            </w:rPr>
	        </w:style>-->
	        <w:style w:type="paragraph" w:styleId="tSubclass">
	            <w:name w:val="tSubclass"/>
	            <w:basedOn w:val="tSubclassBookmark"/>
	            <w:rsid w:val="00A85C47"/>
	            <w:rPr>
					<w:keepNext/>
	                <w:color w:val="FFFFFF"/>
	                <w:sz w:val="2"/>
	                <w:sz-cs w:val="28"/>
	            </w:rPr>
	        </w:style>
	        <w:style w:type="paragraph" w:styleId="lSubclass">
	            <w:name w:val="lSubclass"/>
	            <w:basedOn w:val="tSubclass"/>
	            <w:rsid w:val="00A85C47"/>
	            <w:rPr>
					<w:keepNext/>
	                <w:color w:val="FFFFFF"/>
	                <w:sz w:val="2"/>
	                <w:sz-cs w:val="28"/>
	            </w:rPr>
	        </w:style>
		</w:styles>
	</xsl:template>
	
	<xsl:template name="docPr">
		<w:docPr>
			<w:view w:val="print"/>
			<w:zoom w:percent="120"/>
			<w:attachedTemplate w:val="C:\ipc7\ipc7pubE.dot"/>
			<w:linkStyles/>
			<w:defaultTabStop w:val="720"/>
			<w:evenAndOddHeaders/>
			<w:displayHorizontalDrawingGridEvery w:val="0"/>
			<w:displayVerticalDrawingGridEvery w:val="0"/>
			<w:useMarginsForDrawingGridOrigin/>
			<w:characterSpacingControl w:val="DontCompress"/>
			<w:optimizeForBrowser/>
			<w:validateAgainstSchema/>
			<w:saveInvalidXML w:val="off"/>
			<w:ignoreMixedContent w:val="off"/>
			<w:alwaysShowPlaceholderText w:val="off"/>
			<w:footnotePr>
				<w:footnote w:type="separator">
					<w:p>
						<w:r>
							<w:separator/>
						</w:r>
					</w:p>
				</w:footnote>
				<w:footnote w:type="continuation-separator">
					<w:p>
						<w:r>
							<w:continuationSeparator/>
						</w:r>
					</w:p>
				</w:footnote>
			</w:footnotePr>
			<w:endnotePr>
				<w:endnote w:type="separator">
					<w:p>
						<w:r>
							<w:separator/>
						</w:r>
					</w:p>
				</w:endnote>
				<w:endnote w:type="continuation-separator">
					<w:p>
						<w:r>
							<w:continuationSeparator/>
						</w:r>
					</w:p>
				</w:endnote>
			</w:endnotePr>
			<w:compat>
				<w:footnoteLayoutLikeWW8/>
				<w:shapeLayoutLikeWW8/>
				<w:alignTablesRowByRow/>
				<w:forgetLastTabAlignment/>
				<w:doNotUseHTMLParagraphAutoSpacing/>
				<w:layoutRawTableWidth/>
				<w:layoutTableRowsApart/>
				<w:useWord97LineBreakingRules/>
				<w:dontAllowFieldEndSelect/>
				<w:useWord2002TableStyleRules/>
			</w:compat>
		</w:docPr>
	</xsl:template>

	<xsl:template name="headerForSubclass_bak">
		<xsl:variable name="thissym" select="@symbol"/>
		<xsl:variable name="prevsym" select="script:getPrevSym(string(@symbol))"/>
        <w:p>
            <w:pPr>
                <w:pStyle w:val="headerreference"/>
            </w:pPr>
            <w:r>
                <w:rPr>
                    <w:rStyle w:val="lSubclassBookmark"/>
                </w:rPr>
                <w:t><xsl:value-of select="$prevsym"/></w:t>
            </w:r>
            <w:r>
                <w:t>
                </w:t>
            </w:r>
            <w:r>
                <w:rPr>
                    <w:rStyle w:val="tSubclassBookmark"/>
                </w:rPr>
                <w:t><xsl:value-of select="$thissym"/></w:t>
            </w:r>
            <w:r>
                <w:t>
                </w:t>
            </w:r>
            <w:r>
                <w:rPr>
                    <w:rStyle w:val="tSubclass"/>
                </w:rPr>
                <w:t><xsl:call-template name="translateref">
					<xsl:with-param name="ref" select="$thissym"/>
					<xsl:with-param name="simple" select="1"/>
				</xsl:call-template></w:t>
            </w:r>
            <w:r>
                <w:t>
                </w:t>
            </w:r>
            <w:r>
                <w:rPr>
                    <w:rStyle w:val="lSubclass"/>
                </w:rPr>
                <w:t><xsl:call-template name="translateref">
					<xsl:with-param name="ref" select="$prevsym"/>
					<xsl:with-param name="simple" select="1"/>
				</xsl:call-template></w:t>
            </w:r>
        </w:p>
<!--        <w:p>
            <w:pPr>
                <w:pStyle w:val="subclass"/>
            </w:pPr>
            <w:r>
                <w:br w:type="page"/>
            </w:r>
        </w:p>-->
		<!-- 20050419 TA headerFooter was split from here as separate function -->
	</xsl:template>

	<xsl:template name="headerForSubclass">
<!--		<xsl:variable name="thissym">
			<xsl:choose>
				<xsl:when test="substring(@symbol, 5)='0000000000'"><xsl:value-of select="substring(@symbol,1,4)"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@symbol"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>-->
		<xsl:variable name="thissym" select="@symbol"/>
		<xsl:variable name="prevsym" select="script:getPrevSym(string(@symbol))"/>
 		<w:p>
            <w:pPr>
                <w:pStyle w:val="lSubclassBookmark"/>
            </w:pPr>
            <w:r>
                <w:t><w:t><xsl:value-of select="$prevsym"/></w:t></w:t>
            </w:r>
        </w:p>
        <w:p>
            <w:pPr>
                <w:pStyle w:val="tSubclassBookmark"/>
            </w:pPr>
            <w:r>
                <w:t><xsl:value-of select="$thissym"/></w:t>
            </w:r>
        </w:p>
        <w:p>
            <w:pPr>
                <w:pStyle w:val="tSubclass"/>
            </w:pPr>
            <w:r>
                <w:t><xsl:call-template name="translateref">
					<xsl:with-param name="ref" select="$thissym"/>
					<xsl:with-param name="simple" select="1"/>
				</xsl:call-template></w:t>
            </w:r>
        </w:p>
        <w:p>
            <w:pPr>
                <w:pStyle w:val="lSubclass"/>
            </w:pPr>
            <w:r>
                <w:t><xsl:call-template name="translateref">
					<xsl:with-param name="ref" select="$prevsym"/>
					<xsl:with-param name="simple" select="1"/>
				</xsl:call-template></w:t>
            </w:r>
        </w:p>
        <w:p>
            <w:pPr>
                <w:pStyle w:val="headerreference"/>
            </w:pPr>
        </w:p>
	</xsl:template>

	<!-- 20050419 TA parameter 'first' added -->
	<xsl:template name="headerFooter">
		<xsl:param name="edition"/>
		<xsl:param name="year"/>
		<xsl:param name="section"/>
		<xsl:param name="volume"/>
		<xsl:param name="advfooter" select="1"/>
		<xsl:param name="first" select="'0'"/>
			<xsl:choose>
			<xsl:when test="$first='1'">
		        <w:p>
		            <w:pPr>
				        <w:sectPr>
				            <w:hdr w:type="even">
				                <w:p>
				                    <w:pPr>
				                        <w:pStyle w:val="Header"/>
				                    </w:pPr>
									<xsl:call-template name="headerFooterOddEven"/> <!-- 20050419 TA split, to ensure Odd=Even -->
								</w:p>
				            </w:hdr>
				            <w:hdr w:type="odd">
				                <w:p>
				                    <w:pPr>
				                        <w:pStyle w:val="Header"/>
				                        <w:jc w:val="right"/>
				                    </w:pPr>
									<xsl:call-template name="headerFooterOddEven"/>
								</w:p>
							</w:hdr>
							<!-- Int.Cl. (2006.01) , Section A -->
							<!-- Int.Cl. (2006.01), Section A -->
							<w:ftr w:type="even">
								<w:p>
									<w:pPr>
										<w:pStyle w:val="Footer"/>
									</w:pPr>
									<w:r>
										<w:rPr>
											<w:b/>
										</w:rPr>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
										</w:rPr>
										<w:instrText> PAGE </w:instrText>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
										</w:rPr>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
											<w:noProof/>
										</w:rPr>
										<w:t>8</w:t>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
										</w:rPr>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
									<w:r>
										<w:tab wx:wTab="7155" wx:tlc="none" wx:cTlc="158"/>
										<!-- <w:t><xsl:call-template name="translate"><xsl:with-param name="id" select="'int_cl'"/></xsl:call-template></w:t> -->
									</w:r>
<!--									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:instrText> SUBJECT </w:instrText>
									</w:r>
									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:t><xsl:value-of select="$edition"/></w:t>
									</w:r>
									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:fldChar w:fldCharType="end"/>
									</w:r>-->
									<w:r>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:instrText> SUBJECT </w:instrText>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
									<w:r>
										<w:t> (</w:t>
									</w:r>

<!--
									<w:r>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:instrText> SUBJECT </w:instrText>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
-->									
									<w:r>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:instrText> KEYWORDS </w:instrText>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
<!--									<w:r>
										<w:t>th edition, <xsl:value-of select="$year"/></w:t>
									</w:r>-->
									<w:r>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
									<w:r>
										<w:t>)</w:t>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:instrText> COMMENTS </w:instrText>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
<!--									<w:r>
										<xsl:choose>
											<xsl:when test="$advfooter=1">
												<w:t>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'Section'"/></xsl:call-template><xsl:value-of select="$section"/></w:t>
											</xsl:when>
											<xsl:otherwise>
												<w:t>Vol. <xsl:value-of select="$volume"/>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'Section'"/></xsl:call-template><xsl:value-of select="$section"/></w:t>
											</xsl:otherwise>
										</xsl:choose>
									</w:r>-->
									<w:r>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
								</w:p>
							</w:ftr>
							<w:ftr w:type="odd">
								<w:p>
									<w:pPr>
										<w:pStyle w:val="Footer"/>
									</w:pPr>
									<!--
									<w:r>
										 <w:t><xsl:call-template name="translate"><xsl:with-param name="id" select="'int_cl'"/></xsl:call-template></w:t> 
										
									</w:r>
									-->
<!--									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:instrText> SUBJECT </w:instrText>
									</w:r>
									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:t><xsl:value-of select="$edition"/></w:t>
									</w:r>
									<w:r>
										<w:rPr>
											<w:vertAlign w:val="superscript"/>
										</w:rPr>
										<w:fldChar w:fldCharType="end"/>
									</w:r>-->
									<w:r>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:instrText> SUBJECT </w:instrText>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
									<w:r>
										<w:t> (</w:t>
									</w:r>
<!--									
									<w:r>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:instrText> SUBJECT </w:instrText>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
-->									
<!--									<w:r>
										<xsl:choose>
											<xsl:when test="$advfooter=1">
												<w:t><xsl:value-of select="concat(substring($edition,1,4),'.',substring($edition,5,2))"/></w:t>
											</xsl:when>
											<xsl:otherwise>
												<w:t><xsl:value-of select="concat(substring($edition,1,4),'.',substring($edition,5,2),'.',substring($edition,7,2))"/>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'level_adv'"/></xsl:call-template></w:t>
											</xsl:otherwise>
										</xsl:choose>
									</w:r>
-->									
<!--									
									<w:r>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
-->									
									<w:r>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:instrText> KEYWORDS </w:instrText>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
<!--									<w:r>
										<w:t>th edition, <xsl:value-of select="$year"/></w:t>
									</w:r>-->
									<w:r>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
									<w:r>
										<w:t>)</w:t>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:instrText> COMMENTS </w:instrText>
									</w:r>
									<w:r>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
<!--									<w:r>
										<xsl:choose>
											<xsl:when test="$advfooter=1">
												<w:t>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'Section'"/></xsl:call-template><xsl:value-of select="$section"/></w:t>
											</xsl:when>
											<xsl:otherwise>
												<w:t>Vol. <xsl:value-of select="$volume"/>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'Section'"/></xsl:call-template><xsl:value-of select="$section"/></w:t>
											</xsl:otherwise>
										</xsl:choose>
									</w:r>
-->									<w:r>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
									<w:r>
										<w:tab wx:wTab="7065" wx:tlc="none" wx:cTlc="156"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
										</w:rPr>
										<w:fldChar w:fldCharType="begin"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
										</w:rPr>
										<w:instrText> PAGE </w:instrText>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
										</w:rPr>
										<w:fldChar w:fldCharType="separate"/>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
											<w:noProof/>
										</w:rPr>
										<w:t>77</w:t>
									</w:r>
									<w:r>
										<w:rPr>
											<w:b/>
										</w:rPr>
										<w:fldChar w:fldCharType="end"/>
									</w:r>
								</w:p>
							</w:ftr>
				            <w:hdr w:type="first">
				                <w:p>
				                    <w:pPr>
				                        <w:pStyle w:val="Header"/>
				                    </w:pPr>
				                </w:p>
				            </w:hdr>
				            <w:ftr w:type="first">
				                <w:p>
				                    <w:pPr>
				                        <w:pStyle w:val="Footer"/>
				                    </w:pPr>
				                </w:p>
				            </w:ftr>
					            <w:type w:val="continuous"/>
					            <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
					            <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
					            <w:cols w:space="720"/>
				        </w:sectPr>
					</w:pPr>
				</w:p>
			</xsl:when>
			<xsl:otherwise>
		        <w:p>
		            <w:pPr>
				        <w:sectPr>
<!--				            <w:hdr w:type="even">
				            </w:hdr>
				            <w:hdr w:type="odd">
				            </w:hdr>
				            <w:ftr w:type="even">
				                <w:p>
				                    <w:pPr>
				                        <w:pStyle w:val="Footer"/>
				                    </w:pPr>
				                </w:p>
				            </w:ftr>
				            <w:ftr w:type="odd">
				                <w:p>
				                    <w:pPr>
				                        <w:pStyle w:val="Footer"/>
				                    </w:pPr>
				                </w:p>
				            </w:ftr>
				            <w:hdr w:type="first">
				                <w:p>
				                    <w:pPr>
				                        <w:pStyle w:val="Header"/>
				                    </w:pPr>
				                </w:p>
				            </w:hdr>
				            <w:ftr w:type="first">
				                <w:p>
				                    <w:pPr>
				                        <w:pStyle w:val="Footer"/>
				                    </w:pPr>
				                </w:p>
				            </w:ftr>-->
				            <w:type w:val="continuous"/>
				            <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
				            <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
				            <w:cols w:space="720"/>
				        </w:sectPr>
					</w:pPr>
				</w:p>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="headerFooterOddEven">
		<w:r>
			<w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> If </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> Pageref </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> quote </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref lSubclassBookmark </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01Z</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>_l </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01Z</w:instrText>
        </w:r>
        <w:r>
            <w:instrText>_l</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:b w:val="off"/>
                <w:b-cs/>
                <w:noProof/>
            </w:rPr>
            <w:instrText>Error! Bookmark not defined.</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText> &lt;&gt; </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> page </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>2</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText><xsl:text> </xsl:text><!-- 20050419 TA ' ' must be added here! -->
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> If </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> Pageref </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref tSubclassBookmark </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:b w:val="off"/>
                <w:b-cs/>
                <w:noProof/>
            </w:rPr>
            <w:instrText>Error! Bookmark not defined.</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText> = </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> page </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>2</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText><xsl:text> </xsl:text><!-- 20050419 TA ' ' must be added here! -->
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> if "</w:instrText><xsl:text> </xsl:text><!-- 20050419 TA '" must be added here! -->
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref tSubclassBookmark </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>" = "</w:instrText><xsl:text> </xsl:text><!-- 20050419 TA '" must be added here -->
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText>  styleref tSubclassBookmark \l </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>"<xsl:text> </xsl:text><!-- 20050419 TA " and ' ' must be added here! -->
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> quote </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref tSubclass </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText><xsl:text> </xsl:text><!-- 20050419 TA ' ' must be added here! -->
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> quote </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref tSubclass </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText> – </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref tSubclass \l </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01B</w:instrText>
        </w:r>
        <w:r>
            <w:instrText> – </w:instrText>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref tSubclass </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText><xsl:text> </xsl:text><!-- 20050419 TA ' ' must be added here! -->
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> quote </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref lSubclass </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 B</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText><xsl:text> </xsl:text><!-- 20050419 TA ' ' must be added here! -->
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> if </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> Pageref </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> Styleref tSubclassBookmark </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A01C</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>3</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText> = </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> page </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>3</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText><xsl:text> </xsl:text><!-- 20050419 TA ' ' must be added here! -->
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> quote   – </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="begin"/>
        </w:r>
        <w:r>
            <w:instrText> styleref tSubclass \l </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 C</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:instrText> – </w:instrText>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 C</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText> "" </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>–A 01 C</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="separate"/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:noProof/>
            </w:rPr>
            <w:instrText>A 01 B–A 01 C</w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
        <w:r>
            <w:instrText>
            </w:instrText>
        </w:r>
        <w:r>
            <w:fldChar w:fldCharType="end"/>
        </w:r>
	</xsl:template>
</xsl:stylesheet>

<!-- Stylus Studio meta-information - (c) 2004-2005. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario2" userelativepaths="yes" externalpreview="no" url="file:///z:/temp/class&#x2D;EN/xml/b.xml" htmlbaseurl="" outputurl="" processortype="msxml4" useresolver="no" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="no" validator="internal" customvalidator=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition><TemplateContext></TemplateContext><MapperFilter side="source"></MapperFilter></MapperMetaTag>
</metaInformation>
-->