<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w10="urn:schemas-microsoft-com:office:word"
                xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core" xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:o="urn:schemas-microsoft-com:office:office"
                xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:var="var">

	<xsl:param name="advfooter" select="1"/>

	<xsl:output method="xml" indent="no" encoding="utf-8"/> <!-- 20150916 TA Method XML -->

<!--	<xsl:variable name="edition" select="8"/>-->
	<xsl:variable name="fulledition" select="substring-after(//ipcEntries/@displayMode, 'e')"/>
	<xsl:variable name="edition">
		<xsl:choose>
			<xsl:when test="$fulledition='20090101'">9</xsl:when>
			<xsl:when test="$fulledition='20060101'">8</xsl:when>
			<xsl:when test="$fulledition='20000101'">7</xsl:when>
			<xsl:when test="$fulledition='19950101'">6</xsl:when>
			<xsl:when test="$fulledition='19900101'">5</xsl:when>
			<xsl:when test="$fulledition='19850101'">4</xsl:when>
			<xsl:when test="$fulledition='19800101'">3</xsl:when>
			<xsl:when test="$fulledition='19740701'">2</xsl:when>
			<xsl:when test="$fulledition='19680901'">1</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="year" select="substring($fulledition,1,4)"/>
	<xsl:variable name="level" select="/ipcEntries/@level"/>
	<xsl:variable name="section" select="//ipcEntry[@kind='s']/@symbol"/>
	<xsl:variable name="volume" select="translate($section, 'ABCDEFGH', '11223344')"/>
	<!-- 20150915 TA -->
	<xsl:variable name="lang">
		<xsl:choose>
		<xsl:when test="/ipcEntries/@lang"><xsl:value-of select="ipcEntries/@lang"/></xsl:when>
	 	<xsl:otherwise>
	 		<xsl:value-of select="//ipcEntry[@kind='s']/@lang"/>
	 	</xsl:otherwise>
	 	</xsl:choose>
	</xsl:variable>
	<!-- 20150915 TA -->
	<xsl:variable name="LANG" select="translate($lang,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	<xsl:variable name="fixedTextFile" select="concat($LANG,'_ipc_fixed_texts.xml')"/>
	
	<xsl:include href="lang.xsl"/>
	<xsl:include href="wxml-header.xsl"/>

	
	<xsl:variable name="figs" select="document('figs.xml')/figs"/>
	<xsl:variable name="firstfig" select="//img[1]/@src"/>

	<msxsl:script language="JScript" implements-prefix="var"><![CDATA[

  var variables = new Array();

  var debugCreated=0;

  function getVar(name) // 20150915 TA new javascript syntax
  {
    var val = variables[name];
    return (val == null) ? "" : val;
  }

  function setVar(name,value)  // 20150915 TA new javascript syntax
  {
    variables[name] = value;
    return "";
  }
  function print(s)
	{
      var objFSO;
      objFSO = new ActiveXObject("Scripting.FileSystemObject");
      var ts;
      if( debugCreated ){
        ts = objFSO.OpenTextFile("c:\\temp\\debug.log",8);
      }else{
        ts = objFSO.CreateTextFile("c:\\temp\\debug.log",true);
        debugCreated=1;
      }
      ts.Write(s+"\n");
      ts.Close();
			return "";
  }
]]>
	</msxsl:script>


	<xsl:template match="/">
		<xsl:apply-templates select="//ipcEntry[@kind='c'][1]"/>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='c']">
		<xsl:text disable-output-escaping="yes">&lt;?</xsl:text>mso-application progid="Word.Document"<xsl:text disable-output-escaping="yes">?&gt;</xsl:text>
		<!--
		<w:wordDocument xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core"
		                xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882"
		                xml:space="preserve">
		 -->
		<w:wordDocument xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core"
		                xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882"
		                xml:space="preserve"
		                w:macrosPresent="no"
		                w:embeddedObjPresent="no"
		                w:ocxPresent="no"
			>
			<!-- DEBUG
		<xsl:attribute name="w:macrosPresent">no</xsl:attribute>
		<xsl:attribute name="w:embeddedObjPresent">no</xsl:attribute>
		<xsl:attribute name="w:ocxPresent">no</xsl:attribute>
-->
		<xsl:call-template name="DocumentProperties">
			<xsl:with-param name="lang"><xsl:value-of select="$lang"/></xsl:with-param>
			<xsl:with-param name="level" select="$level"/>
			<xsl:with-param name="smallEdition"><xsl:value-of select="$edition"/></xsl:with-param>
			<xsl:with-param name="edition"><xsl:value-of select="$fulledition"/></xsl:with-param>
			<xsl:with-param name="volume"><xsl:value-of select="$volume"/></xsl:with-param>
			<xsl:with-param name="year"><xsl:value-of select="$year"/></xsl:with-param>
			<xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
			<xsl:with-param name="class"><xsl:value-of select="@symbol"/></xsl:with-param>
			<xsl:with-param name="classTitle"></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="CustomDocumentProperties"/>
		<xsl:call-template name="fonts"/>
		<xsl:call-template name="styles"/>
		<xsl:call-template name="docPr"/>
		<xsl:call-template name="body"/>


		</w:wordDocument>
	</xsl:template>

	<xsl:template name="body">
		<w:body>
			<!-- 20070228 TA added to provide SECTION for 01 classes -->
			
			<xsl:if test="(/ipcEntries[@splitLevel='class'] and substring(@symbol,2,2)='01') or /ipcEntries[@splitLevel='subclass']">
			<!-- 20151002 come over issues in C02 in subclass splitting <xsl:if test="substring(@symbol,2,2)='01'"> -->
				<wx:sect>
					<xsl:variable name="sectionEntry" select="//ipcEntry[@kind='s']"/>
			        <w:p>
			            <w:pPr>
			                <w:pStyle w:val="section"/>
							<w:spacing w:before="0"/>
							<w:pageBreakBefore w:val="off"/>
			            </w:pPr>
			            <w:r>
							<w:rPr><w:caps/></w:rPr>
			            	<w:t><xsl:variable name="sectionCaption"><xsl:call-template name="translate"><xsl:with-param name="id" select="'section'"/></xsl:call-template></xsl:variable><xsl:if test="not(contains(normalize-space($sectionEntry/textBody),$sectionCaption))"><xsl:value-of select="concat($sectionCaption,' ',$sectionEntry/@symbol,' ','&#8212;',' ')"/></xsl:if><xsl:apply-templates select="$sectionEntry/textBody/title" mode="textonly"/></w:t>
			            </w:r>
			        </w:p>
			<xsl:call-template name="headerFooter">
				<xsl:with-param name="first" select="1"/>
				<xsl:with-param name="edition" select="$fulledition"/>
				<xsl:with-param name="year" select="$year"/>
				<xsl:with-param name="section" select="$section"/>
				<xsl:with-param name="volume" select="$volume"/>
				<xsl:with-param name="advfooter" select="$advfooter"/>
				<xsl:with-param name="level" select="/ipcEntries/@level"/>
			</xsl:call-template>
				</wx:sect>
			</xsl:if>

			<xsl:variable name="sectionSymbol" select="substring(@symbol,1,1)"/>
			<xsl:if test="//ipcEntry[@kind = 's']/following-sibling::ipcEntry[@kind='n'] and substring(@symbol,2,2)='01'"> <!-- 20151002 TA added to provide SECTION note only to 01 classes -->
				<wx:sect>
					<xsl:apply-templates select="//ipcEntry[@kind = 's']/following-sibling::ipcEntry[@kind='n' and @symbol=$sectionSymbol]"/>
					<w:p><w:pPr>
			                <w:pStyle w:val="Normal"/>
			               </w:pPr>
			            <w:r></w:r>
			        </w:p>
					<!-- 20070228 TA 'and ... added into condition -->
					<xsl:call-template name="headerFooter">
						<xsl:with-param name="first" select="1"/>
						<xsl:with-param name="edition" select="$fulledition"/>
						<xsl:with-param name="year" select="$year"/>
						<xsl:with-param name="section" select="$section"/>
						<xsl:with-param name="volume" select="$volume"/>
						<xsl:with-param name="advfooter" select="$advfooter"/>
					</xsl:call-template>
				</wx:sect>
			</xsl:if>
			<xsl:call-template name="classSection"/>
			<xsl:for-each select="../ipcEntry[@kind='u']">
				<xsl:value-of select="var:setVar('subc',string(@symbol))"/>
				<xsl:call-template name="subclassSection"/>
			</xsl:for-each>
			<xsl:for-each select="ipcEntry[@kind='u']">
				<xsl:value-of select="var:setVar('subc',string(@symbol))"/>
				<xsl:call-template name="subclassSection"/>
			</xsl:for-each>
			<wx:sect>
				<w:p>
					<w:pPr>
						<w:pStyle w:val="tocsubclass"/>
						<w:sectPr>
							<w:type w:val="continuous"/>
							<w:pgSz w:w="11907" w:h="16840" w:code="9"/>
							<w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
							<w:cols w:space="720"/>
						</w:sectPr>
					</w:pPr>
				</w:p>
			</wx:sect>
			<wx:sect>
				<w:p>
					<w:pPr>
						<w:pStyle w:val="tocsubclass"/>
					</w:pPr>
				</w:p>
				<w:sectPr>
					<w:type w:val="continuous"/>
					<w:pgSz w:w="11907" w:h="16840" w:code="9"/>
					<w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
					<w:cols w:space="720"/>
				</w:sectPr>
			</wx:sect>
		</w:body>
	</xsl:template>

	<xsl:template name="classSection">
		<wx:sect>
			<xsl:call-template name="classOrSubclassEntry"/>
			<xsl:call-template name="headerFooter">
				<xsl:with-param name="first" select="1"/>
				<xsl:with-param name="edition" select="$fulledition"/>
				<xsl:with-param name="year" select="$year"/>
				<xsl:with-param name="section" select="$section"/>
				<xsl:with-param name="volume" select="$volume"/>
				<xsl:with-param name="advfooter" select="$advfooter"/>
			</xsl:call-template>
		</wx:sect>
	</xsl:template>

	<xsl:template match="u">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
		<w:r>
		    <w:rPr>
				<xsl:if test="name(..) = 'entryReference'">
					<w:b w:val="off"/>
				</xsl:if>
		        <w:u w:val="single"/>
		    </w:rPr>
		    <w:t><!--[[<xsl:value-of select="name(..)"/>]]--><xsl:apply-templates/></w:t>
		</w:r>
		<xsl:text disable-output-escaping="yes">&lt;w:r&gt;</xsl:text>
	        <w:rPr>
				<w:u w:val="off"/>
				<xsl:if test="name(..) = 'entryReference'">
					<w:b w:val="off"/>
				</xsl:if>
	        </w:rPr>
		<xsl:text disable-output-escaping="yes">&lt;w:t&gt;</xsl:text>
	</xsl:template>

	<xsl:template match="fig">
		<xsl:choose>
			<xsl:when test="parent::fig">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
			    <w:r>
			        <w:rPr>
			            <w:rFonts w:ascii="Arial" w:h-ansi="Arial"/>
						<w:b w:val="off"/>
			            <wx:font wx:val="Arial"/>
			            <w:sz w:val="20"/>
			        </w:rPr>
			        <w:t><xsl:apply-templates/></w:t>
				</w:r>
				<xsl:call-template name="closeBlock"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="closeBlock">
		<xsl:text disable-output-escaping="yes">&lt;w:r&gt;</xsl:text>
	        <w:rPr>
				<w:u w:val="off"/>
				<xsl:if test="name(..) = 'entryReference'">
					<w:b w:val="off"/>
				</xsl:if>
	        </w:rPr>
		<xsl:text disable-output-escaping="yes">&lt;w:t&gt;</xsl:text>
	</xsl:template>

	<xsl:template match="sub">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
	    <w:r>
	        <w:rPr>
	            <w:rFonts w:ascii="Arial" w:h-ansi="Arial"/>
				<w:b w:val="off"/>
	            <wx:font wx:val="Arial"/>
	            <w:position w:val="-4"/>
	            <w:sz w:val="14"/>
	        </w:rPr>
	        <w:t><xsl:apply-templates/></w:t>
	    </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="llinkt|img[@src='llinkt.gif']">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
        <w:r>
            <w:rPr>
                <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
				<w:b w:val="off"/>
                <wx:font wx:val="Symbol"/>
                <wx:sym wx:font="Symbol" wx:char="F0F1"/>
                <w:position w:val="2"/>
                <w:sz w:val="20"/>
            </w:rPr>
            <w:t>&#241;</w:t>
        </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="rlinkt|img[@src='rlinkt.gif']">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
        <w:r>
            <w:rPr>
                <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
				<w:b w:val="off"/>
                <wx:font wx:val="Symbol"/>
                <wx:sym wx:font="Symbol" wx:char="F0F1"/>
                <w:position w:val="2"/>
                <w:sz w:val="20"/>
            </w:rPr>
            <w:t>&#225;</w:t>
        </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="tbond">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
        <w:r>
            <w:rPr>
                <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
				<w:b w:val="off"/>
                <wx:font wx:val="Symbol"/>
                <wx:sym wx:font="Symbol" wx:char="F0BA"/>
                <w:position w:val="2"/>
                <w:sz w:val="20"/>
            </w:rPr>
            <w:t>&#186;</w:t>
        </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="dbond">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
        <w:r>
            <w:rPr>
                <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
				<w:b w:val="off"/>
                <wx:font wx:val="Symbol"/>
                <wx:sym wx:font="Symbol" wx:char="F0BA"/>
                <w:position w:val="2"/>
                <w:sz w:val="20"/>
            </w:rPr>
            <w:t>=</w:t>
        </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="emdash">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
		<w:r>
            <w:rPr>
                <w:rFonts w:ascii="Arial" w:h-ansi="Arial"/>
				<w:b w:val="off"/>
                <wx:font wx:val="Arial"/>
                <w:spacing w:val="-40"/>
                <w:position w:val="2"/>
                <w:sz w:val="20"/>
            </w:rPr>
            <w:noBreakHyphen/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:rFonts w:ascii="Arial" w:h-ansi="Arial"/>
				<w:b w:val="off"/>
                <wx:font wx:val="Arial"/>
                <w:spacing w:val="-40"/>
                <w:position w:val="2"/>
                <w:sz w:val="20"/>
            </w:rPr>
            <w:noBreakHyphen/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:rFonts w:ascii="Arial" w:h-ansi="Arial"/>
				<w:b w:val="off"/>
                <wx:font wx:val="Arial"/>
                <w:spacing w:val="-40"/>
                <w:position w:val="2"/>
                <w:sz w:val="20"/>
            </w:rPr>
            <w:noBreakHyphen/>
        </w:r>
		<w:r>
			<w:t><xsl:call-template name="nbsp"/></w:t>
		</w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="endash">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
			<w:r>
	            <w:rPr>
	                <w:spacing w:val="-40"/>
	                <w:position w:val="2"/>
	            </w:rPr>
	            <w:noBreakHyphen/>
	        </w:r>
	        <w:r>
	            <w:rPr>
	                <w:spacing w:val="-40"/>
	                <w:position w:val="2"/>
	            </w:rPr>
	            <w:noBreakHyphen/>
	        </w:r>
	        <w:r>
	            <w:rPr>
	                <w:spacing w:val="-40"/>
	                <w:position w:val="2"/>
	            </w:rPr>
	            <w:noBreakHyphen/>
	        </w:r>
			<w:r>
				<w:t><xsl:call-template name="nbsp"/></w:t>
			</w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="ge">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
			<w:r>
                <w:rPr>
                    <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
                    <wx:font wx:val="Symbol"/>
                    <wx:sym wx:font="Symbol" wx:char="F0B3"/>
                    <w:position w:val="2"/>
                </w:rPr>
                <w:t>³</w:t>
            </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="rarrow">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
			<w:r>
                <w:rPr>
                    <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
                    <wx:font wx:val="Symbol"/>
                    <wx:sym wx:font="Symbol" wx:char="F0AE"/>
                    <w:b w:val="off"/>
                    <w:position w:val="2"/>
                    <w:sz w:val="20"/>
                </w:rPr>
                <w:t>®</w:t>
            </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="larrow">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
			<w:r>
                <w:rPr>
                    <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
                    <wx:font wx:val="Symbol"/>
                    <wx:sym wx:font="Symbol" wx:char="F0AC"/>
                    <w:b w:val="off"/>
                    <w:position w:val="2"/>
                    <w:sz w:val="20"/>
                </w:rPr>
                <w:t>¬</w:t>
            </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="beta">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
			<w:r>
                <w:rPr>
                    <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
                    <wx:font wx:val="Symbol"/>
                    <wx:sym wx:font="Symbol" wx:char="F062"/>
                    <w:b w:val="off"/>
                    <w:position w:val="2"/>
                </w:rPr>
                <w:t>b</w:t>
            </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="llinkthree|img[@src='llinkthree.gif']">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
<!--            <w:r>
                <w:rPr>
                    <w:rFonts w:ascii="Arial" w:h-ansi="Arial"/>
                    <wx:font wx:val="Arial"/>
                    <w:spacing w:val="-80"/>
                    <w:sz w:val="20"/>
                </w:rPr>
                <w:noBreakHyphen/>
            </w:r>
            <w:r>
                <w:rPr>
                    <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
                    <wx:font wx:val="Symbol"/>
                    <wx:sym wx:font="Symbol" wx:char="F0F1"/>
                    <w:spacing w:val="-80"/>
                    <w:sz w:val="20"/>
                </w:rPr>
                <w:t>ñ</w:t>
            </w:r>-->
            <w:r>
                <w:rPr>
                    <w:spacing w:val="-120"/>
                    <w:position w:val="1"/>
                    <w:sz-cs w:val="18"/>
                </w:rPr>
                <w:noBreakHyphen/>
            </w:r>
            <w:r>
                <w:rPr>
                    <w:rFonts w:ascii="Symbol" w:h-ansi="Symbol"/>
                    <wx:font wx:val="Symbol"/>
                    <wx:sym wx:font="Symbol" wx:char="F0F1"/>
                    <w:sz w:val="20"/>
                </w:rPr>
                <w:t>ñ</w:t>
            </w:r>
		<xsl:call-template name="closeBlock"/>
	</xsl:template>

	<xsl:template match="degree">
		<xsl:text>°</xsl:text>
	</xsl:template>

	<xsl:template match="oe">
		<xsl:text>œ</xsl:text>
	</xsl:template>

	<xsl:template match="OE">
		<xsl:text>Œ</xsl:text>
	</xsl:template>

	<xsl:template name="subclassSection">
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<wx:sect>
			<xsl:if test="position() != 1">
				<wx:pBdrGroup>
	                <wx:borders>
	                    <wx:bottom wx:val="solid" wx:bdrwidth="10" wx:space="1" wx:color="auto"/>
	                </wx:borders>
	                <w:p>
	                    <w:pPr>
	                        <w:pStyle w:val="line"/>
							<!-- <w:spacing w:before="0" w:after="0"/> -->
	                    </w:pPr>
	                    <aml:annotation aml:id="248" w:type="Word.Bookmark.Start" w:name="{$bookmark}_ESL"/>
	                    <aml:annotation aml:id="248" w:type="Word.Bookmark.End"/>
	                </w:p>
	            </wx:pBdrGroup>
			</xsl:if>
			<xsl:call-template name="headerForSubclass"/>
			<xsl:call-template name="classOrSubclassEntry"/>
			<xsl:call-template name="headerFooter"/>
		</wx:sect>
	</xsl:template>


	<xsl:template name="headerForSubclass-old"> <!-- 20050419 TA name changed -->
		<xsl:variable name="class">
			<xsl:value-of select="substring(@symbol,1,1)"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="substring(@symbol,2,2)"/>
		</xsl:variable>
		<xsl:variable name="actualSubclassChar">
			<xsl:value-of select="substring(@symbol,4,1)"/>
			<xsl:text> </xsl:text>
		</xsl:variable>
		<xsl:variable name="previousSubclassSymbol">
			<xsl:choose>
				<xsl:when test="preceding-sibling::ipcEntry[@kind='u'][1]">
					<xsl:value-of select="preceding-sibling::ipcEntry[@kind='s'][1]/@symbol"/>
				</xsl:when>
				<xsl:otherwise>XXXX</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="previousPreviousSubclassSymbol">
			<xsl:choose>
				<xsl:when test="preceding-sibling::ipcEntry[@kind='u'][2]">
					<xsl:value-of select="preceding-sibling::ipcEntry[@kind='s'][2]/@symbol"/>
				</xsl:when>
				<xsl:otherwise>XXXX</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="previousSubclassPage">
			<xsl:choose>
				<xsl:when test="$previousSubclassSymbol='XXXX'">-1</xsl:when>
				<xsl:otherwise>?</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="previousPreviousSubclassPage">
			<xsl:choose>
				<xsl:when test="$previousPreviousSubclassSymbol='XXXX'">-1</xsl:when>
				<xsl:otherwise>?</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<w:p>
			<w:pPr>
				<w:pStyle w:val="headerreference"/>
			</w:pPr>
			<w:r>
				<w:rPr>
					<w:rStyle w:val="ppspage"/>
				</w:rPr>
				<w:t>
					<xsl:value-of select="$previousPreviousSubclassPage"/>
					<xsl:text> </xsl:text>
				</w:t>
			</w:r>
			<w:r>
				<w:rPr>
					<w:rStyle w:val="pspage"/>
				</w:rPr>
				<w:t>
					<xsl:value-of select="$previousSubclassPage"/>
					<xsl:text> </xsl:text>
				</w:t>
			</w:r>
			<w:r>
				<w:rPr>
					<w:rStyle w:val="ppschar"/>
				</w:rPr>
				<w:t>
					<xsl:value-of select="substring($previousPreviousSubclassSymbol,4,1)"/>
					<xsl:text> </xsl:text>
				</w:t>
			</w:r>
			<w:r>
				<w:rPr>
					<w:rStyle w:val="pschar"/>
				</w:rPr>
				<w:t>
					<xsl:value-of select="substring($previousSubclassSymbol,4,1)"/>
					<xsl:text> </xsl:text>
				</w:t>
			</w:r>
			<w:r>
				<w:rPr>
					<w:rStyle w:val="aschar"/>
				</w:rPr>
				<w:t>
					<xsl:value-of select="$actualSubclassChar"/>
				</w:t>
			</w:r>
			<w:r>
				<w:rPr>
					<w:rStyle w:val="cchar"/>
				</w:rPr>
				<w:t>
					<xsl:value-of select="$class"/>
				</w:t>
			</w:r>
			<w:r>
				<w:t>
					<xsl:text> </xsl:text>
				</w:t>
			</w:r>
		</w:p>
	</xsl:template>

	<xsl:template name="classOrSubclassEntry">
		<xsl:variable name="symbol" select="@symbol"/>
		<xsl:if test="@kind='c'">
			<xsl:variable name="title" select="//ipcEntry[@kind='t' and @symbol=$symbol]/textBody/title/titlePart"/>
			<xsl:if test="$title">
		        <w:p>
		            <w:pPr>
		                <w:pStyle w:val="subsection"/>
						<w:spacing w:before="0"/>
						<w:pageBreakBefore w:val="off"/>
		            </w:pPr>
		            <w:r>
						<xsl:variable name="kind" select="ancestor-or-self::ipcEntry[1]/@kind"/>
						<xsl:if test="$kind='s' or $kind='u' or $kind='c' or $kind='t'">
							<w:rPr><w:caps/></w:rPr>
						</xsl:if>
		                <w:t><xsl:apply-templates select="$title" mode="textonly"/></w:t>
		            </w:r>
		        </w:p>
			<!-- 20050421 TA added { -->
			<!-- <xsl:apply-templates select="//ipcEntry[@kind='t' and @symbol=$symbol]/ipcEntry"/> -->
			<xsl:apply-templates select="//ipcEntry[@kind='n' and @symbol=$symbol and @endSymbol]"/>
			<!-- 20050421 TA added } -->

			</xsl:if>
			<!-- 20050421 TA added { -->
			<xsl:if test="//ipcEntry[@kind='i' and @symbol=$symbol and @endSymbol!='']">
				<xsl:apply-templates select="//ipcEntry[@kind='i' and @symbol=$symbol and @endSymbol!='']"/>
			</xsl:if>
			<!-- 20050421 TA added } -->
		</xsl:if>
		<xsl:variable name="edfix"><xsl:if test="@edition and contains(@edition, $fulledition)">new</xsl:if></xsl:variable>
		<aml:annotation aml:id="0" w:type="Word.Bookmark.Start" w:name="{$symbol}"/>
		<aml:annotation aml:id="0" w:type="Word.Bookmark.End"/>
		<w:p>
			<w:pPr>
				<w:pStyle>
					<xsl:attribute name="w:val">
						<xsl:choose>
							<xsl:when test="@kind='c'">class</xsl:when>
							<xsl:when test="@kind='u'">subclass</xsl:when>
						</xsl:choose>
						<xsl:value-of select="$edfix"/>
					</xsl:attribute>
				</w:pStyle>
				<w:spacing w:before="0" w:after="350"/>
				<w:pageBreakBefore w:val="off"/>
			</w:pPr>
			<w:r>
				<xsl:variable name="advanced">
					<xsl:if test="ancestor-or-self::ipcEntry[1]/@ipcLevel='A' or ancestor-or-self::ipcEntry[1]/@kind='d'">1</xsl:if>
				</xsl:variable>
				<w:t>
					<xsl:value-of select="substring(@symbol,1,1)"/>
<!--					<xsl:text> </xsl:text>-->
					<xsl:value-of select="substring(@symbol,2,2)"/>
					<xsl:if test="@kind='u'">
<!--						<xsl:text> </xsl:text>-->
						<xsl:value-of select="substring(@symbol,4,1)"/>
					</xsl:if>
				</w:t>
			</w:r>
			<w:r>
				<w:tab wx:wTab="345" wx:tlc="none" wx:cTlc="5"/>
			</w:r>
			<xsl:apply-templates select="textBody"/>
			<xsl:if test="@edition">
				<w:r>
					<w:rPr>
						<w:b/>
						<w:i w:val="off"/>
					</w:rPr>
					<w:t><xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>]</w:t>
				</w:r>
			</xsl:if>
		</w:p>
		<xsl:apply-templates select="ipcEntry[@kind='n' and @symbol=$symbol]"/>
		<!-- 20040421 TA testing for @endSymbol='' gives bad result: -->
		<xsl:apply-templates select="ipcEntry[@kind='i' and @symbol=$symbol and (concat('',@endSymbol)='')]"/>
		<xsl:apply-templates select="ipcEntry[(@kind='m' or @kind='l') and substring(@symbol,1,4) = $symbol]"/>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='l']">
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
        <wx:pBdrGroup>
            <wx:borders>
                <wx:bottom wx:val="solid" wx:bdrwidth="10" wx:space="1" wx:color="auto"/>
            </wx:borders>
            <w:p>
                <w:pPr>
                    <w:pStyle w:val="guideline"/>
                    <w:spacing w:before="120" w:after="0"/>
                </w:pPr>
                <aml:annotation aml:id="243" w:type="Word.Bookmark.Start" w:name="{$bookmark}_GL"/>
                <aml:annotation aml:id="243" w:type="Word.Bookmark.End"/>
            </w:p>
        </wx:pBdrGroup>
	</xsl:template>
<!--
2. Notes, subclass indexet langból. 3 jegyű index  symbolnal class index,
   ha end symbol is ki van töltve akkor subsection index, 4 nél subclass index (így van most)

3. Class és subsection indexnél ki kell írni a symbol elejét
-->
	<xsl:template match="ipcEntry[@kind='i']">
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<aml:annotation aml:id="1" w:type="Word.Bookmark.Start" w:name="{$bookmark}_I"/>
		<aml:annotation aml:id="1" w:type="Word.Bookmark.End"/>
		<w:p>
			<w:pPr>
				<w:pStyle w:val="indextitle"/>
				<xsl:if test="preceding-sibling::ipcEntry[@kind='n']">
					<w:spacing w:before="320"/>
				</xsl:if>
			</w:pPr>
			<w:r>
				<w:t>
				<xsl:choose>
					<xsl:when test="@endSymbol">
						<xsl:call-template name="translate"><xsl:with-param name="id" select="'subsection_index'"/></xsl:call-template>
					</xsl:when>
					<xsl:when test="string-length(@symbol) = 3">
						<xsl:call-template name="translate"><xsl:with-param name="id" select="'class_index'"/></xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="translate"><xsl:with-param name="id" select="'subclass_index'"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose></w:t>
			</w:r>
		</w:p>
		<xsl:call-template name="headerFooter"/>
		<!-- 20050310 structure contradiction: section must be closed and opened again -->
		<xsl:text disable-output-escaping="yes">&lt;/wx:sect&gt;&lt;wx:sect&gt;</xsl:text>
		<!-- 20050310 end of structure contradiction -->
		<xsl:apply-templates select="textBody"/>

		<!-- 20050310 structure contradiction: section must be closed and opened again -->
		<xsl:text disable-output-escaping="yes">&lt;/wx:sect&gt;&lt;wx:sect&gt;
		<!-- 20050310 end of structure contradiction -->
			</xsl:text>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='n']">
		<xsl:variable name="edfix"><xsl:if test="@edition and contains(@edition, $fulledition)">new</xsl:if></xsl:variable>
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<xsl:variable name="postfix">
			<xsl:choose>
				<xsl:when test="string-length(@symbol) &lt; 5">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<aml:annotation aml:id="1" w:type="Word.Bookmark.Start" w:name="{$bookmark}_N"/>
		<aml:annotation aml:id="1" w:type="Word.Bookmark.End"/>
		<w:p>
			<w:pPr>
				<w:pStyle w:val="notetitle{$postfix}{$edfix}"/>
				<w:spacing/>
			</w:pPr>
			<w:r><!--[<xsl:value-of select="$postfix"/>]-->
				<w:t><xsl:call-template name="translate">
					<xsl:with-param name="id">Note_s</xsl:with-param>
				</xsl:call-template></w:t>
			</w:r>
            <xsl:if test="@edition">
                <w:r>
                    <w:rPr>
                        <w:b/>
                        <w:i w:val="off"/>
                    </w:rPr>
                    <w:t><xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>]</w:t>
                </w:r>
            </xsl:if>
		</w:p>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='m']">
		<xsl:variable name="edfix"><xsl:if test="@edition and contains(@edition, $fulledition)">new</xsl:if></xsl:variable>
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<xsl:text disable-output-escaping="yes">&lt;/wx:sect&gt;&lt;wx:sect&gt;</xsl:text>
		<xsl:if test="not(preceding-sibling::ipcEntry[@kind='m'])">
			<wx:pBdrGroup>
				<wx:borders>
					<wx:bottom wx:val="solid" wx:bdrwidth="10" wx:space="1" wx:color="auto"/>
				</wx:borders>
				<wx:margin-left wx:val="3118"/>
				<wx:margin-right wx:val="3118"/>
				<w:p>
					<w:pPr>
						<w:pStyle w:val="subclassline"/>
					</w:pPr>
					<aml:annotation aml:id="18" w:type="Word.Bookmark.Start" w:name="{@bookmark_STL}"/><!-- should be H01B_I8_STL -->
					<aml:annotation aml:id="18" w:type="Word.Bookmark.End"/>
				</w:p>
			</wx:pBdrGroup>
			<w:p>
				<w:pPr>
					<w:pStyle w:val="maingroup{$edfix}"/>
					<w:keepNext w:val="off"/>
					<w:spacing w:before="0" w:after="0"/>
					<w:sectPr>
						<w:type w:val="continuous"/>
						<w:pgSz w:w="11907" w:h="16840" w:code="9"/>
						<w:pgMar w:top="0" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
						<w:cols w:space="720"/>
					</w:sectPr>
				</w:pPr>
			</w:p>
			<aml:annotation aml:id="19" w:type="Word.Bookmark.Start" w:name="{$bookmark}"/>
			<aml:annotation aml:id="19" w:type="Word.Bookmark.End"/>
			<xsl:text disable-output-escaping="yes">&lt;/wx:sect&gt;&lt;wx:sect&gt;</xsl:text>
		</xsl:if>
		<!-- 20050421 TA refined { -->
		<!-- <xsl:if test="not(preceding-sibling::ipcEntry[@kind='m'])"> -->
			<xsl:variable name="symbol" select="@symbol" />
			<xsl:apply-templates select="preceding-sibling::ipcEntry[(@kind='g' or @kind='n') and @symbol=$symbol]"/>

		<!-- </xsl:if> -->
		<!-- 20050421 TA refined } -->

		<aml:annotation aml:id="22" w:type="Word.Bookmark.Start" w:name="{$bookmark}_M"/>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.End"/>
		<xsl:if test="not(ipcEntry) and position() = last() and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
	        <aml:annotation aml:id="243" w:type="Word.Bookmark.Start" w:name="{substring($bookmark, 1, 4)}_l"/>
	        <aml:annotation aml:id="243" w:type="Word.Bookmark.End"/>
		</xsl:if>
		<w:p>
			<w:pPr>
				<w:pStyle w:val="maingroup{$edfix}"/>
				<!-- 20060404 TA { not keep with next if MGRP sequence -->
					<xsl:if test="following-sibling::ipcEntry[1]/@kind='m'">
								<w:keepNext w:val="off"/>
					</xsl:if>
				<!-- 20060404 TA } -->
				<!--				<w:keepNext w:val="off"/>-->
				<xsl:choose>
					<xsl:when test="preceding-sibling::ipcEntry[@kind='m' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='n' or @kind='A']"><w:spacing w:after="28" w:before="150"/></xsl:when>
					<xsl:otherwise><w:spacing w:after="28" w:before="0"/></xsl:otherwise>
				</xsl:choose>
				<xsl:if test="not(ipcEntry) and position() = last() and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
                    <w:sectPr>
                        <w:type w:val="continuous"/>
                        <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
                        <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
                        <w:cols w:num="2" w:space="567"/>
                    </w:sectPr>
				</xsl:if>
			</w:pPr>
			<xsl:call-template name="parseSymbol"/>
			<w:r>
				<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
			</w:r>
			<xsl:apply-templates select="*[name() != 'ipcEntry']"/>
			<xsl:if test="@edition">
				<w:r>
					<w:rPr>
						<w:b/>
						<w:i w:val="off"/>
					</w:rPr>
					<w:t>
						<xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>]</w:t>
				</w:r>
			</xsl:if>
		</w:p>
		<!-- 20050421 TA added { -->
		<xsl:apply-templates select="following-sibling::ipcEntry[@kind='n' and @symbol=$symbol]"/>
		<!-- 20050421 TA added } -->
		<xsl:apply-templates select="ipcEntry[@kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A']" mode="inentry"/>
		<xsl:text disable-output-escaping="yes">&lt;/wx:sect&gt;&lt;wx:sect&gt;</xsl:text>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='n']" mode="inentry">
		<xsl:variable name="edfix"><xsl:if test="@edition and contains(@edition, $fulledition)">new</xsl:if></xsl:variable>
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.Start" w:name="{$bookmark}_N"/>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.End"/>
		<w:p>
			<w:pPr>
				<w:pStyle w:val="notetitle0{$edfix}"/>
				<w:spacing w:before="190"/>
			</w:pPr>
			<w:r>
				<w:t><xsl:call-template name="translate">
					<xsl:with-param name="id">Note_s</xsl:with-param>
				</xsl:call-template></w:t>
			</w:r>
            <xsl:if test="@edition">
                <w:r>
                    <w:rPr>
                        <w:b/>
                        <w:i w:val="off"/>
                    </w:rPr>
                    <w:t><xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>]</w:t>
                </w:r>
            </xsl:if>
		</w:p>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.Start" w:name="{$bookmark}_N0"/>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.End"/>
		<xsl:if test="not(ipcEntry) and position() = last() and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
	        <aml:annotation aml:id="243" w:type="Word.Bookmark.Start" w:name="{substring($bookmark, 1, 4)}_l"/>
	        <aml:annotation aml:id="243" w:type="Word.Bookmark.End"/>
		</xsl:if>
		<!--<w:p>
			<w:pPr>
				<w:pStyle w:val="simplenote1{$edfix}"/>
				<xsl:if test="not(textBody/note/noteParagraph/subnote)">
					<w:spacing w:after="283"/>
				</xsl:if>
				<w:rPr>
					<w:b/>
				</w:rPr>
				<xsl:if test="not(ipcEntry) and position() = last() and (string-length(@symbol) &lt; 5 or not(textBody/note/noteParagraph/subnote)) and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
                    <w:sectPr>
                        <w:type w:val="continuous"/>
                        <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
                        <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
                        <w:cols w:num="2" w:space="567"/>
                    </w:sectPr>
				</xsl:if>
			</w:pPr>
			<w:r>
				<w:t><xsl:apply-templates select="textBody/note/noteParagraph/text"/></w:t>
			</w:r>
			<xsl:if test="textBody/note/noteParagraph/@edition">
				<w:r>
					<w:rPr>
						<w:b/>
						<w:i w:val="off"/>
					</w:rPr>
					<w:t>
						<xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="textBody/note/noteParagraph/@edition"/></xsl:call-template>]</w:t>
				</w:r>
			</xsl:if>
		</w:p>-->
		<xsl:apply-templates select="textBody/note/noteParagraph"/>
		<!--<xsl:apply-templates select="textBody/note/noteParagraph/subnote"/>-->
	</xsl:template>

	<xsl:template match="subnote">
		<!--<xsl:if test="ancestor::subnote">
			<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;&lt;/w:p&gt;</xsl:text>
		</xsl:if>-->

		<xsl:variable name="edfix"><xsl:if test="@edition and contains(@edition, $fulledition)">new</xsl:if></xsl:variable>
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="@type='table'">
				<w:tbl>
	                <w:tblPr>
	                    <w:tblW w:w="0" w:type="auto"/>
	                    <w:tblLayout w:type="Fixed"/>
	                    <w:tblCellMar>
	                        <w:left w:w="28" w:type="dxa"/>
	                        <w:right w:w="28" w:type="dxa"/>
	                    </w:tblCellMar>
	                </w:tblPr>
	                <w:tblGrid>
	                    <w:gridCol w:w="2409"/>
						<xsl:choose>
							<xsl:when test="ancestor::ipcEntry[@kind = 'm']">
								<w:gridCol w:w="2478"/>
							</xsl:when>
							<xsl:otherwise>
	                    		<w:gridCol w:w="7228"/>
							</xsl:otherwise>
						</xsl:choose>
	                </w:tblGrid>
					<xsl:for-each select="noteParagraph">
		                <aml:annotation aml:id="22" w:type="Word.Bookmark.Start" w:name="{$bookmark}_N{position()}"/>
		                <aml:annotation aml:id="22" w:type="Word.Bookmark.End"/>
		                <w:tr>
		                    <w:tblPrEx>
		                        <w:tblBorders>
		                            <w:top w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
		                            <w:left w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
		                            <w:bottom w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
		                            <w:right w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
		                            <w:insideH w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
		                            <w:insideV w:val="single" w:sz="4" wx:bdrwidth="10" w:space="0" w:color="auto"/>
		                        </w:tblBorders>
		                        <w:tblCellMar>
		                            <w:top w:w="0" w:type="dxa"/>
		                            <w:bottom w:w="0" w:type="dxa"/>
		                        </w:tblCellMar>
		                    </w:tblPrEx>
		                    <w:trPr>
		                        <w:cantSplit/>
		                    </w:trPr>
		                    <w:tc>
		                        <w:tcPr>
		                            <w:tcW w:w="2409" w:type="dxa"/>
		                            <w:tcBorders>
		                                <w:top w:val="nil"/>
		                                <w:left w:val="nil"/>
		                                <w:bottom w:val="nil"/>
		                                <w:right w:val="nil"/>
		                            </w:tcBorders>
		                        </w:tcPr>
		                        <w:p>
		                            <w:pPr>
		                                <w:pStyle w:val="columnednote{count(ancestor-or-self::subnote) -1}"/>
		                                <!--<w:keepNext/>-->
		                            </w:pPr>
									<xsl:for-each select="references/*">
										<xsl:choose>
											<xsl:when test="name()='sref'">
					                            <w:r>
													<xsl:if test="position() != 1">
														<w:br/>
													</xsl:if>
					                                <w:t><xsl:call-template name="renderSymbol">
														<xsl:with-param name="data" select="substring(@ref, 1, 4)"/>
													</xsl:call-template></w:t>
					                            </w:r>
												<xsl:choose>
													<xsl:when test="string-length(@ref) &gt; 4">
														<xsl:call-template name="renderTabbedSymbolNum">
															<xsl:with-param name="data" select="@ref"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
							                            <!--<w:r>
							                                <w:tab/>
							                            </w:r>
							                            <w:r>
							                                <w:tab/>
							                            </w:r>
							                            <w:r>
							                                <w:tab/>
							                            </w:r>-->
													</xsl:otherwise>
												</xsl:choose>
					                            <w:r>
					                                <!--<w:tab/>-->
													<xsl:if test="following-sibling::mref|following-sibling::sref">
														<w:t>,</w:t>
													</xsl:if>
					                            </w:r>
											</xsl:when>
											<xsl:when test="name()='mref'">
					                            <w:r>
													<xsl:if test="position() != 1">
														<w:br/>
													</xsl:if>
					                                <w:t><xsl:call-template name="renderSymbol">
														<xsl:with-param name="data" select="substring(@ref, 1, 4)"/>
													</xsl:call-template></w:t>
					                            </w:r>
												<xsl:choose>
													<xsl:when test="string-length(@ref) &gt; 4">
														<xsl:call-template name="renderTabbedSymbolNum">
															<xsl:with-param name="data" select="@ref"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
							                            <!--<w:r>
							                                <w:tab/>
							                            </w:r>
							                            <w:r>
							                                <w:tab/>
							                            </w:r>
							                            <w:r>
							                                <w:tab/>
							                            </w:r>-->
													</xsl:otherwise>
												</xsl:choose>
					                            <w:r>
					                                <w:tab/>
													<w:t><xsl:text>-</xsl:text></w:t>
					                            </w:r>
					                            <w:r>
													<w:br/>
					                                <w:t><xsl:call-template name="renderSymbol">
														<xsl:with-param name="data" select="substring(@endRef, 1, 4)"/>
													</xsl:call-template></w:t>
					                            </w:r>
												<xsl:choose>
													<xsl:when test="string-length(@endRef) &gt; 4">
														<xsl:call-template name="renderTabbedSymbolNum">
															<xsl:with-param name="data" select="@endRef"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
							                            <!--<w:r>
							                                <w:tab/>
							                            </w:r>
							                            <w:r>
							                                <w:tab/>
							                            </w:r>
							                            <w:r>
							                                <w:tab/>
							                            </w:r>-->
													</xsl:otherwise>
												</xsl:choose>
					                            <w:r>
					                                <!--<w:tab/>-->
													<xsl:if test="following-sibling::mref|following-sibling::sref">
														<w:t>,</w:t>
													</xsl:if>
					                            </w:r>
											</xsl:when>
										</xsl:choose>
									</xsl:for-each>
		                        </w:p>
		                    </w:tc>
		                    <w:tc>
		                        <w:tcPr>
									<xsl:choose>
										<xsl:when test="ancestor::ipcEntry[@kind = 'm']">
											<w:tcW w:w="2478" w:type="dxa"/>
										</xsl:when>
										<xsl:otherwise>
				                            <w:tcW w:w="7228" w:type="dxa"/>
										</xsl:otherwise>
									</xsl:choose>
		                            <w:tcBorders>
		                                <w:top w:val="nil"/>
		                                <w:left w:val="nil"/>
		                                <w:bottom w:val="nil"/>
		                                <w:right w:val="nil"/>
		                            </w:tcBorders>
		                        </w:tcPr>
		                        <w:p>
		                            <w:pPr>
		                                <w:pStyle w:val="simplenote0"/>
										<!--<xsl:if test="position() = last()">
		                                	<w:spacing w:after="283"/>
										</xsl:if>-->
		                            </w:pPr>
		                            <w:r>
		                                <w:t><xsl:apply-templates select="text"/></w:t>
		                            </w:r>
		                        </w:p>
		                    </w:tc>
		                </w:tr>
					</xsl:for-each>
	            </w:tbl>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="noteParagraph/*">
					<xsl:choose>
						<xsl:when test="name()='text'">
							<xsl:variable name="edfix2"><xsl:if test="../@edition and contains(../@edition, $fulledition)">new</xsl:if></xsl:variable>

							<xsl:variable name="depth">
								<xsl:choose>
									<xsl:when test="../../@type = 'number' and not(ancestor::subnote)">0</xsl:when>
									<xsl:when test="../../@type = 'number' and ../../../../@type='none' and name(../../../..)='note'">0</xsl:when>
									<xsl:when test="ancestor::subnote[@type = 'number'] and ancestor::note[@type='none']"><xsl:value-of select="count(ancestor-or-self::subnote|ancestor-or-self::orphan) - 1"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="count(ancestor-or-self::subnote|ancestor-or-self::orphan)"/></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>

							<aml:annotation aml:id="647" w:type="Word.Bookmark.Start" w:name="{$bookmark}_N1"/>
				            <aml:annotation aml:id="647" w:type="Word.Bookmark.End"/>
				            <w:p>
				                <w:pPr>
				                    <w:pStyle w:val="hangingnote{$depth}{$edfix2}"/>
				                </w:pPr><!--  and string-length(@symbol) &gt; 4  -->
								<xsl:if test="position() = last() and string-length(ancestor::ipcEntry[not(.//ipcEntry)]/@symbol) &gt; 4 and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
									<w:sectPr>
										<w:type w:val="continuous"/>
										<w:pgSz w:w="11907" w:h="16840" w:code="9"/>
										<w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
										<w:cols w:num="2" w:space="567"/>
									</w:sectPr>
								</xsl:if>
								<!--<w:r><w:t>[[<xsl:value-of select="ancestor::ipcEntry[not(.//ipcEntry)]/@symbol"/>]]</w:t></w:r>-->
								<w:r>
									<w:t><xsl:call-template name="getNotePrefix">
										<xsl:with-param name="serial" select="count(../preceding-sibling::noteParagraph)+1"/>
										<xsl:with-param name="type" select="../../@type"/>
									</xsl:call-template></w:t>
				                </w:r>
				                <w:r>
									<xsl:if test="../../@type and ../../@type != 'none'">
				                    	<w:tab wx:wTab="180" wx:tlc="none" wx:cTlc="3"/>
									</xsl:if>
				                    <w:t><xsl:apply-templates select="."/></w:t>
				                </w:r>
								<xsl:if test="../@edition">
									<w:r>
										<w:rPr>
											<w:b/>
											<w:i w:val="off"/>
										</w:rPr>
										<w:t><xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="../@edition"/></xsl:call-template>]</w:t>
									</w:r>
								</xsl:if>
				            </w:p>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="."/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
<!--
		<xsl:if test="ancestor::subnote">
			<xsl:text disable-output-escaping="yes">&lt;w:p&gt;&lt;w:r&gt;&lt;w:t&gt;</xsl:text>
		</xsl:if>-->
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='g']">
		<xsl:variable name="edfix"><xsl:if test="@edition and contains(@edition, $fulledition)">new</xsl:if></xsl:variable>
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<aml:annotation aml:id="1" w:type="Word.Bookmark.Start" w:name="{$bookmark}_G"/>
		<aml:annotation aml:id="1" w:type="Word.Bookmark.End"/>
		<w:p>
			<w:pPr>
				<w:pStyle w:val="guide{$edfix}"/>
                <w:keepNext w:val="off"/>
                <w:rPr>
                    <w:u w:val="none"/>
                </w:rPr>
				<w:spacing w:before="270" w:after="0"/>
			</w:pPr>

			<!-- TA 20060404 called instead of custom code -->
			<xsl:apply-templates select="*[name() != 'ipcEntry']"/>


<!--
			<w:r>
				<w:t><xsl:apply-templates select="textBody/title/titlePart" mode="textonly"/></w:t>
			</w:r>
			<xsl:if test="textBody/title/titlePart/*[name()!='text']">
                <w:r>
                    <w:rPr>
                        <w:b w:val="off"/>
                        <w:u w:val="none"/>
                    </w:rPr>
                    <w:t><xsl:text> (</xsl:text><xsl:apply-templates select="textBody/title/titlePart/*[name()!='text']"/><xsl:text>)</xsl:text></w:t>
                </w:r>
			</xsl:if>
-->
			<xsl:if test="@edition">
                <w:r>
                    <w:rPr>
                        <w:u w:val="none"/>
                    </w:rPr>
                    <w:t> [<xsl:call-template name="getedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>]</w:t>
                </w:r>
			</xsl:if>
		</w:p>
		<!-- 20050421 TA added, F01L 15/00 { -->
		<xsl:apply-templates select="ipcEntry"/>
		<!-- 20050421 TA added } -->
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A']" mode="inentry">
		<xsl:variable name="edfix"><xsl:if test="@edition and contains(@edition, $fulledition)">new</xsl:if></xsl:variable>
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<xsl:variable name="symbol" select="@symbol" />
		<!-- <xsl:apply-templates select="preceding-sibling::ipcEntry[(@kind='g' or @kind='n') and @symbol=$symbol]"/> -->
		<aml:annotation aml:id="22" w:type="Word.Bookmark.Start" w:name="{$bookmark}_{@kind}"/>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.End"/>
		<xsl:if test="not(ipcEntry) and position() = last() and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
	        <aml:annotation aml:id="243" w:type="Word.Bookmark.Start" w:name="{substring($bookmark, 1, 4)}_l"/>
	        <aml:annotation aml:id="243" w:type="Word.Bookmark.End"/>
		</xsl:if>
		<w:p>
			<w:pPr>
				<xsl:choose>
					<xsl:when test="@kind='A'">
						<w:pStyle w:val="dots10{$edfix}"/>
					</xsl:when>
					<xsl:otherwise>
						<w:pStyle w:val="dots{@kind}{$edfix}"/>
					</xsl:otherwise>
				</xsl:choose>
				<w:spacing w:before="0" w:after="28"/>
				<xsl:if test="not(ipcEntry) and position() = last() and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
                    <w:sectPr>
                        <w:type w:val="continuous"/>
                        <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
                        <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
                        <w:cols w:num="2" w:space="567"/>
                    </w:sectPr>
				</xsl:if>
			</w:pPr>
			<xsl:call-template name="parseSymbol"/>
			<w:r>
				<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
				<w:rPr>
					<w:b/>
				</w:rPr>
				<w:t>.</w:t>
			</w:r>
			<xsl:if test="(@kind &gt; 1) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<xsl:if test="(@kind &gt; 2) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<xsl:if test="(@kind &gt; 3) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<xsl:if test="(@kind &gt; 4) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<xsl:if test="(@kind &gt; 5) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<xsl:if test="(@kind &gt; 6) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<xsl:if test="(@kind &gt; 7) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<xsl:if test="(@kind &gt; 8) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<xsl:if test="(@kind &gt; 9) or (@kind = 'A')">
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
			</xsl:if>
			<w:r>
				<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
			</w:r>
			<xsl:apply-templates select="*[name() != 'ipcEntry']"/>
			<xsl:if test="@edition">
				<w:r>
					<w:rPr>
						<w:b/>
						<w:i w:val="off"/>
					</w:rPr>
					<w:t><xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>]</w:t>
				</w:r>
			</xsl:if>
		</w:p>
		<xsl:apply-templates select="ipcEntry" mode="inentry"/>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='d']" mode="inentry">
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<xsl:variable name="symbol" select="@symbol" />
		<aml:annotation aml:id="22" w:type="Word.Bookmark.Start" w:name="{$bookmark}_{@kind}"/>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.End"/>
		<xsl:if test="not(ipcEntry) and position() = last() and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
	        <aml:annotation aml:id="243" w:type="Word.Bookmark.Start" w:name="{substring($bookmark, 1, 4)}_l"/>
	        <aml:annotation aml:id="243" w:type="Word.Bookmark.End"/>
		</xsl:if>
		<w:p>
            <w:pPr>
                <w:pStyle w:val="deleted"/>
                <w:spacing w:before="0" w:after="28"/>
				<xsl:if test="not(ipcEntry) and position() = last() and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
                    <w:sectPr>
                        <w:type w:val="continuous"/>
                        <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
                        <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
                        <w:cols w:num="2" w:space="567"/>
                    </w:sectPr>
				</xsl:if>
            </w:pPr>
			<xsl:call-template name="parseSymbol"/>
            <w:r>
                <w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
                <w:t>
					<xsl:if test=".//transferredTo">
						<xsl:text>(</xsl:text>
							<xsl:call-template name="translate"><xsl:with-param name="id" select="'transferred_to_sing'"/></xsl:call-template>
							<xsl:text> </xsl:text>
							<xsl:for-each select=".//transferredTo/*">
								<xsl:if test="position() != 1">
									<xsl:text>, </xsl:text>
								</xsl:if>
								<xsl:apply-templates select="." mode="full"/>
							</xsl:for-each>
						<xsl:text>)</xsl:text>
					</xsl:if>
					<xsl:if test=".//coveredBy">
						<xsl:text>(</xsl:text>
							<xsl:call-template name="translate"><xsl:with-param name="id" select="'covered_by_sing'"/></xsl:call-template>
							<xsl:text> </xsl:text>
							<xsl:for-each select=".//coveredBy/*">
								<xsl:if test="position() != 1">
									<xsl:text>, </xsl:text>
								</xsl:if>
								<xsl:apply-templates select="." mode="full"/>
							</xsl:for-each>
						<xsl:text>)</xsl:text>
					</xsl:if>
				</w:t>
            </w:r>
		</w:p>
		<xsl:apply-templates select="ipcEntry" mode="inentry"/>
	</xsl:template>
<!--
	<xsl:template match="ipcEntry[@kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A']">
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.Start" w:name="{$bookmark}_{@kind}"/>
		<aml:annotation aml:id="22" w:type="Word.Bookmark.End"/>
		<w:p>
			<w:pPr>
				<w:pStyle w:val="ots1"/>
				<w:spacing w:before="0" w:after="28"/>
			</w:pPr>
				<w:r>
					<w:tab wx:wTab="195" wx:tlc="none" wx:cTlc="3"/>
					<w:t>1</w:t>
				</w:r>
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
					<w:t>/</w:t>
				</w:r>
				<w:r>
					<w:tab wx:wTab="465" wx:tlc="none" wx:cTlc="9"/>
					<w:t>02</w:t>
				</w:r>
				<w:r>
					<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
				</w:r>
				<w:r>
					<w:rPr>
						<w:b/>
					</w:rPr>
					<w:t>.</w:t>
				</w:r>
				<w:r>
					<w:tab wx:wTab="165" wx:tlc="none" wx:cTlc="3"/>
					<w:t>mainly consisting of metals or alloys</w:t>
				</w:r>
		</w:p>
		<xsl:apply-templates/>
	</xsl:template>-->

	<xsl:template match="note">
		<xsl:for-each select="noteParagraph">
			<xsl:call-template name="noteParagraph">
				<xsl:with-param name="depth" select="0"/>
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="orphan">
			<xsl:call-template name="noteParagraph">
				<xsl:with-param name="depth" select="0"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="subnote">
		<xsl:param name="depth"/>
		<xsl:for-each select="noteParagraph">
			<xsl:call-template name="noteParagraph">
				<xsl:with-param name="depth" select="$depth + 1"/>
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="orphan">
			<xsl:call-template name="noteParagraph">
				<xsl:with-param name="depth" select="$depth + 1"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="orphan">
		<xsl:variable name="edfix"><xsl:if test="@edition and contains(@edition, $fulledition)">new</xsl:if></xsl:variable>
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
		<xsl:variable name="indent"><xsl:if test="not(@indent)">1</xsl:if><xsl:value-of select="@indent"/></xsl:variable>
		<aml:annotation aml:id="73" w:type="Word.Bookmark.Start" w:name="{$bookmark}_N4"/>
        <aml:annotation aml:id="73" w:type="Word.Bookmark.End"/>
        <w:p>
            <w:pPr>
                <w:pStyle w:val="simplenote{$indent}{$edfix}"/>
                <w:rPr>
                    <w:b/>
                </w:rPr>
            </w:pPr>
            <w:r>
                <w:t><xsl:apply-templates select="text"/></w:t>
            </w:r>
			<xsl:if test="@edition and @edition != ''">
				<w:r>
					<w:rPr>
						<w:b/>
						<w:i w:val="off"/>
					</w:rPr>
					<w:t>
						<xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>]</w:t>
				</w:r>
			</xsl:if>
        </w:p>
		<xsl:apply-templates select="subnote"/>
	</xsl:template>

	<xsl:template name="noteParagraph" match="noteParagraph">
		<xsl:param name="depth"/>
		<!-- Ha nincs felette subnote vagy orphan és isprefix = 0, akkor 1 legyen -->
		<xsl:variable name="edfix"><xsl:if test="(not(@edition) and ancestor::ipcEntry[1]/@edition=$fulledition) or (@edition and contains(@edition, $fulledition))">new</xsl:if></xsl:variable>
		<xsl:variable name="serial"><xsl:call-template name="getNotePrefix">
			<xsl:with-param name="serial" select="count(preceding-sibling::noteParagraph)+1"/>
			<xsl:with-param name="type" select="../@type"/>
		</xsl:call-template></xsl:variable>
		<xsl:variable name="isPrefix">
			<xsl:choose>
				<xsl:when test="not(../@type) or ../@type='none'">0</xsl:when>
				<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="newdepth">
			<xsl:choose>
				<xsl:when test="not(ancestor::subnote) and not(ancestor::orphan) and ($isPrefix = 0)">1</xsl:when>
				<xsl:when test="not($depth)">0</xsl:when>
				<xsl:otherwise><xsl:value-of select="$depth"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<w:p>
			<w:pPr>
				<w:pStyle>
					<xsl:attribute name="w:val">
						<xsl:choose>
							<xsl:when test="$isPrefix='0'">simplenote</xsl:when>
							<xsl:otherwise>hangingnote</xsl:otherwise>
						</xsl:choose>
						<xsl:value-of select="$newdepth"/>
						<xsl:value-of select="$edfix"/>
					</xsl:attribute>
				</w:pStyle>
				<w:keepNext w:val="off"/>
				<xsl:if test="@edition and contains(@edition, $fulledition)">
					<w:rPr>
						<w:b/>
						<w:i w:val="off"/>
					</w:rPr>
				</xsl:if>
				<xsl:if test="not(following-sibling::noteParagraph) and not(subnote) and not(orphan)">
					<w:spacing w:after="283"/>
				</xsl:if>
<!--				<xsl:if test="not(ipcEntry) and position() = last() and (string-length(@symbol) &lt; 5 or not(textBody/note/noteParagraph/subnote)) and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">-->
<!--				<xsl:if test="position() = last() and (string-length(@symbol) &lt; 5 or (not(textBody/note/noteParagraph/subnote) and not(subnote))) and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A']) and (./ancestor::ipcEntry)/preceding-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9']">-->
				<xsl:if test="position() = last() and not(subnote) and not(orphan) and string-length(ancestor::ipcEntry[not(.//ipcEntry)]/@symbol) &gt; 4 and not((./ancestor::ipcEntry)/following-sibling::ipcEntry[@kind='m' or @kind='n' or @kind='1' or @kind='2' or @kind='3' or @kind='4' or @kind='5' or @kind='6' or @kind='7' or @kind='8' or @kind='9' or @kind='A'])">
                    <w:sectPr>
                        <w:type w:val="continuous"/>
                        <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
                        <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
                        <w:cols w:num="2" w:space="567"/>
                    </w:sectPr>
				</xsl:if>
			</w:pPr>
			<xsl:if test="$isPrefix='1' and $serial">
				<w:r>
					<w:t>
						<xsl:value-of select="$serial"/>
					</w:t>
				</w:r>
			</xsl:if>
			<w:r>
				<xsl:if test="$isPrefix='1' and $serial">
					<w:tab wx:wTab="615" wx:tlc="none" wx:cTlc="13"/>
				</xsl:if>
				<w:t><xsl:apply-templates select="text"/></w:t>
			</w:r>
			<xsl:if test="@edition">
				<w:r>
					<w:rPr>
						<w:b/>
						<w:i w:val="off"/>
					</w:rPr>
					<w:t>
						<xsl:text> </xsl:text>[<xsl:call-template name="getedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>]</w:t>
				</w:r>
			</xsl:if>
		</w:p>
		<xsl:apply-templates select="subnote"/>
		<xsl:apply-templates select="orphan"/>
	</xsl:template>

	<xsl:template name="getNotePrefix">
		<xsl:param name="serial"/>
		<xsl:param name="type"/>
		<!-- note prefix can be language-dependent! -->
		<xsl:choose>
			<xsl:when test="$type='number'">(<xsl:value-of select="$serial"/>)</xsl:when>
			<xsl:when test="$type='roman'">(<xsl:number format="i" level="single" value="$serial"/>)</xsl:when>
			<xsl:when test="$type='Roman'">(<xsl:number format="I" level="single" value="$serial"/>)</xsl:when>
			<xsl:when test="$type='bullet'">-</xsl:when>
			<xsl:when test="$type='alpha'">(<xsl:number format="a" level="single" value="$serial"/>)</xsl:when>
			<xsl:when test="$type='Alpha'">(<xsl:number format="A" level="single" value="$serial"/>)</xsl:when>
			<xsl:when test="$type='none'"></xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="textBody">
		<xsl:apply-templates select="title|note|index"/>
	</xsl:template>

	<xsl:template match="references">
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="(name()='#text' or name()='') and (position()=1 or position()=last())">
					<xsl:value-of select="normalize-space(.)"/>
				</xsl:when>
				<xsl:otherwise><!--[<xsl:value-of select="name()"/>]--><xsl:apply-templates select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="refgroup">
		<xsl:variable name="entry" select="ancestor-or-self::ipcEntry[2]"/>
		<xsl:choose>
			<xsl:when test="$entry/@endSymbol or string-length($entry/@symbol) = 3">
<!--				<xsl:for-each select="node()">
				</xsl:for-each>-->
				<xsl:apply-templates mode="full"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!--
	<xsl:template match="*" mode="ref">
		<xsl:apply-templates select="."/>
	</xsl:template>
-->
	<xsl:template match="text()" mode="full">
		<xsl:if test="position() = last()">
			<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;w:tab/&gt;&lt;w:t&gt;</xsl:text>
<!--</w:t><w:tab/><w:t>-->
		</xsl:if>
		<xsl:value-of select="."/>
	</xsl:template>

	<xsl:template match="text()" mode="full2">
		<xsl:if test="position() = last()">
			<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;w:tab/&gt;&lt;w:t&gt;</xsl:text>
<!--</w:t><w:tab/><w:t>-->
		</xsl:if>
		<xsl:value-of select="."/>
	</xsl:template>

	<xsl:template match="index">
		<xsl:for-each select="indexEntry">
			<xsl:call-template name="indexEntry">
				<xsl:with-param name="depth" select="0"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="indexEntry">
		<xsl:param name="depth"/>
		<xsl:variable name="follow" select="following::*"/>
		<xsl:variable name="texts" select="references/text()"/>
		<w:p>
			<w:pPr>
				<w:pStyle w:val="index{$depth}"/>
				<xsl:if test="not(references/refgroup[2]) and not(indexEntry) and position() = last() and not((./ancestor::indexEntry)/following-sibling::indexEntry)">
					<w:sectPr>
						<w:type w:val="continuous"/>
						<w:pgSz w:w="11907" w:h="16840" w:code="9"/>
						<w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
						<w:cols w:num="2" w:space="567"/>
					</w:sectPr>
				</xsl:if>
			</w:pPr>
			<w:r>
				<w:t><xsl:apply-templates select="text"/></w:t>
			</w:r>
			<xsl:if test="references">
				<w:r>
					<w:tab/>
					<w:t>
						<xsl:apply-templates select="references/refgroup[1]"/>
					</w:t>
				</w:r>
				<xsl:variable name="reftext" select="$texts[1]"/>
				<xsl:if test="$reftext">
	                <w:r>
	                    <w:tab/>
	                    <w:t><xsl:apply-templates select="$reftext"/></w:t>
	                </w:r>
				</xsl:if>
			</xsl:if>
		</w:p>
		<xsl:for-each select="references/refgroup[position() &gt; 1]">
			<xsl:variable name="pos" select="position() +1"/>
			<w:p>
                <w:pPr>
                    <w:pStyle w:val="indexcontinued"/>
					<xsl:if test="position() = last() and not((./ancestor::indexEntry)/following-sibling::indexEntry)">
						<w:sectPr>
							<w:type w:val="continuous"/>
							<w:pgSz w:w="11907" w:h="16840" w:code="9"/>
							<w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
							<w:cols w:num="2" w:space="567"/>
						</w:sectPr>
					</xsl:if>
                </w:pPr>
                <w:r>
                    <w:tab/>
                    <w:t><xsl:apply-templates mode="full2"/></w:t>
                </w:r>
				<xsl:variable name="reftext" select="$texts[$pos]"/>
				<xsl:if test="$reftext">
	                <w:r>
	                    <w:tab/>
	                    <w:t><xsl:apply-templates select="$reftext"/></w:t>
	                </w:r>
				</xsl:if>
            </w:p>
		</xsl:for-each>
		<xsl:for-each select="indexEntry">
			<xsl:call-template name="indexEntry">
				<xsl:with-param name="depth" select="$depth + 1"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="title">
		<xsl:apply-templates select="titlePart"/>
	</xsl:template>

	<xsl:template match="titlePart">
		<w:r>
			<xsl:variable name="kind" select="ancestor-or-self::ipcEntry[1]/@kind"/>
			<!--xsl:if test="$kind='s' or $kind='u' or $kind='c' or $kind='t'">
				<w:rPr><w:caps/></w:rPr>
			</xsl:if-->
			<w:t><xsl:apply-templates select="text"/></w:t>
		</w:r>
		<xsl:if test="entryReference">
			<w:r>
				<w:rPr>
					<w:b w:val="off"/>
					<w:u w:val="none"/> <!-- TA 20060404 guide heading -->
				</w:rPr>
				<w:t><xsl:text> </xsl:text>(<xsl:apply-templates select="entryReference"/>)</w:t>
			</w:r>
		</xsl:if>
		<xsl:if test="following-sibling::titlePart">
			<w:r>
				<w:rPr>
					<w:b w:val="off"/>
					<w:u w:val="none"/> <!-- TA 20060404 guide heading -->
				</w:rPr>
				<w:t>
					<xsl:text>; </xsl:text>
				</w:t>
			</w:r>
		</xsl:if>
	</xsl:template>

	<xsl:template match="titlePart" mode="textonly">
		<xsl:apply-templates select="text"/>
		<xsl:if test="following-sibling::titlePart">
			<xsl:text>; </xsl:text>
		</xsl:if>
	</xsl:template>

	<xsl:template match="text">
		<xsl:apply-templates/>
	</xsl:template>
<!--
	<xsl:template match="text()">
		<xsl:value-of select="translate(text(), '#x0a;#x0d;#x07;', '')"/>
	</xsl:template>
-->
<!--
	<xsl:template match="subnote">
		<xsl:apply-templates select="noteParagraph" mode="subnote"/>
	</xsl:template>

	<xsl:template match="noteParagraph" mode="subnote">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;</xsl:text>
		<xsl:variable name="bookmark">
			<xsl:value-of select="@symbol"/>
			<xsl:if test="@endSymbol!=''">_<xsl:value-of select="@endSymbol"/></xsl:if>
		</xsl:variable>
	    <aml:annotation aml:id="647" w:type="Word.Bookmark.Start" w:name="{$bookmark}_N{position()}"/>
	    <aml:annotation aml:id="647" w:type="Word.Bookmark.End"/>
	    <w:p>
	        <w:pPr>
	            <w:pStyle w:val="hangingnote1"/>
	        </w:pPr>
	        <w:r>
	            <w:t>–</w:t>
	        </w:r>
	        <w:r>
	            <w:tab wx:wTab="180" wx:tlc="none" wx:cTlc="3"/>
				<w:t><xsl:apply-templates/></w:t>
	        </w:r>
	    </w:p>
		<xsl:text disable-output-escaping="yes">&lt;w:t&gt;</xsl:text>
	</xsl:template>
-->
	<xsl:template match="img">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;&lt;w:r&gt;</xsl:text>
		<xsl:variable name="xsrc" select="@src"/>
		<xsl:variable name="src" select="translate($xsrc,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
		<xsl:variable name="fig" select="$figs/fig[@name=$src]"/>
		<xsl:variable name="offs">
			<xsl:choose>
				<xsl:when test="$fig"><xsl:value-of select="round($fig/@offset * 28.34)"/></xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="width">
			<xsl:choose>
			<xsl:when test="$fig"><xsl:value-of select="$fig/@width"/></xsl:when>
			<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="height">
			<xsl:choose>
			<xsl:when test="$fig"><xsl:value-of select="$fig/@height"/></xsl:when>
			<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="name">
			<xsl:choose>
			<xsl:when test="$fig/@print-name"><xsl:value-of select="$fig/@print-name"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="@src"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <w:rPr>
            <w:position w:val="{$offs}"/>
        </w:rPr>
		<w:br/>
        <w:pict>
        	
			<xsl:if test="string($src)=string($firstfig)">
	            <v:shapetype id="_x0000_t75" coordsize="21600,21600" o:spt="75" o:preferrelative="t" path="m@4@5l@4@11@9@11@9@5xe" filled="f" stroked="f">
	                <v:stroke joinstyle="miter"/>
	                <v:formulas>
	                    <v:f eqn="if lineDrawn pixelLineWidth 0"/>
	                    <v:f eqn="sum @0 1 0"/>
	                    <v:f eqn="sum 0 0 @1"/>
	                    <v:f eqn="prod @2 1 2"/>
	                    <v:f eqn="prod @3 21600 pixelWidth"/>
	                    <v:f eqn="prod @3 21600 pixelHeight"/>
	                    <v:f eqn="sum @0 0 1"/>
	                    <v:f eqn="prod @6 1 2"/>
	                    <v:f eqn="prod @7 21600 pixelWidth"/>
	                    <v:f eqn="sum @8 21600 0"/>
	                    <v:f eqn="prod @7 21600 pixelHeight"/>
	                    <v:f eqn="sum @10 21600 0"/>
	                </v:formulas>
	                <v:path o:extrusionok="f" gradientshapeok="t" o:connecttype="rect"/>
	                <o:lock v:ext="edit" aspectratio="t"/>
	            </v:shapetype>
			</xsl:if>
			
			<xsl:variable name="style">
				<xsl:if test="$width!='' and $height!=''">
					<xsl:text>width:</xsl:text>
					<!-- 20151002 TA cm unit <xsl:value-of select="number($fig/@width) div 8.27"/><xsl:text>pt;</xsl:text> -->
					<xsl:value-of select="$fig/@width"/>
					<xsl:text>cm;height:</xsl:text>
					<!-- 20151002 TA cm unit <xsl:value-of select="number($fig/@height) div 8.27"/> -->
					<xsl:value-of select="$fig/@height"/><xsl:text>cm</xsl:text>
					<!-- 20151002 TA cm unit <xsl:text>pt</xsl:text> -->
				</xsl:if>
			</xsl:variable><!-- width:62.25pt;height:23.25pt -->
            <v:shape style="{$style}" type="#_x0000_t75" o:bordertopcolor="white" o:borderleftcolor="white" o:borderbottomcolor="white" o:borderrightcolor="white" fillcolor="window">
            	<xsl:variable name="tempsrc" select="substring($src,1,string-length($src) -4)"/>
            	<!-- 20070301 TA <xsl:variable name="tempsrc" select="$src"/> -->
                <!-- <v:imagedata o:href="images/{$tempsrc}.bmp" o:title="{substring-before($src, '.')}"><xsl:if test="contains($tempsrc,'table')"><xsl:attribute name="grayscale">t</xsl:attribute></xsl:if></v:imagedata> -->
                <v:imagedata o:href="images/{$name}" o:title="{substring-before($src, '.')}"><xsl:if test="contains($name,'table')"><xsl:attribute name="grayscale">t</xsl:attribute></xsl:if></v:imagedata>
                <w10:bordertop type="single" width="24"/>
                <w10:borderleft type="single" width="24"/>
                <w10:borderbottom type="single" width="24"/>
                <w10:borderright type="single" width="24"/>
            </v:shape>
        </w:pict>
		<xsl:text disable-output-escaping="yes">&lt;/w:r&gt;&lt;w:r&gt;&lt;w:t&gt;</xsl:text></xsl:template>

	<xsl:template match="entryReference">
		<xsl:apply-templates/>
		<xsl:choose>
			<xsl:when test="following-sibling::entryReference">;<xsl:text> </xsl:text></xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="sref">
		<xsl:variable name="name" select="name(preceding-sibling::node()[1])"/>
<!--		[<xsl:value-of select="$name"/>]-->
		<xsl:if test="position() != 1 and $name != 'nbsp' and $name != '' and $name != '#text' and $name != 'sref' and $name != 'mref'"><xsl:text> </xsl:text></xsl:if>
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@ref"/>
		</xsl:call-template>
		<xsl:variable name="nextname" select="name(following-sibling::node()[1])"/>
		<xsl:if test="position() != last() and $nextname != 'nbsp' and $nextname != '' and $nextname != '#text' and $nextname != 'sref' and $nextname != 'mref'"><xsl:text> </xsl:text></xsl:if>
	</xsl:template>

	<xsl:template match="sref" mode="full">
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@ref"/>
			<xsl:with-param name="simple" select="1"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="sref" mode="full2">
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@ref"/>
			<xsl:with-param name="simple" select="2"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="translateref">
		<xsl:param name="ref"/>
		<xsl:param name="simple"/>
		<xsl:variable name="ipcEntry" select="ancestor-or-self::ipcEntry"/>
		<xsl:variable name="root" select="substring(ancestor::references/refgroup[1]/*[1]/@ref,1,4)"/>
<!--		[<xsl:value-of select="$root"/>,<xsl:value-of select="$simple"/>,<xsl:value-of select="@ref"/>]-->
		<xsl:choose>
			<xsl:when test="$ipcEntry/@kind='i' and string-length(@ref)=4">
				<xsl:call-template name="renderSymbolNum">
					<xsl:with-param name="data"><xsl:value-of select="$ref"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$ipcEntry/@kind='i' and (not($simple) or ($simple=1 and position() != 1 and (substring(@ref,1,4) = $root)) or ($simple=2 and (substring(@ref,1,4) = $root)))">
				<xsl:call-template name="renderSymbolNum">
					<xsl:with-param name="data"><xsl:value-of select="substring($ref,5)"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="renderSymbol">
					<xsl:with-param name="data" select="$ref"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="renderSymbol">
		<xsl:param name="data"/>
		<xsl:variable name="len" select="string-length($data)"/>
		<xsl:choose>
<!--			<xsl:when test="var:getVar('subc')=substring($data,1,4)">
			</xsl:when>-->
			<xsl:when test="$len=3">
				<xsl:value-of select="substring($data,1,1)"/>
<!--				<xsl:call-template name="nbsp"/>-->
				<xsl:value-of select="substring($data,2,2)"/>
			</xsl:when>
			<xsl:when test="$len=4">
				<xsl:value-of select="substring($data,1,1)"/>
<!--				<xsl:call-template name="nbsp"/>-->
				<xsl:value-of select="substring($data,2,2)"/>
<!--				<xsl:call-template name="nbsp"/>-->
				<xsl:value-of select="substring($data,4,1)"/>
			</xsl:when>
			<xsl:when test="$len &gt; 8">
				<xsl:value-of select="substring($data,1,1)"/>
<!--				<xsl:call-template name="nbsp"/>-->
				<xsl:value-of select="substring($data,2,2)"/>
<!--				<xsl:call-template name="nbsp"/>-->
				<xsl:value-of select="substring($data,4,1)"/>
				<xsl:call-template name="nbsp"/>
				<xsl:call-template name="renderSymbolNum">
					<xsl:with-param name="data"><xsl:value-of select="substring($data,5)"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$data"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="renderSymbolNum">
		<xsl:param name="data"/>
		<xsl:choose>
			<xsl:when test="string-length($data)=4">
				<xsl:value-of select="$data"/>
			</xsl:when>
			<xsl:when test="string-length($data)=10">
				<xsl:choose>
					<xsl:when test="substring($data,1,3)='000'">
						<xsl:value-of select="substring($data,4,1)"/>
					</xsl:when>
					<xsl:when test="substring($data,1,2)='00'">
						<xsl:value-of select="substring($data,3,2)"/>
					</xsl:when>
					<xsl:when test="substring($data,1,1)='0'">
						<xsl:value-of select="substring($data,2,3)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring($data,1,4)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>/</xsl:text>
				<xsl:variable name="last" select="substring($data,5)"/>
				<xsl:choose>
					<xsl:when test="substring($last,3,4)='0000'">
						<xsl:value-of select="substring($last,1,2)"/>
					</xsl:when>
					<xsl:when test="substring($last,4,3)='000'">
						<xsl:value-of select="substring($last,1,3)"/>
					</xsl:when>
					<xsl:when test="substring($last,5,2)='00'">
						<xsl:value-of select="substring($last,1,4)"/>
					</xsl:when>
					<xsl:when test="substring($last,6,1)='0'">
						<xsl:value-of select="substring($last,1,5)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$last"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="substring($data,1,2)='00'">
						<xsl:value-of select="substring($data,3,1)"/>
					</xsl:when>
					<xsl:when test="substring($data,1,1)='0'">
						<xsl:value-of select="substring($data,2,2)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring($data,1,3)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>/</xsl:text>
				<xsl:value-of select="substring($data,4)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="gt">&gt;</xsl:template>

	<xsl:template match="lt">&lt;</xsl:template>

	<xsl:template match="ge">&#x2265;</xsl:template>

	<xsl:template match="le">&#x2264;</xsl:template>

    <xsl:template match="regist">&#xAE;</xsl:template>

    <xsl:template match="omega">&#x03A9;</xsl:template>

	<xsl:template name="nbsp" match="nbsp"><xsl:text> </xsl:text></xsl:template>

	<xsl:template match="mref">
		<xsl:variable name="name" select="name(preceding-sibling::node()[1])"/>
		<xsl:if test="position() != 1 and $name != 'nbsp' and $name != '' and $name != '#text' and $name != 'sref' and $name != 'mref'"><xsl:text> </xsl:text></xsl:if>
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@ref"/>
		</xsl:call-template>
		<xsl:text>-</xsl:text>
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@endRef"/>
		</xsl:call-template>
		<xsl:variable name="nextname" select="name(following-sibling::node()[1])"/>
<!--		[[<xsl:value-of select="$nextname"/>]]-->
		<xsl:if test="position() != last() and $nextname != 'nbsp' and $nextname != '' and $nextname != '#text' and $nextname != 'sref' and $nextname != 'mref'"><xsl:text> </xsl:text></xsl:if>
	</xsl:template>

	<xsl:template match="mref" mode="full">
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@ref"/>
			<xsl:with-param name="simple" select="1"/>
		</xsl:call-template>
		<xsl:text>-</xsl:text>
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@endRef"/>
			<xsl:with-param name="simple" select="1"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="mref" mode="full2">
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@ref"/>
			<xsl:with-param name="simple" select="2"/>
		</xsl:call-template>
		<xsl:text>-</xsl:text>
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@endRef"/>
			<xsl:with-param name="simple" select="2"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="parseSymbol">
		<xsl:call-template name="renderTabbedSymbolNum">
			<xsl:with-param name="data" select="@symbol"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="renderTabbedSymbolNum">
		<xsl:param name="data"/>
		<xsl:variable name="advanced">
			<xsl:if test="ancestor-or-self::ipcEntry[1]/@ipcLevel='A' or ancestor-or-self::ipcEntry[1]/@kind='d'">1</xsl:if>
		</xsl:variable>
		<w:r>
			<w:tab wx:wTab="195" wx:tlc="none" wx:cTlc="3"/>
			<w:t><xsl:choose>
				<xsl:when test="string-length($data)=14">
					<xsl:choose>
						<xsl:when test="substring($data,5,3)='000'">
							<xsl:value-of select="substring($data,8,1)"/>
						</xsl:when>
						<xsl:when test="substring($data,5,2)='00'">
							<xsl:value-of select="substring($data,7,2)"/>
						</xsl:when>
						<xsl:when test="substring($data,5,1)='0'">
							<xsl:value-of select="substring($data,6,3)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="substring($data,5,4)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="substring($data,5,2)='00'">
							<xsl:value-of select="substring($data,7,1)"/>
						</xsl:when>
						<xsl:when test="substring($data,5,1)='0'">
							<xsl:value-of select="substring($data,6,2)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="substring($data,5,3)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose></w:t>
		</w:r>
		<w:r>
			<w:tab wx:wTab="30" wx:tlc="none" wx:cTlc="0"/>
			<w:t>/</w:t>
		</w:r>
		<w:r>
			<w:tab wx:wTab="465" wx:tlc="none" wx:cTlc="9"/>
			<w:t><xsl:choose>
				<xsl:when test="string-length($data)=14">
					<xsl:choose>
						<xsl:when test="substring($data,11,4)='0000'">
							<xsl:value-of select="substring($data,9,2)"/>
						</xsl:when>
						<xsl:when test="substring($data,12,3)='000'">
							<xsl:value-of select="substring($data,9,3)"/>
						</xsl:when>
						<xsl:when test="substring($data,13,2)='00'">
							<xsl:value-of select="substring($data,9,4)"/>
						</xsl:when>
						<xsl:when test="substring($data,14,1)='0'">
							<xsl:value-of select="substring($data,9,5)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="substring($data,9,6)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring($data,8,2)"/>
				</xsl:otherwise>
			</xsl:choose></w:t>
		</w:r>
	</xsl:template>

	<!-- TA 20060404 management of long editions -->
	<xsl:template name="getedition">
		<xsl:param name="edition"/>
		<xsl:variable name="ed">
			<xsl:choose>
				<xsl:when test="contains($edition, ',')">
					<xsl:value-of select="substring-before($edition,',')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$edition"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$ed='19680901'">1</xsl:when>
			<xsl:when test="$ed='19740701'">2</xsl:when>
			<xsl:when test="$ed='19800101'">3</xsl:when>
			<xsl:when test="$ed='19850101'">4</xsl:when>
			<xsl:when test="$ed='19900101'">5</xsl:when>
			<xsl:when test="$ed='19950101'">6</xsl:when>
			<xsl:when test="$ed='20000101'">7</xsl:when>
			<xsl:when test="$ed='20060101'">2006.01</xsl:when>
			<xsl:when test="$ed='20090101'">2009.01</xsl:when>
			<xsl:when test="string-length($ed)=8">
				<xsl:value-of select="concat(substring($edition,1,4),'.',substring($edition,5,2))"/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$ed"/></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="contains($edition, ',')">
			<xsl:text>,&#160;</xsl:text>
			<xsl:call-template name="getedition"><xsl:with-param name="edition" select="substring-after($edition,',')"/></xsl:call-template>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>




<!-- Stylus Studio meta-information - (c) 2004-2005. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="file:///t:/wipo/class&#x2D;SC/xml/a01.xml" htmlbaseurl="" outputurl="result.xml" processortype="msxml4" useresolver="no" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="no" validator="internal" customvalidator=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition><TemplateContext></TemplateContext><MapperFilter side="source"></MapperFilter></MapperMetaTag>
</metaInformation>
-->