<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:WIPO="http://www.altova.com/MapForce/UDF/WIPO" xmlns:vmf="http://www.altova.com/MapForce/UDF/vmf" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" 
 xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:mathml="http://www.w3.org/1998/Math/MathML" xmlns:pat="http://www.wipo.int/standards/XMLSchema/ST96/Patent" exclude-result-prefixes="WIPO vmf xs fn">
	<xsl:param name="xx-patent-document-v2-32" select="'xx-patent-document-v2-3.xml'"/>
	<xsl:param name="xx-patent-document-v2-33" select="'xx-patent-document-v2-3.xml'"/>
	<xsl:param name="xx-patent-document-v2-34" select="'xx-patent-document-v2-3.xml'"/>
	<xsl:param name="xx-patent-document-v2-35" select="'xx-patent-document-v2-3.xml'"/>
	<xsl:param name="xx-patent-document-v2-36" select="'xx-patent-document-v2-3.xml'"/>
	<xsl:param name="xx-patent-document-v2-37" select="'xx-patent-document-v2-3.xml'"/>
	<xsl:template name="WIPO:ST36bio-depositToST96BioDeposit-Bib">
		<xsl:param name="biodeposit" select="()"/>
		<xsl:variable name="var3_url" as="node()?" select="$biodeposit/@url"/>
		<xsl:variable name="var4_depositary" as="node()*" select="$biodeposit/depositary"/>
		<xsl:variable name="var5_num" as="node()?" select="$biodeposit/@num"/>
		<xsl:variable name="var6_id" as="node()?" select="$biodeposit/@id"/>
		<com:BioDeposit>
			<xsl:if test="fn:exists($var6_id)">
				<xsl:attribute name="id" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string($var6_id)"/>
			</xsl:if>
			<xsl:if test="fn:exists($var5_num)">
				<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string($var5_num)"/>
			</xsl:if>
			<xsl:if test="fn:exists($var3_url)">
				<xsl:attribute name="sourceURI" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:anyURI(fn:string($var3_url)))"/>
			</xsl:if>
			<xsl:for-each select="$var4_depositary">
				<xsl:variable name="var2_address" as="node()*" select="*:address[fn:namespace-uri() eq '']"/>
				<com:BioDepositDepositary>
					<com:PostalStructuredAddress>
						<xsl:for-each select="$var2_address/*:address-1[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('1'))"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:address-2[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('2'))"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:address-3[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('3'))"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:address-4[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('5'))"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:address-5[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('4'))"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:pobox[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Postal office box'"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:room[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Room'"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:address-floor[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Floor'"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:building[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Building'"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:street[fn:namespace-uri() eq '']">
							<com:AddressLineText>
								<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Street'"/>
								<xsl:sequence select="fn:string(.)"/>
							</com:AddressLineText>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:city[fn:namespace-uri() eq '']">
							<com:CityName>
								<xsl:sequence select="fn:string(.)"/>
							</com:CityName>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:county[fn:namespace-uri() eq '']">
							<com:CountryCode>
								<xsl:sequence select="fn:string(.)"/>
							</com:CountryCode>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:postcode[fn:namespace-uri() eq '']">
							<com:PostalCode>
								<xsl:sequence select="fn:string(.)"/>
							</com:PostalCode>
						</xsl:for-each>
						<xsl:for-each select="$var2_address/*:mailcode[fn:namespace-uri() eq '']">
							<com:PostalCode>
								<xsl:sequence select="fn:string(.)"/>
							</com:PostalCode>
						</xsl:for-each>
					</com:PostalStructuredAddress>
					<xsl:for-each select="$var2_address">
						<xsl:variable name="var1_current" as="node()" select="."/>
						<xsl:for-each select="*:text[fn:namespace-uri() eq '']">
							<com:PostalAddressText>
								<xsl:for-each select="$var1_current/*:country[fn:namespace-uri() eq '']">
									<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
								</xsl:for-each>
								<xsl:sequence select="fn:string(.)"/>
							</com:PostalAddressText>
						</xsl:for-each>
					</xsl:for-each>
				</com:BioDepositDepositary>
			</xsl:for-each>
			<xsl:for-each select="$biodeposit/*:bio-accno[fn:namespace-uri() eq '']">
				<com:BiologicalAccessionNumber>
					<xsl:sequence select="fn:string(.)"/>
				</com:BiologicalAccessionNumber>
			</xsl:for-each>
			<xsl:for-each select="$biodeposit/*:date[fn:namespace-uri() eq '']">
				<com:BioDepositDate>
					<xsl:sequence select="fn:string(.)"/>
				</com:BioDepositDate>
			</xsl:for-each>
			<xsl:for-each select="$biodeposit/*:term[fn:namespace-uri() eq '']">
				<com:BioDepositTermText>
					<xsl:for-each select="$var4_depositary/*:address[fn:namespace-uri() eq '']/*:text[fn:namespace-uri() eq '']">
						<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:BioDepositTermText>
			</xsl:for-each>
			<xsl:for-each select="$biodeposit/*:dtext[fn:namespace-uri() eq '']">
				<com:BioDepositText>
					<xsl:sequence select="fn:string(.)"/>
				</com:BioDepositText>
			</xsl:for-each>
		</com:BioDeposit>
	</xsl:template>
	<xsl:template name="WIPO:ST36address-bookToST96PublicationContact">
		<xsl:param name="addressbook" select="()"/>
		<xsl:variable name="var1_address" as="node()*" select="$addressbook/address"/>
		<com:PublicationContact>
			<com:Name>
				<xsl:for-each select="$addressbook/*:last-name[fn:namespace-uri() eq '']">
					<com:PersonName>
						<com:PersonStructuredName>
							<xsl:for-each select="$addressbook/*:prefix[fn:namespace-uri() eq '']">
								<com:NamePrefix>
									<xsl:sequence select="fn:string(.)"/>
								</com:NamePrefix>
							</xsl:for-each>
							<xsl:for-each select="$addressbook/*:first-name[fn:namespace-uri() eq '']">
								<com:FirstName>
									<xsl:sequence select="fn:string(.)"/>
								</com:FirstName>
							</xsl:for-each>
							<xsl:for-each select="$addressbook/*:middle-name[fn:namespace-uri() eq '']">
								<com:MiddleName>
									<xsl:sequence select="fn:string(.)"/>
								</com:MiddleName>
							</xsl:for-each>
							<com:LastName>
								<xsl:sequence select="fn:string(.)"/>
							</com:LastName>
							<xsl:for-each select="$addressbook/*:first-last-name[fn:namespace-uri() eq '']">
								<com:FirstLastName>
									<xsl:sequence select="fn:string(.)"/>
								</com:FirstLastName>
							</xsl:for-each>
							<xsl:for-each select="$addressbook/*:second-last-name[fn:namespace-uri() eq '']">
								<com:SecondLastName>
									<xsl:sequence select="fn:string(.)"/>
								</com:SecondLastName>
							</xsl:for-each>
							<xsl:for-each select="$addressbook/*:suffix[fn:namespace-uri() eq '']">
								<com:NameSuffix>
									<xsl:sequence select="fn:string(.)"/>
								</com:NameSuffix>
							</xsl:for-each>
						</com:PersonStructuredName>
					</com:PersonName>
				</xsl:for-each>
				<xsl:for-each select="$addressbook/*:orgname[fn:namespace-uri() eq '']">
					<com:OrganizationName>
						<com:OrganizationStandardName>
							<xsl:for-each select="node()[fn:boolean(self::text())]">
								<xsl:sequence select="fn:string(.)"/>
							</xsl:for-each>
						</com:OrganizationStandardName>
					</com:OrganizationName>
				</xsl:for-each>
				<xsl:for-each select="$addressbook/*:name[fn:namespace-uri() eq '']">
					<com:EntityName>
						<xsl:sequence select="fn:string(.)"/>
					</com:EntityName>
				</xsl:for-each>
			</com:Name>
			<xsl:for-each select="$var1_address/*:city[fn:namespace-uri() eq '']">
				<com:CityName>
					<xsl:sequence select="fn:string(.)"/>
				</com:CityName>
			</xsl:for-each>
			<xsl:for-each select="$var1_address/*:state[fn:namespace-uri() eq '']">
				<com:GeographicRegionName>
					<xsl:sequence select="fn:string(.)"/>
				</com:GeographicRegionName>
			</xsl:for-each>
			<xsl:for-each select="$var1_address/*:country[fn:namespace-uri() eq '']">
				<com:CountryCode>
					<xsl:sequence select="fn:string(.)"/>
				</com:CountryCode>
			</xsl:for-each>
			<xsl:for-each select="$var1_address/*:postcode[fn:namespace-uri() eq '']">
				<com:PostalCode>
					<xsl:sequence select="fn:string(.)"/>
				</com:PostalCode>
			</xsl:for-each>
		</com:PublicationContact>
	</xsl:template>
	<xsl:template name="WIPO:ST36partiesToST96PartyBag">
		<xsl:param name="parties" select="()"/>
		<xsl:param name="assignees" select="()"/>
		<xsl:param name="examiners" select="()"/>
		<pat:PartyBag xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:m="http://www.w3.org/1998/Math/MathML" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
			<xsl:for-each select="$parties/*:applicants[fn:namespace-uri() eq '']">
				<pat:ApplicantBag>
					<xsl:for-each select="*:applicant[fn:namespace-uri() eq '']">
						<xsl:variable name="var6_designation" as="node()?" select="@designation"/>
						<xsl:variable name="var7_apptype" as="node()?" select="@app-type"/>
						<xsl:variable name="var8_sequence" as="node()?" select="@sequence"/>
						<xsl:variable name="var5_resultof_exists" as="xs:boolean" select="fn:exists($var8_sequence)"/>
						<pat:Applicant>
							<xsl:if test="$var5_resultof_exists">
								<xsl:attribute name="com:sequenceNumber" select="fn:string($var8_sequence)"/>
							</xsl:if>
							<xsl:for-each select="*:addressbook[fn:namespace-uri() eq '']">
								<xsl:variable name="var1_resultof_ST__address_bookToST__PublicationContact" as="node()?">
									<xsl:call-template name="WIPO:ST36address-bookToST96PublicationContact">
										<xsl:with-param name="addressbook" as="node()">
											<addressbook xmlns="">
												<xsl:sequence select="(./@node(), ./node())"/>
											</addressbook>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var1_resultof_ST__address_bookToST__PublicationContact">
									<com:PublicationContact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:PublicationContact>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:if test="fn:exists($var7_apptype)">
								<pat:ApplicantCategory>
									<xsl:call-template name="vmf:vmf6_inputtoresult">
										<xsl:with-param name="input" select="fn:string($var7_apptype)" as="xs:string"/>
									</xsl:call-template>
								</pat:ApplicantCategory>
							</xsl:if>
							<xsl:for-each select="*:nationality[fn:namespace-uri() eq '']/*:country[fn:namespace-uri() eq '']">
								<com:NationalityCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:NationalityCode>
							</xsl:for-each>
							<xsl:if test="fn:exists($var6_designation)">
								<xsl:variable name="var2_resultof_vmf__inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf7_inputtoresult">
										<xsl:with-param name="input" select="fn:string($var6_designation)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:if test="fn:exists($var2_resultof_vmf__inputtoresult)">
									<pat:DesignationCategory>
										<xsl:sequence select="$var2_resultof_vmf__inputtoresult"/>
									</pat:DesignationCategory>
								</xsl:if>
							</xsl:if>
							<xsl:for-each select="*:residence[fn:namespace-uri() eq '']/*:country[fn:namespace-uri() eq '']">
								<com:ResidenceCountryCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:ResidenceCountryCode>
							</xsl:for-each>
							<xsl:for-each select="*:us-rights[fn:namespace-uri() eq '']">
								<xsl:variable name="var4_kind" as="node()?" select="@kind"/>
								<pat:SuccessorRights>
									<xsl:if test="$var5_resultof_exists">
										<xsl:attribute name="applicantSequenceNumberReference" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Patent" select="fn:string($var8_sequence)"/>
									</xsl:if>
									<xsl:for-each select="node()[fn:boolean(self::text())]">
										<pat:SuccessorRightsText>
											<xsl:sequence select="fn:string(.)"/>
										</pat:SuccessorRightsText>
									</xsl:for-each>
									<xsl:if test="fn:exists($var4_kind)">
										<xsl:variable name="var3_resultof_vmf__inputtoresult" as="xs:string?">
											<xsl:call-template name="vmf:vmf8_inputtoresult">
												<xsl:with-param name="input" select="fn:string($var4_kind)" as="xs:string"/>
											</xsl:call-template>
										</xsl:variable>
										<xsl:if test="fn:exists($var3_resultof_vmf__inputtoresult)">
											<pat:SuccessorCategory>
												<xsl:sequence select="$var3_resultof_vmf__inputtoresult"/>
											</pat:SuccessorCategory>
										</xsl:if>
									</xsl:if>
								</pat:SuccessorRights>
							</xsl:for-each>
						</pat:Applicant>
					</xsl:for-each>
				</pat:ApplicantBag>
			</xsl:for-each>
			<xsl:for-each select="$parties/*:inventors[fn:namespace-uri() eq '']">
				<pat:InventorBag>
					<xsl:for-each select="*:inventor[fn:namespace-uri() eq '']">
						<xsl:variable name="var12_current" as="node()" select="."/>
						<xsl:variable name="var11_sequence" as="node()?" select="@sequence"/>
						<pat:Inventor>
							<xsl:if test="fn:exists($var11_sequence)">
								<xsl:attribute name="com:sequenceNumber" select="fn:string($var11_sequence)"/>
							</xsl:if>
							<xsl:for-each select="*:addressbook[fn:namespace-uri() eq '']">
								<xsl:variable name="var9_resultof_ST__address_bookToST__PublicationContact" as="node()?">
									<xsl:call-template name="WIPO:ST36address-bookToST96PublicationContact">
										<xsl:with-param name="addressbook" as="node()">
											<addressbook xmlns="">
												<xsl:sequence select="(./@node(), ./node())"/>
											</addressbook>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var9_resultof_ST__address_bookToST__PublicationContact">
									<com:PublicationContact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:PublicationContact>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:for-each select="*:designated-states[fn:namespace-uri() eq '']">
								<xsl:variable name="var10_designation" as="node()?" select="$var12_current/@designation"/>
								<pat:StateDesignation>
									<xsl:if test="fn:exists($var10_designation)">
										<pat:NewDesignationCountryCode>
											<xsl:sequence select="fn:string($var10_designation)"/>
										</pat:NewDesignationCountryCode>
									</xsl:if>
									<xsl:for-each select="*:country[fn:namespace-uri() eq '']">
										<pat:NationalDesignation>
											<com:DesignatedCountryCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:DesignatedCountryCode>
										</pat:NationalDesignation>
									</xsl:for-each>
									<xsl:for-each select="*:region[fn:namespace-uri() eq '']">
										<pat:RegionalDesignation>
											<xsl:for-each select="*:country[fn:namespace-uri() eq '']">
												<com:DesignatedCountryCode>
													<xsl:sequence select="fn:string(.)"/>
												</com:DesignatedCountryCode>
											</xsl:for-each>
										</pat:RegionalDesignation>
									</xsl:for-each>
								</pat:StateDesignation>
							</xsl:for-each>
						</pat:Inventor>
					</xsl:for-each>
				</pat:InventorBag>
			</xsl:for-each>
			<pat:AssigneeBag>
				<xsl:for-each select="$assignees/*:assignee[fn:namespace-uri() eq '']">
					<pat:Assignee>
						<xsl:for-each select="*:addressbook[fn:namespace-uri() eq '']">
							<xsl:variable name="var13_resultof_ST__address_bookToST__PublicationContact" as="node()?">
								<xsl:call-template name="WIPO:ST36address-bookToST96PublicationContact">
									<xsl:with-param name="addressbook" as="node()">
										<addressbook xmlns="">
											<xsl:sequence select="(./@node(), ./node())"/>
										</addressbook>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:for-each select="$var13_resultof_ST__address_bookToST__PublicationContact">
								<com:PublicationContact>
									<xsl:sequence select="(./@node(), ./node())"/>
								</com:PublicationContact>
							</xsl:for-each>
						</xsl:for-each>
					</pat:Assignee>
				</xsl:for-each>
			</pat:AssigneeBag>
			<xsl:for-each select="$parties/*:agents[fn:namespace-uri() eq '']">
				<xsl:variable name="var18_current" as="node()" select="."/>
				<pat:RegisteredPractitionerBag>
					<xsl:for-each select="*:agent[fn:namespace-uri() eq '']">
						<xsl:variable name="var16_reptype" as="node()?" select="@rep-type"/>
						<xsl:variable name="var17_sequence" as="node()?" select="@sequence"/>
						<pat:RegisteredPractitioner>
							<xsl:if test="fn:exists($var17_sequence)">
								<xsl:attribute name="com:sequenceNumber" select="fn:string($var17_sequence)"/>
							</xsl:if>
							<xsl:for-each select="$var18_current/*:customer-number[fn:namespace-uri() eq '']">
								<pat:RegisteredPractitionerRegistrationNumber>
									<xsl:sequence select="fn:string(.)"/>
								</pat:RegisteredPractitionerRegistrationNumber>
							</xsl:for-each>
							<xsl:if test="fn:exists($var16_reptype)">
								<xsl:variable name="var14_resultof_vmf__inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf9_inputtoresult">
										<xsl:with-param name="input" select="fn:string($var16_reptype)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:if test="fn:exists($var14_resultof_vmf__inputtoresult)">
									<pat:RegisteredPractitionerCategory>
										<xsl:sequence select="$var14_resultof_vmf__inputtoresult"/>
									</pat:RegisteredPractitionerCategory>
								</xsl:if>
							</xsl:if>
							<xsl:for-each select="*:addressbook[fn:namespace-uri() eq '']">
								<xsl:variable name="var15_resultof_ST__address_bookToST__PublicationContact" as="node()?">
									<xsl:call-template name="WIPO:ST36address-bookToST96PublicationContact">
										<xsl:with-param name="addressbook" as="node()">
											<addressbook xmlns="">
												<xsl:sequence select="(./@node(), ./node())"/>
											</addressbook>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var15_resultof_ST__address_bookToST__PublicationContact">
									<com:PublicationContact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:PublicationContact>
								</xsl:for-each>
							</xsl:for-each>
						</pat:RegisteredPractitioner>
					</xsl:for-each>
				</pat:RegisteredPractitionerBag>
			</xsl:for-each>
			<pat:ExaminerBag>
				<xsl:for-each select="$examiners/*:primary-examiner[fn:namespace-uri() eq '']">
					<xsl:variable name="var21_resultof_filter" as="node()*" select="*:name[fn:namespace-uri() eq ''][fn:exists(@name-type)]"/>
					<pat:PrimaryExaminer>
						<com:Name>
							<com:PersonName>
								<xsl:for-each select="$var21_resultof_filter[(fn:string(@name-type) = 'natural')]">
									<com:PersonFullName>
										<xsl:sequence select="fn:string(.)"/>
									</com:PersonFullName>
								</xsl:for-each>
								<com:PersonStructuredName>
									<xsl:for-each select="*:prefix[fn:namespace-uri() eq '']">
										<com:NamePrefix>
											<xsl:sequence select="fn:string(.)"/>
										</com:NamePrefix>
									</xsl:for-each>
									<xsl:for-each select="*:first-name[fn:namespace-uri() eq '']">
										<com:FirstName>
											<xsl:sequence select="fn:string(.)"/>
										</com:FirstName>
									</xsl:for-each>
									<xsl:for-each select="*:middle-name[fn:namespace-uri() eq '']">
										<com:MiddleName>
											<xsl:sequence select="fn:string(.)"/>
										</com:MiddleName>
									</xsl:for-each>
									<xsl:for-each select="*:last-name[fn:namespace-uri() eq '']">
										<com:LastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:LastName>
									</xsl:for-each>
									<xsl:for-each select="*:first-last-name[fn:namespace-uri() eq '']">
										<com:FirstLastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:FirstLastName>
									</xsl:for-each>
									<xsl:for-each select="*:second-last-name[fn:namespace-uri() eq '']">
										<com:SecondLastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:SecondLastName>
									</xsl:for-each>
									<xsl:for-each select="*:suffix[fn:namespace-uri() eq '']">
										<com:NameSuffix>
											<xsl:sequence select="fn:string(.)"/>
										</com:NameSuffix>
									</xsl:for-each>
									<xsl:for-each select="*:synonym[fn:namespace-uri() eq '']">
										<com:PersonOtherName>
											<xsl:sequence select="fn:string(.)"/>
										</com:PersonOtherName>
									</xsl:for-each>
								</com:PersonStructuredName>
							</com:PersonName>
							<xsl:for-each select="*:orgname[fn:namespace-uri() eq '']">
								<com:OrganizationName>
									<xsl:for-each select="$var21_resultof_filter[(fn:string(@name-type) = 'legal')]">
										<com:OrganizationStandardName>
											<xsl:sequence select="fn:string(.)"/>
										</com:OrganizationStandardName>
									</xsl:for-each>
								</com:OrganizationName>
							</xsl:for-each>
							<com:EntityName>
								<xsl:for-each select="*:role[fn:namespace-uri() eq '']">
									<xsl:attribute name="com:entityNameCategory" select="fn:string(.)"/>
								</xsl:for-each>
							</com:EntityName>
						</com:Name>
						<xsl:for-each select="*:electronic-signature[fn:namespace-uri() eq '']">
							<xsl:variable name="var19_date" as="node()?" select="@date"/>
							<xsl:variable name="var20_placesigned" as="node()?" select="@place-signed"/>
							<com:ElectronicSignature>
								<xsl:if test="fn:exists($var19_date)">
									<com:ElectronicSignatureDate>
										<xsl:sequence select="fn:string($var19_date)"/>
									</com:ElectronicSignatureDate>
								</xsl:if>
								<xsl:if test="fn:exists($var20_placesigned)">
									<com:ElectronicSignaturePlace>
										<xsl:sequence select="fn:string($var20_placesigned)"/>
									</com:ElectronicSignaturePlace>
								</xsl:if>
								<xsl:for-each select="*:basic-signature[fn:namespace-uri() eq '']">
									<com:ElectronicBasicSignature>
										<xsl:for-each select="*:fax-image[fn:namespace-uri() eq ''][fn:exists(@file)]">
											<com:ElectronicBasicSignatureImageURI>
												<xsl:sequence select="xs:string(xs:anyURI(fn:string(@file)))"/>
											</com:ElectronicBasicSignatureImageURI>
										</xsl:for-each>
										<xsl:for-each select="*:text-string[fn:namespace-uri() eq '']">
											<com:ElectronicBasicSignatureText>
												<xsl:sequence select="fn:string(.)"/>
											</com:ElectronicBasicSignatureText>
										</xsl:for-each>
										<xsl:for-each select="*:click-wrap[fn:namespace-uri() eq '']">
											<com:ElectronicBasicSignatureClickWrap>
												<xsl:sequence select="()"/>
											</com:ElectronicBasicSignatureClickWrap>
										</xsl:for-each>
									</com:ElectronicBasicSignature>
								</xsl:for-each>
								<xsl:for-each select="*:enhanced-signature[fn:namespace-uri() eq '']">
									<com:ElectronicEnhancedSignature>
										<xsl:for-each select="*:pkcs7[fn:namespace-uri() eq '']">
											<xsl:attribute name="com:pkcs7Indicator" select="()"/>
										</xsl:for-each>
									</com:ElectronicEnhancedSignature>
								</xsl:for-each>
							</com:ElectronicSignature>
						</xsl:for-each>
					</pat:PrimaryExaminer>
				</xsl:for-each>
				<xsl:for-each select="$examiners/*:assistant-examiner[fn:namespace-uri() eq '']">
					<pat:AssistantExaminer>
						<com:Name>
							<com:PersonName>
								<xsl:for-each select="*:name[fn:namespace-uri() eq ''][fn:exists(@name-type)][(fn:string(@name-type) = 'natural')]">
									<com:PersonFullName>
										<xsl:sequence select="fn:string(.)"/>
									</com:PersonFullName>
								</xsl:for-each>
								<com:PersonStructuredName>
									<xsl:for-each select="*:prefix[fn:namespace-uri() eq '']">
										<com:NamePrefix>
											<xsl:sequence select="fn:string(.)"/>
										</com:NamePrefix>
									</xsl:for-each>
									<xsl:for-each select="*:first-name[fn:namespace-uri() eq '']">
										<com:FirstName>
											<xsl:sequence select="fn:string(.)"/>
										</com:FirstName>
									</xsl:for-each>
									<xsl:for-each select="*:middle-name[fn:namespace-uri() eq '']">
										<com:MiddleName>
											<xsl:sequence select="fn:string(.)"/>
										</com:MiddleName>
									</xsl:for-each>
									<xsl:for-each select="*:last-name[fn:namespace-uri() eq '']">
										<com:LastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:LastName>
									</xsl:for-each>
									<xsl:for-each select="*:first-last-name[fn:namespace-uri() eq '']">
										<com:FirstLastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:FirstLastName>
									</xsl:for-each>
									<xsl:for-each select="*:second-last-name[fn:namespace-uri() eq '']">
										<com:SecondLastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:SecondLastName>
									</xsl:for-each>
									<xsl:for-each select="*:suffix[fn:namespace-uri() eq '']">
										<com:NameSuffix>
											<xsl:sequence select="fn:string(.)"/>
										</com:NameSuffix>
									</xsl:for-each>
									<xsl:for-each select="*:synonym[fn:namespace-uri() eq '']">
										<com:PersonOtherName>
											<xsl:sequence select="fn:string(.)"/>
										</com:PersonOtherName>
									</xsl:for-each>
								</com:PersonStructuredName>
							</com:PersonName>
							<xsl:for-each select="*:orgname[fn:namespace-uri() eq '']">
								<com:OrganizationName>
									<xsl:sequence select="()"/>
								</com:OrganizationName>
							</xsl:for-each>
							<com:EntityName>
								<xsl:for-each select="*:role[fn:namespace-uri() eq '']">
									<xsl:attribute name="com:entityNameCategory" select="fn:string(.)"/>
								</xsl:for-each>
							</com:EntityName>
						</com:Name>
						<xsl:for-each select="*:electronic-signature[fn:namespace-uri() eq '']">
							<xsl:variable name="var22_date" as="node()?" select="@date"/>
							<xsl:variable name="var23_placesigned" as="node()?" select="@place-signed"/>
							<com:ElectronicSignature>
								<xsl:if test="fn:exists($var22_date)">
									<com:ElectronicSignatureDate>
										<xsl:sequence select="fn:string($var22_date)"/>
									</com:ElectronicSignatureDate>
								</xsl:if>
								<xsl:if test="fn:exists($var23_placesigned)">
									<com:ElectronicSignaturePlace>
										<xsl:sequence select="fn:string($var23_placesigned)"/>
									</com:ElectronicSignaturePlace>
								</xsl:if>
								<xsl:for-each select="*:basic-signature[fn:namespace-uri() eq '']">
									<com:ElectronicBasicSignature>
										<xsl:for-each select="*:fax-image[fn:namespace-uri() eq ''][fn:exists(@file)]">
											<com:ElectronicBasicSignatureImageURI>
												<xsl:sequence select="xs:string(xs:anyURI(fn:string(@file)))"/>
											</com:ElectronicBasicSignatureImageURI>
										</xsl:for-each>
										<xsl:for-each select="*:text-string[fn:namespace-uri() eq '']">
											<com:ElectronicBasicSignatureText>
												<xsl:sequence select="fn:string(.)"/>
											</com:ElectronicBasicSignatureText>
										</xsl:for-each>
										<xsl:for-each select="*:click-wrap[fn:namespace-uri() eq '']">
											<com:ElectronicBasicSignatureClickWrap>
												<xsl:sequence select="()"/>
											</com:ElectronicBasicSignatureClickWrap>
										</xsl:for-each>
									</com:ElectronicBasicSignature>
								</xsl:for-each>
								<xsl:for-each select="*:enhanced-signature[fn:namespace-uri() eq '']">
									<com:ElectronicEnhancedSignature>
										<xsl:for-each select="*:pkcs7[fn:namespace-uri() eq '']">
											<xsl:attribute name="com:pkcs7Indicator" select="()"/>
										</xsl:for-each>
									</com:ElectronicEnhancedSignature>
								</xsl:for-each>
							</com:ElectronicSignature>
						</xsl:for-each>
					</pat:AssistantExaminer>
				</xsl:for-each>
				<xsl:for-each select="$examiners/*:authorized-officer[fn:namespace-uri() eq '']">
					<pat:AuthorizedOfficer>
						<com:Name>
							<com:PersonName>
								<xsl:for-each select="*:name[fn:namespace-uri() eq ''][fn:exists(@name-type)][(fn:string(@name-type) = 'natural')]">
									<com:PersonFullName>
										<xsl:sequence select="fn:string(.)"/>
									</com:PersonFullName>
								</xsl:for-each>
								<com:PersonStructuredName>
									<xsl:for-each select="*:prefix[fn:namespace-uri() eq '']">
										<com:NamePrefix>
											<xsl:sequence select="fn:string(.)"/>
										</com:NamePrefix>
									</xsl:for-each>
									<xsl:for-each select="*:first-name[fn:namespace-uri() eq '']">
										<com:FirstName>
											<xsl:sequence select="fn:string(.)"/>
										</com:FirstName>
									</xsl:for-each>
									<xsl:for-each select="*:middle-name[fn:namespace-uri() eq '']">
										<com:MiddleName>
											<xsl:sequence select="fn:string(.)"/>
										</com:MiddleName>
									</xsl:for-each>
									<xsl:for-each select="*:last-name[fn:namespace-uri() eq '']">
										<com:LastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:LastName>
									</xsl:for-each>
									<xsl:for-each select="*:first-last-name[fn:namespace-uri() eq '']">
										<com:FirstLastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:FirstLastName>
									</xsl:for-each>
									<xsl:for-each select="*:second-last-name[fn:namespace-uri() eq '']">
										<com:SecondLastName>
											<xsl:sequence select="fn:string(.)"/>
										</com:SecondLastName>
									</xsl:for-each>
									<xsl:for-each select="*:suffix[fn:namespace-uri() eq '']">
										<com:NameSuffix>
											<xsl:sequence select="fn:string(.)"/>
										</com:NameSuffix>
									</xsl:for-each>
									<xsl:for-each select="*:synonym[fn:namespace-uri() eq '']">
										<com:PersonOtherName>
											<xsl:sequence select="fn:string(.)"/>
										</com:PersonOtherName>
									</xsl:for-each>
								</com:PersonStructuredName>
							</com:PersonName>
							<xsl:for-each select="*:orgname[fn:namespace-uri() eq '']">
								<com:OrganizationName>
									<xsl:sequence select="()"/>
								</com:OrganizationName>
							</xsl:for-each>
							<com:EntityName>
								<xsl:for-each select="*:role[fn:namespace-uri() eq '']">
									<xsl:attribute name="com:entityNameCategory" select="fn:string(.)"/>
								</xsl:for-each>
							</com:EntityName>
						</com:Name>
						<xsl:for-each select="*:phone[fn:namespace-uri() eq '']">
							<com:PhoneNumber>
								<xsl:sequence select="fn:string(.)"/>
							</com:PhoneNumber>
						</xsl:for-each>
						<xsl:for-each select="*:fax[fn:namespace-uri() eq '']">
							<com:FaxNumber>
								<xsl:sequence select="fn:string(.)"/>
							</com:FaxNumber>
						</xsl:for-each>
						<xsl:for-each select="*:email[fn:namespace-uri() eq '']">
							<com:EmailAddressText>
								<xsl:sequence select="fn:string(.)"/>
							</com:EmailAddressText>
						</xsl:for-each>
						<xsl:for-each select="*:electronic-signature[fn:namespace-uri() eq '']">
							<xsl:variable name="var24_date" as="node()?" select="@date"/>
							<xsl:variable name="var25_placesigned" as="node()?" select="@place-signed"/>
							<com:ElectronicSignature>
								<xsl:if test="fn:exists($var24_date)">
									<com:ElectronicSignatureDate>
										<xsl:sequence select="fn:string($var24_date)"/>
									</com:ElectronicSignatureDate>
								</xsl:if>
								<xsl:if test="fn:exists($var25_placesigned)">
									<com:ElectronicSignaturePlace>
										<xsl:sequence select="fn:string($var25_placesigned)"/>
									</com:ElectronicSignaturePlace>
								</xsl:if>
								<xsl:for-each select="*:basic-signature[fn:namespace-uri() eq '']">
									<com:ElectronicBasicSignature>
										<xsl:for-each select="*:fax-image[fn:namespace-uri() eq ''][fn:exists(@file)]">
											<com:ElectronicBasicSignatureImageURI>
												<xsl:sequence select="xs:string(xs:anyURI(fn:string(@file)))"/>
											</com:ElectronicBasicSignatureImageURI>
										</xsl:for-each>
										<xsl:for-each select="*:text-string[fn:namespace-uri() eq '']">
											<com:ElectronicBasicSignatureText>
												<xsl:sequence select="fn:string(.)"/>
											</com:ElectronicBasicSignatureText>
										</xsl:for-each>
										<xsl:for-each select="*:click-wrap[fn:namespace-uri() eq '']">
											<com:ElectronicBasicSignatureClickWrap>
												<xsl:sequence select="()"/>
											</com:ElectronicBasicSignatureClickWrap>
										</xsl:for-each>
									</com:ElectronicBasicSignature>
								</xsl:for-each>
								<xsl:for-each select="*:enhanced-signature[fn:namespace-uri() eq '']">
									<com:ElectronicEnhancedSignature>
										<xsl:for-each select="*:pkcs7[fn:namespace-uri() eq '']">
											<xsl:attribute name="com:pkcs7Indicator" select="()"/>
										</xsl:for-each>
									</com:ElectronicEnhancedSignature>
								</xsl:for-each>
							</com:ElectronicSignature>
						</xsl:for-each>
					</pat:AuthorizedOfficer>
				</xsl:for-each>
			</pat:ExaminerBag>
			<xsl:for-each select="$parties/*:correspondence-address[fn:namespace-uri() eq '']">
				<com:CorrespondenceAddress>
					<xsl:for-each select="*:customer-number[fn:namespace-uri() eq '']">
						<com:PartyIdentifier>
							<xsl:sequence select="fn:string(.)"/>
						</com:PartyIdentifier>
					</xsl:for-each>
					<xsl:for-each select="*:addressbook[fn:namespace-uri() eq '']">
						<xsl:variable name="var26_resultof_ST__address_bookToST__contact" as="node()?">
							<xsl:call-template name="WIPO:ST36address-bookToST96contact">
								<xsl:with-param name="addressbook" as="node()">
									<addressbook xmlns="">
										<xsl:sequence select="(./@node(), ./node())"/>
									</addressbook>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var26_resultof_ST__address_bookToST__contact">
							<com:Contact>
								<xsl:sequence select="(./@node(), ./node())"/>
							</com:Contact>
						</xsl:for-each>
					</xsl:for-each>
				</com:CorrespondenceAddress>
			</xsl:for-each>
		</pat:PartyBag>
	</xsl:template>
	<xsl:template name="WIPO:ST36address-bookToST96contact">
		<xsl:param name="addressbook" select="()"/>
		<xsl:variable name="var3_ead" as="node()*" select="$addressbook/ead"/>
		<xsl:variable name="var4_lang" as="node()?" select="$addressbook/@lang"/>
		<com:Contact>
			<xsl:if test="fn:exists($var4_lang)">
				<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string($var4_lang)"/>
			</xsl:if>
			<com:Name>
				<xsl:for-each select="$addressbook/*:last-name[fn:namespace-uri() eq '']">
					<com:PersonName>
						<com:PersonStructuredName>
							<xsl:for-each select="$addressbook/*:prefix[fn:namespace-uri() eq '']">
								<com:NamePrefix>
									<xsl:sequence select="fn:string(.)"/>
								</com:NamePrefix>
							</xsl:for-each>
							<xsl:for-each select="$addressbook/*:first-name[fn:namespace-uri() eq '']">
								<com:FirstName>
									<xsl:sequence select="fn:string(.)"/>
								</com:FirstName>
							</xsl:for-each>
							<xsl:for-each select="$addressbook/*:middle-name[fn:namespace-uri() eq '']">
								<com:MiddleName>
									<xsl:sequence select="fn:string(.)"/>
								</com:MiddleName>
							</xsl:for-each>
							<com:LastName>
								<xsl:sequence select="fn:string(.)"/>
							</com:LastName>
							<xsl:for-each select="$addressbook/*:first-last-name[fn:namespace-uri() eq '']">
								<com:FirstLastName>
									<xsl:sequence select="fn:string(.)"/>
								</com:FirstLastName>
							</xsl:for-each>
							<xsl:for-each select="$addressbook/*:second-last-name[fn:namespace-uri() eq '']">
								<com:SecondLastName>
									<xsl:sequence select="fn:string(.)"/>
								</com:SecondLastName>
							</xsl:for-each>
							<xsl:for-each select="$addressbook/*:suffix[fn:namespace-uri() eq '']">
								<com:NameSuffix>
									<xsl:sequence select="fn:string(.)"/>
								</com:NameSuffix>
							</xsl:for-each>
						</com:PersonStructuredName>
					</com:PersonName>
				</xsl:for-each>
				<xsl:for-each select="$addressbook/*:orgname[fn:namespace-uri() eq '']">
					<com:OrganizationName>
						<com:OrganizationStandardName>
							<xsl:for-each select="node()[fn:boolean(self::text())]">
								<xsl:sequence select="fn:string(.)"/>
							</xsl:for-each>
						</com:OrganizationStandardName>
					</com:OrganizationName>
				</xsl:for-each>
				<xsl:for-each select="$addressbook/*:name[fn:namespace-uri() eq '']">
					<com:EntityName>
						<xsl:for-each select="$addressbook/*:role[fn:namespace-uri() eq '']">
							<xsl:attribute name="entityNameCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
						</xsl:for-each>
						<xsl:sequence select="fn:string(.)"/>
					</com:EntityName>
				</xsl:for-each>
			</com:Name>
			<com:PostalAddressBag>
				<xsl:for-each select="$addressbook/*:address[fn:namespace-uri() eq '']">
					<com:PostalAddress>
						<com:PostalStructuredAddress>
							<xsl:for-each select="*:address-1[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('1'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:address-4[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('4'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:address-2[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('2'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:address-3[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('3'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:address-5[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:decimal('5'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:pobox[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Postal office box'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:room[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Room'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:address-floor[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Floor'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:building[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Building'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:street[fn:namespace-uri() eq '']">
								<com:AddressLineText>
									<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Street'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="*:city[fn:namespace-uri() eq '']">
								<com:CityName>
									<xsl:sequence select="fn:string(.)"/>
								</com:CityName>
							</xsl:for-each>
							<xsl:for-each select="*:county[fn:namespace-uri() eq '']">
								<com:GeographicRegionName>
									<xsl:attribute name="geographicRegionCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'County'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:GeographicRegionName>
							</xsl:for-each>
							<xsl:for-each select="*:state[fn:namespace-uri() eq '']">
								<com:GeographicRegionName>
									<xsl:attribute name="geographicRegionCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'State'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:GeographicRegionName>
							</xsl:for-each>
							<xsl:for-each select="*:country[fn:namespace-uri() eq '']">
								<com:CountryCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:CountryCode>
							</xsl:for-each>
							<xsl:for-each select="*:mailcode[fn:namespace-uri() eq '']">
								<com:PostalCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:PostalCode>
							</xsl:for-each>
							<xsl:for-each select="*:postcode[fn:namespace-uri() eq '']">
								<com:PostalCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:PostalCode>
							</xsl:for-each>
						</com:PostalStructuredAddress>
						<xsl:for-each select="*:text[fn:namespace-uri() eq '']">
							<com:PostalAddressText>
								<xsl:sequence select="fn:string(.)"/>
							</com:PostalAddressText>
						</xsl:for-each>
					</com:PostalAddress>
				</xsl:for-each>
			</com:PostalAddressBag>
			<xsl:for-each select="$addressbook/*:fax[fn:namespace-uri() eq '']">
				<com:FaxNumberBag>
					<com:FaxNumber>
						<xsl:sequence select="fn:string(.)"/>
					</com:FaxNumber>
				</com:FaxNumberBag>
			</xsl:for-each>
			<xsl:for-each select="$addressbook/*:email[fn:namespace-uri() eq '']">
				<xsl:variable name="var2_emailpurpose" as="node()?" select="@email-purpose"/>
				<com:EmailAddressBag>
					<com:EmailAddressText>
						<xsl:if test="fn:exists($var2_emailpurpose)">
							<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
								<xsl:call-template name="vmf:vmf10_inputtoresult">
									<xsl:with-param name="input" select="fn:string($var2_emailpurpose)" as="xs:string"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="fn:exists($var1_resultof_vmf___inputtoresult)">
								<xsl:attribute name="emailAddressPurposeCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="$var1_resultof_vmf___inputtoresult"/>
							</xsl:if>
						</xsl:if>
						<xsl:sequence select="fn:string(.)"/>
					</com:EmailAddressText>
				</com:EmailAddressBag>
			</xsl:for-each>
			<xsl:for-each select="$addressbook/*:url[fn:namespace-uri() eq '']">
				<com:WebAddressBag>
					<com:WebAddressURI>
						<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
					</com:WebAddressURI>
				</com:WebAddressBag>
			</xsl:for-each>
			<xsl:for-each select="$addressbook/*:phone[fn:namespace-uri() eq '']">
				<com:PhoneNumberBag>
					<com:PhoneNumber>
						<xsl:for-each select="$var3_ead">
							<xsl:attribute name="phoneNumberCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
						</xsl:for-each>
						<xsl:sequence select="fn:string(.)"/>
					</com:PhoneNumber>
				</com:PhoneNumberBag>
			</xsl:for-each>
			<xsl:for-each select="$var3_ead">
				<com:OtherElectronicAddressBag>
					<xsl:sequence select="()"/>
				</com:OtherElectronicAddressBag>
			</xsl:for-each>
		</com:Contact>
	</xsl:template>
	<xsl:template name="vmf:vmf1_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='utility'">
				<xsl:copy-of select="'Utility'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf2_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='national'">
				<xsl:copy-of select="'National'"/>
			</xsl:when>
			<xsl:when test="$input='regional'">
				<xsl:copy-of select="'Regional'"/>
			</xsl:when>
			<xsl:when test="$input='international'">
				<xsl:copy-of select="'PCT'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf3_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='cited by applicant'">
				<xsl:copy-of select="'Applicant'"/>
			</xsl:when>
			<xsl:when test="$input='cited by examiner'">
				<xsl:copy-of select="'Examiner'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf4_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='yes'">
				<xsl:copy-of select="'true'"/>
			</xsl:when>
			<xsl:when test="$input='no'">
				<xsl:copy-of select="'false'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf5_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='agent'">
				<xsl:copy-of select="'Agent'"/>
			</xsl:when>
			<xsl:when test="$input='attorney'">
				<xsl:copy-of select="'Attorney'"/>
			</xsl:when>
			<xsl:when test="$input='common-representative'">
				<xsl:copy-of select="'Common representative'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf6_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='applicant-inventor'">
				<xsl:copy-of select="'Applicant_Inventor'"/>
			</xsl:when>
			<xsl:when test="$input='legal-representative'">
				<xsl:copy-of select="' '"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="'Applicant'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf7_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='all'">
				<xsl:copy-of select="'All'"/>
			</xsl:when>
			<xsl:when test="$input='all-except-us'">
				<xsl:copy-of select="'All except US'"/>
			</xsl:when>
			<xsl:when test="$input='us-only'">
				<xsl:copy-of select="'US only'"/>
			</xsl:when>
			<xsl:when test="$input='as-indicated'">
				<xsl:copy-of select="'As indicated'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf8_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='heir'">
				<xsl:copy-of select="'Heir'"/>
			</xsl:when>
			<xsl:when test="$input='heiress'">
				<xsl:copy-of select="'Heiress'"/>
			</xsl:when>
			<xsl:when test="$input='executor'">
				<xsl:copy-of select="'Executor'"/>
			</xsl:when>
			<xsl:when test="$input='executrix'">
				<xsl:copy-of select="'Executrix'"/>
			</xsl:when>
			<xsl:when test="$input='estate'">
				<xsl:copy-of select="'Estate'"/>
			</xsl:when>
			<xsl:when test="$input='legal-representative'">
				<xsl:copy-of select="'Legal representative'"/>
			</xsl:when>
			<xsl:when test="$input='administrator'">
				<xsl:copy-of select="'Administrator'"/>
			</xsl:when>
			<xsl:when test="$input='administratrix '">
				<xsl:copy-of select="'Administratrix'"/>
			</xsl:when>
			<xsl:when test="$input='legal-representatives'">
				<xsl:copy-of select="'Legal representatives'"/>
			</xsl:when>
			<xsl:when test="$input='heirs'">
				<xsl:copy-of select="'Heirs'"/>
			</xsl:when>
			<xsl:when test="$input='executors'">
				<xsl:copy-of select="'Executors'"/>
			</xsl:when>
			<xsl:when test="$input='legal-heirs'">
				<xsl:copy-of select="'Legal heirs'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf9_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='agent'">
				<xsl:copy-of select="'Agent'"/>
			</xsl:when>
			<xsl:when test="$input='attorney'">
				<xsl:copy-of select="'Attorney'"/>
			</xsl:when>
			<xsl:when test="$input='common-representative'">
				<xsl:copy-of select="'Common representative'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf10_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='informal'">
				<xsl:copy-of select="'Informal'"/>
			</xsl:when>
			<xsl:when test="$input='general'">
				<xsl:copy-of select="'General'"/>
			</xsl:when>
			<xsl:when test="$input='advanced'">
				<xsl:copy-of select="'Advanced'"/>
			</xsl:when>
			<xsl:when test="$input='main'">
				<xsl:copy-of select="'Main'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:output method="xml" encoding="UTF-8" byte-order-mark="no" indent="yes"/>
	<xsl:template match="/">
		<pat:BibliographicData xmlns:pat="http://www.wipo.int/standards/XMLSchema/ST96/Patent" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:m="http://www.w3.org/1998/Math/MathML" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
			<xsl:attribute name="xsi:schemaLocation" namespace="http://www.w3.org/2001/XMLSchema-instance" select="'http://www.wipo.int/standards/XMLSchema/ST96/Patent C:/wipo/Annex/VI/V20/ST96Schema/flattened/BibliographicData_V2_0.xsd'"/>
			<xsl:for-each select="bibliographic-data">
				<xsl:variable name="var114_current" as="node()" select="."/>
				<xsl:variable name="var112_country" as="node()?" select="@country"/>
				<xsl:variable name="var113_id" as="node()?" select="@id"/>
				<xsl:variable name="var110_resultof_first" as="node()" select="publication-reference"/>
				<xsl:variable name="var111_resultof_first" as="node()" select="application-reference"/>
				<xsl:variable name="var107_id" as="node()?" select="$var111_resultof_first/@id"/>
				<xsl:variable name="var108_id" as="node()?" select="$var110_resultof_first/@id"/>
				<xsl:variable name="var109_appltype" as="node()?" select="$var111_resultof_first/@appl-type"/>
				<xsl:variable name="var105_resultof_first" as="node()" select="$var111_resultof_first/document-id"/>
				<xsl:variable name="var106_resultof_first" as="node()" select="$var110_resultof_first/document-id"/>
				<xsl:variable name="var104_resultof_cast" as="xs:string" select="fn:string($var105_resultof_first/country)"/>
				<xsl:if test="fn:exists($var113_id)">
					<xsl:attribute name="com:id" select="fn:string($var113_id)"/>
				</xsl:if>
				<xsl:if test="fn:exists($var112_country)">
					<xsl:attribute name="com:officeCode" select="fn:string($var112_country)"/>
				</xsl:if>
				<xsl:attribute name="com:st96Version" select="'V2_0'"/>
				<pat:PatentPublicationIdentification>
					<xsl:if test="fn:exists($var108_id)">
						<xsl:attribute name="com:id" select="fn:string($var108_id)"/>
					</xsl:if>
					<com:IPOfficeCode>
						<xsl:sequence select="fn:string($var106_resultof_first/country)"/>
					</com:IPOfficeCode>
					<pat:PublicationNumber>
						<xsl:sequence select="fn:string($var106_resultof_first/doc-number)"/>
					</pat:PublicationNumber>
					<xsl:for-each select="$var106_resultof_first/kind">
						<com:PatentDocumentKindCode>
							<xsl:sequence select="fn:string(.)"/>
						</com:PatentDocumentKindCode>
					</xsl:for-each>
					<xsl:for-each select="$var106_resultof_first/date">
						<com:PublicationDate>
							<xsl:sequence select="fn:string(.)"/>
						</com:PublicationDate>
					</xsl:for-each>
				</pat:PatentPublicationIdentification>
				<pat:ApplicationIdentification>
					<xsl:if test="fn:exists($var107_id)">
						<xsl:attribute name="com:id" select="fn:string($var107_id)"/>
					</xsl:if>
					<com:IPOfficeCode>
						<xsl:sequence select="$var104_resultof_cast"/>
					</com:IPOfficeCode>
					<com:ApplicationNumber>
						<com:IPOfficeCode>
							<xsl:sequence select="$var104_resultof_cast"/>
						</com:IPOfficeCode>
						<com:ApplicationNumberText>
							<xsl:sequence select="fn:string($var105_resultof_first/doc-number)"/>
						</com:ApplicationNumberText>
					</com:ApplicationNumber>
					<xsl:if test="fn:exists($var109_appltype)">
						<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf1_inputtoresult">
								<xsl:with-param name="input" select="fn:string($var109_appltype)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:if test="fn:exists($var1_resultof_vmf__inputtoresult)">
							<pat:InventionSubjectMatterCategory>
								<xsl:sequence select="$var1_resultof_vmf__inputtoresult"/>
							</pat:InventionSubjectMatterCategory>
						</xsl:if>
					</xsl:if>
					<xsl:for-each select="$var105_resultof_first/date">
						<pat:FilingDate>
							<xsl:sequence select="fn:string(.)"/>
						</pat:FilingDate>
					</xsl:for-each>
				</pat:ApplicationIdentification>
				<xsl:for-each select="priority-claims">
					<pat:PriorityClaimBag>
						<xsl:for-each select="priority-claim">
							<xsl:variable name="var5_id" as="node()?" select="@id"/>
							<xsl:variable name="var4_resultof_vmf__inputtoresult" as="xs:string?">
								<xsl:call-template name="vmf:vmf2_inputtoresult">
									<xsl:with-param name="input" select="fn:string(@kind)" as="xs:string"/>
								</xsl:call-template>
							</xsl:variable>
							<pat:PriorityClaim>
								<xsl:if test="fn:exists($var5_id)">
									<xsl:attribute name="com:id" select="fn:string($var5_id)"/>
								</xsl:if>
								<xsl:attribute name="com:sequenceNumber" select="fn:string(@sequence)"/>
								<com:IPOfficeCode>
									<xsl:sequence select="fn:string(country)"/>
								</com:IPOfficeCode>
								<xsl:for-each select="doc-number">
									<com:ApplicationNumber>
										<xsl:for-each select="node()[fn:boolean(self::text())]">
											<com:ApplicationNumberText>
												<xsl:sequence select="fn:string(.)"/>
											</com:ApplicationNumberText>
										</xsl:for-each>
									</com:ApplicationNumber>
								</xsl:for-each>
								<pat:FilingDate>
									<xsl:sequence select="fn:string(date)"/>
								</pat:FilingDate>
								<xsl:if test="fn:exists($var4_resultof_vmf__inputtoresult)">
									<pat:ApplicationFilingCategory>
										<xsl:sequence select="$var4_resultof_vmf__inputtoresult"/>
									</pat:ApplicationFilingCategory>
								</xsl:if>
								<xsl:for-each select="priority-doc-requested">
									<pat:RequestedPriorityDocumentIndicator>
										<xsl:sequence select="()"/>
									</pat:RequestedPriorityDocumentIndicator>
								</xsl:for-each>
								<xsl:for-each select="priority-doc-attached">
									<pat:AttachedPriorityDocumentIndicator>
										<xsl:sequence select="()"/>
									</pat:AttachedPriorityDocumentIndicator>
								</xsl:for-each>
								<xsl:for-each select="priority-doc-from-library">
									<xsl:variable name="var2_libraryidentifier" as="node()?" select="@library-identifier"/>
									<xsl:variable name="var3_actionby" as="node()?" select="@action-by"/>
									<pat:OnlineAvailablePriorityDocumentIndicator>
										<xsl:if test="fn:exists($var2_libraryidentifier)">
											<xsl:attribute name="pat:libraryIdentifier" select="fn:string($var2_libraryidentifier)"/>
										</xsl:if>
										<xsl:if test="fn:exists($var3_actionby)">
											<xsl:attribute name="com:officeCode" select="fn:string($var3_actionby)"/>
										</xsl:if>
									</pat:OnlineAvailablePriorityDocumentIndicator>
								</xsl:for-each>
							</pat:PriorityClaim>
						</xsl:for-each>
					</pat:PriorityClaimBag>
				</xsl:for-each>
				<xsl:for-each select="term-of-grant">
					<pat:GrantTerm>
						<xsl:for-each select="length-of-grant">
							<pat:GrantLengthQuantity>
								<xsl:sequence select="xs:string(xs:decimal(fn:string(.)))"/>
							</pat:GrantLengthQuantity>
						</xsl:for-each>
						<xsl:for-each select="disclaimer">
							<pat:TerminalDisclaimer>
								<xsl:for-each select="date">
									<pat:DisclaimerDate>
										<xsl:sequence select="fn:string(.)"/>
									</pat:DisclaimerDate>
								</xsl:for-each>
								<xsl:for-each select="text">
									<pat:DisclaimerText>
										<xsl:sequence select="fn:string(.)"/>
									</pat:DisclaimerText>
								</xsl:for-each>
							</pat:TerminalDisclaimer>
						</xsl:for-each>
						<xsl:for-each select="lapse-of-patent">
							<pat:PatentTermLapseQuantity>
								<xsl:sequence select="()"/>
							</pat:PatentTermLapseQuantity>
						</xsl:for-each>
					</pat:GrantTerm>
				</xsl:for-each>
				<pat:PatentClassificationBag>
					<xsl:for-each select="classification-ipc">
						<xsl:variable name="var6_id" as="node()?" select="@id"/>
						<pat:IPCClassification>
							<xsl:if test="fn:exists($var6_id)">
								<xsl:attribute name="com:id" select="fn:string($var6_id)"/>
							</xsl:if>
							<com:Edition>
								<xsl:sequence select="fn:string(edition)"/>
							</com:Edition>
							<pat:MainClassification>
								<xsl:sequence select="fn:string(main-classification)"/>
							</pat:MainClassification>
							<xsl:for-each select="further-classification">
								<pat:FurtherClassification>
									<xsl:sequence select="fn:string(.)"/>
								</pat:FurtherClassification>
							</xsl:for-each>
						</pat:IPCClassification>
					</xsl:for-each>
					<xsl:for-each select="classifications-ipcr">
						<pat:IPCRClassificationBag>
							<xsl:for-each select="classification-ipcr">
								<xsl:variable name="var7_id" as="node()?" select="@id"/>
								<xsl:variable name="var8_sequence" as="node()?" select="@sequence"/>
								<pat:IPCRClassification>
									<xsl:if test="fn:exists($var7_id)">
										<xsl:attribute name="com:id" select="fn:string($var7_id)"/>
									</xsl:if>
									<xsl:if test="fn:exists($var8_sequence)">
										<xsl:attribute name="com:sequenceNumber" select="fn:string($var8_sequence)"/>
									</xsl:if>
									<xsl:for-each select="text">
										<pat:PatentClassificationText>
											<xsl:sequence select="fn:string(.)"/>
										</pat:PatentClassificationText>
									</xsl:for-each>
									<xsl:for-each select="ipc-version-indicator">
										<pat:ClassificationVersionDate>
											<xsl:sequence select="fn:string(date)"/>
										</pat:ClassificationVersionDate>
									</xsl:for-each>
									<xsl:for-each select="classification-level">
										<pat:PatentClassificationLevelCode>
											<xsl:sequence select="fn:string(.)"/>
										</pat:PatentClassificationLevelCode>
									</xsl:for-each>
									<xsl:for-each select="symbol-position">
										<com:SymbolPositionCode>
											<xsl:sequence select="fn:string(.)"/>
										</com:SymbolPositionCode>
									</xsl:for-each>
									<xsl:for-each select="classification-value">
										<pat:IPCClassificationValueCode>
											<xsl:sequence select="fn:string(.)"/>
										</pat:IPCClassificationValueCode>
									</xsl:for-each>
									<xsl:for-each select="action-date">
										<pat:ActionDate>
											<xsl:sequence select="fn:string(date)"/>
										</pat:ActionDate>
									</xsl:for-each>
									<xsl:for-each select="classification-status">
										<pat:IPCClassificationStatusCode>
											<xsl:sequence select="fn:string(.)"/>
										</pat:IPCClassificationStatusCode>
									</xsl:for-each>
									<xsl:for-each select="classification-data-source">
										<pat:PatentClassificationDataSourceCode>
											<xsl:sequence select="fn:string(.)"/>
										</pat:PatentClassificationDataSourceCode>
									</xsl:for-each>
									<xsl:for-each select="generating-office">
										<pat:GeneratingOfficeCode>
											<xsl:sequence select="fn:string(country)"/>
										</pat:GeneratingOfficeCode>
									</xsl:for-each>
									<xsl:for-each select="section">
										<pat:Section>
											<xsl:sequence select="fn:string(.)"/>
										</pat:Section>
									</xsl:for-each>
									<xsl:for-each select="class">
										<pat:Class>
											<xsl:sequence select="fn:string(.)"/>
										</pat:Class>
									</xsl:for-each>
									<xsl:for-each select="subclass">
										<pat:Subclass>
											<xsl:sequence select="fn:string(.)"/>
										</pat:Subclass>
									</xsl:for-each>
									<xsl:for-each select="main-group">
										<pat:MainGroup>
											<xsl:sequence select="fn:string(.)"/>
										</pat:MainGroup>
									</xsl:for-each>
									<xsl:for-each select="subgroup">
										<pat:Subgroup>
											<xsl:sequence select="fn:string(.)"/>
										</pat:Subgroup>
									</xsl:for-each>
								</pat:IPCRClassification>
							</xsl:for-each>
						</pat:IPCRClassificationBag>
					</xsl:for-each>
					<xsl:for-each select="classification-national">
						<xsl:variable name="var10_id" as="node()?" select="@id"/>
						<pat:NationalClassification>
							<xsl:if test="fn:exists($var10_id)">
								<xsl:attribute name="com:id" select="fn:string($var10_id)"/>
							</xsl:if>
							<com:IPOfficeCode>
								<xsl:sequence select="fn:string(country)"/>
							</com:IPOfficeCode>
							<xsl:for-each select="edition">
								<com:Edition>
									<xsl:sequence select="fn:string(.)"/>
								</com:Edition>
							</xsl:for-each>
							<pat:MainNationalClassification>
								<xsl:for-each select="(main-classification/node())[fn:boolean(self::text())]">
									<pat:PatentClassificationText>
										<xsl:sequence select="fn:string(.)"/>
									</pat:PatentClassificationText>
								</xsl:for-each>
							</pat:MainNationalClassification>
							<xsl:for-each select="further-classification">
								<xsl:variable name="var9_id" as="node()?" select="@id"/>
								<pat:FurtherNationalClassification>
									<xsl:if test="fn:exists($var9_id)">
										<xsl:attribute name="com:id" select="fn:string($var9_id)"/>
									</xsl:if>
									<xsl:for-each select="node()[fn:boolean(self::text())]">
										<pat:PatentClassificationText>
											<xsl:sequence select="fn:string(.)"/>
										</pat:PatentClassificationText>
									</xsl:for-each>
								</pat:FurtherNationalClassification>
							</xsl:for-each>
						</pat:NationalClassification>
					</xsl:for-each>
					<xsl:for-each select="classification-locarno">
						<xsl:variable name="var12_id" as="node()?" select="@id"/>
						<xsl:variable name="var11_resultof_first" as="node()" select="edition"/>
						<com:LocarnoClassificationBag>
							<xsl:if test="fn:exists($var12_id)">
								<xsl:attribute name="com:id" select="fn:string($var12_id)"/>
							</xsl:if>
							<com:LocarnoClassificationEdition>
								<xsl:sequence select="fn:string($var11_resultof_first)"/>
							</com:LocarnoClassificationEdition>
							<xsl:for-each select="($var11_resultof_first/node())[fn:boolean(self::text())]">
								<com:LocarnoClassificationDate>
									<xsl:sequence select="fn:string(.)"/>
								</com:LocarnoClassificationDate>
							</xsl:for-each>
							<com:LocarnoClassification>
								<com:LocarnoClass>
									<xsl:sequence select="fn:string(main-classification)"/>
								</com:LocarnoClass>
							</com:LocarnoClassification>
							<xsl:for-each select="text">
								<com:LocarnoClassificationText>
									<xsl:sequence select="fn:string(.)"/>
								</com:LocarnoClassificationText>
							</xsl:for-each>
						</com:LocarnoClassificationBag>
					</xsl:for-each>
				</pat:PatentClassificationBag>
				<pat:InventionTitleBag>
					<xsl:for-each select="invention-title">
						<xsl:variable name="var13_id" as="node()?" select="@id"/>
						<xsl:variable name="var14_lang" as="node()?" select="@lang"/>
						<pat:InventionTitle>
							<xsl:if test="fn:exists($var13_id)">
								<xsl:attribute name="com:id" select="fn:string($var13_id)"/>
							</xsl:if>
							<xsl:if test="fn:exists($var14_lang)">
								<xsl:attribute name="com:languageCode" select="fn:string($var14_lang)"/>
							</xsl:if>
							<xsl:for-each select="node()[fn:boolean(self::text())]">
								<xsl:sequence select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="b">
								<com:B>
									<xsl:for-each select="node()[fn:boolean(self::text())]">
										<xsl:sequence select="fn:string(.)"/>
									</xsl:for-each>
								</com:B>
							</xsl:for-each>
							<xsl:for-each select="i">
								<com:I>
									<xsl:for-each select="node()[fn:boolean(self::text())]">
										<xsl:sequence select="fn:string(.)"/>
									</xsl:for-each>
								</com:I>
							</xsl:for-each>
							<xsl:for-each select="o">
								<com:O>
									<xsl:for-each select="node()[fn:boolean(self::text())]">
										<xsl:sequence select="fn:string(.)"/>
									</xsl:for-each>
								</com:O>
							</xsl:for-each>
							<xsl:for-each select="u">
								<com:U>
									<xsl:for-each select="node()[fn:boolean(self::text())]">
										<xsl:sequence select="fn:string(.)"/>
									</xsl:for-each>
								</com:U>
							</xsl:for-each>
							<xsl:for-each select="sup">
								<com:Sub>
									<xsl:for-each select="node()[fn:boolean(self::text())]">
										<xsl:sequence select="fn:string(.)"/>
									</xsl:for-each>
								</com:Sub>
							</xsl:for-each>
							<xsl:for-each select="sub">
								<com:Sup>
									<xsl:for-each select="node()[fn:boolean(self::text())]">
										<xsl:sequence select="fn:string(.)"/>
									</xsl:for-each>
								</com:Sup>
							</xsl:for-each>
						</pat:InventionTitle>
					</xsl:for-each>
				</pat:InventionTitleBag>
				<xsl:for-each select="references-cited">
					<xsl:variable name="var26_citation" as="node()*" select="citation"/>
					<pat:ReferenceCitationBag>
						<xsl:for-each select="$var26_citation[fn:exists(@id)]">
							<xsl:attribute name="com:id" select="fn:string(@id)"/>
						</xsl:for-each>
						<xsl:for-each select="$var26_citation">
							<pat:ReferenceCitation>
								<xsl:for-each select="category">
									<xsl:variable name="var16_resultof_filter" as="node()*">
										<xsl:for-each select="node()[fn:boolean(self::text())]">
											<xsl:variable name="var15_resultof_vmf__inputtoresult" as="xs:string?">
												<xsl:call-template name="vmf:vmf3_inputtoresult">
													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
												</xsl:call-template>
											</xsl:variable>
											<xsl:if test="fn:exists($var15_resultof_vmf__inputtoresult)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:for-each>
									</xsl:variable>
									<xsl:for-each select="$var16_resultof_filter">
										<xsl:attribute name="pat:citingPartyCategory">
											<xsl:call-template name="vmf:vmf3_inputtoresult">
												<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
											</xsl:call-template>
										</xsl:attribute>
									</xsl:for-each>
								</xsl:for-each>
								<xsl:for-each select="patcit">
									<xsl:variable name="var18_id" as="node()?" select="@id"/>
									<xsl:variable name="var19_num" as="node()?" select="@num"/>
									<com:PatentCitation>
										<xsl:if test="fn:exists($var18_id)">
											<xsl:attribute name="com:id" select="fn:string($var18_id)"/>
										</xsl:if>
										<xsl:if test="fn:exists($var19_num)">
											<xsl:attribute name="com:sequenceNumber" select="fn:string($var19_num)"/>
										</xsl:if>
										<xsl:for-each select="text">
											<com:PatentCitationText>
												<xsl:sequence select="fn:string(.)"/>
											</com:PatentCitationText>
										</xsl:for-each>
										<xsl:for-each select="document-id">
											<xsl:variable name="var17_lang" as="node()?" select="@lang"/>
											<com:CitedPatentDocumentIdentification>
												<xsl:if test="fn:exists($var17_lang)">
													<xsl:attribute name="com:languageCode" select="fn:string($var17_lang)"/>
												</xsl:if>
												<com:IPOfficeCode>
													<xsl:sequence select="fn:string(country)"/>
												</com:IPOfficeCode>
												<com:DocumentNumber>
													<xsl:sequence select="fn:string(doc-number)"/>
												</com:DocumentNumber>
												<xsl:for-each select="name">
													<com:EntityName>
														<xsl:sequence select="fn:string(.)"/>
													</com:EntityName>
												</xsl:for-each>
												<xsl:for-each select="kind">
													<com:PatentDocumentKindCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:PatentDocumentKindCode>
												</xsl:for-each>
												<xsl:for-each select="date">
													<com:PatentDocumentDate>
														<xsl:sequence select="fn:string(.)"/>
													</com:PatentDocumentDate>
												</xsl:for-each>
											</com:CitedPatentDocumentIdentification>
										</xsl:for-each>
									</com:PatentCitation>
								</xsl:for-each>
								<xsl:for-each select="nplcit">
									<xsl:variable name="var20_num" as="node()?" select="@num"/>
									<xsl:variable name="var21_lang" as="node()?" select="@lang"/>
									<xsl:variable name="var22_id" as="node()?" select="@id"/>
									<com:NPLCitation>
										<xsl:if test="fn:exists($var22_id)">
											<xsl:attribute name="com:id" select="fn:string($var22_id)"/>
										</xsl:if>
										<xsl:if test="fn:exists($var21_lang)">
											<xsl:attribute name="com:languageCode" select="fn:string($var21_lang)"/>
										</xsl:if>
										<xsl:if test="fn:exists($var20_num)">
											<xsl:attribute name="com:sequenceNumber" select="fn:string($var20_num)"/>
										</xsl:if>
										<xsl:for-each select="othercit">
											<com:NPLCitationText>
												<xsl:sequence select="fn:string(.)"/>
											</com:NPLCitationText>
										</xsl:for-each>
										<xsl:for-each select="book">
											<com:CitedBook>
												<xsl:for-each select="notes">
													<com:Notes>
														<xsl:sequence select="fn:string(.)"/>
													</com:Notes>
												</xsl:for-each>
											</com:CitedBook>
										</xsl:for-each>
										<xsl:for-each select="article">
											<com:CitedJournalArticle>
												<xsl:sequence select="()"/>
											</com:CitedJournalArticle>
										</xsl:for-each>
									</com:NPLCitation>
								</xsl:for-each>
								<xsl:for-each select="rel-passage">
									<pat:CitedPassageBag>
										<pat:CitedPassage>
											<pat:PassageRangeBag>
												<xsl:for-each select="text">
													<pat:PassageRangeText>
														<xsl:sequence select="fn:string(.)"/>
													</pat:PassageRangeText>
												</xsl:for-each>
												<xsl:for-each select="passage">
													<pat:PassageRange>
														<pat:PassageRangeStart>
															<xsl:sequence select="()"/>
														</pat:PassageRangeStart>
														<xsl:for-each select="node()[fn:boolean(self::text())]">
															<pat:PassageRangeEnd>
																<xsl:sequence select="()"/>
															</pat:PassageRangeEnd>
														</xsl:for-each>
													</pat:PassageRange>
												</xsl:for-each>
											</pat:PassageRangeBag>
											<pat:PassageRelevanceBag>
												<pat:PassageRelevance>
													<xsl:for-each select="category">
														<pat:CitationCategoryCode>
															<xsl:sequence select="fn:string(.)"/>
														</pat:CitationCategoryCode>
													</xsl:for-each>
													<xsl:for-each select="rel-claims">
														<xsl:variable name="var23_resultof_filter" as="node()*" select="node()[fn:boolean(self::text())]"/>
														<pat:RelatedClaimBag>
															<pat:PatentClaimRange>
																<xsl:for-each select="$var23_resultof_filter">
																	<pat:PatentClaimStartNumber>
																		<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																	</pat:PatentClaimStartNumber>
																</xsl:for-each>
																<xsl:for-each select="$var23_resultof_filter">
																	<pat:PatentClaimEndNumber>
																		<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																	</pat:PatentClaimEndNumber>
																</xsl:for-each>
															</pat:PatentClaimRange>
														</pat:RelatedClaimBag>
													</xsl:for-each>
												</pat:PassageRelevance>
											</pat:PassageRelevanceBag>
										</pat:CitedPassage>
									</pat:CitedPassageBag>
								</xsl:for-each>
								<xsl:for-each select="classification-national">
									<xsl:variable name="var25_id" as="node()?" select="@id"/>
									<pat:PatentClassificationBag>
										<pat:NationalClassification>
											<xsl:if test="fn:exists($var25_id)">
												<xsl:attribute name="com:id" select="fn:string($var25_id)"/>
											</xsl:if>
											<com:IPOfficeCode>
												<xsl:sequence select="fn:string(country)"/>
											</com:IPOfficeCode>
											<xsl:for-each select="edition">
												<com:Edition>
													<xsl:sequence select="fn:string(.)"/>
												</com:Edition>
											</xsl:for-each>
											<pat:MainNationalClassification>
												<xsl:for-each select="(main-classification/node())[fn:boolean(self::text())]">
													<pat:PatentClassificationText>
														<xsl:sequence select="fn:string(.)"/>
													</pat:PatentClassificationText>
												</xsl:for-each>
											</pat:MainNationalClassification>
											<xsl:for-each select="further-classification">
												<xsl:variable name="var24_id" as="node()?" select="@id"/>
												<pat:FurtherNationalClassification>
													<xsl:if test="fn:exists($var24_id)">
														<xsl:attribute name="com:id" select="fn:string($var24_id)"/>
													</xsl:if>
													<xsl:for-each select="node()[fn:boolean(self::text())]">
														<pat:PatentClassificationText>
															<xsl:sequence select="fn:string(.)"/>
														</pat:PatentClassificationText>
													</xsl:for-each>
												</pat:FurtherNationalClassification>
											</xsl:for-each>
										</pat:NationalClassification>
									</pat:PatentClassificationBag>
								</xsl:for-each>
							</pat:ReferenceCitation>
						</xsl:for-each>
					</pat:ReferenceCitationBag>
				</xsl:for-each>
				<xsl:for-each select="number-of-claims">
					<pat:ClaimTotalQuantity>
						<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
					</pat:ClaimTotalQuantity>
				</xsl:for-each>
				<xsl:for-each select="field-of-search">
					<pat:SearchField>
						<pat:PatentClassificationBag>
							<xsl:for-each select="classification-ipc">
								<xsl:variable name="var27_id" as="node()?" select="@id"/>
								<pat:IPCClassification>
									<xsl:if test="fn:exists($var27_id)">
										<xsl:attribute name="com:id" select="fn:string($var27_id)"/>
									</xsl:if>
									<com:Edition>
										<xsl:sequence select="fn:string(edition)"/>
									</com:Edition>
									<pat:MainClassification>
										<xsl:sequence select="fn:string(main-classification)"/>
									</pat:MainClassification>
									<xsl:for-each select="further-classification">
										<pat:FurtherClassification>
											<xsl:sequence select="fn:string(.)"/>
										</pat:FurtherClassification>
									</xsl:for-each>
								</pat:IPCClassification>
							</xsl:for-each>
							<pat:IPCRClassificationBag>
								<xsl:for-each select="classifications-ipcr">
									<xsl:variable name="var28_id" as="node()?" select="@id"/>
									<pat:IPCRClassification>
										<xsl:if test="fn:exists($var28_id)">
											<xsl:attribute name="com:id" select="fn:string($var28_id)"/>
										</xsl:if>
									</pat:IPCRClassification>
								</xsl:for-each>
							</pat:IPCRClassificationBag>
							<xsl:for-each select="classification-national">
								<xsl:variable name="var30_id" as="node()?" select="@id"/>
								<pat:NationalClassification>
									<xsl:if test="fn:exists($var30_id)">
										<xsl:attribute name="com:id" select="fn:string($var30_id)"/>
									</xsl:if>
									<com:IPOfficeCode>
										<xsl:sequence select="fn:string(country)"/>
									</com:IPOfficeCode>
									<xsl:for-each select="edition">
										<com:Edition>
											<xsl:sequence select="fn:string(.)"/>
										</com:Edition>
									</xsl:for-each>
									<pat:MainNationalClassification>
										<xsl:for-each select="(main-classification/node())[fn:boolean(self::text())]">
											<pat:PatentClassificationText>
												<xsl:sequence select="fn:string(.)"/>
											</pat:PatentClassificationText>
										</xsl:for-each>
									</pat:MainNationalClassification>
									<xsl:for-each select="further-classification">
										<xsl:variable name="var29_id" as="node()?" select="@id"/>
										<pat:FurtherNationalClassification>
											<xsl:if test="fn:exists($var29_id)">
												<xsl:attribute name="com:id" select="fn:string($var29_id)"/>
											</xsl:if>
											<xsl:for-each select="node()[fn:boolean(self::text())]">
												<pat:PatentClassificationText>
													<xsl:sequence select="fn:string(.)"/>
												</pat:PatentClassificationText>
											</xsl:for-each>
										</pat:FurtherNationalClassification>
									</xsl:for-each>
								</pat:NationalClassification>
							</xsl:for-each>
						</pat:PatentClassificationBag>
					</pat:SearchField>
				</xsl:for-each>
				<xsl:for-each select="figures">
					<pat:FigureBag>
						<xsl:for-each select="(number-of-drawing-sheets/node())[fn:boolean(self::text())]">
							<pat:DrawingSheetTotalQuantity>
								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
							</pat:DrawingSheetTotalQuantity>
						</xsl:for-each>
						<xsl:for-each select="(number-of-figures/node())[fn:boolean(self::text())]">
							<pat:FigureTotalQuantity>
								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
							</pat:FigureTotalQuantity>
						</xsl:for-each>
						<xsl:for-each select="figure-to-publish">
							<pat:PublishFigure>
								<xsl:for-each select="(fig-number/node())[fn:boolean(self::text())]">
									<pat:FigureNumber>
										<xsl:sequence select="fn:string(.)"/>
									</pat:FigureNumber>
								</xsl:for-each>
							</pat:PublishFigure>
						</xsl:for-each>
					</pat:FigureBag>
				</xsl:for-each>
				<xsl:for-each select="related-documents">
					<pat:RelatedDocumentBag>
						<xsl:for-each select="addition">
							<xsl:variable name="var41_resultof_first" as="node()" select="relation"/>
							<xsl:variable name="var40_resultof_first" as="node()" select="$var41_resultof_first/parent-doc"/>
							<xsl:variable name="var39_parentgrantdocument" as="node()?" select="$var40_resultof_first/parent-grant-document"/>
							<xsl:variable name="var37_resultof_first" as="node()" select="$var41_resultof_first/child-doc/document-id"/>
							<xsl:variable name="var38_resultof_first" as="node()" select="$var40_resultof_first/document-id"/>
							<xsl:variable name="var36_date" as="node()?" select="$var38_resultof_first/date"/>
							<xsl:variable name="var33_resultof_cast" as="xs:string" select="fn:string($var38_resultof_first/doc-number)"/>
							<xsl:variable name="var34_resultof_cast" as="xs:string" select="fn:string($var37_resultof_first/country)"/>
							<xsl:variable name="var35_resultof_cast" as="xs:string" select="fn:string($var38_resultof_first/country)"/>
							<pat:Addition>
								<pat:ParentDocument>
									<pat:PatentDocumentIdentification>
										<pat:ApplicationIdentification>
											<com:IPOfficeCode>
												<xsl:sequence select="$var35_resultof_cast"/>
											</com:IPOfficeCode>
											<com:ApplicationNumber>
												<com:IPOfficeCode>
													<xsl:sequence select="$var35_resultof_cast"/>
												</com:IPOfficeCode>
												<com:ApplicationNumberText>
													<xsl:sequence select="$var33_resultof_cast"/>
												</com:ApplicationNumberText>
											</com:ApplicationNumber>
											<xsl:for-each select="$var36_date">
												<pat:FilingDate>
													<xsl:sequence select="fn:string(.)"/>
												</pat:FilingDate>
											</xsl:for-each>
										</pat:ApplicationIdentification>
										<pat:PatentPublicationIdentification>
											<com:IPOfficeCode>
												<xsl:sequence select="$var35_resultof_cast"/>
											</com:IPOfficeCode>
											<pat:PublicationNumber>
												<xsl:sequence select="$var33_resultof_cast"/>
											</pat:PublicationNumber>
											<xsl:for-each select="$var38_resultof_first/kind">
												<com:PatentDocumentKindCode>
													<xsl:sequence select="fn:string(.)"/>
												</com:PatentDocumentKindCode>
											</xsl:for-each>
											<xsl:for-each select="$var36_date">
												<com:PublicationDate>
													<xsl:sequence select="fn:string(.)"/>
												</com:PublicationDate>
											</xsl:for-each>
										</pat:PatentPublicationIdentification>
										<pat:PatentGrantIdentification>
											<xsl:for-each select="$var39_parentgrantdocument">
												<com:IPOfficeCode>
													<xsl:sequence select="fn:string(document-id/country)"/>
												</com:IPOfficeCode>
											</xsl:for-each>
											<xsl:for-each select="$var39_parentgrantdocument">
												<pat:PatentNumber>
													<xsl:sequence select="fn:string(document-id/doc-number)"/>
												</pat:PatentNumber>
											</xsl:for-each>
											<xsl:for-each select="$var39_parentgrantdocument/document-id/kind">
												<com:PatentDocumentKindCode>
													<xsl:sequence select="fn:string(.)"/>
												</com:PatentDocumentKindCode>
											</xsl:for-each>
											<xsl:for-each select="$var39_parentgrantdocument/document-id/date">
												<pat:GrantDate>
													<xsl:sequence select="fn:string(.)"/>
												</pat:GrantDate>
											</xsl:for-each>
										</pat:PatentGrantIdentification>
									</pat:PatentDocumentIdentification>
									<xsl:for-each select="$var40_resultof_first/parent-status">
										<pat:ParentDocumentStatusCode>
											<xsl:sequence select="fn:string(.)"/>
										</pat:ParentDocumentStatusCode>
									</xsl:for-each>
									<xsl:for-each select="$var40_resultof_first/parent-pct-document">
										<xsl:variable name="var32_resultof_first" as="node()" select="document-id"/>
										<xsl:variable name="var31_resultof_cast" as="xs:string" select="fn:string($var32_resultof_first/country)"/>
										<pat:PCTDocumentParent>
											<pat:ApplicationIdentification>
												<com:IPOfficeCode>
													<xsl:sequence select="$var31_resultof_cast"/>
												</com:IPOfficeCode>
												<com:ApplicationNumber>
													<com:IPOfficeCode>
														<xsl:sequence select="$var31_resultof_cast"/>
													</com:IPOfficeCode>
													<com:ApplicationNumberText>
														<xsl:sequence select="fn:string($var32_resultof_first/doc-number)"/>
													</com:ApplicationNumberText>
												</com:ApplicationNumber>
												<xsl:for-each select="$var32_resultof_first/date">
													<pat:FilingDate>
														<xsl:sequence select="fn:string(.)"/>
													</pat:FilingDate>
												</xsl:for-each>
											</pat:ApplicationIdentification>
										</pat:PCTDocumentParent>
									</xsl:for-each>
								</pat:ParentDocument>
								<pat:ChildDocument>
									<pat:PatentDocumentIdentification>
										<pat:ApplicationIdentification>
											<com:IPOfficeCode>
												<xsl:sequence select="$var34_resultof_cast"/>
											</com:IPOfficeCode>
											<com:ApplicationNumber>
												<com:IPOfficeCode>
													<xsl:sequence select="$var34_resultof_cast"/>
												</com:IPOfficeCode>
												<com:ApplicationNumberText>
													<xsl:sequence select="fn:string($var37_resultof_first/doc-number)"/>
												</com:ApplicationNumberText>
											</com:ApplicationNumber>
											<xsl:for-each select="$var37_resultof_first/date">
												<pat:FilingDate>
													<xsl:sequence select="fn:string(.)"/>
												</pat:FilingDate>
											</xsl:for-each>
										</pat:ApplicationIdentification>
									</pat:PatentDocumentIdentification>
								</pat:ChildDocument>
							</pat:Addition>
						</xsl:for-each>
						<xsl:for-each select="division">
							<pat:Division>
								<xsl:sequence select="()"/>
							</pat:Division>
						</xsl:for-each>
						<xsl:for-each select="continuation">
							<xsl:variable name="var44_resultof_first" as="node()" select="relation"/>
							<xsl:variable name="var42_resultof_first" as="node()" select="$var44_resultof_first/parent-doc/document-id"/>
							<xsl:variable name="var43_resultof_first" as="node()" select="$var44_resultof_first/child-doc/document-id"/>
							<pat:Continuation>
								<pat:ParentDocument>
									<pat:PatentDocumentIdentification>
										<pat:ApplicationIdentification>
											<com:IPOfficeCode>
												<xsl:sequence select="fn:string($var42_resultof_first/country)"/>
											</com:IPOfficeCode>
											<com:ApplicationNumber>
												<com:ApplicationNumberText>
													<xsl:sequence select="fn:string($var42_resultof_first/doc-number)"/>
												</com:ApplicationNumberText>
											</com:ApplicationNumber>
										</pat:ApplicationIdentification>
									</pat:PatentDocumentIdentification>
								</pat:ParentDocument>
								<pat:ChildDocument>
									<pat:PatentDocumentIdentification>
										<pat:ApplicationIdentification>
											<com:IPOfficeCode>
												<xsl:sequence select="fn:string($var43_resultof_first/country)"/>
											</com:IPOfficeCode>
											<com:ApplicationNumber>
												<com:ApplicationNumberText>
													<xsl:sequence select="fn:string($var43_resultof_first/doc-number)"/>
												</com:ApplicationNumberText>
											</com:ApplicationNumber>
										</pat:ApplicationIdentification>
									</pat:PatentDocumentIdentification>
								</pat:ChildDocument>
							</pat:Continuation>
						</xsl:for-each>
						<xsl:for-each select="continuation-in-part">
							<xsl:variable name="var49_resultof_first" as="node()" select="relation"/>
							<xsl:variable name="var48_resultof_first" as="node()" select="$var49_resultof_first/parent-doc"/>
							<xsl:variable name="var46_resultof_first" as="node()" select="$var48_resultof_first/document-id"/>
							<xsl:variable name="var47_resultof_first" as="node()" select="$var49_resultof_first/child-doc/document-id"/>
							<pat:PartialContinuation>
								<pat:ParentDocument>
									<pat:PatentDocumentIdentification>
										<pat:ApplicationIdentification>
											<com:IPOfficeCode>
												<xsl:sequence select="fn:string($var46_resultof_first/country)"/>
											</com:IPOfficeCode>
											<com:ApplicationNumber>
												<com:ApplicationNumberText>
													<xsl:sequence select="fn:string($var46_resultof_first/doc-number)"/>
												</com:ApplicationNumberText>
											</com:ApplicationNumber>
											<xsl:for-each select="$var46_resultof_first/date">
												<pat:FilingDate>
													<xsl:sequence select="fn:string(.)"/>
												</pat:FilingDate>
											</xsl:for-each>
										</pat:ApplicationIdentification>
										<xsl:for-each select="$var48_resultof_first/parent-grant-document">
											<xsl:variable name="var45_resultof_first" as="node()" select="document-id"/>
											<pat:PatentGrantIdentification>
												<com:IPOfficeCode>
													<xsl:sequence select="fn:string($var45_resultof_first/country)"/>
												</com:IPOfficeCode>
												<pat:PatentNumber>
													<xsl:sequence select="fn:string($var45_resultof_first/doc-number)"/>
												</pat:PatentNumber>
												<xsl:for-each select="$var45_resultof_first/kind">
													<com:PatentDocumentKindCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:PatentDocumentKindCode>
												</xsl:for-each>
												<xsl:for-each select="$var45_resultof_first/date">
													<pat:GrantDate>
														<xsl:sequence select="fn:string(.)"/>
													</pat:GrantDate>
												</xsl:for-each>
											</pat:PatentGrantIdentification>
										</xsl:for-each>
									</pat:PatentDocumentIdentification>
									<xsl:for-each select="$var48_resultof_first/parent-status">
										<pat:ParentDocumentStatusCode>
											<xsl:sequence select="fn:string(.)"/>
										</pat:ParentDocumentStatusCode>
									</xsl:for-each>
								</pat:ParentDocument>
								<pat:ChildDocument>
									<pat:PatentDocumentIdentification>
										<pat:ApplicationIdentification>
											<com:IPOfficeCode>
												<xsl:sequence select="fn:string($var47_resultof_first/country)"/>
											</com:IPOfficeCode>
											<com:ApplicationNumber>
												<com:ApplicationNumberText>
													<xsl:sequence select="fn:string($var47_resultof_first/doc-number)"/>
												</com:ApplicationNumberText>
											</com:ApplicationNumber>
										</pat:ApplicationIdentification>
									</pat:PatentDocumentIdentification>
								</pat:ChildDocument>
							</pat:PartialContinuation>
						</xsl:for-each>
						<xsl:for-each select="continuing-reissue">
							<pat:ContinuingReissue>
								<xsl:sequence select="()"/>
							</pat:ContinuingReissue>
						</xsl:for-each>
						<xsl:for-each select="reissue">
							<pat:Reissue>
								<xsl:sequence select="()"/>
							</pat:Reissue>
						</xsl:for-each>
						<xsl:for-each select="reexamination">
							<pat:Reexamination>
								<xsl:sequence select="()"/>
							</pat:Reexamination>
						</xsl:for-each>
						<xsl:for-each select="substitution">
							<pat:Substitution>
								<xsl:sequence select="()"/>
							</pat:Substitution>
						</xsl:for-each>
						<xsl:for-each select="utility-model-basis">
							<pat:UtilityModelBasis>
								<xsl:sequence select="()"/>
							</pat:UtilityModelBasis>
						</xsl:for-each>
						<xsl:for-each select="correction">
							<pat:Correction>
								<xsl:sequence select="()"/>
							</pat:Correction>
						</xsl:for-each>
						<xsl:for-each select="related-publication">
							<xsl:variable name="var50_resultof_first" as="node()" select="document-id"/>
							<pat:RelatedPublication>
								<xsl:for-each select="node()[fn:boolean(self::text())]">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:for-each>
								<pat:PatentDocumentIdentification>
									<pat:PatentPublicationIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="fn:string($var50_resultof_first/country)"/>
										</com:IPOfficeCode>
										<pat:PublicationNumber>
											<xsl:sequence select="fn:string($var50_resultof_first/doc-number)"/>
										</pat:PublicationNumber>
										<xsl:for-each select="$var50_resultof_first/kind">
											<com:PatentDocumentKindCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:PatentDocumentKindCode>
										</xsl:for-each>
										<xsl:for-each select="$var50_resultof_first/date">
											<com:PublicationDate>
												<xsl:sequence select="fn:string(.)"/>
											</com:PublicationDate>
										</xsl:for-each>
									</pat:PatentPublicationIdentification>
								</pat:PatentDocumentIdentification>
							</pat:RelatedPublication>
						</xsl:for-each>
					</pat:RelatedDocumentBag>
				</xsl:for-each>
				<xsl:for-each select="assignees">
					<xsl:variable name="var53_current" as="node()" select="."/>
					<xsl:for-each select="$var114_current/examiners">
						<xsl:variable name="var52_resultof_first" as="node()" select="$var114_current/parties"/>
						<xsl:variable name="var51_resultof_ST__partiesToST__PartyBag" as="node()?">
							<xsl:call-template name="WIPO:ST36partiesToST96PartyBag">
								<xsl:with-param name="parties" as="node()">
									<parties>
										<xsl:sequence select="($var52_resultof_first/@node(), $var52_resultof_first/node())"/>
									</parties>
								</xsl:with-param>
								<xsl:with-param name="assignees" as="node()">
									<assignees>
										<xsl:sequence select="($var53_current/@node(), $var53_current/node())"/>
									</assignees>
								</xsl:with-param>
								<xsl:with-param name="examiners" as="node()">
									<examiners>
										<xsl:sequence select="(./@node(), ./node())"/>
									</examiners>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var51_resultof_ST__partiesToST__PartyBag">
							<pat:PartyBag>
								<xsl:sequence select="(./@node(), ./node())"/>
							</pat:PartyBag>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="pct-or-regional-filing-data">
					<xsl:variable name="var56_resultof_first" as="node()" select="document-id"/>
					<xsl:variable name="var55_lang" as="node()?" select="$var56_resultof_first/@lang"/>
					<xsl:variable name="var54_resultof_cast" as="xs:string" select="fn:string($var56_resultof_first/country)"/>
					<pat:InternationalFilingData>
						<pat:ApplicationIdentification>
							<com:IPOfficeCode>
								<xsl:sequence select="$var54_resultof_cast"/>
							</com:IPOfficeCode>
							<com:ApplicationNumber>
								<com:IPOfficeCode>
									<xsl:sequence select="$var54_resultof_cast"/>
								</com:IPOfficeCode>
								<com:ApplicationNumberText>
									<xsl:sequence select="fn:string($var56_resultof_first/doc-number)"/>
								</com:ApplicationNumberText>
							</com:ApplicationNumber>
							<xsl:if test="fn:exists($var55_lang)">
								<com:FilingLanguageCode>
									<xsl:sequence select="fn:string($var55_lang)"/>
								</com:FilingLanguageCode>
							</xsl:if>
							<xsl:for-each select="$var56_resultof_first/date">
								<pat:FilingDate>
									<xsl:sequence select="fn:string(.)"/>
								</pat:FilingDate>
							</xsl:for-each>
						</pat:ApplicationIdentification>
						<xsl:for-each select="us-371c124-date">
							<pat:NationalStageFilingDate>
								<xsl:sequence select="fn:string(date)"/>
							</pat:NationalStageFilingDate>
						</xsl:for-each>
					</pat:InternationalFilingData>
				</xsl:for-each>
				<xsl:for-each select="pct-or-regional-publishing-data">
					<xsl:variable name="var59_resultof_first" as="node()" select="document-id"/>
					<pat:InternationalPublishingData>
						<pat:PatentDocumentIdentification>
							<pat:PatentPublicationIdentification>
								<com:IPOfficeCode>
									<xsl:sequence select="fn:string($var59_resultof_first/country)"/>
								</com:IPOfficeCode>
								<pat:PublicationNumber>
									<xsl:sequence select="fn:string($var59_resultof_first/doc-number)"/>
								</pat:PublicationNumber>
								<xsl:for-each select="$var59_resultof_first/kind">
									<com:PatentDocumentKindCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:PatentDocumentKindCode>
								</xsl:for-each>
								<xsl:for-each select="$var59_resultof_first/date">
									<com:PublicationDate>
										<xsl:sequence select="fn:string(.)"/>
									</com:PublicationDate>
								</xsl:for-each>
							</pat:PatentPublicationIdentification>
						</pat:PatentDocumentIdentification>
						<xsl:for-each select="gazette-reference">
							<xsl:variable name="var57_country" as="node()?" select="@country"/>
							<xsl:variable name="var58_id" as="node()?" select="@id"/>
							<pat:GazetteReference>
								<xsl:if test="fn:exists($var58_id)">
									<xsl:attribute name="com:id" select="fn:string($var58_id)"/>
								</xsl:if>
								<pat:GazetteNumber>
									<xsl:sequence select="fn:string(gazette-num)"/>
								</pat:GazetteNumber>
								<com:PublicationDate>
									<xsl:sequence select="fn:string(date)"/>
								</com:PublicationDate>
								<xsl:for-each select="text">
									<pat:GazetteReferenceText>
										<xsl:sequence select="fn:string(.)"/>
									</pat:GazetteReferenceText>
								</xsl:for-each>
								<xsl:if test="fn:exists($var57_country)">
									<com:IPOfficeCode>
										<xsl:sequence select="fn:string($var57_country)"/>
									</com:IPOfficeCode>
								</xsl:if>
							</pat:GazetteReference>
						</xsl:for-each>
					</pat:InternationalPublishingData>
				</xsl:for-each>
				<xsl:for-each select="patent-family">
					<xsl:variable name="var65_id" as="node()?" select="@id"/>
					<xsl:variable name="var64_resultof_first" as="node()" select="priority-application/document-id"/>
					<xsl:variable name="var63_date" as="node()?" select="$var64_resultof_first/date"/>
					<xsl:variable name="var61_resultof_cast" as="xs:string" select="fn:string($var64_resultof_first/country)"/>
					<xsl:variable name="var62_resultof_cast" as="xs:string" select="fn:string($var64_resultof_first/doc-number)"/>
					<pat:PatentFamily>
						<xsl:if test="fn:exists($var65_id)">
							<xsl:attribute name="com:id" select="fn:string($var65_id)"/>
						</xsl:if>
						<pat:PriorityApplication>
							<pat:ApplicationIdentification>
								<com:IPOfficeCode>
									<xsl:sequence select="$var61_resultof_cast"/>
								</com:IPOfficeCode>
								<com:ApplicationNumber>
									<com:IPOfficeCode>
										<xsl:sequence select="$var61_resultof_cast"/>
									</com:IPOfficeCode>
									<com:ApplicationNumberText>
										<xsl:sequence select="$var62_resultof_cast"/>
									</com:ApplicationNumberText>
								</com:ApplicationNumber>
								<xsl:for-each select="$var63_date">
									<pat:FilingDate>
										<xsl:sequence select="fn:string(.)"/>
									</pat:FilingDate>
								</xsl:for-each>
							</pat:ApplicationIdentification>
							<pat:PatentPublicationIdentification>
								<com:IPOfficeCode>
									<xsl:sequence select="$var61_resultof_cast"/>
								</com:IPOfficeCode>
								<pat:PublicationNumber>
									<xsl:sequence select="$var62_resultof_cast"/>
								</pat:PublicationNumber>
								<xsl:for-each select="$var64_resultof_first/kind">
									<com:PatentDocumentKindCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:PatentDocumentKindCode>
								</xsl:for-each>
								<xsl:for-each select="$var63_date">
									<com:PublicationDate>
										<xsl:sequence select="fn:string(.)"/>
									</com:PublicationDate>
								</xsl:for-each>
							</pat:PatentPublicationIdentification>
						</pat:PriorityApplication>
						<xsl:for-each select="family-member">
							<xsl:variable name="var60_resultof_first" as="node()" select="document-id"/>
							<pat:PatentFamilyMember>
								<pat:PatentPublicationIdentification>
									<com:IPOfficeCode>
										<xsl:sequence select="fn:string($var60_resultof_first/country)"/>
									</com:IPOfficeCode>
									<pat:PublicationNumber>
										<xsl:sequence select="fn:string($var60_resultof_first/doc-number)"/>
									</pat:PublicationNumber>
									<xsl:for-each select="$var60_resultof_first/kind">
										<com:PatentDocumentKindCode>
											<xsl:sequence select="fn:string(.)"/>
										</com:PatentDocumentKindCode>
									</xsl:for-each>
									<xsl:for-each select="$var60_resultof_first/date">
										<com:PublicationDate>
											<xsl:sequence select="fn:string(.)"/>
										</com:PublicationDate>
									</xsl:for-each>
								</pat:PatentPublicationIdentification>
							</pat:PatentFamilyMember>
						</xsl:for-each>
						<xsl:for-each select="text">
							<pat:PatentFamilyText>
								<xsl:sequence select="fn:string(.)"/>
							</pat:PatentFamilyText>
						</xsl:for-each>
					</pat:PatentFamily>
				</xsl:for-each>
				<xsl:for-each select="bio-deposit">
					<xsl:variable name="var66_resultof_ST__bio_depositToST__BioDeposit_Bib" as="node()?">
						<xsl:call-template name="WIPO:ST36bio-depositToST96BioDeposit-Bib">
							<xsl:with-param name="biodeposit" as="node()">
								<bio-deposit>
									<xsl:sequence select="(./@node(), ./node())"/>
								</bio-deposit>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var66_resultof_ST__bio_depositToST__BioDeposit_Bib">
						<com:BioDeposit>
							<xsl:sequence select="(./@node(), ./node())"/>
						</com:BioDeposit>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="plain-language-designation">
					<xsl:variable name="var67_lang" as="node()?" select="@lang"/>
					<pat:PlainLanguageDesignationText>
						<xsl:if test="fn:exists($var67_lang)">
							<xsl:attribute name="com:languageCode" select="fn:string($var67_lang)"/>
						</xsl:if>
						<xsl:sequence select="fn:string(.)"/>
					</pat:PlainLanguageDesignationText>
				</xsl:for-each>
				<xsl:for-each select="language-of-filing">
					<com:FilingLanguageCode>
						<xsl:sequence select="fn:string(.)"/>
					</com:FilingLanguageCode>
				</xsl:for-each>
				<xsl:for-each select="language-of-publication">
					<com:PublicationLanguageCode>
						<xsl:sequence select="fn:string(.)"/>
					</com:PublicationLanguageCode>
				</xsl:for-each>
				<xsl:for-each select="designation-of-states">
					<xsl:variable name="var76_resultof_first" as="node()" select="designation-pct"/>
					<xsl:variable name="var74_national" as="node()?" select="$var76_resultof_first/national"/>
					<xsl:variable name="var75_regional" as="node()*" select="$var76_resultof_first/regional"/>
					<pat:StateDesignation>
						<xsl:for-each select="$var76_resultof_first/new-designation-country">
							<pat:NewDesignationCountryCode>
								<xsl:sequence select="fn:string(.)"/>
							</pat:NewDesignationCountryCode>
						</xsl:for-each>
						<xsl:for-each select="$var75_regional">
							<pat:NationalDesignation>
								<xsl:for-each select="$var74_national/country">
									<com:DesignatedCountryCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:DesignatedCountryCode>
								</xsl:for-each>
								<xsl:for-each select="$var74_national">
									<xsl:variable name="var73_current" as="node()" select="."/>
									<xsl:for-each select="(country/node())[fn:boolean(self::text())]">
										<xsl:variable name="var72_protectionrequest" as="node()*" select="$var73_current/protection-request"/>
										<xsl:variable name="var71_resultof_map" as="node()*">
											<xsl:for-each select="$var72_protectionrequest/document-id">
												<com:IPOfficeCode>
													<xsl:sequence select="fn:string(country)"/>
												</com:IPOfficeCode>
											</xsl:for-each>
										</xsl:variable>
										<pat:ProtectionRequest>
											<xsl:variable name="var69_resultof_filter" as="node()*">
												<xsl:for-each select="$var72_protectionrequest[fn:exists(@subset)]">
													<xsl:variable name="var68_resultof_vmf__inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf4_inputtoresult">
															<xsl:with-param name="input" select="fn:string(@subset)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<xsl:if test="fn:exists($var68_resultof_vmf__inputtoresult)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:for-each>
											</xsl:variable>
											<xsl:for-each select="$var69_resultof_filter">
												<xsl:variable name="var70_resultof_first" as="xs:string">
													<xsl:call-template name="vmf:vmf4_inputtoresult">
														<xsl:with-param name="input" select="fn:string(@subset)" as="xs:string"/>
													</xsl:call-template>
												</xsl:variable>
												<xsl:attribute name="pat:subsetIndicator" select="xs:string(xs:boolean($var70_resultof_first))"/>
											</xsl:for-each>
											<xsl:for-each select="$var72_protectionrequest">
												<pat:ProtectionCategory>
													<xsl:sequence select="fn:string(kind-of-protection)"/>
												</pat:ProtectionCategory>
											</xsl:for-each>
											<pat:PatentDocumentIdentification>
												<pat:ApplicationIdentification>
													<xsl:sequence select="$var71_resultof_map"/>
													<com:ApplicationNumber>
														<xsl:sequence select="$var71_resultof_map"/>
														<xsl:for-each select="$var72_protectionrequest/document-id">
															<com:ApplicationNumberText>
																<xsl:sequence select="fn:string(doc-number)"/>
															</com:ApplicationNumberText>
														</xsl:for-each>
													</com:ApplicationNumber>
													<xsl:for-each select="$var72_protectionrequest/document-id/date">
														<pat:FilingDate>
															<xsl:sequence select="fn:string(.)"/>
														</pat:FilingDate>
													</xsl:for-each>
												</pat:ApplicationIdentification>
											</pat:PatentDocumentIdentification>
										</pat:ProtectionRequest>
									</xsl:for-each>
								</xsl:for-each>
							</pat:NationalDesignation>
						</xsl:for-each>
						<xsl:for-each select="$var74_national">
							<pat:RegionalDesignation>
								<xsl:for-each select="$var75_regional">
									<pat:RegionalOfficeCode>
										<xsl:sequence select="fn:string(region/country)"/>
									</pat:RegionalOfficeCode>
								</xsl:for-each>
								<xsl:for-each select="$var75_regional/country">
									<com:DesignatedCountryCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:DesignatedCountryCode>
								</xsl:for-each>
							</pat:RegionalDesignation>
						</xsl:for-each>
					</pat:StateDesignation>
				</xsl:for-each>
				<xsl:for-each select="licensee-data">
					<xsl:variable name="var80_resultof_first" as="node()" select="licensee/addressbook"/>
					<pat:LicenceDataBag>
						<pat:LicenceData>
							<xsl:variable name="var77_resultof_ST__address_bookToST__contact" as="node()?">
								<xsl:call-template name="WIPO:ST36address-bookToST96contact">
									<xsl:with-param name="addressbook" as="node()">
										<addressbook>
											<xsl:sequence select="($var80_resultof_first/@node(), $var80_resultof_first/node())"/>
										</addressbook>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<pat:Licensee>
								<xsl:for-each select="$var77_resultof_ST__address_bookToST__contact">
									<com:Contact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:Contact>
								</xsl:for-each>
							</pat:Licensee>
							<xsl:for-each select="attorney-or-agent">
								<xsl:variable name="var79_resultof_vmf__inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf5_inputtoresult">
										<xsl:with-param name="input" select="fn:string(@rep-type)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<pat:RegisteredPractitioner>
									<xsl:if test="fn:exists($var79_resultof_vmf__inputtoresult)">
										<pat:RegisteredPractitionerCategory>
											<xsl:sequence select="$var79_resultof_vmf__inputtoresult"/>
										</pat:RegisteredPractitionerCategory>
									</xsl:if>
									<xsl:for-each select="addressbook">
										<xsl:variable name="var78_resultof_ST__address_bookToST__contact" as="node()?">
											<xsl:call-template name="WIPO:ST36address-bookToST96contact">
												<xsl:with-param name="addressbook" as="node()">
													<addressbook>
														<xsl:sequence select="(./@node(), ./node())"/>
													</addressbook>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:for-each select="$var78_resultof_ST__address_bookToST__contact">
											<com:Contact>
												<xsl:sequence select="(./@node(), ./node())"/>
											</com:Contact>
										</xsl:for-each>
									</xsl:for-each>
								</pat:RegisteredPractitioner>
							</xsl:for-each>
							<xsl:for-each select="effective-in">
								<pat:EffectiveCountryBag>
									<xsl:for-each select="country">
										<com:CountryCode>
											<xsl:sequence select="fn:string(.)"/>
										</com:CountryCode>
									</xsl:for-each>
								</pat:EffectiveCountryBag>
							</xsl:for-each>
						</pat:LicenceData>
					</pat:LicenceDataBag>
				</xsl:for-each>
				<xsl:for-each select="date-of-earliest-priority">
					<pat:EarliestPriorityApplication>
						<pat:FilingDate>
							<xsl:sequence select="()"/>
						</pat:FilingDate>
					</pat:EarliestPriorityApplication>
				</xsl:for-each>
				<xsl:for-each select="date-complete-specification-filed">
					<pat:CompleteSpecificationFilingDate>
						<xsl:sequence select="()"/>
					</pat:CompleteSpecificationFilingDate>
				</xsl:for-each>
				<xsl:for-each select="dates-of-public-availability">
					<pat:PublicAvailabilityDateBag>
						<xsl:for-each select="gazette-reference">
							<xsl:variable name="var82_country" as="node()?" select="@country"/>
							<xsl:variable name="var83_id" as="node()?" select="@id"/>
							<xsl:variable name="var81_resultof_first" as="node()" select="gazette-num"/>
							<pat:GazetteReference>
								<xsl:if test="fn:exists($var83_id)">
									<xsl:attribute name="com:id" select="fn:string($var83_id)"/>
								</xsl:if>
								<pat:GazetteNumber>
									<xsl:sequence select="fn:string($var81_resultof_first)"/>
								</pat:GazetteNumber>
								<xsl:for-each select="($var81_resultof_first/node())[fn:boolean(self::text())]">
									<com:PublicationDate>
										<xsl:sequence select="fn:string(.)"/>
									</com:PublicationDate>
								</xsl:for-each>
								<xsl:for-each select="text">
									<pat:GazetteReferenceText>
										<xsl:sequence select="fn:string(.)"/>
									</pat:GazetteReferenceText>
								</xsl:for-each>
								<xsl:if test="fn:exists($var82_country)">
									<com:IPOfficeCode>
										<xsl:sequence select="fn:string($var82_country)"/>
									</com:IPOfficeCode>
								</xsl:if>
							</pat:GazetteReference>
						</xsl:for-each>
						<xsl:for-each select="unexamined-not-printed-without-grant">
							<xsl:variable name="var85_resultof_first" as="node()" select="document-id"/>
							<xsl:variable name="var84_resultof_cast" as="xs:string" select="fn:string($var85_resultof_first/country)"/>
							<pat:UnexaminedNoGrantNotPrintedPatentDocument>
								<pat:PatentDocumentIdentification>
									<pat:ApplicationIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="$var84_resultof_cast"/>
										</com:IPOfficeCode>
										<com:ApplicationNumber>
											<com:IPOfficeCode>
												<xsl:sequence select="$var84_resultof_cast"/>
											</com:IPOfficeCode>
											<com:ApplicationNumberText>
												<xsl:sequence select="fn:string($var85_resultof_first/doc-number)"/>
											</com:ApplicationNumberText>
										</com:ApplicationNumber>
										<xsl:for-each select="$var85_resultof_first/date">
											<pat:FilingDate>
												<xsl:sequence select="fn:string(.)"/>
											</pat:FilingDate>
										</xsl:for-each>
									</pat:ApplicationIdentification>
								</pat:PatentDocumentIdentification>
								<xsl:for-each select="text">
									<com:CommentText>
										<xsl:sequence select="fn:string(.)"/>
									</com:CommentText>
								</xsl:for-each>
							</pat:UnexaminedNoGrantNotPrintedPatentDocument>
						</xsl:for-each>
						<xsl:for-each select="examined-not-printed-without-grant">
							<xsl:variable name="var87_resultof_first" as="node()" select="document-id"/>
							<xsl:variable name="var86_resultof_cast" as="xs:string" select="fn:string($var87_resultof_first/country)"/>
							<pat:ExaminedNoGrantNotPrintedPatentDocument>
								<pat:PatentDocumentIdentification>
									<pat:ApplicationIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="$var86_resultof_cast"/>
										</com:IPOfficeCode>
										<com:ApplicationNumber>
											<com:IPOfficeCode>
												<xsl:sequence select="$var86_resultof_cast"/>
											</com:IPOfficeCode>
											<com:ApplicationNumberText>
												<xsl:sequence select="fn:string($var87_resultof_first/doc-number)"/>
											</com:ApplicationNumberText>
										</com:ApplicationNumber>
										<xsl:for-each select="$var87_resultof_first/date">
											<pat:FilingDate>
												<xsl:sequence select="fn:string(.)"/>
											</pat:FilingDate>
										</xsl:for-each>
									</pat:ApplicationIdentification>
								</pat:PatentDocumentIdentification>
								<xsl:for-each select="text">
									<com:CommentText>
										<xsl:sequence select="fn:string(.)"/>
									</com:CommentText>
								</xsl:for-each>
							</pat:ExaminedNoGrantNotPrintedPatentDocument>
						</xsl:for-each>
						<xsl:for-each select="unexamined-printed-without-grant">
							<xsl:variable name="var88_resultof_first" as="node()" select="document-id"/>
							<pat:UnexaminedNoGrantPrintedPatentDocument>
								<pat:PatentDocumentIdentification>
									<pat:PatentPublicationIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="fn:string($var88_resultof_first/country)"/>
										</com:IPOfficeCode>
										<pat:PublicationNumber>
											<xsl:sequence select="fn:string($var88_resultof_first/doc-number)"/>
										</pat:PublicationNumber>
										<xsl:for-each select="$var88_resultof_first/kind">
											<com:PatentDocumentKindCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:PatentDocumentKindCode>
										</xsl:for-each>
										<xsl:for-each select="$var88_resultof_first/date">
											<com:PublicationDate>
												<xsl:sequence select="fn:string(.)"/>
											</com:PublicationDate>
										</xsl:for-each>
									</pat:PatentPublicationIdentification>
								</pat:PatentDocumentIdentification>
								<xsl:for-each select="text">
									<com:CommentText>
										<xsl:sequence select="fn:string(.)"/>
									</com:CommentText>
								</xsl:for-each>
							</pat:UnexaminedNoGrantPrintedPatentDocument>
						</xsl:for-each>
						<xsl:for-each select="examined-printed-without-grant">
							<xsl:variable name="var89_resultof_first" as="node()" select="document-id"/>
							<pat:ExaminedNoGrantPrintedPatentDocument>
								<pat:PatentDocumentIdentification>
									<pat:PatentPublicationIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="fn:string($var89_resultof_first/country)"/>
										</com:IPOfficeCode>
										<pat:PublicationNumber>
											<xsl:sequence select="fn:string($var89_resultof_first/doc-number)"/>
										</pat:PublicationNumber>
										<xsl:for-each select="$var89_resultof_first/kind">
											<com:PatentDocumentKindCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:PatentDocumentKindCode>
										</xsl:for-each>
										<xsl:for-each select="$var89_resultof_first/date">
											<com:PublicationDate>
												<xsl:sequence select="fn:string(.)"/>
											</com:PublicationDate>
										</xsl:for-each>
									</pat:PatentPublicationIdentification>
								</pat:PatentDocumentIdentification>
								<xsl:for-each select="text">
									<com:CommentText>
										<xsl:sequence select="fn:string(.)"/>
									</com:CommentText>
								</xsl:for-each>
							</pat:ExaminedNoGrantPrintedPatentDocument>
						</xsl:for-each>
						<xsl:for-each select="claims-only-available">
							<xsl:variable name="var91_resultof_first" as="node()" select="document-id"/>
							<xsl:variable name="var90_resultof_cast" as="xs:string" select="fn:string($var91_resultof_first/country)"/>
							<pat:OnlyAvailableClaims>
								<pat:PatentDocumentIdentification>
									<pat:ApplicationIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="$var90_resultof_cast"/>
										</com:IPOfficeCode>
										<com:ApplicationNumber>
											<com:IPOfficeCode>
												<xsl:sequence select="$var90_resultof_cast"/>
											</com:IPOfficeCode>
											<com:ApplicationNumberText>
												<xsl:sequence select="fn:string($var91_resultof_first/doc-number)"/>
											</com:ApplicationNumberText>
										</com:ApplicationNumber>
										<xsl:for-each select="$var91_resultof_first/date">
											<pat:FilingDate>
												<xsl:sequence select="fn:string(.)"/>
											</pat:FilingDate>
										</xsl:for-each>
									</pat:ApplicationIdentification>
								</pat:PatentDocumentIdentification>
								<xsl:for-each select="text">
									<com:CommentText>
										<xsl:sequence select="fn:string(.)"/>
									</com:CommentText>
								</xsl:for-each>
							</pat:OnlyAvailableClaims>
						</xsl:for-each>
						<xsl:for-each select="not-printed-with-grant">
							<xsl:variable name="var92_resultof_first" as="node()" select="document-id"/>
							<pat:NotPrintedPatentGrant>
								<pat:PatentDocumentIdentification>
									<pat:PatentGrantIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="fn:string($var92_resultof_first/country)"/>
										</com:IPOfficeCode>
										<pat:PatentNumber>
											<xsl:sequence select="fn:string($var92_resultof_first/doc-number)"/>
										</pat:PatentNumber>
										<xsl:for-each select="$var92_resultof_first/kind">
											<com:PatentDocumentKindCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:PatentDocumentKindCode>
										</xsl:for-each>
										<xsl:for-each select="$var92_resultof_first/date">
											<pat:GrantDate>
												<xsl:sequence select="fn:string(.)"/>
											</pat:GrantDate>
										</xsl:for-each>
									</pat:PatentGrantIdentification>
								</pat:PatentDocumentIdentification>
							</pat:NotPrintedPatentGrant>
						</xsl:for-each>
						<xsl:for-each select="invalidation-of-patent">
							<xsl:variable name="var93_resultof_first" as="node()" select="document-id"/>
							<pat:PatentInvalidation>
								<pat:PatentDocumentIdentification>
									<pat:PatentGrantIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="fn:string($var93_resultof_first/country)"/>
										</com:IPOfficeCode>
										<pat:PatentNumber>
											<xsl:sequence select="fn:string($var93_resultof_first/doc-number)"/>
										</pat:PatentNumber>
										<xsl:for-each select="$var93_resultof_first/kind">
											<com:PatentDocumentKindCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:PatentDocumentKindCode>
										</xsl:for-each>
										<xsl:for-each select="$var93_resultof_first/date">
											<pat:GrantDate>
												<xsl:sequence select="fn:string(.)"/>
											</pat:GrantDate>
										</xsl:for-each>
									</pat:PatentGrantIdentification>
								</pat:PatentDocumentIdentification>
							</pat:PatentInvalidation>
						</xsl:for-each>
						<xsl:for-each select="printed-as-amended">
							<xsl:variable name="var94_resultof_first" as="node()" select="document-id"/>
							<pat:PrintedAsAmendedDocument>
								<pat:PatentDocumentIdentification>
									<pat:PatentPublicationIdentification>
										<com:IPOfficeCode>
											<xsl:sequence select="fn:string($var94_resultof_first/country)"/>
										</com:IPOfficeCode>
										<pat:PublicationNumber>
											<xsl:sequence select="fn:string($var94_resultof_first/doc-number)"/>
										</pat:PublicationNumber>
										<xsl:for-each select="$var94_resultof_first/kind">
											<com:PatentDocumentKindCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:PatentDocumentKindCode>
										</xsl:for-each>
										<xsl:for-each select="$var94_resultof_first/date">
											<com:PublicationDate>
												<xsl:sequence select="fn:string(.)"/>
											</com:PublicationDate>
										</xsl:for-each>
									</pat:PatentPublicationIdentification>
								</pat:PatentDocumentIdentification>
								<xsl:for-each select="text">
									<com:CommentText>
										<xsl:sequence select="fn:string(.)"/>
									</com:CommentText>
								</xsl:for-each>
							</pat:PrintedAsAmendedDocument>
						</xsl:for-each>
					</pat:PublicAvailabilityDateBag>
				</xsl:for-each>
				<xsl:for-each select="dates-rights-effective">
					<pat:RightsEffectiveDateBag>
						<xsl:for-each select="request-for-examination">
							<com:ExaminationRequestDate>
								<xsl:sequence select="fn:string(date)"/>
							</com:ExaminationRequestDate>
						</xsl:for-each>
						<xsl:for-each select="first-examination-report-despatched">
							<pat:FirstDespatchedExaminationReportDate>
								<xsl:sequence select="fn:string(date)"/>
							</pat:FirstDespatchedExaminationReportDate>
						</xsl:for-each>
						<xsl:for-each select="patent-maintained-as-amended">
							<pat:PatentMaintainedAsAmendedDate>
								<xsl:sequence select="fn:string(date)"/>
							</pat:PatentMaintainedAsAmendedDate>
						</xsl:for-each>
						<xsl:for-each select="request-for-conversion-to-national-application">
							<pat:NationalApplicationConversionRequest>
								<pat:NationalApplicationConversionRequestDate>
									<xsl:sequence select="fn:string(date)"/>
								</pat:NationalApplicationConversionRequestDate>
								<com:IPOfficeCode>
									<xsl:sequence select="fn:string(country)"/>
								</com:IPOfficeCode>
							</pat:NationalApplicationConversionRequest>
						</xsl:for-each>
						<xsl:for-each select="proceedings-suspended">
							<pat:ProceedingsSuspensionDate>
								<xsl:sequence select="fn:string(date)"/>
							</pat:ProceedingsSuspensionDate>
						</xsl:for-each>
						<xsl:for-each select="proceedings-interrupted">
							<pat:ProceedingsInterruptionDate>
								<xsl:sequence select="fn:string(date)"/>
							</pat:ProceedingsInterruptionDate>
						</xsl:for-each>
						<xsl:for-each select="proceedings-resumed">
							<pat:ProceedingsResumptionDate>
								<xsl:sequence select="fn:string(date)"/>
							</pat:ProceedingsResumptionDate>
						</xsl:for-each>
						<xsl:for-each select="notification-of-rights-after-appeal">
							<pat:AfterAppealRightsNotificationDate>
								<xsl:sequence select="fn:string(date)"/>
							</pat:AfterAppealRightsNotificationDate>
						</xsl:for-each>
						<xsl:for-each select="date-entering-into-force">
							<pat:EnteredIntoForceDate>
								<xsl:sequence select="fn:string(date)"/>
							</pat:EnteredIntoForceDate>
						</xsl:for-each>
					</pat:RightsEffectiveDateBag>
				</xsl:for-each>
				<xsl:for-each select="st50-republication">
					<xsl:variable name="var103_modifications" as="node()?" select="modifications"/>
					<xsl:variable name="var102_resultof_first" as="node()" select="correction-notice/gazette-reference"/>
					<xsl:variable name="var100_country" as="node()?" select="$var102_resultof_first/@country"/>
					<xsl:variable name="var101_id" as="node()?" select="$var102_resultof_first/@id"/>
					<pat:PatentDocumentRepublication>
						<xsl:for-each select="republication-code">
							<pat:RepublicationCategory>
								<xsl:sequence select="fn:string(.)"/>
							</pat:RepublicationCategory>
						</xsl:for-each>
						<xsl:for-each select="cancellation-date">
							<pat:RepublicationCancellationDate>
								<xsl:sequence select="fn:string(.)"/>
							</pat:RepublicationCancellationDate>
						</xsl:for-each>
						<pat:ModificationPartIdentification>
							<xsl:for-each select="$var103_modifications/modified-bibliography">
								<xsl:variable name="var95_inidcode" as="node()+" select="inid-code"/>
								<pat:ModifiedBibliography>
									<xsl:for-each select="$var95_inidcode[fn:exists(@sequence)]">
										<xsl:attribute name="com:sequenceNumber" select="fn:string(@sequence)"/>
									</xsl:for-each>
									<xsl:for-each select="$var95_inidcode">
										<pat:PatentINIDCode>
											<xsl:sequence select="fn:string(.)"/>
										</pat:PatentINIDCode>
									</xsl:for-each>
								</pat:ModifiedBibliography>
							</xsl:for-each>
							<xsl:for-each select="$var103_modifications/modified-part">
								<xsl:variable name="var96_lang" as="node()?" select="@lang"/>
								<xsl:variable name="var97_sequence" as="node()?" select="@sequence"/>
								<pat:ModifiedPartInformation>
									<xsl:if test="fn:exists($var97_sequence)">
										<xsl:attribute name="com:sequenceNumber" select="fn:string($var97_sequence)"/>
									</xsl:if>
									<xsl:if test="fn:exists($var96_lang)">
										<xsl:attribute name="com:languageCode" select="fn:string($var96_lang)"/>
									</xsl:if>
									<pat:ModifiedPartCategory>
										<xsl:sequence select="fn:string(modified-part-name)"/>
									</pat:ModifiedPartCategory>
									<xsl:for-each select="modified-item">
										<pat:ModifiedItemText>
											<xsl:sequence select="fn:string(.)"/>
										</pat:ModifiedItemText>
									</xsl:for-each>
								</pat:ModifiedPartInformation>
							</xsl:for-each>
						</pat:ModificationPartIdentification>
						<xsl:for-each select="republication-notes">
							<pat:RepublicationNoteTextBag>
								<xsl:for-each select="republication-note">
									<xsl:variable name="var98_sequence" as="node()?" select="@sequence"/>
									<xsl:variable name="var99_lang" as="node()?" select="@lang"/>
									<pat:RepublicationNoteText>
										<xsl:if test="fn:exists($var99_lang)">
											<xsl:attribute name="com:languageCode" select="fn:string($var99_lang)"/>
										</xsl:if>
										<xsl:if test="fn:exists($var98_sequence)">
											<xsl:attribute name="com:sequenceNumber" select="fn:string($var98_sequence)"/>
										</xsl:if>
										<xsl:sequence select="fn:string(.)"/>
									</pat:RepublicationNoteText>
								</xsl:for-each>
							</pat:RepublicationNoteTextBag>
						</xsl:for-each>
						<pat:GazetteReference>
							<xsl:if test="fn:exists($var101_id)">
								<xsl:attribute name="com:id" select="fn:string($var101_id)"/>
							</xsl:if>
							<pat:GazetteNumber>
								<xsl:sequence select="fn:string($var102_resultof_first/gazette-num)"/>
							</pat:GazetteNumber>
							<com:PublicationDate>
								<xsl:sequence select="fn:string($var102_resultof_first/date)"/>
							</com:PublicationDate>
							<xsl:for-each select="$var102_resultof_first/text">
								<pat:GazetteReferenceText>
									<xsl:sequence select="fn:string(.)"/>
								</pat:GazetteReferenceText>
							</xsl:for-each>
							<xsl:if test="fn:exists($var100_country)">
								<com:IPOfficeCode>
									<xsl:sequence select="fn:string($var100_country)"/>
								</com:IPOfficeCode>
							</xsl:if>
						</pat:GazetteReference>
					</pat:PatentDocumentRepublication>
				</xsl:for-each>
				<xsl:for-each select="date-exhibition-filed">
					<pat:ExhibitionFilingDate>
						<xsl:sequence select="()"/>
					</pat:ExhibitionFilingDate>
				</xsl:for-each>
				<xsl:for-each select="date-rights-reestablished">
					<pat:RightsReestablishedDate>
						<xsl:sequence select="()"/>
					</pat:RightsReestablishedDate>
				</xsl:for-each>
				<xsl:for-each select="date-application-withdrawn-by-applicant">
					<pat:ApplicationWithdrawnDate>
						<xsl:sequence select="()"/>
					</pat:ApplicationWithdrawnDate>
				</xsl:for-each>
				<xsl:for-each select="date-application-deemed-withdrawn">
					<pat:ApplicationDeemedWithdrawnDate>
						<xsl:sequence select="()"/>
					</pat:ApplicationDeemedWithdrawnDate>
				</xsl:for-each>
				<xsl:for-each select="date-of-revocation">
					<pat:PatentRevocationDate>
						<xsl:sequence select="()"/>
					</pat:PatentRevocationDate>
				</xsl:for-each>
				<xsl:for-each select="date-pct-article-22-39-fulfilled">
					<pat:PCTNationalPhaseEntryDate>
						<xsl:sequence select="fn:string(date)"/>
					</pat:PCTNationalPhaseEntryDate>
				</xsl:for-each>
				<xsl:for-each select="date-application-partially-withdrawn">
					<pat:ApplicationPartiallyWithdrawnDate>
						<xsl:sequence select="fn:string(date)"/>
					</pat:ApplicationPartiallyWithdrawnDate>
				</xsl:for-each>
				<xsl:for-each select="opposition-data">
					<pat:OppositionData>
						<xsl:sequence select="()"/>
					</pat:OppositionData>
				</xsl:for-each>
			</xsl:for-each>
		</pat:BibliographicData>
	</xsl:template>
</xsl:stylesheet>
