<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:WIPO="http://www.altova.com/MapForce/UDF/WIPO" xmlns:vmf="http://www.altova.com/MapForce/UDF/vmf"  xmlns:xlink="http://www.w3.org/1999/xlink"  xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ns0="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:ns1="http://www.wipo.int/standards/XMLSchema/ST96/Patent" exclude-result-prefixes="WIPO vmf xs fn ns0 ns1 xlink">
	<xsl:param name="BibliographicData_V2_03" select="'BibliographicData_V2_0.xml'"/>
	<xsl:param name="BibliographicData_V2_04" select="'BibliographicData_V2_0.xml'"/>
	<xsl:param name="BibliographicData_V2_05" select="'BibliographicData_V2_0.xml'"/>
	<xsl:param name="BibliographicData_V2_06" select="'BibliographicData_V2_0.xml'"/>
	<xsl:param name="BibliographicData_V2_07" select="'BibliographicData_V2_0.xml'"/>
	<xsl:template name="WIPO:ST96FigureBagToST36figures">
		<xsl:param name="FigureBag" select="()"/>
		<figures>
			<xsl:for-each select="$FigureBag/ns1:DrawingSheetTotalQuantity">
				<number-of-drawing-sheets>
					<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
				</number-of-drawing-sheets>
			</xsl:for-each>
			<xsl:for-each select="$FigureBag/ns1:FigureTotalQuantity">
				<number-of-figures>
					<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
				</number-of-figures>
			</xsl:for-each>
			<xsl:for-each select="$FigureBag/ns1:PublishFigure">
				<figure-to-publish>
					<xsl:for-each select="ns1:FigureNumber">
						<fig-number>
							<xsl:sequence select="fn:string(.)"/>
						</fig-number>
					</xsl:for-each>
				</figure-to-publish>
			</xsl:for-each>
		</figures>
	</xsl:template>
	<xsl:template name="WIPO:ST96PublicationContactToST36address-book">
		<xsl:param name="PublicationContact" select="()"/>
		<xsl:variable name="var1_Name" as="node()*" select="$PublicationContact/ns0:Name"/>
		<xsl:variable name="var2_languageCode" as="node()?" select="$PublicationContact/@ns0:languageCode"/>
		<addressbook>
			<xsl:if test="fn:exists($var2_languageCode)">
				<xsl:attribute name="lang" select="fn:string($var2_languageCode)"/>
			</xsl:if>
			<xsl:for-each select="$var1_Name/ns0:EntityName">
				<name>
					<xsl:sequence select="fn:string(.)"/>
				</name>
			</xsl:for-each>
			<xsl:for-each select="$var1_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:NamePrefix">
				<prefix>
					<xsl:sequence select="fn:string(.)"/>
				</prefix>
			</xsl:for-each>
			<xsl:for-each select="$var1_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:LastName">
				<last-name>
					<xsl:sequence select="fn:string(.)"/>
				</last-name>
			</xsl:for-each>
			<xsl:for-each select="($var1_Name/ns0:OrganizationName/ns0:OrganizationStandardName/node())[fn:boolean(self::text())]">
				<orgname>
					<xsl:sequence select="fn:string(.)"/>
				</orgname>
			</xsl:for-each>
			<xsl:for-each select="$var1_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:FirstName">
				<first-name>
					<xsl:sequence select="fn:string(.)"/>
				</first-name>
			</xsl:for-each>
			<xsl:for-each select="$var1_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:MiddleName">
				<middle-name>
					<xsl:sequence select="fn:string(.)"/>
				</middle-name>
			</xsl:for-each>
			<xsl:for-each select="$var1_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:FirstLastName">
				<first-last-name>
					<xsl:sequence select="fn:string(.)"/>
				</first-last-name>
			</xsl:for-each>
			<xsl:for-each select="$var1_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:SecondLastName">
				<second-last-name>
					<xsl:sequence select="fn:string(.)"/>
				</second-last-name>
			</xsl:for-each>
			<xsl:for-each select="$var1_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:NameSuffix">
				<suffix>
					<xsl:sequence select="fn:string(.)"/>
				</suffix>
			</xsl:for-each>
			<address>
				<city>
					<xsl:for-each select="$PublicationContact/ns0:CityName">
						<xsl:sequence select="fn:string(.)"/>
					</xsl:for-each>
				</city>
				<xsl:for-each select="$PublicationContact/ns0:GeographicRegionName">
					<state>
						<xsl:sequence select="fn:string(.)"/>
					</state>
				</xsl:for-each>
				<xsl:for-each select="$PublicationContact/ns0:PostalCode">
					<postcode>
						<xsl:sequence select="fn:string(.)"/>
					</postcode>
				</xsl:for-each>
				<xsl:for-each select="$PublicationContact/ns0:CountryCode">
					<country>
						<xsl:sequence select="fn:string(.)"/>
					</country>
				</xsl:for-each>
			</address>
		</addressbook>
	</xsl:template>
	<xsl:template name="WIPO:ST96ReferenceCitationBagToST36reference-cited">
		<xsl:param name="ReferenceCitationBagType" select="()"/>
		<references-cited>
			<xsl:for-each select="$ReferenceCitationBagType/ns1:ReferenceCitation">
				<xsl:variable name="var9_citingPartyCategory" as="node()?" select="@ns1:citingPartyCategory"/>
				<citation>
					<xsl:for-each select="ns0:PatentCitation">
						<xsl:variable name="var1_id" as="node()?" select="@ns0:id"/>
						<xsl:variable name="var2_sequenceNumber" as="node()?" select="@ns0:sequenceNumber"/>
						<patcit>
							<xsl:if test="fn:exists($var1_id)">
								<xsl:attribute name="id" select="fn:string($var1_id)"/>
							</xsl:if>
							<xsl:if test="fn:exists($var2_sequenceNumber)">
								<xsl:attribute name="num" select="fn:string($var2_sequenceNumber)"/>
							</xsl:if>
							<xsl:for-each select="ns0:PatentCitationText">
								<text>
									<xsl:sequence select="fn:string(.)"/>
								</text>
							</xsl:for-each>
							<xsl:for-each select="ns0:CitedPatentDocumentIdentification">
								<document-id>
									<xsl:for-each select="ns0:IPOfficeCode">
										<country>
											<xsl:sequence select="fn:string(.)"/>
										</country>
									</xsl:for-each>
									<xsl:for-each select="ns0:DocumentNumber">
										<doc-number>
											<xsl:sequence select="fn:string(.)"/>
										</doc-number>
									</xsl:for-each>
									<xsl:for-each select="ns0:PatentDocumentKindCode">
										<kind>
											<xsl:sequence select="fn:string(.)"/>
										</kind>
									</xsl:for-each>
									<xsl:for-each select="ns0:EntityName">
										<name>
											<xsl:sequence select="fn:string(.)"/>
										</name>
									</xsl:for-each>
									<xsl:for-each select="ns0:PatentDocumentDate">
										<date>
											<xsl:sequence select="fn:string(.)"/>
										</date>
									</xsl:for-each>
								</document-id>
							</xsl:for-each>
						</patcit>
					</xsl:for-each>
					<xsl:for-each select="ns0:NPLCitation">
						<xsl:variable name="var3_sequenceNumber" as="node()?" select="@ns0:sequenceNumber"/>
						<xsl:variable name="var4_languageCode" as="node()?" select="@ns0:languageCode"/>
						<xsl:variable name="var5_id" as="node()?" select="@ns0:id"/>
						<nplcit>
							<xsl:if test="fn:exists($var5_id)">
								<xsl:attribute name="id" select="fn:string($var5_id)"/>
							</xsl:if>
							<xsl:if test="fn:exists($var3_sequenceNumber)">
								<xsl:attribute name="num" select="fn:string($var3_sequenceNumber)"/>
							</xsl:if>
							<xsl:if test="fn:exists($var4_languageCode)">
								<xsl:attribute name="lang" select="fn:string($var4_languageCode)"/>
							</xsl:if>
							<othercit>
								<xsl:for-each select="ns0:NPLCitationText">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:for-each>
							</othercit>
						</nplcit>
					</xsl:for-each>
					<xsl:if test="fn:exists($var9_citingPartyCategory)">
						<xsl:variable name="var6_resultof_vmf__inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf7_inputtoresult">
								<xsl:with-param name="input" select="fn:string($var9_citingPartyCategory)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:if test="fn:exists($var6_resultof_vmf__inputtoresult)">
							<category>
								<xsl:sequence select="$var6_resultof_vmf__inputtoresult"/>
							</category>
						</xsl:if>
					</xsl:if>
					<xsl:for-each select="ns1:PatentClassificationBag/ns1:NationalClassification">
						<xsl:variable name="var8_id" as="node()?" select="@ns0:id"/>
						<classification-national>
							<xsl:if test="fn:exists($var8_id)">
								<xsl:attribute name="id" select="fn:string($var8_id)"/>
							</xsl:if>
							<xsl:for-each select="ns0:IPOfficeCode">
								<country>
									<xsl:sequence select="fn:string(.)"/>
								</country>
							</xsl:for-each>
							<xsl:for-each select="ns0:Edition">
								<edition>
									<xsl:sequence select="fn:string(.)"/>
								</edition>
							</xsl:for-each>
							<xsl:for-each select="ns1:MainNationalClassification">
								<main-classification>
									<xsl:for-each select="ns1:PatentClassificationText">
										<xsl:sequence select="fn:string(.)"/>
									</xsl:for-each>
								</main-classification>
							</xsl:for-each>
							<xsl:for-each select="ns1:FurtherNationalClassification">
								<xsl:variable name="var7_id" as="node()?" select="@ns0:id"/>
								<further-classification>
									<xsl:if test="fn:exists($var7_id)">
										<xsl:attribute name="id" select="fn:string($var7_id)"/>
									</xsl:if>
									<xsl:for-each select="ns1:PatentClassificationText">
										<xsl:sequence select="fn:string(.)"/>
									</xsl:for-each>
								</further-classification>
							</xsl:for-each>
						</classification-national>
					</xsl:for-each>
				</citation>
			</xsl:for-each>
		</references-cited>
	</xsl:template>
	<xsl:template name="WIPO:ST96RelatedDocumentBagToST36related-document">
		<xsl:param name="RelatedDocumentBagType" select="()"/>
		<related-documents>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:Addition">
				<addition>
					<xsl:sequence select="()"/>
				</addition>
			</xsl:for-each>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:Division">
				<division>
					<xsl:sequence select="()"/>
				</division>
			</xsl:for-each>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:Continuation">
				<continuation>
					<xsl:sequence select="()"/>
				</continuation>
			</xsl:for-each>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:PartialContinuation">
				<continuation-in-part>
					<relation>
						<xsl:for-each select="ns1:ParentDocument">
							<xsl:variable name="var1_PatentDocumentIdentification" as="node()*" select="ns1:PatentDocumentIdentification"/>
							<parent-doc>
								<xsl:for-each select="$var1_PatentDocumentIdentification/ns1:ApplicationIdentification">
									<document-id>
										<xsl:for-each select="ns0:FilingLanguageCode">
											<xsl:attribute name="lang" select="fn:string(.)"/>
										</xsl:for-each>
										<xsl:for-each select="ns0:IPOfficeCode">
											<country>
												<xsl:sequence select="fn:string(.)"/>
											</country>
										</xsl:for-each>
										<xsl:for-each select="ns0:ApplicationNumber/ns0:ApplicationNumberText">
											<doc-number>
												<xsl:sequence select="fn:string(.)"/>
											</doc-number>
										</xsl:for-each>
										<xsl:for-each select="ns1:FilingDate">
											<date>
												<xsl:sequence select="fn:string(.)"/>
											</date>
										</xsl:for-each>
									</document-id>
								</xsl:for-each>
								<parent-grant-document>
									<xsl:for-each select="$var1_PatentDocumentIdentification/ns1:PatentGrantIdentification">
										<document-id>
											<xsl:for-each select="ns0:PublicationLanguageCode">
												<xsl:attribute name="lang" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="ns0:IPOfficeCode">
												<country>
													<xsl:sequence select="fn:string(.)"/>
												</country>
											</xsl:for-each>
											<xsl:for-each select="ns1:PatentNumber">
												<doc-number>
													<xsl:sequence select="fn:string(.)"/>
												</doc-number>
											</xsl:for-each>
											<xsl:for-each select="ns0:PatentDocumentKindCode">
												<kind>
													<xsl:sequence select="fn:string(.)"/>
												</kind>
											</xsl:for-each>
											<xsl:for-each select="ns1:GrantDate">
												<date>
													<xsl:sequence select="fn:string(.)"/>
												</date>
											</xsl:for-each>
										</document-id>
									</xsl:for-each>
								</parent-grant-document>
							</parent-doc>
						</xsl:for-each>
						<xsl:for-each select="ns1:ChildDocument">
							<child-doc>
								<xsl:for-each select="ns1:PatentDocumentIdentification/ns1:ApplicationIdentification">
									<document-id>
										<xsl:for-each select="ns0:FilingLanguageCode">
											<xsl:attribute name="lang" select="fn:string(.)"/>
										</xsl:for-each>
										<xsl:for-each select="ns0:IPOfficeCode">
											<country>
												<xsl:sequence select="fn:string(.)"/>
											</country>
										</xsl:for-each>
										<xsl:for-each select="ns0:ApplicationNumber/ns0:ApplicationNumberText">
											<doc-number>
												<xsl:sequence select="fn:string(.)"/>
											</doc-number>
										</xsl:for-each>
										<xsl:for-each select="ns1:FilingDate">
											<date>
												<xsl:sequence select="fn:string(.)"/>
											</date>
										</xsl:for-each>
									</document-id>
								</xsl:for-each>
							</child-doc>
						</xsl:for-each>
					</relation>
				</continuation-in-part>
			</xsl:for-each>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:Reissue">
				<reissue>
					<xsl:sequence select="()"/>
				</reissue>
			</xsl:for-each>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:Reexamination">
				<reexamination>
					<xsl:sequence select="()"/>
				</reexamination>
			</xsl:for-each>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:Substitution">
				<substitution>
					<xsl:sequence select="()"/>
				</substitution>
			</xsl:for-each>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:Correction">
				<correction>
					<xsl:sequence select="()"/>
				</correction>
			</xsl:for-each>
			<xsl:for-each select="$RelatedDocumentBagType/ns1:RelatedPublication">
				<related-publication>
					<xsl:for-each select="node()[fn:boolean(self::text())]">
						<xsl:sequence select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="ns1:PatentDocumentIdentification/ns1:PatentPublicationIdentification">
						<document-id>
							<xsl:for-each select="ns0:PublicationLanguageCode">
								<xsl:attribute name="lang" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="ns0:IPOfficeCode">
								<country>
									<xsl:sequence select="fn:string(.)"/>
								</country>
							</xsl:for-each>
							<xsl:for-each select="ns1:PublicationNumber">
								<doc-number>
									<xsl:sequence select="fn:string(.)"/>
								</doc-number>
							</xsl:for-each>
							<xsl:for-each select="ns0:PatentDocumentKindCode">
								<kind>
									<xsl:sequence select="fn:string(.)"/>
								</kind>
							</xsl:for-each>
							<xsl:for-each select="ns0:PublicationDate">
								<date>
									<xsl:sequence select="fn:string(.)"/>
								</date>
							</xsl:for-each>
						</document-id>
					</xsl:for-each>
				</related-publication>
			</xsl:for-each>
		</related-documents>
	</xsl:template>
	<xsl:template name="WIPO:ST96NationalClassitificationToST36classification-national">
		<xsl:param name="NationalClassification" select="()"/>
		<xsl:variable name="var2_id" as="node()?" select="$NationalClassification/@ns0:id"/>
		<classification-national>
			<xsl:if test="fn:exists($var2_id)">
				<xsl:attribute name="id" select="fn:string($var2_id)"/>
			</xsl:if>
			<xsl:for-each select="$NationalClassification/ns0:IPOfficeCode">
				<country>
					<xsl:sequence select="fn:string(.)"/>
				</country>
			</xsl:for-each>
			<xsl:for-each select="$NationalClassification/ns0:Edition">
				<edition>
					<xsl:sequence select="fn:string(.)"/>
				</edition>
			</xsl:for-each>
			<xsl:for-each select="$NationalClassification/ns1:MainNationalClassification">
				<main-classification>
					<xsl:for-each select="ns1:PatentClassificationText">
						<xsl:sequence select="fn:string(.)"/>
					</xsl:for-each>
				</main-classification>
			</xsl:for-each>
			<xsl:for-each select="$NationalClassification/ns1:FurtherNationalClassification">
				<xsl:variable name="var1_id" as="node()?" select="@ns0:id"/>
				<further-classification>
					<xsl:if test="fn:exists($var1_id)">
						<xsl:attribute name="id" select="fn:string($var1_id)"/>
					</xsl:if>
					<xsl:for-each select="ns1:PatentClassificationText">
						<xsl:sequence select="fn:string(.)"/>
					</xsl:for-each>
				</further-classification>
			</xsl:for-each>
		</classification-national>
	</xsl:template>
	<xsl:template name="vmf:vmf1_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Applicant_Inventor'">
				<xsl:copy-of select="'applicant-inventor'"/>
			</xsl:when>
			<xsl:when test="$input='Applicant'">
				<xsl:copy-of select="'applicant'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf2_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='All'">
				<xsl:copy-of select="'all'"/>
			</xsl:when>
			<xsl:when test="$input='All except US'">
				<xsl:copy-of select="'all-except-us'"/>
			</xsl:when>
			<xsl:when test="$input='US only'">
				<xsl:copy-of select="'us-only'"/>
			</xsl:when>
			<xsl:when test="$input='As indicated'">
				<xsl:copy-of select="'as-indicated'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf3_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Heir'">
				<xsl:copy-of select="'heir'"/>
			</xsl:when>
			<xsl:when test="$input='Heiress'">
				<xsl:copy-of select="'heiress'"/>
			</xsl:when>
			<xsl:when test="$input='Excecutor'">
				<xsl:copy-of select="'exceutor'"/>
			</xsl:when>
			<xsl:when test="$input='Executrix'">
				<xsl:copy-of select="'executrix'"/>
			</xsl:when>
			<xsl:when test="$input='Estate'">
				<xsl:copy-of select="'estate'"/>
			</xsl:when>
			<xsl:when test="$input='Legal representative'">
				<xsl:copy-of select="'legal-representative'"/>
			</xsl:when>
			<xsl:when test="$input='Administrator'">
				<xsl:copy-of select="'administrator'"/>
			</xsl:when>
			<xsl:when test="$input='Administratrix'">
				<xsl:copy-of select="'administratrix'"/>
			</xsl:when>
			<xsl:when test="$input='Legal representatives'">
				<xsl:copy-of select="'legal representatives'"/>
			</xsl:when>
			<xsl:when test="$input='Heirs'">
				<xsl:copy-of select="'Heirs'"/>
			</xsl:when>
			<xsl:when test="$input='Executors'">
				<xsl:copy-of select="'executors'"/>
			</xsl:when>
			<xsl:when test="$input='Legal heirs'">
				<xsl:copy-of select="'legal heirs'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf4_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Agent'">
				<xsl:copy-of select="'agent'"/>
			</xsl:when>
			<xsl:when test="$input='Attorney'">
				<xsl:copy-of select="'attorney'"/>
			</xsl:when>
			<xsl:when test="$input='Legal Representative'">
				<xsl:copy-of select="'legal representative'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf5_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='true'">
				<xsl:copy-of select="'yes'"/>
			</xsl:when>
			<xsl:when test="$input='false'">
				<xsl:copy-of select="'no'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf6_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Agent'">
				<xsl:copy-of select="'agent'"/>
			</xsl:when>
			<xsl:when test="$input='Attorney'">
				<xsl:copy-of select="'attorney'"/>
			</xsl:when>
			<xsl:when test="$input='Common representative'">
				<xsl:copy-of select="'common-representative'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf7_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Applicant'">
				<xsl:copy-of select="'cited by applicant'"/>
			</xsl:when>
			<xsl:when test="$input='Examiner'">
				<xsl:copy-of select="'cited by examiner'"/>
			</xsl:when>
			<xsl:when test="$input='Opponent'">
				<xsl:copy-of select="'cited by opponent'"/>
			</xsl:when>
			<xsl:when test="$input='Third Party'">
				<xsl:copy-of select="'cited by third party'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:output method="xml" encoding="UTF-8" byte-order-mark="no" indent="yes" doctype-system="C:/wipo/Annex/VI/V20/ST36DTD/xx-patent-document-v2-3.dtd"/>
	<xsl:template match="/">
		<xsl:variable name="var40_BibliographicData" as="node()?" select="ns1:BibliographicData"/>
		<bibliographic-data>
			<xsl:for-each select="$var40_BibliographicData[fn:exists(@ns0:id)]">
				<xsl:attribute name="id" select="fn:string(@ns0:id)"/>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData[fn:exists(@ns0:officeCode)]">
				<xsl:attribute name="country" select="fn:string(@ns0:officeCode)"/>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PlainLanguageDesignationText">
				<xsl:variable name="var1_languageCode" as="node()?" select="@ns0:languageCode"/>
				<plain-language-designation>
					<xsl:if test="fn:exists($var1_languageCode)">
						<xsl:attribute name="lang" select="fn:string($var1_languageCode)"/>
					</xsl:if>
					<xsl:sequence select="fn:string(.)"/>
				</plain-language-designation>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PatentPublicationIdentification">
				<xsl:variable name="var2_id" as="node()?" select="@ns0:id"/>
				<publication-reference>
					<xsl:if test="fn:exists($var2_id)">
						<xsl:attribute name="id" select="fn:string($var2_id)"/>
					</xsl:if>
					<document-id>
						<country>
							<xsl:sequence select="fn:string(ns0:IPOfficeCode)"/>
						</country>
						<doc-number>
							<xsl:sequence select="fn:string(ns1:PublicationNumber)"/>
						</doc-number>
						<xsl:for-each select="ns0:PatentDocumentKindCode">
							<kind>
								<xsl:sequence select="fn:string(.)"/>
							</kind>
						</xsl:for-each>
						<xsl:for-each select="ns0:PublicationDate">
							<date>
								<xsl:sequence select="fn:string(.)"/>
							</date>
						</xsl:for-each>
					</document-id>
				</publication-reference>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PatentClassificationBag/ns1:IPCClassification">
				<xsl:variable name="var3_id" as="node()?" select="@ns0:id"/>
				<classification-ipc>
					<xsl:if test="fn:exists($var3_id)">
						<xsl:attribute name="id" select="fn:string($var3_id)"/>
					</xsl:if>
					<edition>
						<xsl:sequence select="fn:string(ns0:Edition)"/>
					</edition>
					<main-classification>
						<xsl:sequence select="fn:string(ns1:MainClassification)"/>
					</main-classification>
					<xsl:for-each select="ns1:FurtherClassification">
						<further-classification>
							<xsl:sequence select="fn:string(.)"/>
						</further-classification>
					</xsl:for-each>
				</classification-ipc>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PatentClassificationBag/ns1:IPCRClassificationBag">
				<classifications-ipcr>
					<xsl:for-each select="ns1:IPCRClassification">
						<xsl:variable name="var4_id" as="node()?" select="@ns0:id"/>
						<xsl:variable name="var5_sequenceNumber" as="node()?" select="@ns0:sequenceNumber"/>
						<classification-ipcr>
							<xsl:if test="fn:exists($var4_id)">
								<xsl:attribute name="id" select="fn:string($var4_id)"/>
							</xsl:if>
							<xsl:if test="fn:exists($var5_sequenceNumber)">
								<xsl:attribute name="sequence" select="fn:string($var5_sequenceNumber)"/>
							</xsl:if>
							<ipc-version-indicator>
								<xsl:for-each select="ns1:ClassificationVersionDate">
									<date>
										<xsl:sequence select="fn:string(.)"/>
									</date>
								</xsl:for-each>
							</ipc-version-indicator>
							<xsl:for-each select="ns1:PatentClassificationLevelCode">
								<classification-level>
									<xsl:sequence select="fn:string(.)"/>
								</classification-level>
							</xsl:for-each>
							<xsl:for-each select="ns1:Section">
								<section>
									<xsl:sequence select="fn:string(.)"/>
								</section>
							</xsl:for-each>
							<xsl:for-each select="ns1:Class">
								<class>
									<xsl:sequence select="fn:string(.)"/>
								</class>
							</xsl:for-each>
							<xsl:for-each select="ns1:Subclass">
								<subclass>
									<xsl:sequence select="fn:string(.)"/>
								</subclass>
							</xsl:for-each>
							<xsl:for-each select="ns1:MainGroup">
								<main-group>
									<xsl:sequence select="fn:string(.)"/>
								</main-group>
							</xsl:for-each>
							<xsl:for-each select="ns1:Subgroup">
								<subgroup>
									<xsl:sequence select="fn:string(.)"/>
								</subgroup>
							</xsl:for-each>
							<xsl:for-each select="ns0:SymbolPositionCode">
								<symbol-position>
									<xsl:sequence select="fn:string(.)"/>
								</symbol-position>
							</xsl:for-each>
							<xsl:for-each select="ns1:IPCClassificationValueCode">
								<classification-value>
									<xsl:sequence select="fn:string(.)"/>
								</classification-value>
							</xsl:for-each>
							<action-date>
								<xsl:for-each select="ns1:ActionDate">
									<date>
										<xsl:sequence select="fn:string(.)"/>
									</date>
								</xsl:for-each>
							</action-date>
							<generating-office>
								<xsl:for-each select="ns1:GeneratingOfficeCode">
									<country>
										<xsl:sequence select="fn:string(.)"/>
									</country>
								</xsl:for-each>
							</generating-office>
							<xsl:for-each select="ns1:IPCClassificationStatusCode">
								<classification-status>
									<xsl:sequence select="fn:string(.)"/>
								</classification-status>
							</xsl:for-each>
							<xsl:for-each select="ns1:PatentClassificationDataSourceCode">
								<classification-data-source>
									<xsl:sequence select="fn:string(.)"/>
								</classification-data-source>
							</xsl:for-each>
							<xsl:for-each select="ns1:PatentClassificationText">
								<text>
									<xsl:sequence select="fn:string(.)"/>
								</text>
							</xsl:for-each>
						</classification-ipcr>
					</xsl:for-each>
				</classifications-ipcr>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PatentClassificationBag/ns1:NationalClassification">
				<xsl:variable name="var6_resultof_ST__NationalClassitificationToST__classification_national" as="node()?">
					<xsl:call-template name="WIPO:ST96NationalClassitificationToST36classification-national">
						<xsl:with-param name="NationalClassification" as="node()">
							<NationalClassification xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</NationalClassification>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var6_resultof_ST__NationalClassitificationToST__classification_national">
					<classification-national>
						<xsl:sequence select="(./@node(), ./node())"/>
					</classification-national>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PatentClassificationBag/ns0:LocarnoClassificationBag">
				<xsl:variable name="var7_id" as="node()?" select="@ns0:id"/>
				<xsl:variable name="var8_LocarnoClassification" as="node()*" select="ns0:LocarnoClassification"/>
				<classification-locarno>
					<xsl:if test="fn:exists($var7_id)">
						<xsl:attribute name="id" select="fn:string($var7_id)"/>
					</xsl:if>
					<edition>
						<xsl:sequence select="fn:string(ns0:LocarnoClassificationEdition)"/>
					</edition>
					<xsl:for-each select="$var8_LocarnoClassification">
						<main-classification>
							<xsl:sequence select="()"/>
						</main-classification>
					</xsl:for-each>
					<xsl:for-each select="$var8_LocarnoClassification">
						<further-classification>
							<xsl:sequence select="()"/>
						</further-classification>
					</xsl:for-each>
					<xsl:for-each select="ns0:LocarnoClassificationText">
						<text>
							<xsl:sequence select="fn:string(.)"/>
						</text>
					</xsl:for-each>
				</classification-locarno>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData">
				<xsl:variable name="var10_resultof_first" as="node()" select="ns1:ApplicationIdentification"/>
				<xsl:variable name="var9_id" as="node()?" select="$var10_resultof_first/@ns0:id"/>
				<application-reference>
					<xsl:if test="fn:exists($var9_id)">
						<xsl:attribute name="id" select="fn:string($var9_id)"/>
					</xsl:if>
					<xsl:for-each select="$var10_resultof_first/ns1:InventionSubjectMatterCategory">
						<xsl:attribute name="appl-type" select="fn:string(.)"/>
					</xsl:for-each>
					<document-id>
						<country>
							<xsl:sequence select="fn:string($var10_resultof_first/ns0:IPOfficeCode)"/>
						</country>
						<xsl:for-each select="$var10_resultof_first/ns0:ApplicationNumber/ns0:ApplicationNumberText">
							<doc-number>
								<xsl:sequence select="fn:string(.)"/>
							</doc-number>
						</xsl:for-each>
						<xsl:for-each select="$var10_resultof_first/ns1:ApplicationFilingCategory">
							<kind>
								<xsl:sequence select="fn:string(.)"/>
							</kind>
						</xsl:for-each>
						<xsl:for-each select="$var10_resultof_first/ns1:FilingDate">
							<date>
								<xsl:sequence select="fn:string(.)"/>
							</date>
						</xsl:for-each>
					</document-id>
				</application-reference>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns0:FilingLanguageCode">
				<language-of-filing>
					<xsl:sequence select="fn:string(.)"/>
				</language-of-filing>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns0:PublicationLanguageCode">
				<language-of-publication>
					<xsl:sequence select="fn:string(.)"/>
				</language-of-publication>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData">
				<xsl:variable name="var23_resultof_first" as="node()" select="ns1:PartyBag"/>
				<parties>
					<xsl:for-each select="$var23_resultof_first/ns1:ApplicantBag">
						<applicants>
							<xsl:for-each select="ns1:Applicant">
								<xsl:variable name="var16_sequenceNumber" as="node()?" select="@ns0:sequenceNumber"/>
								<xsl:variable name="var15_resultof_vmf__inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf1_inputtoresult">
										<xsl:with-param name="input" select="fn:string(ns1:ApplicantCategory)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<applicant>
									<xsl:if test="fn:exists($var16_sequenceNumber)">
										<xsl:attribute name="sequence" select="fn:string($var16_sequenceNumber)"/>
									</xsl:if>
									<xsl:if test="fn:exists($var15_resultof_vmf__inputtoresult)">
										<xsl:attribute name="app-type" select="$var15_resultof_vmf__inputtoresult"/>
									</xsl:if>
									<xsl:variable name="var12_resultof_filter" as="node()?">
										<xsl:for-each select="ns1:DesignationCategory">
											<xsl:variable name="var11_resultof_vmf__inputtoresult" as="xs:string?">
												<xsl:call-template name="vmf:vmf2_inputtoresult">
													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
												</xsl:call-template>
											</xsl:variable>
											<xsl:if test="fn:exists($var11_resultof_vmf__inputtoresult)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:for-each>
									</xsl:variable>
									<xsl:for-each select="$var12_resultof_filter">
										<xsl:attribute name="designation">
											<xsl:call-template name="vmf:vmf2_inputtoresult">
												<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
											</xsl:call-template>
										</xsl:attribute>
									</xsl:for-each>
									<xsl:for-each select="ns0:PublicationContact">
										<xsl:variable name="var13_resultof_ST__PublicationContactToST__address_book" as="node()?">
											<xsl:call-template name="WIPO:ST96PublicationContactToST36address-book">
												<xsl:with-param name="PublicationContact" as="node()">
													<PublicationContact xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
														<xsl:sequence select="(./@node(), ./node())"/>
													</PublicationContact>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:for-each select="$var13_resultof_ST__PublicationContactToST__address_book">
											<addressbook>
												<xsl:sequence select="(./@node(), ./node())"/>
											</addressbook>
										</xsl:for-each>
									</xsl:for-each>
									<xsl:for-each select="ns0:NationalityCode">
										<nationality>
											<country>
												<xsl:sequence select="fn:string(.)"/>
											</country>
										</nationality>
									</xsl:for-each>
									<xsl:for-each select="ns0:ResidenceCountryCode">
										<residence>
											<country>
												<xsl:sequence select="fn:string(.)"/>
											</country>
										</residence>
									</xsl:for-each>
									<xsl:for-each select="ns1:SuccessorRights">
										<xsl:variable name="var14_resultof_vmf__inputtoresult" as="xs:string?">
											<xsl:call-template name="vmf:vmf3_inputtoresult">
												<xsl:with-param name="input" select="fn:string(ns1:SuccessorCategory)" as="xs:string"/>
											</xsl:call-template>
										</xsl:variable>
										<us-rights>
											<xsl:if test="fn:exists($var14_resultof_vmf__inputtoresult)">
												<xsl:attribute name="kind" select="$var14_resultof_vmf__inputtoresult"/>
											</xsl:if>
											<xsl:for-each select="ns1:SuccessorRightsText">
												<xsl:sequence select="fn:string(.)"/>
											</xsl:for-each>
										</us-rights>
									</xsl:for-each>
								</applicant>
							</xsl:for-each>
						</applicants>
					</xsl:for-each>
					<xsl:for-each select="$var23_resultof_first/ns1:InventorBag">
						<inventors>
							<xsl:for-each select="ns1:Inventor">
								<xsl:variable name="var18_sequenceNumber" as="node()?" select="@ns0:sequenceNumber"/>
								<inventor>
									<xsl:if test="fn:exists($var18_sequenceNumber)">
										<xsl:attribute name="sequence" select="fn:string($var18_sequenceNumber)"/>
									</xsl:if>
									<xsl:for-each select="ns0:PublicationContact">
										<xsl:variable name="var17_resultof_ST__PublicationContactToST__address_book" as="node()?">
											<xsl:call-template name="WIPO:ST96PublicationContactToST36address-book">
												<xsl:with-param name="PublicationContact" as="node()">
													<PublicationContact xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
														<xsl:sequence select="(./@node(), ./node())"/>
													</PublicationContact>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:for-each select="$var17_resultof_ST__PublicationContactToST__address_book">
											<addressbook>
												<xsl:sequence select="(./@node(), ./node())"/>
											</addressbook>
										</xsl:for-each>
									</xsl:for-each>
								</inventor>
							</xsl:for-each>
						</inventors>
					</xsl:for-each>
					<xsl:for-each select="$var23_resultof_first/ns0:CorrespondenceAddress">
						<correspondence-address>
							<xsl:for-each select="ns0:Contact">
								<xsl:variable name="var19_languageCode" as="node()?" select="@ns0:languageCode"/>
								<xsl:variable name="var20_Name" as="node()?" select="ns0:Name"/>
								<addressbook>
									<xsl:if test="fn:exists($var19_languageCode)">
										<xsl:attribute name="lang" select="fn:string($var19_languageCode)"/>
									</xsl:if>
									<xsl:for-each select="$var20_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:NamePrefix">
										<prefix>
											<xsl:sequence select="fn:string(.)"/>
										</prefix>
									</xsl:for-each>
									<xsl:for-each select="$var20_Name/ns0:PersonName/ns0:PersonStructuredName">
										<last-name>
											<xsl:sequence select="fn:string(ns0:LastName)"/>
										</last-name>
									</xsl:for-each>
									<xsl:for-each select="$var20_Name/ns0:OrganizationName">
										<orgname>
											<xsl:for-each select="(ns0:OrganizationStandardName/node())[fn:boolean(self::text())]">
												<xsl:sequence select="fn:string(.)"/>
											</xsl:for-each>
										</orgname>
									</xsl:for-each>
									<xsl:for-each select="$var20_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:FirstName">
										<first-name>
											<xsl:sequence select="fn:string(.)"/>
										</first-name>
									</xsl:for-each>
									<xsl:for-each select="$var20_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:MiddleName">
										<middle-name>
											<xsl:sequence select="fn:string(.)"/>
										</middle-name>
									</xsl:for-each>
									<xsl:for-each select="$var20_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:FirstLastName">
										<first-last-name>
											<xsl:sequence select="fn:string(.)"/>
										</first-last-name>
									</xsl:for-each>
									<xsl:for-each select="$var20_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:SecondLastName">
										<second-last-name>
											<xsl:sequence select="fn:string(.)"/>
										</second-last-name>
									</xsl:for-each>
									<xsl:for-each select="$var20_Name/ns0:PersonName/ns0:PersonStructuredName/ns0:NameSuffix">
										<suffix>
											<xsl:sequence select="fn:string(.)"/>
										</suffix>
									</xsl:for-each>
									<xsl:for-each select="ns0:PhoneNumberBag/ns0:PhoneNumber">
										<phone>
											<xsl:sequence select="fn:string(.)"/>
										</phone>
									</xsl:for-each>
									<xsl:for-each select="ns0:EmailAddressBag/ns0:EmailAddressText">
										<email>
											<xsl:sequence select="fn:string(.)"/>
										</email>
									</xsl:for-each>
								</addressbook>
							</xsl:for-each>
						</correspondence-address>
					</xsl:for-each>
					<xsl:for-each select="$var23_resultof_first/ns1:RegisteredPractitionerBag">
						<agents>
							<xsl:for-each select="ns1:RegisteredPractitioner">
								<xsl:variable name="var22_resultof_vmf__inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf4_inputtoresult">
										<xsl:with-param name="input" select="fn:string(ns1:RegisteredPractitionerCategory)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<agent>
									<xsl:attribute name="sequence" select="fn:string(@ns0:sequenceNumber)"/>
									<xsl:if test="fn:exists($var22_resultof_vmf__inputtoresult)">
										<xsl:attribute name="rep-type" select="$var22_resultof_vmf__inputtoresult"/>
									</xsl:if>
									<xsl:for-each select="ns0:PublicationContact">
										<xsl:variable name="var21_resultof_ST__PublicationContactToST__address_book" as="node()?">
											<xsl:call-template name="WIPO:ST96PublicationContactToST36address-book">
												<xsl:with-param name="PublicationContact" as="node()">
													<PublicationContact xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
														<xsl:sequence select="(./@node(), ./node())"/>
													</PublicationContact>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:for-each select="$var21_resultof_ST__PublicationContactToST__address_book">
											<addressbook>
												<xsl:sequence select="(./@node(), ./node())"/>
											</addressbook>
										</xsl:for-each>
									</xsl:for-each>
								</agent>
							</xsl:for-each>
						</agents>
					</xsl:for-each>
				</parties>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:StateDesignation">
				<designation-of-states>
					<designation-pct>
						<xsl:for-each select="ns1:NationalDesignation">
							<regional>
								<xsl:for-each select="ns0:DesignatedCountryCode">
									<country>
										<xsl:sequence select="fn:string(.)"/>
									</country>
								</xsl:for-each>
								<xsl:for-each select="ns1:ProtectionRequest">
									<xsl:variable name="var25_subsetIndicator" as="node()?" select="@ns1:subsetIndicator"/>
									<protection-request>
										<xsl:if test="fn:exists($var25_subsetIndicator)">
											<xsl:variable name="var24_resultof_vmf__inputtoresult" as="xs:string?">
												<xsl:call-template name="vmf:vmf5_inputtoresult">
													<xsl:with-param name="input" select="xs:string(xs:boolean(fn:string($var25_subsetIndicator)))" as="xs:string"/>
												</xsl:call-template>
											</xsl:variable>
											<xsl:if test="fn:exists($var24_resultof_vmf__inputtoresult)">
												<xsl:attribute name="subset" select="$var24_resultof_vmf__inputtoresult"/>
											</xsl:if>
										</xsl:if>
									</protection-request>
								</xsl:for-each>
							</regional>
						</xsl:for-each>
					</designation-pct>
				</designation-of-states>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:InventionTitleBag/ns1:InventionTitle">
				<xsl:variable name="var26_id" as="node()?" select="@ns0:id"/>
				<xsl:variable name="var27_languageCode" as="node()?" select="@ns0:languageCode"/>
				<invention-title>
					<xsl:if test="fn:exists($var26_id)">
						<xsl:attribute name="id" select="fn:string($var26_id)"/>
					</xsl:if>
					<xsl:if test="fn:exists($var27_languageCode)">
						<xsl:attribute name="lang" select="fn:string($var27_languageCode)"/>
					</xsl:if>
					<xsl:for-each select="node()">
						<xsl:if test="fn:boolean(self::text())">
							<xsl:sequence select="fn:string(.)"/>
						</xsl:if>
						<xsl:if test="fn:boolean(self::ns0:B)">
							<b>
								<xsl:for-each select="node()[fn:boolean(self::text())]">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:for-each>
							</b>
						</xsl:if>
						<xsl:if test="fn:boolean(self::ns0:I)">
							<i>
								<xsl:for-each select="node()[fn:boolean(self::text())]">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:for-each>
							</i>
						</xsl:if>
						<xsl:if test="fn:boolean(self::ns0:U)">
							<u>
								<xsl:for-each select="node()[fn:boolean(self::text())]">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:for-each>
							</u>
						</xsl:if>
						<xsl:if test="fn:boolean(self::ns0:O)">
							<o>
								<xsl:for-each select="node()[fn:boolean(self::text())]">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:for-each>
							</o>
						</xsl:if>
						<xsl:if test="fn:boolean(self::ns0:Sup)">
							<sup>
								<xsl:for-each select="node()[fn:boolean(self::text())]">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:for-each>
							</sup>
						</xsl:if>
						<xsl:if test="fn:boolean(self::ns0:Sub)">
							<sub>
								<xsl:for-each select="node()[fn:boolean(self::text())]">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:for-each>
							</sub>
						</xsl:if>
					</xsl:for-each>
				</invention-title>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PartyBag/ns1:AssigneeBag">
				<assignees>
					<xsl:for-each select="ns1:Assignee">
						<assignee>
							<xsl:for-each select="ns0:PublicationContact">
								<xsl:variable name="var29_resultof_first" as="node()" select="ns0:Name"/>
								<xsl:variable name="var28_PersonName" as="node()*" select="$var29_resultof_first/ns0:PersonName"/>
								<addressbook>
									<xsl:for-each select="$var28_PersonName/ns0:PersonStructuredName">
										<last-name>
											<xsl:sequence select="fn:string(ns0:LastName)"/>
										</last-name>
									</xsl:for-each>
									<xsl:for-each select="$var29_resultof_first/ns0:OrganizationName">
										<orgname>
											<xsl:for-each select="(ns0:OrganizationStandardName/node())[fn:boolean(self::text())]">
												<xsl:sequence select="fn:string(.)"/>
											</xsl:for-each>
										</orgname>
									</xsl:for-each>
									<xsl:for-each select="$var28_PersonName/ns0:PersonStructuredName/ns0:FirstName">
										<first-name>
											<xsl:sequence select="fn:string(.)"/>
										</first-name>
									</xsl:for-each>
									<address>
										<xsl:for-each select="ns0:CityName">
											<city>
												<xsl:sequence select="fn:string(.)"/>
											</city>
										</xsl:for-each>
										<xsl:for-each select="ns0:GeographicRegionName">
											<state>
												<xsl:sequence select="fn:string(.)"/>
											</state>
										</xsl:for-each>
										<xsl:for-each select="ns0:CountryCode">
											<country>
												<xsl:sequence select="fn:string(.)"/>
											</country>
										</xsl:for-each>
									</address>
								</addressbook>
							</xsl:for-each>
						</assignee>
					</xsl:for-each>
				</assignees>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:LicenceDataBag/ns1:LicenceData">
				<licensee-data>
					<licensee>
						<xsl:sequence select="()"/>
					</licensee>
					<xsl:variable name="var31_resultof_filter" as="node()?">
						<xsl:for-each select="ns1:RegisteredPractitioner">
							<xsl:variable name="var30_resultof_vmf__inputtoresult" as="xs:string?">
								<xsl:call-template name="vmf:vmf6_inputtoresult">
									<xsl:with-param name="input" select="fn:string(ns1:RegisteredPractitionerCategory)" as="xs:string"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="fn:exists($var30_resultof_vmf__inputtoresult)">
								<xsl:sequence select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<attorney-or-agent>
						<xsl:for-each select="$var31_resultof_filter">
							<xsl:attribute name="rep-type">
								<xsl:call-template name="vmf:vmf6_inputtoresult">
									<xsl:with-param name="input" select="fn:string(ns1:RegisteredPractitionerCategory)" as="xs:string"/>
								</xsl:call-template>
							</xsl:attribute>
						</xsl:for-each>
					</attorney-or-agent>
					<xsl:for-each select="ns1:EffectiveCountryBag">
						<effective-in>
							<xsl:for-each select="ns0:CountryCode">
								<country>
									<xsl:sequence select="fn:string(.)"/>
								</country>
							</xsl:for-each>
						</effective-in>
					</xsl:for-each>
				</licensee-data>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:EarliestPriorityApplication">
				<date-of-earliest-priority>
					<xsl:sequence select="()"/>
				</date-of-earliest-priority>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:CompleteSpecificationFilingDate">
				<date-complete-specification-filed>
					<xsl:sequence select="()"/>
				</date-complete-specification-filed>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:FigureBag">
				<xsl:variable name="var32_resultof_ST__FigureBagToST__figures" as="node()?">
					<xsl:call-template name="WIPO:ST96FigureBagToST36figures">
						<xsl:with-param name="FigureBag" as="node()">
							<FigureBag xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</FigureBag>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var32_resultof_ST__FigureBagToST__figures">
					<figures>
						<xsl:sequence select="(./@node(), ./node())"/>
					</figures>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:ReferenceCitationBag">
				<xsl:variable name="var34_resultof_ST__ReferenceCitationBagToST__reference_cited" as="node()?">
					<xsl:call-template name="WIPO:ST96ReferenceCitationBagToST36reference-cited">
						<xsl:with-param name="ReferenceCitationBagType" as="node()">
							<ReferenceCitationBagType xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</ReferenceCitationBagType>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="fn:exists($var34_resultof_ST__ReferenceCitationBagToST__reference_cited)">
					<xsl:variable name="var33_resultof_first" as="node()" select="$var34_resultof_ST__ReferenceCitationBagToST__reference_cited"/>
					<references-cited>
						<xsl:sequence select="($var33_resultof_first/@node(), $var33_resultof_first/node())"/>
					</references-cited>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PartyBag/ns1:ExaminerBag">
				<examiners>
					<xsl:for-each select="ns1:PrimaryExaminer">
						<xsl:variable name="var35_PersonName" as="node()*" select="ns0:Name/ns0:PersonName"/>
						<primary-examiner>
							<xsl:for-each select="$var35_PersonName/ns0:PersonStructuredName">
								<last-name>
									<xsl:sequence select="fn:string(ns0:LastName)"/>
								</last-name>
							</xsl:for-each>
							<xsl:for-each select="$var35_PersonName/ns0:PersonStructuredName/ns0:FirstName">
								<first-name>
									<xsl:sequence select="fn:string(.)"/>
								</first-name>
							</xsl:for-each>
						</primary-examiner>
					</xsl:for-each>
					<xsl:for-each select="ns1:AssistantExaminer">
						<xsl:variable name="var36_PersonName" as="node()*" select="ns0:Name/ns0:PersonName"/>
						<assistant-examiner>
							<xsl:for-each select="$var36_PersonName/ns0:PersonStructuredName">
								<last-name>
									<xsl:sequence select="fn:string(ns0:LastName)"/>
								</last-name>
							</xsl:for-each>
							<xsl:for-each select="$var36_PersonName/ns0:PersonStructuredName/ns0:FirstName">
								<first-name>
									<xsl:sequence select="fn:string(.)"/>
								</first-name>
							</xsl:for-each>
						</assistant-examiner>
					</xsl:for-each>
					<xsl:for-each select="ns1:AuthorizedOfficer">
						<authorized-officer>
							<name>
								<xsl:sequence select="()"/>
							</name>
						</authorized-officer>
					</xsl:for-each>
				</examiners>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:ClaimTotalQuantity">
				<number-of-claims>
					<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
				</number-of-claims>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:RelatedDocumentBag">
				<xsl:variable name="var37_resultof_ST__RelatedDocumentBagToST__related_document" as="node()?">
					<xsl:call-template name="WIPO:ST96RelatedDocumentBagToST36related-document">
						<xsl:with-param name="RelatedDocumentBagType" as="node()">
							<RelatedDocumentBagType xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</RelatedDocumentBagType>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var37_resultof_ST__RelatedDocumentBagToST__related_document">
					<related-documents>
						<xsl:sequence select="(./@node(), ./node())"/>
					</related-documents>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:ExhibitionFilingDate">
				<date-exhibition-filed>
					<xsl:sequence select="()"/>
				</date-exhibition-filed>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PCTNationalPhaseEntryDate">
				<date-pct-article-22-39-fulfilled>
					<date>
						<xsl:sequence select="fn:string(.)"/>
					</date>
				</date-pct-article-22-39-fulfilled>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns0:BioDeposit">
				<xsl:variable name="var38_id" as="node()?" select="@ns0:id"/>
				<bio-deposit>
					<xsl:if test="fn:exists($var38_id)">
						<xsl:attribute name="id" select="fn:string($var38_id)"/>
					</xsl:if>
				</bio-deposit>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:InternationalFilingData">
				<xsl:variable name="var39_resultof_first" as="node()" select="ns1:ApplicationIdentification"/>
				<pct-or-regional-filing-data>
					<document-id>
						<xsl:for-each select="$var39_resultof_first/ns0:FilingLanguageCode">
							<xsl:attribute name="lang" select="fn:string(.)"/>
						</xsl:for-each>
						<country>
							<xsl:sequence select="fn:string($var39_resultof_first/ns0:IPOfficeCode)"/>
						</country>
						<xsl:for-each select="$var39_resultof_first/ns0:ApplicationNumber/ns0:ApplicationNumberText">
							<doc-number>
								<xsl:sequence select="fn:string(.)"/>
							</doc-number>
						</xsl:for-each>
						<xsl:for-each select="$var39_resultof_first/ns1:FilingDate">
							<date>
								<xsl:sequence select="fn:string(.)"/>
							</date>
						</xsl:for-each>
					</document-id>
				</pct-or-regional-filing-data>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:InternationalPublishingData">
				<pct-or-regional-publishing-data>
					<xsl:for-each select="ns1:PatentDocumentIdentification/ns1:PatentPublicationIdentification">
						<document-id>
							<xsl:for-each select="ns0:PublicationLanguageCode">
								<xsl:attribute name="lang" select="fn:string(.)"/>
							</xsl:for-each>
							<country>
								<xsl:sequence select="fn:string(ns0:IPOfficeCode)"/>
							</country>
							<doc-number>
								<xsl:sequence select="fn:string(ns1:PublicationNumber)"/>
							</doc-number>
							<xsl:for-each select="ns0:PatentDocumentKindCode">
								<kind>
									<xsl:sequence select="fn:string(.)"/>
								</kind>
							</xsl:for-each>
							<xsl:for-each select="ns0:PublicationDate">
								<date>
									<xsl:sequence select="fn:string(.)"/>
								</date>
							</xsl:for-each>
						</document-id>
					</xsl:for-each>
				</pct-or-regional-publishing-data>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:RightsReestablishedDate">
				<date-rights-reestablished>
					<xsl:sequence select="()"/>
				</date-rights-reestablished>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:ApplicationWithdrawnDate">
				<date-application-withdrawn-by-applicant>
					<xsl:sequence select="()"/>
				</date-application-withdrawn-by-applicant>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:ApplicationDeemedWithdrawnDate">
				<date-application-deemed-withdrawn>
					<xsl:sequence select="()"/>
				</date-application-deemed-withdrawn>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:PatentRevocationDate">
				<date-of-revocation>
					<xsl:sequence select="()"/>
				</date-of-revocation>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:ApplicationPartiallyWithdrawnDate">
				<date-application-partially-withdrawn>
					<date>
						<xsl:sequence select="fn:string(.)"/>
					</date>
				</date-application-partially-withdrawn>
			</xsl:for-each>
			<xsl:for-each select="$var40_BibliographicData/ns1:OppositionData">
				<opposition-data>
					<xsl:sequence select="()"/>
				</opposition-data>
			</xsl:for-each>
		</bibliographic-data>
	</xsl:template>
</xsl:stylesheet>
