# WIPO XSL to JSON (Xsd2Json) Schema Transformation Tool

XSD to JSON Schema Transformation Tool is a Java library that helps you transform a provided XSD to its JSON Schema equivalent according to the rules found [here](https://www3.wipo.int/confluence/display/xml4iptf/JSON+3rd+Round?preview=/1169981692/1172439056/Round3_JSON_Transformation_Rules.docx).

## Requirements

Java Runtime Environment 1.8 (or higher)
 
## Usage

```bash
usage: java -jar Xsd2JsonSchema.jar [[option] <Argument>]
Available options -
 -a <Appendix-C file with path>           Use user supplied Appendix-C
                                          known abbreviations file
 -e <Custom JSON Schema file extension>   Custom JSON Schema file
                                          extension (default - ".json")
 -h,--help                                Command usage help
 -i <Input XSD File/Folder>               Input XSD file or folder for
                                          transformation)
 -o <Output Folder>                       Output folder for transformed
                                          JSON Schema(s), default: User
                                          home directory
                                          (C:\Users\<user-id>\jsonSchema)
 -r                                       Recursively transforms input
                                          file and its referenced
                                          (included/imported) XSDs
                                          (available only with single XSD
                                          file transformation)

Example: 1 - Help/Usage
java -jar Xsd2JsonSchema.jar -help

Example: 2 - Transform one XSD with standard ST.96 Appedix C Terms
java -jar Xsd2JsonSchema.jar -i
"C:\Schema\ST.96_V5_0\Common\abstractNumber.xsd"

Example: 3 - Transform one XSD with standard ST.96 Appedix C Terms into
specific output folder
java -jar Xsd2JsonSchema.jar -i
"C:\Schema\ST.96_V5_0\Common\abstractNumber.xsd" -o "C:\Temp"

Example: 4 - Transform one XSD with user provided Abbreviations/Terms
java -jar Xsd2JsonSchema.jar -i
"C:\Schema\ST.96_V5_0\Common\abstractNumber.xsd" -a
"C:\MyAbbreviations.txt"

Example: 5 - Transform one XSD with custom JSON schema extension
java -jar Xsd2JsonSchema.jar -i
"C:\Schema\ST.96_V5_0\Common\abstractNumber.xsd" -e ".json"

Example: 6 - Transform one XSD with user provided Abbreviations/Terms and
custom JSON schema extension
java -jar Xsd2JsonSchema.jar -i
"C:\Schema\ST.96_V5_0\Common\abstractNumber.xsd" -a
"C:\MyAbbreviations.txt" -e ".json"

Example: 7 - Transform one XSD and the included/imported schemas
recursively
java -jar Xsd2JsonSchema.jar -i
"C:\Schema\ST.96_V5_0\Patent\Applicant.xsd" -r

Example: 8 - Transform all the XSD schemas from provided directory (the
recursive flag cannot be used with directory)
java -jar Xsd2JsonSchema.jar -i "C:\Schema\ST.96_V5_0\Common"
```
