/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.utils.annex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.wipo.xsd2json.utils.annex.XsdTypeUtils;

public class SchemaAnnexUtils {
    private File sourceXsdFile;
    private Map<String, String> schemaLocationsMap = new HashMap<String, String>();

    public SchemaAnnexUtils(File sourceXsdFile) throws IOException, URISyntaxException {
        this.sourceXsdFile = sourceXsdFile;
        this.createTypeRefAnnex();
    }

    private void createTypeRefAnnex() throws IOException, URISyntaxException {
        if (this.sourceXsdFile.getName().toLowerCase().endsWith(".xsd")) {
            this.addSchemaLocation(this.sourceXsdFile);
        }
    }

    private void addSchemaLocation(File xsdFile) throws FileNotFoundException, MalformedURLException, URISyntaxException {
        FileInputStream is = new FileInputStream(xsdFile);
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        schemaCol.setBaseUri(xsdFile.getParent());
        XmlSchema schema = schemaCol.read(new StreamSource(is));
        List<String> types = this.getTypeOfSchema(schema);
        if (schema.getItems() != null && schema.getItems().size() > 0) {
            for (XmlSchemaObject item : schema.getItems()) {
                String filePath;
                String pathOfXsdType;
                if (item instanceof XmlSchemaInclude) {
                    for (String type : types) {
                        if (!this.xsdHasType(item, type, schema)) continue;
                        pathOfXsdType = ((XmlSchemaInclude)item).getSchema().getSourceURI();
                        filePath = Paths.get(new URL(pathOfXsdType).toURI()).toString();
                        if (this.schemaLocationsMap.containsKey(type)) continue;
                        this.schemaLocationsMap.put(type, filePath);
                    }
                }
                if (item instanceof XmlSchemaImport) {
                    for (String type : types) {
                        if (!this.xsdHasType(item, type, schema)) continue;
                        pathOfXsdType = ((XmlSchemaImport)item).getSchema().getSourceURI();
                        filePath = Paths.get(new URL(pathOfXsdType).toURI()).toString();
                        if (this.schemaLocationsMap.containsKey(type)) continue;
                        this.schemaLocationsMap.put(type, filePath);
                    }
                }
                if (item instanceof XmlSchemaComplexType || item instanceof XmlSchemaSimpleType) {
                    for (String type : types) {
                        pathOfXsdType = this.sourceXsdFile.toURI().toString();
                        filePath = Paths.get(new URL(pathOfXsdType).toURI()).toString();
                        if (this.schemaLocationsMap.containsKey(type)) continue;
                        this.schemaLocationsMap.put(type, filePath);
                    }
                }
                if (!(item instanceof XmlSchemaGroup) && !(item instanceof XmlSchemaAttributeGroup)) continue;
                for (String type : types) {
                    pathOfXsdType = this.sourceXsdFile.toURI().toString();
                    filePath = Paths.get(new URL(pathOfXsdType).toURI()).toString();
                    if (this.schemaLocationsMap.containsKey(type)) continue;
                    this.schemaLocationsMap.put(type, filePath);
                }
            }
        }
    }

    private boolean xsdHasType(XmlSchemaObject item, String type, XmlSchema xmlSchema) throws FileNotFoundException {
        XmlSchema schema = xmlSchema;
        if (item instanceof XmlSchemaInclude || item instanceof XmlSchemaImport) {
            String xsdFilePath = null;
            if (item instanceof XmlSchemaInclude) {
                xsdFilePath = ((XmlSchemaInclude)item).getSchema().getSourceURI().replace("file:/", "");
            }
            if (item instanceof XmlSchemaImport) {
                xsdFilePath = ((XmlSchemaImport)item).getSchema().getSourceURI().replace("file:/", "");
            }
            File xsdFile = new File(xsdFilePath);
            FileInputStream is = new FileInputStream(xsdFile);
            XmlSchemaCollection schemaCol = new XmlSchemaCollection();
            schemaCol.setBaseUri(xsdFile.getParent());
            schema = schemaCol.read(new StreamSource(is));
        }
        List<String> namesOfSchema = this.getNamesOfSchema(schema);
        for (String name : namesOfSchema) {
            if (!name.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    private List<String> getNamesOfSchema(XmlSchema schema) {
        String name;
        ArrayList<String> nameList = new ArrayList<String>();
        if (schema.getElements() != null && schema.getElements().size() > 0) {
            for (Map.Entry<QName, XmlSchemaAnnotated> entry : schema.getElements().entrySet()) {
                XmlSchemaElement element = (XmlSchemaElement)entry.getValue();
                name = element.getName();
                nameList.add(name);
            }
        }
        if (schema.getAttributes() != null && schema.getAttributes().size() > 0) {
            for (Map.Entry<QName, XmlSchemaAnnotated> entry : schema.getAttributes().entrySet()) {
                XmlSchemaAttribute attribute = (XmlSchemaAttribute)entry.getValue();
                name = attribute.getName();
                nameList.add(name);
            }
        }
        if (schema.getSchemaTypes() != null && schema.getSchemaTypes().entrySet().size() > 0) {
            for (Map.Entry<QName, XmlSchemaAnnotated> entry : schema.getSchemaTypes().entrySet()) {
                if (entry.getValue() instanceof XmlSchemaSimpleType) {
                    XmlSchemaSimpleType simpleType = (XmlSchemaSimpleType)entry.getValue();
                    nameList.add(simpleType.getName());
                }
                if (!(entry.getValue() instanceof XmlSchemaComplexType)) continue;
                XmlSchemaComplexType complexTypeType = (XmlSchemaComplexType)entry.getValue();
                name = complexTypeType.getName();
                nameList.add(name);
            }
        }
        return nameList;
    }

    private List<String> getTypeOfSchema(XmlSchema schema) throws FileNotFoundException {
        ArrayList<String> typeList = new ArrayList<String>();
        if (schema.getElements() != null && schema.getElements().size() > 0) {
            typeList.addAll(this.addElementsToTypeList(schema.getElements()));
        }
        if (schema.getAttributes() != null && schema.getAttributes().size() > 0) {
            typeList.addAll(this.addAttributesToTypeList(schema.getAttributes()));
        }
        if (schema.getSchemaTypes() != null && schema.getSchemaTypes().entrySet().size() > 0) {
            for (Map.Entry<QName, XmlSchemaType> entry : schema.getSchemaTypes().entrySet()) {
                if (entry.getValue() instanceof XmlSchemaSimpleType) {
                    typeList.addAll(this.addSimpleTypesToTypeList(schema.getSchemaTypes().entrySet()));
                }
                if (!(entry.getValue() instanceof XmlSchemaComplexType)) continue;
                typeList.addAll(this.addComplexTypesToTypeList(schema.getSchemaTypes().entrySet()));
            }
        }
        if (schema.getGroups() != null && schema.getGroups().entrySet().size() > 0) {
            typeList.addAll(this.addGroupTypesToTypeList(schema.getGroups().entrySet()));
        }
        return typeList;
    }

    private List<String> addElementsToTypeList(Map<QName, XmlSchemaElement> elements) {
        ArrayList<String> elementsTypeList = new ArrayList<String>();
        for (Map.Entry<QName, XmlSchemaElement> entry : elements.entrySet()) {
            XmlSchemaElement element = entry.getValue();
            elementsTypeList.add(XsdTypeUtils.getTypeOfElement(element));
        }
        return elementsTypeList;
    }

    private List<String> addAttributesToTypeList(Map<QName, XmlSchemaAttribute> attributes) {
        ArrayList<String> attributesTypeList = new ArrayList<String>();
        for (Map.Entry<QName, XmlSchemaAttribute> entry : attributes.entrySet()) {
            XmlSchemaAttribute attribute = entry.getValue();
            attributesTypeList.add(XsdTypeUtils.getTypeOfAttribute(attribute));
        }
        return attributesTypeList;
    }

    private List<String> addSimpleTypesToTypeList(Set<Map.Entry<QName, XmlSchemaType>> simpleTypes) {
        ArrayList<String> simpleTypesTypeList = new ArrayList<String>();
        for (Map.Entry<QName, XmlSchemaType> entry : simpleTypes) {
            if (!(entry.getValue() instanceof XmlSchemaSimpleType)) continue;
            XmlSchemaSimpleType simpleType = (XmlSchemaSimpleType)entry.getValue();
            simpleTypesTypeList.addAll(XsdTypeUtils.getTypeOfSimpleType(simpleType));
        }
        return simpleTypesTypeList;
    }

    private List<String> addComplexTypesToTypeList(Set<Map.Entry<QName, XmlSchemaType>> complexTypes) {
        ArrayList<String> complexTypesTypeList = new ArrayList<String>();
        for (Map.Entry<QName, XmlSchemaType> entry : complexTypes) {
            if (!(entry.getValue() instanceof XmlSchemaComplexType)) continue;
            XmlSchemaComplexType complexTypeType = (XmlSchemaComplexType)entry.getValue();
            complexTypesTypeList.addAll(XsdTypeUtils.getTypeOfComplexType(complexTypeType));
        }
        return complexTypesTypeList;
    }

    private List<String> addGroupTypesToTypeList(Set<Map.Entry<QName, XmlSchemaGroup>> groupTypes) {
        ArrayList<String> groupTypesTypeList = new ArrayList<String>();
        for (Map.Entry<QName, XmlSchemaGroup> entry : groupTypes) {
            if (!(entry.getValue() instanceof XmlSchemaGroup)) continue;
            XmlSchemaGroup groupTypesType = entry.getValue();
            groupTypesTypeList.addAll(XsdTypeUtils.getTypeOfComplexType(groupTypesType));
        }
        return groupTypesTypeList;
    }

    public Map<String, String> getSchemaLocationsMap() {
        return this.schemaLocationsMap;
    }
}

