/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.main;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.wipo.xsd2json.constants.FolderPaths;
import org.wipo.xsd2json.converter.JsonSchemaBuilderFactory;
import org.wipo.xsd2json.schema.writers.JsonSchemaWriterFactory;
import org.wipo.xsd2json.utils.AppendixC;
import org.wipo.xsd2json.utils.NamingUtils;
import org.wipo.xsd2json.utils.OrganizationUtils;

public class InvokerMain {
    private static final String USAGE_EXAMPLES = "\nExample: 1 - Help/Usage\tjava -jar Xsd2JsonSchema.jar -help\n\nExample: 2 - Transform one XSD with standard ST.96 Appedix C Terms\tjava -jar Xsd2JsonSchema.jar -i \"C:\\Schema\\ST.96_V5_0\\Common\\abstractNumber.xsd\"\n\nExample: 3 - Transform one XSD with standard ST.96 Appedix C Terms into specific output folder\tjava -jar Xsd2JsonSchema.jar -i \"C:\\Schema\\ST.96_V5_0\\Common\\abstractNumber.xsd\" -o \"C:\\Temp\"\n\nExample: 4 - Transform one XSD with user provided Abbreviations/Terms\tjava -jar Xsd2JsonSchema.jar -i \"C:\\Schema\\ST.96_V5_0\\Common\\abstractNumber.xsd\" -a \"C:\\MyAbbreviations.txt\"\n\nExample: 5 - Transform one XSD with custom JSON schema extension\tjava -jar Xsd2JsonSchema.jar -i \"C:\\Schema\\ST.96_V5_0\\Common\\abstractNumber.xsd\" -e \".json\"\n\nExample: 6 - Transform one XSD with user provided Abbreviations/Terms and custom JSON schema extension\tjava -jar Xsd2JsonSchema.jar -i \"C:\\Schema\\ST.96_V5_0\\Common\\abstractNumber.xsd\" -a \"C:\\MyAbbreviations.txt\" -e \".json\"\n\nExample: 7 - Transform one XSD and the included/imported schemas recursively\tjava -jar Xsd2JsonSchema.jar -i \"C:\\Schema\\ST.96_V5_0\\Patent\\Applicant.xsd\" -r\n\nExample: 8 - Transform all the XSD schemas from provided directory (the recursive flag cannot be used with directory)\tjava -jar Xsd2JsonSchema.jar -i \"C:\\Schema\\ST.96_V5_0\\Common\"\n";
    public static List<String> recursiveList = new ArrayList<String>();
    private static Map<String, String> allXsds = new HashMap<String, String>();

    public static void main(String[] args) throws Exception {
        InvokerMain mainObj = new InvokerMain();
        String currentFile = "";
        String inputXsd = null;
        String outputFolder = FolderPaths.exportFolder;
        String apndxCFile = null;
        String jsonSchExt = ".json";
        boolean recursiveTransform = false;
        Options options = new Options();
        Option iOpt = Option.builder("i").required().argName("Input XSD File/Folder").desc("Input XSD file or folder for transformation)").hasArgs().numberOfArgs(1).valueSeparator(' ').build();
        Option rOpt = Option.builder("r").required(false).desc("Recursively transforms input file and its referenced (included/imported) XSDs (available only with single XSD file transformation)").hasArg(false).build();
        Option oOpt = Option.builder("o").required(false).argName("Output Folder").desc("Output folder for transformed JSON Schema(s), default: User home directory (C:\\Users\\<user-id>\\jsonSchema)").hasArgs().numberOfArgs(1).valueSeparator(' ').build();
        Option aOpt = Option.builder("a").required(false).argName("Appendix-C file with path").desc("Use user supplied Appendix-C known abbreviations file").hasArgs().numberOfArgs(1).valueSeparator(' ').build();
        Option eOpt = Option.builder("e").required(false).argName("Custom JSON Schema file extension").desc("Custom JSON Schema file extension (default - \".json\")").hasArgs().numberOfArgs(1).valueSeparator(' ').build();
        Option hOpt = Option.builder("h").required(false).longOpt("help").desc("Command usage help").hasArg(false).build();
        options.addOption(iOpt);
        options.addOption(rOpt);
        options.addOption(oOpt);
        options.addOption(aOpt);
        options.addOption(eOpt);
        options.addOption(hOpt);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException parseException) {
            System.err.println("Invalid usage!!");
            InvokerMain.printHelpMessage(options);
            return;
        }
        if (cmd.hasOption("h") || cmd.hasOption("help")) {
            InvokerMain.printHelpMessage(options);
            return;
        }
        if (args.length == 0) {
            InvokerMain.printHelpMessage(options);
            return;
        }
        Option[] optionArray = cmd.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (!options.hasOption(option.getOpt())) {
                System.err.println("Invalid usage!!");
                InvokerMain.printHelpMessage(options);
                return;
            }
            ++n2;
        }
        if (cmd.hasOption('i')) {
            inputXsd = cmd.getOptionValue("i");
            if (inputXsd == null) {
                System.err.println("Invalid usage!!");
                System.err.println("Missing input XSD file value");
                InvokerMain.printHelpMessage(options);
                return;
            }
            File inputXsdFl = new File(inputXsd);
            if (!inputXsdFl.exists()) {
                System.err.println("Invalid usage!!");
                System.err.println("Cannot access ".concat(inputXsd));
                return;
            }
            if (inputXsdFl.isFile() && !inputXsd.toLowerCase().endsWith(".xsd")) {
                System.err.println("Invalid usage!!");
                System.err.println("Invalid input file ".concat(inputXsd).concat("\nPlease provide valid XSD file."));
                return;
            }
        }
        if (cmd.hasOption('r')) {
            inputXsd = cmd.getOptionValue("i");
            recursiveTransform = true;
            if (!new File(inputXsd).isFile()) {
                System.err.println("Invalid usage!!");
                System.err.println("Recursive transformation is available only for XSD file input value");
                return;
            }
        }
        if (cmd.hasOption("a") && (apndxCFile = cmd.getOptionValue("a", null)) == null) {
            System.err.println("Invalid usage!!");
            System.err.println("Missing user supplied Appendix-C file");
            return;
        }
        AppendixC apndx = null;
        apndx = apndxCFile != null ? new AppendixC(new File(apndxCFile)) : new AppendixC(null);
        NamingUtils.KNOWN_TERMS = apndx.getKnownAbbreviations();
        if (cmd.hasOption("e") && (jsonSchExt = cmd.getOptionValue("e")) == null) {
            System.err.println("Invalid usage!!");
            System.err.println("Missing custom user preferred JSON schema extension value");
            return;
        }
        if (cmd.hasOption("o")) {
            outputFolder = cmd.getOptionValue("o");
            if (outputFolder == null) {
                System.err.println("Invalid usage!!");
                System.err.println("Missing output folder");
                return;
            }
            if (!outputFolder.endsWith(File.separator)) {
                outputFolder = outputFolder.concat(File.separator);
            }
        }
        try {
            List<String> xsdPaths = null;
            if (new File(inputXsd).isDirectory()) {
                xsdPaths = mainObj.findAllXsdsInsideFolder(inputXsd);
            } else {
                xsdPaths = new ArrayList<String>();
                xsdPaths.add(inputXsd);
            }
            for (String path : xsdPaths) {
                if (!path.toLowerCase().contains(".xsd")) continue;
                currentFile = path;
                mainObj.transformXsdToJsonSchema(currentFile, jsonSchExt, recursiveTransform, outputFolder);
            }
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(InvokerMain.class.getName()).log(Level.SEVERE, "main()- An error was encountered while parsing xsd : " + currentFile, ex);
        }
        System.out.println("XSD -> JSON Transformation completed!");
    }

    private static void printHelpMessage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar Xsd2JsonSchema.jar [[option] <Argument>]", "Available options - ", options, USAGE_EXAMPLES);
    }

    public void transformXsdToJsonSchema(String selectedXsd, String jsonExt, boolean recursiveTransform, String outputFolder) throws IOException, URISyntaxException {
        recursiveList.add(selectedXsd);
        File xsdFile = new File(selectedXsd);
        JsonSchemaBuilderFactory jsonSchemaBuilderFactory = new JsonSchemaBuilderFactory(xsdFile, jsonExt);
        Map<String, Object> finalMap = jsonSchemaBuilderFactory.createJsonSchema();
        JsonSchemaWriterFactory writerFactory = new JsonSchemaWriterFactory();
        ObjectWriter writer = writerFactory.buildWriter();
        File jsonFl = Paths.get(String.valueOf(outputFolder) + NamingUtils.getJsonFileNameFromXsdFileName(selectedXsd, jsonExt), new String[0]).toFile();
        if (!jsonFl.exists()) {
            jsonFl.getParentFile().mkdirs();
        }
        writer.writeValue(jsonFl, finalMap);
        if (recursiveTransform) {
            this.recursiveWriting(jsonSchemaBuilderFactory.getTypeRefAnnex(), jsonExt, outputFolder);
            this.rearrangeAllXSDsToCorrectFolderStructure(allXsds, jsonExt, outputFolder);
        }
    }

    public void recursiveWriting(Map<String, String> typeRefAnnex, String jsonExt, String outputFolder) throws IOException, URISyntaxException {
        allXsds.putAll(typeRefAnnex);
        for (Map.Entry<String, String> entry : typeRefAnnex.entrySet()) {
            if (recursiveList.contains(entry.getValue()) || entry.getValue().contains("ExternalStandards")) continue;
            File xsdFile = new File(entry.getValue());
            JsonSchemaBuilderFactory jsonSchemaBuilderFactory = new JsonSchemaBuilderFactory(xsdFile, jsonExt);
            recursiveList.add(entry.getValue());
            Map<String, Object> finalMap = jsonSchemaBuilderFactory.createJsonSchema();
            JsonSchemaWriterFactory writerFactory = new JsonSchemaWriterFactory();
            ObjectWriter writer = writerFactory.buildWriter();
            File jsonFl = Paths.get(String.valueOf(outputFolder) + NamingUtils.getJsonFileNameFromXsdFileName(entry.getValue(), jsonExt), new String[0]).toFile();
            if (!jsonFl.exists()) {
                jsonFl.getParentFile().mkdirs();
            }
            writer.writeValue(jsonFl, finalMap);
            this.recursiveWriting(jsonSchemaBuilderFactory.getTypeRefAnnex(), jsonExt, outputFolder);
        }
    }

    public void rearrangeAllXSDsToCorrectFolderStructure(Map<String, String> allXsds, String jsonExt, String outputFolder) throws IOException {
        String commonPathForAllXsds = OrganizationUtils.calculateCommonPathForAllXSDs(allXsds);
        for (String xsdKey : allXsds.keySet()) {
            String xsd = allXsds.get(xsdKey);
            if ("".equals(xsd = xsd.replace(commonPathForAllXsds, ""))) break;
            String[] tokens = xsd.split("\\\\");
            String path = outputFolder;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (!token.contains(".xsd")) {
                    if (!Files.exists(Paths.get(path = String.valueOf(path) + token, new String[0]), new LinkOption[0])) {
                        new File(path).mkdirs();
                    }
                    if (!path.endsWith("\\")) {
                        path = String.valueOf(path) + "\\";
                    }
                }
                ++n2;
            }
            try {
                FileUtils.moveFileToDirectory(new File(String.valueOf(outputFolder) + NamingUtils.getJsonFileNameFromXsdFileName(xsd, jsonExt)), new File(path), false);
            }
            catch (Exception ex) {
                Logger.getLogger(InvokerMain.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
        }
    }

    public List<String> findAllXsdsInsideFolder(String folderPath) {
        File[] files;
        ArrayList<String> results = new ArrayList<String>();
        File[] fileArray = files = new File(folderPath).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                results.add(file.getPath());
            } else {
                results.addAll(this.findAllXsdsInsideFolder(file.getPath()));
            }
            ++n2;
        }
        return results;
    }
}

