/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.elements;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMinLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;
import org.wipo.xsd2json.schema.builders.representation.SimpleRestrictionJsonElement;

public class SimpleRestrictionElementBuilder {
    XmlSchemaSimpleType simpleType;
    File xsdFile;
    long parentMaxOccurs;
    Object fixedValue;
    boolean createDefsOnlyEntry;
    Map<String, String> typeRefAnnex;
    String jsonSchemaExt;
    String versionTxt;

    public SimpleRestrictionElementBuilder(XmlSchemaSimpleType simpleType, long parentMaxOccurs, Object fixedValue, boolean createDefsOnlyEntry, Map<String, String> typeRefAnnex, File xsdFile, String jsonSchemaExt, String versionTxt) {
        this.simpleType = simpleType;
        this.parentMaxOccurs = parentMaxOccurs;
        this.fixedValue = fixedValue;
        this.createDefsOnlyEntry = createDefsOnlyEntry;
        this.typeRefAnnex = typeRefAnnex;
        this.xsdFile = xsdFile;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    public BaseJsonElement build() {
        return this.addPropertiesToDefinitions(this.simpleType);
    }

    private BaseJsonElement addPropertiesToDefinitions(XmlSchemaSimpleType simpleType) {
        String name = simpleType.getName();
        String type = null;
        if (((XmlSchemaSimpleTypeRestriction)simpleType.getContent()).getBaseTypeName() == null) {
            XmlSchemaSimpleTypeRestriction cont = (XmlSchemaSimpleTypeRestriction)simpleType.getContent();
            XmlSchemaSimpleType baseType = cont.getBaseType();
            QName itemTypeName = ((XmlSchemaSimpleTypeList)baseType.getContent()).getItemTypeName();
            type = itemTypeName.getLocalPart();
        } else {
            type = ((XmlSchemaSimpleTypeRestriction)simpleType.getContent()).getBaseTypeName().getLocalPart();
        }
        XmlSchemaAnnotation annotation = simpleType.getAnnotation();
        SimpleRestrictionJsonElement bjs = new SimpleRestrictionJsonElement(name, type, 1L, 1L, this.parentMaxOccurs, this.typeRefAnnex, annotation, this.addPropertiesToSimpleTypeJsonSchema(simpleType), this.createDefsOnlyEntry, this.xsdFile.getPath(), this.jsonSchemaExt, this.versionTxt);
        return bjs;
    }

    private Map<String, String> addPropertiesToSimpleTypeJsonSchema(XmlSchemaSimpleType simpleType) {
        List<XmlSchemaFacet> facets;
        if (simpleType.getContent() instanceof XmlSchemaSimpleTypeRestriction && !(facets = ((XmlSchemaSimpleTypeRestriction)simpleType.getContent()).getFacets()).isEmpty()) {
            LinkedHashMap<String, String> propList = new LinkedHashMap<String, String>();
            for (XmlSchemaFacet facet : facets) {
                if (facet instanceof XmlSchemaLengthFacet || facet instanceof XmlSchemaMaxLengthFacet) {
                    propList.put("maxLength", facet.getValue().toString());
                    continue;
                }
                if (facet instanceof XmlSchemaMinLengthFacet) {
                    propList.put("minLength", facet.getValue().toString());
                    continue;
                }
                if (!(facet instanceof XmlSchemaPatternFacet)) continue;
                propList.put("pattern", facet.getValue().toString());
            }
            return propList;
        }
        return null;
    }
}

