/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.elements;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.wipo.xsd2json.constants.TypeConstants;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;
import org.wipo.xsd2json.schema.builders.representation.UnionJsonElement;
import org.wipo.xsd2json.utils.JsonTypeUtils;

public class UnionElementBuilder {
    XmlSchemaSimpleType simpleType;
    boolean createDefsOnlyEntry;
    Map<String, String> typeRefAnnex;
    File xsdFile;
    String jsonSchemaExt;
    String versionTxt;

    public UnionElementBuilder(XmlSchemaSimpleType simpleType, boolean createDefsOnlyEntry, Map<String, String> typeRefAnnex, File xsdFile, String jsonSchemaExt, String versionTxt) {
        this.simpleType = simpleType;
        this.typeRefAnnex = typeRefAnnex;
        this.xsdFile = xsdFile;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    public BaseJsonElement build() {
        return this.addUnionToDefinitions(this.simpleType);
    }

    private BaseJsonElement addUnionToDefinitions(XmlSchemaSimpleType simpleType) {
        String name = simpleType.getName();
        String type = simpleType.getQName().getLocalPart();
        XmlSchemaAnnotation annotation = simpleType.getAnnotation();
        UnionJsonElement bje = new UnionJsonElement(name, type, 0L, 1L, 1L, this.createDefsOnlyEntry, this.typeRefAnnex, annotation, this.getUnionList(simpleType), this.xsdFile.getPath(), this.jsonSchemaExt, this.versionTxt);
        return bje;
    }

    private List<Map<String, Object>> getUnionList(XmlSchemaSimpleType simpleType) {
        ArrayList<Map<String, Object>> unionList = new ArrayList<Map<String, Object>>();
        XmlSchemaSimpleTypeUnion unionElement = (XmlSchemaSimpleTypeUnion)simpleType.getContent();
        QName[] qNameArray = unionElement.getMemberTypesQNames();
        int n = qNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            QName qname = qNameArray[n2];
            Map<String, Object> unionItem = TypeConstants.primitiveTypeMap.get(qname.getLocalPart());
            if (unionItem == null) {
                unionItem = JsonTypeUtils.createRefFromXsd(this.typeRefAnnex, qname.getLocalPart(), this.xsdFile, this.jsonSchemaExt);
            }
            unionList.add(unionItem);
            ++n2;
        }
        return unionList;
    }
}

