/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.elements;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAnnotationItem;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.w3c.dom.Node;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;
import org.wipo.xsd2json.schema.builders.representation.EnumJsonElement;
import org.wipo.xsd2json.utils.XmlUtil;

public class EnumElementBuilder {
    XmlSchemaSimpleType simpleType;
    long parentMaxOccurs;
    Object fixedValue;
    boolean createDefsOnlyEntry;
    Map<String, String> typeRefAnnex;
    File xsdFile;
    String jsonSchemaExt;
    String versionTxt;
    List<XmlSchemaAnnotationItem> enumAnnotationItems = new ArrayList<XmlSchemaAnnotationItem>();

    public EnumElementBuilder(XmlSchemaSimpleType simpleType, long parentMaxOccurs, Object fixedValue, boolean createDefsOnlyEntry, Map<String, String> typeRefAnnex, File xsdFile, String jsonSchemaExt, String versionTxt) {
        this.simpleType = simpleType;
        this.parentMaxOccurs = parentMaxOccurs;
        this.fixedValue = fixedValue;
        this.createDefsOnlyEntry = createDefsOnlyEntry;
        this.typeRefAnnex = typeRefAnnex;
        this.xsdFile = xsdFile;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    public BaseJsonElement build() {
        return this.addEnumToDefinitions(this.simpleType);
    }

    private BaseJsonElement addEnumToDefinitions(XmlSchemaSimpleType simpleType) {
        String name = simpleType.getName();
        String type = null;
        if (((XmlSchemaSimpleTypeRestriction)simpleType.getContent()).getBaseTypeName() == null) {
            XmlSchemaSimpleTypeRestriction cont = (XmlSchemaSimpleTypeRestriction)simpleType.getContent();
            XmlSchemaSimpleType baseType = cont.getBaseType();
            QName itemTypeName = ((XmlSchemaSimpleTypeList)baseType.getContent()).getItemTypeName();
            type = itemTypeName.getLocalPart();
        } else {
            type = ((XmlSchemaSimpleTypeRestriction)simpleType.getContent()).getBaseTypeName().getLocalPart();
        }
        List<String> enumList = this.addEnumToSimpleTypeJsonSchema(simpleType);
        XmlSchemaAnnotation annotation = simpleType.getAnnotation();
        if (!this.enumAnnotationItems.isEmpty()) {
            if (annotation == null) {
                annotation = new XmlSchemaAnnotation();
            }
            annotation.getItems().addAll(this.enumAnnotationItems);
        }
        EnumJsonElement bjs = new EnumJsonElement(name, type, 0L, 1L, this.parentMaxOccurs, this.typeRefAnnex, annotation, enumList, this.fixedValue, this.createDefsOnlyEntry, this.xsdFile.getPath(), this.jsonSchemaExt, this.versionTxt);
        return bjs;
    }

    private List<String> addEnumToSimpleTypeJsonSchema(XmlSchemaSimpleType simpleType) {
        List<XmlSchemaFacet> facets;
        if (simpleType.getContent() instanceof XmlSchemaSimpleTypeRestriction && !(facets = ((XmlSchemaSimpleTypeRestriction)simpleType.getContent()).getFacets()).isEmpty()) {
            ArrayList<String> enumList = new ArrayList<String>();
            for (XmlSchemaFacet facet : facets) {
                if (!(facet instanceof XmlSchemaEnumerationFacet)) continue;
                enumList.add(facet.getValue().toString());
                if (facet.getAnnotation() == null) continue;
                for (XmlSchemaAnnotationItem annotation : facet.getAnnotation().getItems()) {
                    if (!(annotation instanceof XmlSchemaDocumentation)) continue;
                    for (Node documentation : XmlUtil.asList(((XmlSchemaDocumentation)annotation).getMarkup())) {
                        XmlSchemaAppInfo appInfo = new XmlSchemaAppInfo();
                        appInfo.addMetaInfo(facet.getValue().toString(), documentation.getNodeValue());
                        XmlSchemaAnnotation newAntn = new XmlSchemaAnnotation();
                        newAntn.getItems().add(appInfo);
                        this.enumAnnotationItems.addAll(newAntn.getItems());
                    }
                }
            }
            return enumList;
        }
        return null;
    }
}

