/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.organize;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.wipo.xsd2json.constants.FolderPaths;
import org.wipo.xsd2json.utils.OrganizationUtils;

public class OrganizeXsdPerTypeUtils {
    private File sourceXsdFile;

    public OrganizeXsdPerTypeUtils(File sourceXsdFile) throws IOException, URISyntaxException {
        this.sourceXsdFile = sourceXsdFile;
    }

    public void organizeXsdPerType() throws IOException, URISyntaxException {
        if (this.sourceXsdFile.getName().contains("xsd")) {
            this.addSchemaLocation(this.sourceXsdFile);
        }
    }

    private void addSchemaLocation(File xsdFile) throws IOException, URISyntaxException {
        FileInputStream is = new FileInputStream(xsdFile);
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        schemaCol.setBaseUri(xsdFile.getParent());
        XmlSchema schema = schemaCol.read(new StreamSource(is));
        if (schema.getSchemaTypes() != null && schema.getSchemaTypes().entrySet().size() > 0) {
            for (Map.Entry<QName, XmlSchemaType> entry : schema.getSchemaTypes().entrySet()) {
                if (entry.getValue() instanceof XmlSchemaComplexType) {
                    this.complexTypeOrganize((XmlSchemaComplexType)entry.getValue(), xsdFile);
                    continue;
                }
                if (!(entry.getValue() instanceof XmlSchemaSimpleType)) continue;
                this.simpleTypeOrganize((XmlSchemaSimpleType)entry.getValue(), xsdFile);
            }
        } else if (schema.getElements() != null && schema.getElements().size() > 0) {
            OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.elementsFolder);
        } else if (schema.getAttributes() != null && schema.getAttributes().size() > 0) {
            OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.attributesFolder);
        }
    }

    private void complexTypeOrganize(XmlSchemaComplexType resolvedComplexType, File xsdFile) throws IOException {
        if (resolvedComplexType.getContentModel() != null) {
            if (resolvedComplexType.getContentModel().getContent() instanceof XmlSchemaSimpleContentExtension) {
                OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.simpleTypeExtensionFolder);
            }
            if (resolvedComplexType.getContentModel().getContent() instanceof XmlSchemaComplexContentExtension) {
                OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.complexTypeExtensionFolder);
            }
        }
        if (resolvedComplexType.getParticle() != null && resolvedComplexType.getParticle() instanceof XmlSchemaSequence) {
            OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.sequenceTypeExtensionFolder);
        }
        if (resolvedComplexType.getParticle() != null && resolvedComplexType.getParticle() instanceof XmlSchemaChoice) {
            OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.choiceTypeExtensionFolder);
        }
    }

    private void simpleTypeOrganize(XmlSchemaSimpleType resolvedSimpleType, File xsdFile) throws IOException {
        if (resolvedSimpleType.getContent() instanceof XmlSchemaSimpleTypeRestriction) {
            OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.simpleTypeRestrictionFolder);
        }
        if (resolvedSimpleType.getContent() instanceof XmlSchemaSimpleTypeUnion) {
            OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.simpleTypeUnionFolder);
        }
        if (resolvedSimpleType.getContent() instanceof XmlSchemaSimpleTypeList) {
            OrganizationUtils.moveFileToFolder(xsdFile, FolderPaths.simpleTypeListFolder);
        }
    }
}

