/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.types;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.wipo.xsd2json.schema.builders.elements.AttributeElementBuilder;
import org.wipo.xsd2json.schema.builders.elements.BaseExtensionElementBuilder;
import org.wipo.xsd2json.schema.builders.elements.ChoiceElementBuilder;
import org.wipo.xsd2json.schema.builders.elements.SequenceElementBuilder;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;
import org.wipo.xsd2json.schema.builders.representation.ComplexJsonElement;
import org.wipo.xsd2json.schema.builders.types.AbstractJsonSchemaBuilder;
import org.wipo.xsd2json.utils.NamingUtils;

public class ComplexTypeJsonSchemaBuilder
extends AbstractJsonSchemaBuilder {
    XmlSchemaComplexType complexType;
    String compName;
    long parentMaxOccurs;
    boolean extendOrRestrictType;
    String baseCompName;

    public ComplexTypeJsonSchemaBuilder(XmlSchemaComplexType complexType, String compName, long parentMaxOccurs, boolean createDefsOnlyEntry, File xsdFile, Map<String, String> typeRefAnnex, String jsonSchemaExt, String versionTxt) {
        this.complexType = complexType;
        this.compName = compName;
        this.parentMaxOccurs = parentMaxOccurs;
        this.createDefsOnlyEntry = createDefsOnlyEntry;
        this.xsdFile = xsdFile;
        this.baseCompName = this.createDefsOnlyEntry ? NamingUtils.makeLowerCamelCase(xsdFile.getName().substring(0, xsdFile.getName().toLowerCase().lastIndexOf(".xsd"))) : compName;
        this.typeRefAnnex = typeRefAnnex;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    @Override
    BaseJsonElement addXsdElementToJsonSchema() {
        XmlSchemaParticle particle;
        if (this.complexType.isMixed()) {
            this.isMixedContent = true;
            System.out.println("Mixed XSD: " + this.xsdFile.getPath());
        }
        long maxOccurs = 1L;
        long minOccurs = 0L;
        if (!(this.complexType instanceof XmlSchemaComplexType)) {
            throw new RuntimeException("Wrong Configuration for Complex Type!");
        }
        ArrayList<BaseJsonElement> properties = new ArrayList<BaseJsonElement>();
        ComplexJsonElement cje = null;
        for (XmlSchemaAttributeOrGroupRef attr : this.complexType.getAttributes()) {
            if (attr instanceof XmlSchemaAttribute) {
                properties.add(new AttributeElementBuilder((XmlSchemaAttribute)attr, this.isMixedContent ? 1L : (this.parentMaxOccurs <= 1L ? maxOccurs : this.parentMaxOccurs), this.createDefsOnlyEntry, this.xsdFile, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt).build());
            }
            if (!(attr instanceof XmlSchemaAttributeGroupRef)) continue;
            throw new RuntimeException("XmlSchemaAttributeGroupRef of complex type is not yet mapped!!!");
        }
        if (this.complexType.getContentModel() != null && (this.complexType.getContentModel() instanceof XmlSchemaSimpleContent || this.complexType.getContentModel() instanceof XmlSchemaComplexContent)) {
            if (this.complexType.getContentModel() instanceof XmlSchemaSimpleContent) {
                return this.getTypeOfSimpleContentModel((XmlSchemaSimpleContent)this.complexType.getContentModel(), this.parentMaxOccurs, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
            }
            if (this.complexType.getContentModel() instanceof XmlSchemaComplexContent) {
                return this.getComplexContentModel((XmlSchemaComplexContent)this.complexType.getContentModel(), this.parentMaxOccurs, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
            }
        }
        if ((particle = this.complexType.getParticle()) != null) {
            maxOccurs = particle.getMaxOccurs();
            minOccurs = particle.getMinOccurs();
            if (particle instanceof XmlSchemaSequence) {
                maxOccurs = particle.getMaxOccurs();
                minOccurs = particle.getMinOccurs();
                XmlSchemaSequence seqItm = (XmlSchemaSequence)particle;
                if (maxOccurs == (long)seqItm.getItems().size()) {
                    maxOccurs = 1L;
                }
                SequenceElementBuilder seb = new SequenceElementBuilder((XmlSchemaSequence)particle, this.isMixedContent, false, 0, this.parentMaxOccurs <= 1L ? maxOccurs : this.parentMaxOccurs, this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
                properties.add(seb.build());
            }
            if (particle instanceof XmlSchemaChoice) {
                XmlSchemaChoice chItm = (XmlSchemaChoice)particle;
                maxOccurs = particle.getMaxOccurs();
                if (maxOccurs == (long)chItm.getItems().size()) {
                    maxOccurs = 1L;
                }
                minOccurs = particle.getMinOccurs();
                int multipleChoiceEntryCounter = 0;
                ChoiceElementBuilder ceb = new ChoiceElementBuilder((XmlSchemaChoice)particle, this.isMixedContent, multipleChoiceEntryCounter, this.isMixedContent ? 1L : (this.parentMaxOccurs <= 1L ? maxOccurs : this.parentMaxOccurs), this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
                properties.add(ceb.build());
            }
        }
        cje = new ComplexJsonElement(this.complexType.getName(), this.complexType.getQName().getLocalPart(), this.extendOrRestrictType, minOccurs, maxOccurs, this.isMixedContent ? 1L : (this.parentMaxOccurs <= 1L ? maxOccurs : this.parentMaxOccurs), this.isMixedContent, this.typeRefAnnex, null, properties, this.xsdFile.getPath(), this.createDefsOnlyEntry, this.jsonSchemaExt, this.versionTxt);
        return cje;
    }

    private BaseJsonElement getComplexContentModel(XmlSchemaComplexContent complexContentModel, long parentMaxOccurs, Map<String, String> typeRefAnnex, File baseXsdFile, String jsonSchemaExt, String versionTxt) {
        if (complexContentModel.getContent() instanceof XmlSchemaSimpleContentExtension) {
            return new BaseExtensionElementBuilder(complexContentModel.getContent(), this.baseCompName, complexContentModel.isMixed(), parentMaxOccurs, this.createDefsOnlyEntry, typeRefAnnex, baseXsdFile, jsonSchemaExt, versionTxt).build();
        }
        if (complexContentModel.getContent() instanceof XmlSchemaComplexContentExtension) {
            return new BaseExtensionElementBuilder(complexContentModel.getContent(), this.baseCompName, complexContentModel.isMixed(), parentMaxOccurs, this.createDefsOnlyEntry, typeRefAnnex, baseXsdFile, jsonSchemaExt, versionTxt).build();
        }
        if (complexContentModel.getContent() instanceof XmlSchemaComplexContentRestriction) {
            return new BaseExtensionElementBuilder(complexContentModel.getContent(), this.baseCompName, complexContentModel.isMixed(), parentMaxOccurs, this.createDefsOnlyEntry, typeRefAnnex, baseXsdFile, jsonSchemaExt, versionTxt).build();
        }
        System.out.println("Unhandled XmlSchemaComplexContent Type: " + complexContentModel.getContent().getClass().getName());
        return null;
    }

    private List<BaseJsonElement> getTypeOfComplexContentModel(XmlSchemaComplexContent complexContentModel, long parentMaxOccurs, Map<String, String> typeRefAnnex, File baseXsdFile, String jsonSchemaExt, String versionTxt) {
        ArrayList<BaseJsonElement> allElements = new ArrayList<BaseJsonElement>();
        long maxOccurs = 1L;
        if (complexContentModel.getContent() instanceof XmlSchemaSimpleContentExtension) {
            allElements.add(new BaseExtensionElementBuilder(complexContentModel.getContent(), this.baseCompName, complexContentModel.isMixed(), parentMaxOccurs, this.createDefsOnlyEntry, typeRefAnnex, baseXsdFile, jsonSchemaExt, versionTxt).build());
            for (XmlSchemaAttributeOrGroupRef attr : ((XmlSchemaSimpleContentExtension)complexContentModel.getContent()).getAttributes()) {
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                allElements.add(new AttributeElementBuilder((XmlSchemaAttribute)attr, this.isMixedContent ? 1L : (parentMaxOccurs <= 1L ? maxOccurs : parentMaxOccurs), this.createDefsOnlyEntry, baseXsdFile, typeRefAnnex, jsonSchemaExt, versionTxt).build());
            }
        } else if (complexContentModel.getContent() instanceof XmlSchemaComplexContentExtension) {
            allElements.add(new BaseExtensionElementBuilder(complexContentModel.getContent(), this.baseCompName, complexContentModel.isMixed(), parentMaxOccurs, this.createDefsOnlyEntry, typeRefAnnex, baseXsdFile, jsonSchemaExt, versionTxt).build());
            for (XmlSchemaAttributeOrGroupRef attr : ((XmlSchemaComplexContentExtension)complexContentModel.getContent()).getAttributes()) {
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                allElements.add(new AttributeElementBuilder((XmlSchemaAttribute)attr, this.isMixedContent ? 1L : (parentMaxOccurs <= 1L ? maxOccurs : parentMaxOccurs), this.createDefsOnlyEntry, baseXsdFile, typeRefAnnex, jsonSchemaExt, versionTxt).build());
            }
        } else if (complexContentModel.getContent() instanceof XmlSchemaComplexContentRestriction) {
            allElements.add(new BaseExtensionElementBuilder(complexContentModel.getContent(), this.baseCompName, complexContentModel.isMixed(), parentMaxOccurs, this.createDefsOnlyEntry, typeRefAnnex, baseXsdFile, jsonSchemaExt, versionTxt).build());
            for (XmlSchemaAttributeOrGroupRef attr : ((XmlSchemaComplexContentRestriction)complexContentModel.getContent()).getAttributes()) {
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                allElements.add(new AttributeElementBuilder((XmlSchemaAttribute)attr, this.isMixedContent ? 1L : (parentMaxOccurs <= 1L ? maxOccurs : parentMaxOccurs), this.createDefsOnlyEntry, baseXsdFile, typeRefAnnex, jsonSchemaExt, versionTxt).build());
            }
        } else {
            System.out.println("Unhandled XmlSchemaComplexContent Type: " + complexContentModel.getContent().getClass().getName());
        }
        return allElements;
    }

    private BaseJsonElement getTypeOfSimpleContentModel(XmlSchemaSimpleContent simpleContentModel, long parentMaxOccurs, Map<String, String> typeRefAnnex, File baseXsdFile, String jsonSchemaExt, String versionTxt) {
        if ((simpleContentModel.getContent() instanceof XmlSchemaSimpleContentExtension || simpleContentModel.getContent() instanceof XmlSchemaComplexContentExtension) && ((XmlSchemaSimpleContentExtension)simpleContentModel.getContent()).getBaseTypeName() != null) {
            BaseExtensionElementBuilder beeb = new BaseExtensionElementBuilder(simpleContentModel.getContent(), this.baseCompName, false, parentMaxOccurs, this.createDefsOnlyEntry, typeRefAnnex, baseXsdFile, jsonSchemaExt, versionTxt);
            return beeb.build();
        }
        return null;
    }
}

